package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * Constants for use with {@link com.smartgwt.client.widgets.Canvas#getAllCanvases Canvas.getAllCanvases()} to specify
 * which canvases to return.
 */
public enum CanvasFilterMode implements ValueEnum {
    /**
     * Return only canvases that are drawn, visible to the end user, and non-generated (developer-created). This is the
     * default. Visibility checking includes parental visibility, so a canvas whose parent is hidden will not be returned.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "visible".
     */
    VISIBLE("visible"),
    /**
     * Return only canvases that are drawn and visible to the end user, including generated canvases (autoChildren, etc.).
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "visibleIncludeGenerated".
     */
    VISIBLEINCLUDEGENERATED("visibleIncludeGenerated"),
    /**
     * Return only canvases that are drawn (regardless of visibility or generated status).
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "drawn".
     */
    DRAWN("drawn"),
    /**
     * Return only canvases that are drawn but hidden (either directly hidden or hidden due to a hidden parent).
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "drawnHidden".
     */
    DRAWNHIDDEN("drawnHidden"),
    /**
     * Return only canvases that are not yet drawn.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "undrawn".
     */
    UNDRAWN("undrawn"),
    /**
     * Return only generated canvases (autoChildren and other framework- generated canvases) that are drawn and visible.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "generated".
     */
    GENERATED("generated"),
    /**
     * Return all canvases regardless of drawn/visibility/generated state.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "all".
     */
    ALL("all"),
    /**
     * Return all generated canvases regardless of drawn/visibility state.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "allGenerated".
     */
    ALLGENERATED("allGenerated"),
    /**
     * Return all non-generated canvases regardless of drawn/visibility state.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "allNonGenerated".
     */
    ALLNONGENERATED("allNonGenerated");
    private String value;

    CanvasFilterMode(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
