
package com.smartgwt.client.docs;

/**
 * <h3>Full Text Search</h3>
 * Full Text Search (FTS) enables searching the content of documents stored in binary
 *  fields, rather than just metadata fields. When enabled on a DataSource, textual search
 *  operators (contains, iContains, startsWith, etc.) applied to FTS-eligible binary fields
 *  will automatically trigger full-text search through a configured provider.
 *  <P>
 *  <b>Enabling Full Text Search</b>
 *  <P>
 *  FTS is enabled by adding a &lt;fullTextSearch&gt; element to your DataSource definition:
 *  <pre>
 *  &lt;DataSource ID="documents"&gt;
 *    &lt;fullTextSearch provider="openSearch"/&gt;
 *    &lt;fields&gt;
 *      &lt;field name="id" type="sequence" primaryKey="true"/&gt;
 *      &lt;field name="docFile" type="binary"/&gt;
 *    &lt;/fields&gt;
 *  &lt;/DataSource&gt;
 *  </pre>
 *  <P>
 *  With this configuration, any fetch request that includes textual criteria on the
 *  "docFile" field will trigger an FTS query against the configured provider (OpenSearch
 *  or Elasticsearch in this example).
 *  <P>
 *  <b>How FTS Works</b>
 *  <P>
 *  When a fetch request includes textual search operators on an FTS-eligible binary field:
 *  <ol>
 *  <li>The framework detects this as an FTS trigger</li>
 *  <li>A query is sent to the FTS provider (OpenSearch, Elasticsearch, or Oracle Text)</li>
 *  <li>The provider returns matching document IDs and relevance metadata (score, snippets)</li>
 * <li>The original criteria is modified to include a primary key restriction to only those
 * IDs</li>
 *  <li>The normal database fetch executes with the modified criteria</li>
 *  <li>FTS metadata (scores, snippets) is merged into the response records</li>
 *  </ol>
 *  <P>
 *  <b>Supported Search Operators</b>
 *  <P>
 *  The following operators trigger FTS when applied to an FTS-eligible binary field:
 *  <ul>
 *  <li><b>contains/iContains</b>: Match documents containing the search term(s)</li>
 *  <li><b>startsWith/iStartsWith</b>: Match documents with terms starting with the value</li>
 *  <li><b>endsWith/iEndsWith</b>: Match documents with terms ending with the value</li>
 *  <li><b>equals/iEquals</b>: Exact term match</li>
 *  </ul>
 *  <P>
 *  Additionally, FTS-specific operators are available for advanced searching:
 *  <ul>
 *  <li><b>phrase/iPhrase</b>: Match an exact phrase (words in order)</li>
 *  <li><b>near/iNear</b>: Proximity search - match terms within a certain distance</li>
 *  <li><b>fuzzy/iFuzzy</b>: Approximate matching with edit distance tolerance</li>
 *  <li><b>prefixMatch/iPrefixMatch</b>: Match terms starting with the given prefix</li>
 *  </ul>
 *  <P>
 *  The "i" prefix variants perform case-insensitive matching.
 *  <P>
 *  <b>FTS Providers</b>
 *  <P>
 *  Two types of FTS providers are supported:
 *  <ul>
 *  <li><b>External providers</b> (OpenSearch, Elasticsearch): These use a separate search
 *  engine that maintains its own full-text index. Results are fetched via a provider
 *  DataSource and merged with the primary fetch.</li>
 *  <li><b>Oracle Text</b>: A special case that generates CONTAINS() and SCORE() SQL
 *  predicates directly, with no separate provider query.</li>
 *  </ul>
 *  <P>
 *  Configure providers in server.properties:
 *  <pre>
 *  # Default provider when not specified in DataSource
 *  fullText.defaultProvider=openSearch
 * 
 *  # List of available providers
 *  fullText.providers=oracleText,openSearch
 * 
 *  # External provider configuration
 *  fullText.provider.openSearch.dataSourceID=FTSOpenSearch
 *  fullText.openSearch.endpoint=http://localhost:9200
 * 
 *  # Oracle Text is built-in (no external DataSource)
 *  fullText.provider.oracleText.type=oracleText
 *  </pre>
 *  <P>
 *  <b>FTS Result Fields</b>
 *  <P>
 *  When FTS is enabled, the following fields are automatically generated on the DataSource
 *  to receive FTS metadata:
 *  <ul>
 *  <li><b>fts_score</b>: Relevance score from the search engine (float)</li>
 *  <li><b>fts_snippet</b>: A highlighted snippet showing match context (text)</li>
 *  <li><b>fts_snippets</b>: Multiple snippets if document has multiple matches (JSON array)</li>
 * <li><b>fts_highlights</b>: Highlighted field contents showing match locations (JSON
 * object)</li>
 *  <li><b>fts_rank</b>: Result rank within the search results (integer)</li>
 *  <li><b>fts_providerMeta</b>: Provider-specific metadata (JSON)</li>
 *  </ul>
 *  <P>
 *  The field name prefix can be customized via the resultFieldPrefix attribute.
 *  <P>
 *  <b>Field-Level Configuration</b>
 *  <P>
 *  Individual binary fields can be excluded from FTS or assigned different providers:
 *  <pre>
 *  &lt;field name="docFile" type="binary"/&gt;
 *  &lt;field name="thumbnail" type="binary" fullTextSearch="false"/&gt;
 *  &lt;field name="archiveFile" type="binary" fullTextProvider="oracleText"/&gt;
 *  </pre>
 *  <P>
 *  <b>Error Handling</b>
 *  <P>
 *  FTS errors can be handled according to policy (set on provider or DataSource):
 *  <ul>
 *  <li><b>fail</b> (default): FTS errors cause the request to fail</li>
 *  <li><b>warnAndIgnore</b>: Log warning and continue without FTS results</li>
 *  <li><b>ignore</b>: Silently continue without FTS results</li>
 *  </ul>
 *  <P>
 *  <b>API Access</b>
 *  <P>
 *  Server-side code can access the original criteria (before FTS modification) via
 *  DSRequest.getOriginalCriteria(). FTS metadata can also be accessed via
 *  DSRequest.getMergeData().
 */
public interface FullTextSearch {
}
