
package com.smartgwt.client.docs;

/**
 * <h3>Task Input / Output</h3>
 * <h4>Input</h4>
 * Tasks require "inputs" to do their work, just like a method call.  For example, {@link
 * com.smartgwt.client.util.workflow.GridFetchDataTask}
 *  requires {@link com.smartgwt.client.util.workflow.GridFetchDataTask#getCriteria criteria}.
 *  <p>
 * For built-in tasks, you can typically use {@link com.smartgwt.client.docs.TaskInputExpression
 * TaskInputExpressions} to declare
 * that the inputs of a task are drawn from {@link
 * com.smartgwt.client.util.workflow.Process#getState Process.state}, the {@link
 * com.smartgwt.client.util.workflow.Task#setOutput output} of a
 * previous task in the process, or from global context such as {@link
 * com.smartgwt.client.util.workflow.Process#getRuleScope ruleScope}.
 *  See the docs for each task for details.
 *  <p>
 * If you are implementing your own task and want to support <code>TaskInputExpressions</code> for
 * the data
 * required by your task, use {@link com.smartgwt.client.util.workflow.Task#getExpressionValue
 * Task.getExpressionValue()}.
 *  <p>
 * You can also use the property {@link com.smartgwt.client.util.workflow.Task#getInputs
 * Task.inputs} to automatically support <code>TaskInputExpressions</code>:
 * call {@link com.smartgwt.client.util.workflow.Task#getInputRecord getInputRecord()} to get the
 * values of the provided expressions.
 *  <p>
 *  <h4>Output</h4>
 * A task can call {@link com.smartgwt.client.util.workflow.Task#setOutput Task.setOutput()} to
 * provide outputs which other tasks can use via
 * <code>TaskInputExpressions</code> or programmatically via APIs such as {@link
 * com.smartgwt.client.util.workflow.Process#getLastTaskOutput Process.getLastTaskOutput()}.
 *  <P>
 * Using the property {@link com.smartgwt.client.util.workflow.Task#getOutputField
 * Task.outputField} and/or {@link com.smartgwt.client.util.workflow.Task#getOutputFieldList
 * Task.outputFieldList} allows certain properties
 * of the output, from setOutput(), to be written into the {@link
 * com.smartgwt.client.util.workflow.Process#getState Process.state}. Use {@link
 * com.smartgwt.client.util.workflow.Task#getOutputField Task.outputField}
 * to specify the field in the process state where the task output should be written. Or, for more
 * complex
 * tasks, use {@link com.smartgwt.client.util.workflow.Task#getOutputFieldList
 * Task.outputFieldList} to specify multiple fields.
 *  <P>
 * You can also use the property {@link com.smartgwt.client.util.workflow.Task#getOutputExpression
 * Task.outputExpression} to write task output directly into a
 * {@link com.smartgwt.client.widgets.DataBoundComponent} instead of or in addition to the process
 * state.
 *  <P>
 *  An output expression is a String prefixed with "$" followed by the DataBoundComponent
 *  ID and optionally followed by a dot-separated field name. When no optional field name
 *  is specified, the task output is written to the target component using setValues() or
 *  setData(). With the optional field name, the task output is written to the target
 *  with setFieldValue() or setEditValue(). For a ListGrid the row is either the current
 *  edit row or the one selected row.
 *  <P>
 *  As an example, consider a DynamicForm with ID of "orderHeader". By specifying an
 *  <code>outputExpression</code> as "$orderHeader" for a fetch DSRequestTask the response
 *  record will be assigned directly to the DynamicForm.
 *  <P>
 *  <h4>Inputs examples</h4>
 * <code>inputRecord</code> represents the result of the <code>inputs</code> extracted from the
 * process state.
 *  <P>
 * If the {@link com.smartgwt.client.util.workflow.Process#getState Process.state} represented in
 * JSON is:
 *  <pre>
 *  {
 *     orderId:5,
 *     orderItems: [
 *        {name:"Pencils", quantity:3, itemId:2344}
 *     ],
 *     orderUser: { name:"Henry Winkle", address:"...", ... }
 *  }
 *  </pre>
 *  Consider these input definitions and resulting <code>inputRecord</code>:
 *  <ul>
 *  <li>inputs: "orderId"
 *    <ul>
 *      <li>inputRecord: { orderId: 5 }
 *    </ul>
 *  <li>inputs: [ "orderUser.name", "orderUser" ]
 *    <ul>
 *      <li>inputRecord: { name: "Henry Winkle", orderUser: { name: "Henry Winkle", address: ... }
 *    </ul>
 *  <li>inputs: "orderUser"
 *    <ul>
 *      <li>inputRecord: { name: "Henry Winkle", address: ... }
 *    </ul>
 *  <li>inputs: [ "orderUser" ]
 *    <ul>
 *      <li>inputRecord: { orderUser: { name: "Henry Winkle", address: ... } }
 *    </ul>
 *  </ul>
 * @see com.smartgwt.client.util.workflow.Task#getInputRecord
 * @see com.smartgwt.client.util.workflow.Task#getExpressionValue
 * @see com.smartgwt.client.util.workflow.ScriptTask#setOutput
 * @see com.smartgwt.client.util.workflow.Task#getInputs
 * @see com.smartgwt.client.util.workflow.Task#getInputFieldList
 * @see com.smartgwt.client.util.workflow.Task#getOutputField
 * @see com.smartgwt.client.util.workflow.Task#getOutputFieldList
 * @see com.smartgwt.client.util.workflow.Task#getOutputExpression
 * @see com.smartgwt.client.util.workflow.DSRequestTask#getCriteria
 * @see com.smartgwt.client.util.workflow.DSRequestTask#getOutputField
 * @see com.smartgwt.client.util.workflow.DSRequestTask#getOutputFieldList
 */
public interface TaskIO {
}
