
package com.smartgwt.client.docs;

/**
 * A  CoTTask can automatically retry when its outputs fail
 *  validation (via  CoTTask.outputDS/ CoTTask.outputFields) or when
 * {@link com.smartgwt.client.util.workflow.Process#beforeTaskCommit Process.beforeTaskCommit()}
 * returns errors. The retry budget is controlled by
 *   CoTTask.maxRetries and, if unset on the task, inherits from
 *   CoTProcess.maxRetries.
 *  <p>
 *  <h4>What happens when retries are exhausted</h4>
 *  If every attempt fails up to the retry budget:
 *  <ul>
 *  <li>No  CoTTask.stateUpdates are committed.</li>
 *  <li>The process halts immediately (no fallback routing).</li>
 * <li>{@link com.smartgwt.client.util.workflow.Process#addFinishedHandler
 * Process.finished(process,lastTask,failure)} is fired with
 *      <code>lastTask</code> set to the failing task and <code>failure</code> set to
 *      <code>true</code>.</li>
 *  </ul>
 *  <p>
 *  <h4>Detecting retry exhaustion</h4>
 * You can observe exhaustion by implementing {@link
 * com.smartgwt.client.util.workflow.Process#addFinishedHandler Process.finished()} and checking
 * the
 * <code>failure</code> flag. In isolation tests that use {@link
 * com.smartgwt.client.util.workflow.Process#runTask runTask()},
 *  the same notification fires on exhaustion; the task's validation errors remain
 *  available on the task.
 *  <pre>
 *  isc.CoTProcess.create({
 *      ...
 *      finished : function (proc, lastTask, failure) {
 *          if (failure) {
 *              isc.logWarn("CoT halted: retries exhausted in task: " + lastTask.ID);
 *              // lastTask.errors contains the final validation errors
 *          }
 *      }
 *  });
 *  </pre>
 */
public interface AIRetriesExhausted {
}
