/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.data;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Represents a field in a {@link com.smartgwt.client.widgets.DataBoundComponent}.
 * @see com.smartgwt.client.widgets.grid.ListGridField
 * @see com.smartgwt.client.widgets.viewer.DetailViewerField
 */
@BeanFactory.FrameworkClass
public class DBCField extends Field {

    public static DBCField getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof DBCField) {
            existingObj.setJsObj(jsObj);
            return (DBCField)existingObj;
        } else

        {
            return new DBCField(jsObj);
        }
    }
        


    public DBCField(){
        
    }

    public DBCField(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * Preferred display format to use for date type values within this field. If this property is set on a field displayed in
     * a databound component such as a {@link com.smartgwt.client.widgets.form.DynamicForm} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid} it will be respected (See {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getDateFormatter FormItem.dateFormatter} and {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getDateFormatter ListGridField.dateFormatter}). <P> Note that this
     * property is also honored when exporting directly to  Excel spreadsheets (ie, when using XLS or XLSX/OOXML form,
     * <b>not</b> CSV); "date" and "datetime" fields with this property set will deliver real dates and formatting information
     * to Excel, rather than formatted strings or unformatted dates.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param dateFormatter New dateFormatter value. Default value is null
     * @return {@link com.smartgwt.client.data.DBCField DBCField} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public DBCField setDateFormatter(DateDisplayFormat dateFormatter) {
        return (DBCField)setAttribute("dateFormatter", dateFormatter == null ? null : dateFormatter.getValue());
    }

    /**
     * Preferred display format to use for date type values within this field. If this property is set on a field displayed in
     * a databound component such as a {@link com.smartgwt.client.widgets.form.DynamicForm} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid} it will be respected (See {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getDateFormatter FormItem.dateFormatter} and {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getDateFormatter ListGridField.dateFormatter}). <P> Note that this
     * property is also honored when exporting directly to  Excel spreadsheets (ie, when using XLS or XLSX/OOXML form,
     * <b>not</b> CSV); "date" and "datetime" fields with this property set will deliver real dates and formatting information
     * to Excel, rather than formatted strings or unformatted dates.
     *
     * @return Current dateFormatter value. Default value is null
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public DateDisplayFormat getDateFormatter()  {
        return EnumUtil.getEnum(DateDisplayFormat.values(), getAttribute("dateFormatter"));
    }
    

    /**
     * When records from this dataSource are displayed in a dataBoundComponent such as a {@link
     * com.smartgwt.client.widgets.grid.ListGrid}, the <code>displayField</code> attribute may be used to cause some  field to
     * display a value from another field in the record. <P> This is typically used for editable {@link
     * com.smartgwt.client.data.DataSourceField#getForeignKey DataSourceField.foreignKey} fields.  In this scenario, a
     * dataSource field has a foreignKey field which stores an ID value used to identify records in another, related
     * dataSource. Rather than display this ID to users, developers may wish to display another, user-friendly field from the
     * related record. This is easy to achieve by  having a second field on the dataSource which will be populated with the
     * "display value" from this related dataSource, and using <code>dataSourceField.displayField</code>  to show this value. 
     * The {@link com.smartgwt.client.docs.serverds.DataSourceField#includeFrom DataSourceField.includeFrom} feature handles
     * populating this field automatically for dataSources backed by the {@link com.smartgwt.client.docs.ServerDataIntegration
     * Smart GWT Server}. See the "Editing included fields" section of the {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#includeFrom DataSourceField.includeFrom} documentation for more on
     * editing included foreignKey fields. <P> Editable dataSourceFields with a specified <code>displayField</code> and 
     * <code>foreignKey</code> will typically be edited using a {@link com.smartgwt.client.widgets.form.fields.SelectItem}  or
     * {@link com.smartgwt.client.widgets.form.fields.ComboBoxItem}. In this case, in addition to identifying the field to use
     * as a static display value within the record being edited, <code>displayField</code> will also identify which field on
     * the related dataSource to use as a display field when showing a set of options to the user. This behavior may be
     * modified in a couple of ways: <ul>  <li>The {@link com.smartgwt.client.data.DataSourceField#getForeignDisplayField
     * DataSourceField.foreignDisplayField} attribute may be used to handle the      case where the name of the field used as a
     * displayField within the dataSource is      different from the name of the included/equivalent field in the related
     * dataSource.</li>  <li>The {@link com.smartgwt.client.data.DataSourceField#getUseLocalDisplayFieldValue
     * DataSourceField.useLocalDisplayFieldValue} attribute may be explicitly      set to false to avoid picking up a display
     * value from the local record altogether.      Instead the displayField will be used only to derive the display value from
     * a related record from the optionDataSource</li> </ul> For more on how FormItems use the displayField property, see
     * {@link com.smartgwt.client.widgets.form.fields.FormItem#getDisplayField FormItem.displayField}.
     *
     * @param displayField New displayField value. Default value is null
     * @return {@link com.smartgwt.client.data.DBCField DBCField} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.DataSourceRelations Relations
     */
    public DBCField setDisplayField(String displayField) {
        return (DBCField)setAttribute("displayField", displayField);
    }

    /**
     * When records from this dataSource are displayed in a dataBoundComponent such as a {@link
     * com.smartgwt.client.widgets.grid.ListGrid}, the <code>displayField</code> attribute may be used to cause some  field to
     * display a value from another field in the record. <P> This is typically used for editable {@link
     * com.smartgwt.client.data.DataSourceField#getForeignKey DataSourceField.foreignKey} fields.  In this scenario, a
     * dataSource field has a foreignKey field which stores an ID value used to identify records in another, related
     * dataSource. Rather than display this ID to users, developers may wish to display another, user-friendly field from the
     * related record. This is easy to achieve by  having a second field on the dataSource which will be populated with the
     * "display value" from this related dataSource, and using <code>dataSourceField.displayField</code>  to show this value. 
     * The {@link com.smartgwt.client.docs.serverds.DataSourceField#includeFrom DataSourceField.includeFrom} feature handles
     * populating this field automatically for dataSources backed by the {@link com.smartgwt.client.docs.ServerDataIntegration
     * Smart GWT Server}. See the "Editing included fields" section of the {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#includeFrom DataSourceField.includeFrom} documentation for more on
     * editing included foreignKey fields. <P> Editable dataSourceFields with a specified <code>displayField</code> and 
     * <code>foreignKey</code> will typically be edited using a {@link com.smartgwt.client.widgets.form.fields.SelectItem}  or
     * {@link com.smartgwt.client.widgets.form.fields.ComboBoxItem}. In this case, in addition to identifying the field to use
     * as a static display value within the record being edited, <code>displayField</code> will also identify which field on
     * the related dataSource to use as a display field when showing a set of options to the user. This behavior may be
     * modified in a couple of ways: <ul>  <li>The {@link com.smartgwt.client.data.DataSourceField#getForeignDisplayField
     * DataSourceField.foreignDisplayField} attribute may be used to handle the      case where the name of the field used as a
     * displayField within the dataSource is      different from the name of the included/equivalent field in the related
     * dataSource.</li>  <li>The {@link com.smartgwt.client.data.DataSourceField#getUseLocalDisplayFieldValue
     * DataSourceField.useLocalDisplayFieldValue} attribute may be explicitly      set to false to avoid picking up a display
     * value from the local record altogether.      Instead the displayField will be used only to derive the display value from
     * a related record from the optionDataSource</li> </ul> For more on how FormItems use the displayField property, see
     * {@link com.smartgwt.client.widgets.form.fields.FormItem#getDisplayField FormItem.displayField}.
     *
     * @return Current displayField value. Default value is null
     * @see com.smartgwt.client.docs.DataSourceRelations Relations
     */
    public String getDisplayField()  {
        return getAttributeAsString("displayField");
    }
    

    /**
     * Name of this field.  Must be unique within the {@link com.smartgwt.client.widgets.DataBoundComponent} as well as a valid
     * JavaScript identifier. See {@link com.smartgwt.client.docs.FieldName} for details and how to check for validity. <p> The
     * name of the field is usually also the property in each record which holds the record's value for the field.
     *
     * @param name New name value. Default value is null
     * @return {@link com.smartgwt.client.data.DBCField DBCField} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.FieldName FieldName 
     */
    public DBCField setName(String name) {
        return (DBCField)setAttribute("name", name);
    }

    /**
     * Name of this field.  Must be unique within the {@link com.smartgwt.client.widgets.DataBoundComponent} as well as a valid
     * JavaScript identifier. See {@link com.smartgwt.client.docs.FieldName} for details and how to check for validity. <p> The
     * name of the field is usually also the property in each record which holds the record's value for the field.
     *
     * @return Current name value. Default value is null
     * @see com.smartgwt.client.docs.FieldName FieldName 
     */
    public String getName()  {
        return getAttributeAsString("name");
    }
    

    /**
     * Preferred time-format to apply to date type values within this field.  If this property is specified on a field
     * displayed within a dataBound component such as a {@link com.smartgwt.client.widgets.grid.ListGrid} or {@link
     * com.smartgwt.client.widgets.form.DynamicForm}, any dates displayed in this field will be formatted as times using the
     * appropriate format. <P> This is most commonly only applied to fields specified as type <code>"time"</code> though if no
     * explicit {@link com.smartgwt.client.widgets.form.fields.FormItem#getDateFormatter FormItem.dateFormatter} is specified
     * it will be respected for other  fields as well. <P> See {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getTimeFormatter ListGridField.timeFormatter} and {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getTimeFormatter FormItem.timeFormatter} for more information.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param timeFormatter New timeFormatter value. Default value is null
     * @return {@link com.smartgwt.client.data.DBCField DBCField} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public DBCField setTimeFormatter(TimeDisplayFormat timeFormatter) {
        return (DBCField)setAttribute("timeFormatter", timeFormatter == null ? null : timeFormatter.getValue());
    }

    /**
     * Preferred time-format to apply to date type values within this field.  If this property is specified on a field
     * displayed within a dataBound component such as a {@link com.smartgwt.client.widgets.grid.ListGrid} or {@link
     * com.smartgwt.client.widgets.form.DynamicForm}, any dates displayed in this field will be formatted as times using the
     * appropriate format. <P> This is most commonly only applied to fields specified as type <code>"time"</code> though if no
     * explicit {@link com.smartgwt.client.widgets.form.fields.FormItem#getDateFormatter FormItem.dateFormatter} is specified
     * it will be respected for other  fields as well. <P> See {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getTimeFormatter ListGridField.timeFormatter} and {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getTimeFormatter FormItem.timeFormatter} for more information.
     *
     * @return Current timeFormatter value. Default value is null
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public TimeDisplayFormat getTimeFormatter()  {
        return EnumUtil.getEnum(TimeDisplayFormat.values(), getAttribute("timeFormatter"));
    }
    

    /**
     * A {@link com.smartgwt.client.types.ValueMap} is a set of legal values for a field.
     *  <p>
     *  The valueMap can be specified as either an Array of legal values, or as an
     *  {@link java.lang.Object} where each property maps a stored value to a user-displayable value.
     *  <p>
     *  To enforce that a field should be constrained to only the values in the valueMap, either
     *  declare {@link com.smartgwt.client.data.DataSourceField#getType field.type} as "enum", or use a
     *  {@link com.smartgwt.client.types.ValidatorType} of "isOneOf" with explicitly listed values.  Otherwise,
     * although a normal {@link com.smartgwt.client.widgets.form.fields.SelectItem} control will only allow values from the
     * valueMap to be
     * entered, other controls such as a {@link com.smartgwt.client.widgets.form.fields.ComboBoxItem ComboBox} will allow other
     * values 
     *  to be entered.
     *  <p>
     *  In XML, a valueMap that specifies only a list of legal values is specified as follows:
     *  <pre>
     *    &lt;valueMap&gt;
     *     &lt;value&gt;Pens &amp; Pencils&lt;/value&gt;
     *     &lt;value&gt;Stationery&lt;/value&gt;
     *     &lt;value&gt;Computer Products&lt;/value&gt;
     *     &lt;value&gt;Furniture&lt;/value&gt;
     *     &lt;value&gt;Misc&lt;/value&gt;
     *    &lt;/valueMap&gt;
     *  </pre>
     *  A ValueMap that specifies stored values mapped to user-visible values is specified as
     *  follows:
     *  <pre>
     *    &lt;valueMap&gt;
     *     &lt;value ID="1"&gt;Pens &amp; Pencils&lt;/value&gt;
     *     &lt;value ID="2"&gt;Stationery&lt;/value&gt;
     *     &lt;value ID="3"&gt;Computer Products&lt;/value&gt;
     *     &lt;value ID="4"&gt;Furniture&lt;/value&gt;
     *     &lt;value ID="5"&gt;Misc&lt;/value&gt;
     *    &lt;/valueMap&gt;
     *  </pre>
     *
     * @param valueMap New valueMap value. Default value is null
     * @return {@link com.smartgwt.client.data.DBCField DBCField} instance, for chaining setter calls
     */
    public DBCField setValueMap(Map valueMap) {
        return (DBCField)setAttribute("valueMap", valueMap);
    }

    /**
     * A {@link com.smartgwt.client.types.ValueMap} is a set of legal values for a field.
     *  <p>
     *  The valueMap can be specified as either an Array of legal values, or as an
     *  {@link java.lang.Object} where each property maps a stored value to a user-displayable value.
     *  <p>
     *  To enforce that a field should be constrained to only the values in the valueMap, either
     *  declare {@link com.smartgwt.client.data.DataSourceField#getType field.type} as "enum", or use a
     *  {@link com.smartgwt.client.types.ValidatorType} of "isOneOf" with explicitly listed values.  Otherwise,
     * although a normal {@link com.smartgwt.client.widgets.form.fields.SelectItem} control will only allow values from the
     * valueMap to be
     * entered, other controls such as a {@link com.smartgwt.client.widgets.form.fields.ComboBoxItem ComboBox} will allow other
     * values 
     *  to be entered.
     *  <p>
     *  In XML, a valueMap that specifies only a list of legal values is specified as follows:
     *  <pre>
     *    &lt;valueMap&gt;
     *     &lt;value&gt;Pens &amp; Pencils&lt;/value&gt;
     *     &lt;value&gt;Stationery&lt;/value&gt;
     *     &lt;value&gt;Computer Products&lt;/value&gt;
     *     &lt;value&gt;Furniture&lt;/value&gt;
     *     &lt;value&gt;Misc&lt;/value&gt;
     *    &lt;/valueMap&gt;
     *  </pre>
     *  A ValueMap that specifies stored values mapped to user-visible values is specified as
     *  follows:
     *  <pre>
     *    &lt;valueMap&gt;
     *     &lt;value ID="1"&gt;Pens &amp; Pencils&lt;/value&gt;
     *     &lt;value ID="2"&gt;Stationery&lt;/value&gt;
     *     &lt;value ID="3"&gt;Computer Products&lt;/value&gt;
     *     &lt;value ID="4"&gt;Furniture&lt;/value&gt;
     *     &lt;value ID="5"&gt;Misc&lt;/value&gt;
     *    &lt;/valueMap&gt;
     *  </pre>
     *
     * @return Current valueMap value. Default value is null
     */
    public Map getValueMap()  {
        return getAttributeAsMap("valueMap");
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
