/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets.form.fields;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * MultiPickerItem provides an interface to edit data involving whether a  record has membership in a certain set, for
 * example, where specific Employees  are part of specific Teams. <P> MultiPickerItem is a compact editor for this purpose,
 * using a  {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickerLayout pop-up} to present a {@link
 * com.smartgwt.client.widgets.grid.Shuttle}-style interface  for moving records or values being different categories. When
 * the MultiPickerItem  pop-up is not active, MultiPickerItem just displays the currently chosen  values as read-only text,
 * which can be {@link com.smartgwt.client.widgets.form.fields.StaticTextItem#getClipValue clipped} to  appear in a very
 * small space. <P> <b>Note</b>: if your use case is a <i>search</i> interface to generate criteria,  in either the
 * FilterEditor of a ListGrid/TreeGrid, or in a SearchForm,  SetFilterItem is the right choice. Generally, use
 * SetFilterItem for searching,  and MultiPickerItem (or {@link com.smartgwt.client.widgets.grid.Shuttle}) for editing. <P>
 * To configure a MultiPickerItem, provide either an optionDataSource or a  valueMap. The {@link
 * com.smartgwt.client.widgets.form.fields.FormItem#getValue value} stored by a MultiPickerItem  is the set of selected
 * items, as either a list of  {@link com.smartgwt.client.data.DataSourceField#getPrimaryKey primary key values} if an
 * optionDataSource  is used, or as just ID values if an valueMap is used. <p> The item's picker-component can be
 * customized via settings such as  {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSortField sortField},
 * or by configuring  {@link com.smartgwt.client.types.AutoChild auto-children} like the  {@link
 * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getFilterForm search-form}, the  {@link
 * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickList main pickList-grid} or the separate list of  {@link
 * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionList selected values}.  You can use  {@link
 * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getOptionFilterContext optionFilterContext} to apply custom
 * <code>requestProperties</code> to fetches from the main <code>pickList</code> grid.
 */
@BeanFactory.FrameworkClass
public class MultiPickerItem extends StaticTextItem {

    public static MultiPickerItem getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof MultiPickerItem) {
            existingObj.setJsObj(jsObj);
            return (MultiPickerItem)existingObj;
        } else

        {
            return new MultiPickerItem(jsObj);
        }
    }
        


    /**
     * Changes the defaults for Canvas AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults Canvas defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, Canvas defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(MultiPickerItem.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "Canvas");
        }
        defaults.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
        var cleanDefaultsJS = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(defaults.@com.smartgwt.client.widgets.BaseWidget::getConfig()(), true);
        $wnd.isc.MultiPickerItem.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    /**
     * Changes the defaults for FormItem AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults FormItem defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, FormItem defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(MultiPickerItem.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "FormItem");
        }
        defaults.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var cleanDefaultsJS = defaults.@com.smartgwt.client.widgets.form.fields.FormItem::getEditorTypeConfig()();
        $wnd.isc.MultiPickerItem.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    public static native void changePickerIconDefaults(FormItemIcon defaults) /*-{
        $wnd.isc.MultiPickerItem.changeDefaults("pickerIconDefaults", defaults.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;

    public MultiPickerItem(){
        setAttribute("editorType", "MultiPickerItem");
    }

    public MultiPickerItem(JavaScriptObject jsObj){
        super(jsObj);
    }


    public MultiPickerItem(String name) {
        setName(name);
                setAttribute("editorType", "MultiPickerItem");
    }



    // ********************* Properties / Attributes ***********************

    /**
     * Should we show an {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getExpansionIcon expansionIcon} expand
     * button allowing the user to show an expanded view of the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickList pickList} with multiple fields. <P>
     * <code>canExpand</code> only applies to MultiPickerItems with selectionStyle set to "pickList" or "pickTree" and an
     * explicitly specified set  of {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getExpandedPickListFields
     * expandedPickListFields} to display within the expanded view.
     *
     * @param canExpand New canExpand value. Default value is true
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setCanExpand(Boolean canExpand) {
        return (MultiPickerItem)setAttribute("canExpand", canExpand);
    }

    /**
     * Should we show an {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getExpansionIcon expansionIcon} expand
     * button allowing the user to show an expanded view of the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickList pickList} with multiple fields. <P>
     * <code>canExpand</code> only applies to MultiPickerItems with selectionStyle set to "pickList" or "pickTree" and an
     * explicitly specified set  of {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getExpandedPickListFields
     * expandedPickListFields} to display within the expanded view.
     *
     * @return Current canExpand value. Default value is true
     */
    public Boolean getCanExpand()  {
        Boolean result = getAttributeAsBoolean("canExpand", true);
        return result == null ? true : result;
    }
    

    /**
     * For multiPickerItems with {@link com.smartgwt.client.types.SelectionStyle selectionStyle:"pickTree"}, should the user be
     * able to select and deselect folders? <P> If false, selection checkboxes will only be visible by leaf nodes within the
     * pickTree data set. <P> Note that this flag may be set to true in conjunction with  {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getIncludeSelectedParents includeSelectedParents:false}. In this
     * case the user may check and uncheck parent nodes as a convenient way to  select or unselect all their children due to
     * {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCascadeSelection cascading selection}, but the parent
     * nodes themselves won't be present in the item's value.
     *
     * @param canSelectFolders New canSelectFolders value. Default value is true
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setCanSelectFolders(Boolean canSelectFolders) {
        return (MultiPickerItem)setAttribute("canSelectFolders", canSelectFolders);
    }

    /**
     * For multiPickerItems with {@link com.smartgwt.client.types.SelectionStyle selectionStyle:"pickTree"}, should the user be
     * able to select and deselect folders? <P> If false, selection checkboxes will only be visible by leaf nodes within the
     * pickTree data set. <P> Note that this flag may be set to true in conjunction with  {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getIncludeSelectedParents includeSelectedParents:false}. In this
     * case the user may check and uncheck parent nodes as a convenient way to  select or unselect all their children due to
     * {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCascadeSelection cascading selection}, but the parent
     * nodes themselves won't be present in the item's value.
     *
     * @return Current canSelectFolders value. Default value is true
     */
    public Boolean getCanSelectFolders()  {
        Boolean result = getAttributeAsBoolean("canSelectFolders", true);
        return result == null ? true : result;
    }
    

    /**
     * For multiPickerItems with {@link com.smartgwt.client.types.SelectionStyle selectionStyle:"pickTree"}, and {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCanSelectFolders canSelectFolders:true}, should  {@link
     * com.smartgwt.client.widgets.tree.TreeGrid#getCascadeSelection TreeGrid.cascadeSelection} be enabled on our pickTree?
     *
     * @param cascadeSelection New cascadeSelection value. Default value is true
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setCascadeSelection(Boolean cascadeSelection) {
        return (MultiPickerItem)setAttribute("cascadeSelection", cascadeSelection);
    }

    /**
     * For multiPickerItems with {@link com.smartgwt.client.types.SelectionStyle selectionStyle:"pickTree"}, and {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCanSelectFolders canSelectFolders:true}, should  {@link
     * com.smartgwt.client.widgets.tree.TreeGrid#getCascadeSelection TreeGrid.cascadeSelection} be enabled on our pickTree?
     *
     * @return Current cascadeSelection value. Default value is true
     */
    public Boolean getCascadeSelection()  {
        Boolean result = getAttributeAsBoolean("cascadeSelection", true);
        return result == null ? true : result;
    }
    

    /**
     * {@link com.smartgwt.client.docs.SCImgURL} for the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getExpansionIcon expansionIcon} while in expanded mode
     *
     * @param collapseIconSrc New collapseIconSrc value. Default value is "[SKINIMG]/actions/collapse_left.png"
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setCollapseIconSrc(String collapseIconSrc) {
        return (MultiPickerItem)setAttribute("collapseIconSrc", collapseIconSrc);
    }

    /**
     * {@link com.smartgwt.client.docs.SCImgURL} for the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getExpansionIcon expansionIcon} while in expanded mode
     *
     * @return Current collapseIconSrc value. Default value is "[SKINIMG]/actions/collapse_left.png"
     */
    public String getCollapseIconSrc()  {
        return getAttributeAsString("collapseIconSrc");
    }
    

    /**
     * If this MultiPickerItem is deriving its options from a dataSource, should it ensure unique field values by {@link
     * com.smartgwt.client.data.DSRequest#getGroupBy grouping by} the value field for this item? This is not necessary if the
     * target dataSource value field is already unique - for example if this is the primaryKey field for a dataSource. <P> Note
     * that for MultiPickerItems with <code>deriveUniqueValues:true</code>, any {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getExpandedPickListFields expandedPickListFields} to be
     * displayed in the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCanExpand expanded view} will not be
     * able to display meaningful values unless a  {@link com.smartgwt.client.data.DSRequest#getSummaryFunctions
     * summaryFunction} is supplied to produce aggregated values from the grouped data. This may be achieved by specifying 
     * summaryFunctions directly on the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getOptionFilterContext
     * optionFilterContext}, or on the  {@link com.smartgwt.client.data.DataSource#getOperationBindings operationBinding} for
     * the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getOptionOperationId fetch operation}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param deriveUniqueValues New deriveUniqueValues value. Default value is false
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setDeriveUniqueValues(Boolean deriveUniqueValues) {
        return (MultiPickerItem)setAttribute("deriveUniqueValues", deriveUniqueValues);
    }

    /**
     * If this MultiPickerItem is deriving its options from a dataSource, should it ensure unique field values by {@link
     * com.smartgwt.client.data.DSRequest#getGroupBy grouping by} the value field for this item? This is not necessary if the
     * target dataSource value field is already unique - for example if this is the primaryKey field for a dataSource. <P> Note
     * that for MultiPickerItems with <code>deriveUniqueValues:true</code>, any {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getExpandedPickListFields expandedPickListFields} to be
     * displayed in the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCanExpand expanded view} will not be
     * able to display meaningful values unless a  {@link com.smartgwt.client.data.DSRequest#getSummaryFunctions
     * summaryFunction} is supplied to produce aggregated values from the grouped data. This may be achieved by specifying 
     * summaryFunctions directly on the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getOptionFilterContext
     * optionFilterContext}, or on the  {@link com.smartgwt.client.data.DataSource#getOperationBindings operationBinding} for
     * the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getOptionOperationId fetch operation}.
     *
     * @return Current deriveUniqueValues value. Default value is false
     */
    public Boolean getDeriveUniqueValues()  {
        Boolean result = getAttributeAsBoolean("deriveUniqueValues", true);
        return result == null ? false : result;
    }
    

    /**
     * Clear All button {@link com.smartgwt.client.types.AutoChild}
     * <p>
     * This component is an AutoChild named "deselectAllButton".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current deselectAllButton value. Default value is null
     */
    public ToolStripButton getDeselectAllButton()  {
        return (ToolStripButton)ToolStripButton.getByJSObject(getAttributeAsJavaScriptObject("deselectAllButton"));
    }
    

    /**
     * Title for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getDeselectAllButton deselectAllButton}
     *
     * @param deselectAllButtonTitle New deselectAllButtonTitle value. Default value is "Clear All"
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setDeselectAllButtonTitle(String deselectAllButtonTitle) {
        return (MultiPickerItem)setAttribute("deselectAllButtonTitle", deselectAllButtonTitle);
    }

    /**
     * Title for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getDeselectAllButton deselectAllButton}
     *
     * @return Current deselectAllButtonTitle value. Default value is "Clear All"
     */
    public String getDeselectAllButtonTitle()  {
        return getAttributeAsString("deselectAllButtonTitle");
    }
    

    /**
     * Disabled prompt for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getDeselectAllButton
     * deselectAllButton} while filtered if {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectAllWhileFiltered selectAllWhileFiltered} is set to
     * <code>"disable"</code>.
     *
     * @param deselectAllWhileFiltered_disabledPrompt New deselectAllWhileFiltered_disabledPrompt value. Default value is "Clear All disabled while filtered"
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setDeselectAllWhileFiltered_disabledPrompt(String deselectAllWhileFiltered_disabledPrompt) {
        return (MultiPickerItem)setAttribute("deselectAllWhileFiltered_disabledPrompt", deselectAllWhileFiltered_disabledPrompt);
    }

    /**
     * Disabled prompt for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getDeselectAllButton
     * deselectAllButton} while filtered if {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectAllWhileFiltered selectAllWhileFiltered} is set to
     * <code>"disable"</code>.
     *
     * @return Current deselectAllWhileFiltered_disabledPrompt value. Default value is "Clear All disabled while filtered"
     */
    public String getDeselectAllWhileFiltered_disabledPrompt()  {
        return getAttributeAsString("deselectAllWhileFiltered_disabledPrompt");
    }
    

    /**
     * Disabled prompt for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getDeselectAllButton
     * deselectAllButton} while filtered if {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectAllWhileFiltered selectAllWhileFiltered} is set to
     * <code>"whenLoaded"</code> and the PickList does not have a complete data set loaded on the client.
     *
     * @param deselectAllWhileFiltered_partialCachePrompt New deselectAllWhileFiltered_partialCachePrompt value. Default value is "Unable to Clear All as the full set of options has not been fetched from the server."
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setDeselectAllWhileFiltered_partialCachePrompt(String deselectAllWhileFiltered_partialCachePrompt) {
        return (MultiPickerItem)setAttribute("deselectAllWhileFiltered_partialCachePrompt", deselectAllWhileFiltered_partialCachePrompt);
    }

    /**
     * Disabled prompt for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getDeselectAllButton
     * deselectAllButton} while filtered if {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectAllWhileFiltered selectAllWhileFiltered} is set to
     * <code>"whenLoaded"</code> and the PickList does not have a complete data set loaded on the client.
     *
     * @return Current deselectAllWhileFiltered_partialCachePrompt value. Default value is "Unable to Clear All as the full set of options has not been fetched from the server."
     */
    public String getDeselectAllWhileFiltered_partialCachePrompt()  {
        return getAttributeAsString("deselectAllWhileFiltered_partialCachePrompt");
    }
    

    /**
     * If set, this item will display a value from another field to the user instead of showing the underlying data value for
     * the {@link com.smartgwt.client.widgets.form.fields.FormItem#getName field name}. <P> This property is used in two ways:
     * <P> The item will display the displayField value from the  {@link com.smartgwt.client.widgets.form.DynamicForm#getValues
     * record currently being edited} if  {@link com.smartgwt.client.widgets.form.fields.FormItem#getUseLocalDisplayFieldValue
     * FormItem.useLocalDisplayFieldValue} is true, (or if unset and the conditions outlined in the documentation for that
     * property are met). <P> If this field has an {@link com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource
     * FormItem.optionDataSource}, this property is used by default to identify which value to use as a display value in
     * records from this related dataSource. In this usage the specified displayField must be  explicitly defined in the
     * optionDataSource to be used - see  {@link com.smartgwt.client.widgets.form.fields.FormItem#getDisplayFieldName
     * getDisplayFieldName()} for more on this behavior.<br> If not using {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getUseLocalDisplayFieldValue local display values}, the display value
     * for this item will be derived by performing a fetch against the  {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource option dataSource}  to find a record where the
     * {@link com.smartgwt.client.widgets.form.fields.FormItem#getValueFieldName value field} matches  this item's value, and
     * use the <code>displayField</code> value from that record.<br> In addition to this, PickList-based form items that
     * provide a list of possible options such as the {@link com.smartgwt.client.widgets.form.fields.SelectItem} or {@link
     * com.smartgwt.client.widgets.form.fields.ComboBoxItem} will show the  <code>displayField</code> values to the user by
     * default, allowing them to choose a new data value (see {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getValueField FormItem.valueField}) from a list of user-friendly
     * display values. <P> This essentially allows the specified <code>optionDataSource</code> to be used as a server based
     * {@link valueMap}. <P> If {@link com.smartgwt.client.widgets.form.fields.FormItem#getUseLocalDisplayFieldValue local
     * display values} are being used and {@link com.smartgwt.client.widgets.form.fields.FormItem#getStoreDisplayValues
     * FormItem.storeDisplayValues} is true, selecting a new value will update both the value for this field and the associated
     * display-field value on the record being edited. <P> Note: Developers may specify the {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getForeignDisplayField FormItem.foreignDisplayField} property  in
     * addition to <code>displayField</code>. This is useful for cases where the display field name in the local dataSource
     * differs from the display field name in the optionDataSource. See the documentation for {@link
     * com.smartgwt.client.data.DataSourceField#getForeignDisplayField DataSourceField.foreignDisplayField} for more on
     * this.<br> If a foreignDisplayField is specified, as with just displayField, if  {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getUseLocalDisplayFieldValue local display values} are being used and
     * {@link com.smartgwt.client.widgets.form.fields.FormItem#getStoreDisplayValues FormItem.storeDisplayValues} is true, when
     * the user  chooses a value the associated display-field value  on the record being edited will be updated. In this case
     * it would be set to the  foreignDisplayField value from the related record. This means foreignDisplayField  is always
     * expected to be set to the equivalent field in the related dataSources.<br> Developers looking to display some
     * <i>other</i> arbitrary field(s) from the related dataSource during editing should consider using custom 
     * PickList.pickListFields instead of setting a foreignDisplayField.  <P> Note that if <code>optionDataSource</code> is set
     * and no valid display field is specified, {@link com.smartgwt.client.widgets.form.fields.FormItem#getDisplayFieldName
     * FormItem.getDisplayFieldName()} will return the dataSource title  field by default. <P> If a displayField is specified
     * for a freeform text based item (such as a  {@link com.smartgwt.client.widgets.form.fields.ComboBoxItem}), any
     * user-entered value will be treated as a display value. In this scenario, items will derive the data value for the item
     * from the first record where the displayField value matches the user-entered value. To avoid ambiguity, developers may
     * wish to avoid this usage if display values are not unique.
     *
     * @param displayField New displayField value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.form.fields.FormItem#getDisplayFieldName
     * @see com.smartgwt.client.widgets.form.fields.FormItem#invalidateDisplayValueCache
     * @see com.smartgwt.client.docs.Databinding DataBinding
     */
    public MultiPickerItem setDisplayField(String displayField) {
        return (MultiPickerItem)setAttribute("displayField", displayField);
    }

    /**
     * If set, this item will display a value from another field to the user instead of showing the underlying data value for
     * the {@link com.smartgwt.client.widgets.form.fields.FormItem#getName field name}. <P> This property is used in two ways:
     * <P> The item will display the displayField value from the  {@link com.smartgwt.client.widgets.form.DynamicForm#getValues
     * record currently being edited} if  {@link com.smartgwt.client.widgets.form.fields.FormItem#getUseLocalDisplayFieldValue
     * FormItem.useLocalDisplayFieldValue} is true, (or if unset and the conditions outlined in the documentation for that
     * property are met). <P> If this field has an {@link com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource
     * FormItem.optionDataSource}, this property is used by default to identify which value to use as a display value in
     * records from this related dataSource. In this usage the specified displayField must be  explicitly defined in the
     * optionDataSource to be used - see  {@link com.smartgwt.client.widgets.form.fields.FormItem#getDisplayFieldName
     * getDisplayFieldName()} for more on this behavior.<br> If not using {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getUseLocalDisplayFieldValue local display values}, the display value
     * for this item will be derived by performing a fetch against the  {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource option dataSource}  to find a record where the
     * {@link com.smartgwt.client.widgets.form.fields.FormItem#getValueFieldName value field} matches  this item's value, and
     * use the <code>displayField</code> value from that record.<br> In addition to this, PickList-based form items that
     * provide a list of possible options such as the {@link com.smartgwt.client.widgets.form.fields.SelectItem} or {@link
     * com.smartgwt.client.widgets.form.fields.ComboBoxItem} will show the  <code>displayField</code> values to the user by
     * default, allowing them to choose a new data value (see {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getValueField FormItem.valueField}) from a list of user-friendly
     * display values. <P> This essentially allows the specified <code>optionDataSource</code> to be used as a server based
     * {@link valueMap}. <P> If {@link com.smartgwt.client.widgets.form.fields.FormItem#getUseLocalDisplayFieldValue local
     * display values} are being used and {@link com.smartgwt.client.widgets.form.fields.FormItem#getStoreDisplayValues
     * FormItem.storeDisplayValues} is true, selecting a new value will update both the value for this field and the associated
     * display-field value on the record being edited. <P> Note: Developers may specify the {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getForeignDisplayField FormItem.foreignDisplayField} property  in
     * addition to <code>displayField</code>. This is useful for cases where the display field name in the local dataSource
     * differs from the display field name in the optionDataSource. See the documentation for {@link
     * com.smartgwt.client.data.DataSourceField#getForeignDisplayField DataSourceField.foreignDisplayField} for more on
     * this.<br> If a foreignDisplayField is specified, as with just displayField, if  {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getUseLocalDisplayFieldValue local display values} are being used and
     * {@link com.smartgwt.client.widgets.form.fields.FormItem#getStoreDisplayValues FormItem.storeDisplayValues} is true, when
     * the user  chooses a value the associated display-field value  on the record being edited will be updated. In this case
     * it would be set to the  foreignDisplayField value from the related record. This means foreignDisplayField  is always
     * expected to be set to the equivalent field in the related dataSources.<br> Developers looking to display some
     * <i>other</i> arbitrary field(s) from the related dataSource during editing should consider using custom 
     * PickList.pickListFields instead of setting a foreignDisplayField.  <P> Note that if <code>optionDataSource</code> is set
     * and no valid display field is specified, {@link com.smartgwt.client.widgets.form.fields.FormItem#getDisplayFieldName
     * FormItem.getDisplayFieldName()} will return the dataSource title  field by default. <P> If a displayField is specified
     * for a freeform text based item (such as a  {@link com.smartgwt.client.widgets.form.fields.ComboBoxItem}), any
     * user-entered value will be treated as a display value. In this scenario, items will derive the data value for the item
     * from the first record where the displayField value matches the user-entered value. To avoid ambiguity, developers may
     * wish to avoid this usage if display values are not unique.
     *
     * @return Current displayField value. Default value is null
     * @see com.smartgwt.client.widgets.form.fields.FormItem#getDisplayFieldName
     * @see com.smartgwt.client.widgets.form.fields.FormItem#invalidateDisplayValueCache
     * @see com.smartgwt.client.docs.Databinding DataBinding
     */
    public String getDisplayField()  {
        return getAttributeAsString("displayField");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCanExpand canExpand} is true, this is the list of
     * fields to display in the  PickList or {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickTree
     * pickTree} when the picker is expanded
     *
     * @param expandedPickListFields New expandedPickListFields value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setExpandedPickListFields(ListGridField... expandedPickListFields) {
        return (MultiPickerItem)setAttribute("expandedPickListFields", expandedPickListFields);
    }

    /**
     * If {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCanExpand canExpand} is true, this is the list of
     * fields to display in the  PickList or {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickTree
     * pickTree} when the picker is expanded
     *
     * @return Current expandedPickListFields value. Default value is null
     */
    public ListGridField[] getExpandedPickListFields()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfListGridField(getAttributeAsJavaScriptObject("expandedPickListFields"));
    }
    

    /**
     * {@link com.smartgwt.client.docs.SCImgURL} for the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getExpansionIcon expansionIcon} while not in expanded mode
     *
     * @param expandIconSrc New expandIconSrc value. Default value is "[SKINIMG]/actions/expand_right.png"
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setExpandIconSrc(String expandIconSrc) {
        return (MultiPickerItem)setAttribute("expandIconSrc", expandIconSrc);
    }

    /**
     * {@link com.smartgwt.client.docs.SCImgURL} for the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getExpansionIcon expansionIcon} while not in expanded mode
     *
     * @return Current expandIconSrc value. Default value is "[SKINIMG]/actions/expand_right.png"
     */
    public String getExpandIconSrc()  {
        return getAttributeAsString("expandIconSrc");
    }
    

    /**
     * Height for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickerLayout pickerLayout} in expanded
     * mode when {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCanExpand canExpand} is true
     *
     * @param expansionHeight New expansionHeight value. Default value is 500
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setExpansionHeight(Integer expansionHeight) {
        return (MultiPickerItem)setAttribute("expansionHeight", expansionHeight);
    }

    /**
     * Height for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickerLayout pickerLayout} in expanded
     * mode when {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCanExpand canExpand} is true
     *
     * @return Current expansionHeight value. Default value is 500
     */
    public Integer getExpansionHeight()  {
        return getAttributeAsInt("expansionHeight");
    }
    

    /**
     * Automatically generated expand / collapse icon when {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCanExpand canExpand} is true
     * <p>
     * This component is an AutoChild named "expansionIcon".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current expansionIcon value. Default value is null
     */
    public ToolStripButton getExpansionIcon()  {
        return (ToolStripButton)ToolStripButton.getByJSObject(getAttributeAsJavaScriptObject("expansionIcon"));
    }
    

    /**
     * Width for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickerLayout pickerLayout} in expanded
     * mode when {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCanExpand canExpand} is true
     *
     * @param expansionWidth New expansionWidth value. Default value is 500
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setExpansionWidth(Integer expansionWidth) {
        return (MultiPickerItem)setAttribute("expansionWidth", expansionWidth);
    }

    /**
     * Width for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickerLayout pickerLayout} in expanded
     * mode when {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCanExpand canExpand} is true
     *
     * @return Current expansionWidth value. Default value is 500
     */
    public Integer getExpansionWidth()  {
        return getAttributeAsInt("expansionWidth");
    }
    

    /**
     * Dynamic form showing a single text item for filtering the PickList while {@link
     * com.smartgwt.client.types.SelectionStyle} is "pickList". <P> May be hidden by setting {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getShowFilterForm showFilterForm} to false. <P> If {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCanExpand canExpand} is true, the filter form will not be
     * displayed in the expanded view, as it would be unclear to the user which of the expanded fields would be filtered by it.
     * <P> Instead if <code>showFilterForm</code> is true, the pickList will show the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor filterEditor} by default, allowing the user to filter by
     * {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getExpandedPickListFields field} <P> Instead of the
     * filterForm, developers may display the standard filterEditor for the pickList in non-expanded view via {@link
     * com.smartgwt.client.docs.AutoChildUsage pickList autoChild properties}. If you do this  the filterForm will not be
     * displayed even if<code>showFilterForm</code> is true.
     * <p>
     * This component is an AutoChild named "filterForm".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current filterForm value. Default value is null
     */
    public DynamicForm getFilterForm()  {
        return (DynamicForm)DynamicForm.getByJSObject(getAttributeAsJavaScriptObject("filterForm"));
    }
    

    /**
     * {@link com.smartgwt.client.widgets.form.fields.FormItem#getHint Hint} for the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getFilterForm filterForm} text item. <P> This will be shown
     * inside the field via {@link com.smartgwt.client.widgets.form.fields.TextItem#getShowHintInField
     * TextItem.showHintInField}
     *
     * @param filterHint New filterHint value. Default value is "Filter"
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setFilterHint(String filterHint) {
        return (MultiPickerItem)setAttribute("filterHint", filterHint);
    }

    /**
     * {@link com.smartgwt.client.widgets.form.fields.FormItem#getHint Hint} for the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getFilterForm filterForm} text item. <P> This will be shown
     * inside the field via {@link com.smartgwt.client.widgets.form.fields.TextItem#getShowHintInField
     * TextItem.showHintInField}
     *
     * @return Current filterHint value. Default value is "Filter"
     */
    public String getFilterHint()  {
        return getAttributeAsString("filterHint");
    }
    

    /**
     * Automatically generated right-aligned inline filter indicator icon  for the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getFilterForm filterForm} text box. <P> This icon may be
     * customized using the standard AutoChild pattern as well as via {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getFilterIconSrc filterIconSrc}, {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getFilterIconWidth filterIconWidth}, {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getFilterIconHeight filterIconHeight}
     * <p>
     * This component is an AutoChild named "filterIcon".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current filterIcon value. Default value is null
     */
    public FormItemIcon getFilterIcon()  {
        return new FormItemIcon(getAttributeAsJavaScriptObject("filterIcon"));
    }
    

    /**
     * {@link com.smartgwt.client.widgets.form.fields.FormItemIcon#getHeight height} for the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getFilterIcon filterIcon}
     *
     * @param filterIconHeight New filterIconHeight value. Default value is 16
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setFilterIconHeight(Integer filterIconHeight) {
        return (MultiPickerItem)setAttribute("filterIconHeight", filterIconHeight);
    }

    /**
     * {@link com.smartgwt.client.widgets.form.fields.FormItemIcon#getHeight height} for the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getFilterIcon filterIcon}
     *
     * @return Current filterIconHeight value. Default value is 16
     */
    public Integer getFilterIconHeight()  {
        return getAttributeAsInt("filterIconHeight");
    }
    

    /**
     * {@link com.smartgwt.client.widgets.form.fields.FormItemIcon#getSrc src} for the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getFilterIcon filterIcon}
     *
     * @param filterIconSrc New filterIconSrc value. Default value is "[SKINIMG]actions/view.png"
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setFilterIconSrc(String filterIconSrc) {
        return (MultiPickerItem)setAttribute("filterIconSrc", filterIconSrc);
    }

    /**
     * {@link com.smartgwt.client.widgets.form.fields.FormItemIcon#getSrc src} for the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getFilterIcon filterIcon}
     *
     * @return Current filterIconSrc value. Default value is "[SKINIMG]actions/view.png"
     */
    public String getFilterIconSrc()  {
        return getAttributeAsString("filterIconSrc");
    }
    

    /**
     * {@link com.smartgwt.client.widgets.form.fields.FormItemIcon#getWidth width} for the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getFilterIcon filterIcon}
     *
     * @param filterIconWidth New filterIconWidth value. Default value is 16
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setFilterIconWidth(Integer filterIconWidth) {
        return (MultiPickerItem)setAttribute("filterIconWidth", filterIconWidth);
    }

    /**
     * {@link com.smartgwt.client.widgets.form.fields.FormItemIcon#getWidth width} for the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getFilterIcon filterIcon}
     *
     * @return Current filterIconWidth value. Default value is 16
     */
    public Integer getFilterIconWidth()  {
        return getAttributeAsInt("filterIconWidth");
    }
    

    /**
     * Should {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterOnKeypress filterOnKeypress} be active for the
     * pickList? <P> This behavior applies to filter values entered in the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getFilterForm filterForm} as well as the the standard
     * filterEditor for the picklist in {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCanExpand expanded
     * view}.
     *
     * @param filterPickListOnKeypress New filterPickListOnKeypress value. Default value is true
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setFilterPickListOnKeypress(boolean filterPickListOnKeypress) {
        return (MultiPickerItem)setAttribute("filterPickListOnKeypress", filterPickListOnKeypress);
    }

    /**
     * Should {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterOnKeypress filterOnKeypress} be active for the
     * pickList? <P> This behavior applies to filter values entered in the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getFilterForm filterForm} as well as the the standard
     * filterEditor for the picklist in {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCanExpand expanded
     * view}.
     *
     * @return Current filterPickListOnKeypress value. Default value is true
     */
    public boolean getFilterPickListOnKeypress()  {
        Boolean result = getAttributeAsBoolean("filterPickListOnKeypress", true);
        return result == null ? true : result;
    }
    

    /**
     * For multiPickerItems with {@link com.smartgwt.client.types.SelectionStyle selectionStyle:"pickTree"}, and {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCanSelectFolders canSelectFolders:true}, should selected
     * parent nodes be included in the item's value? <P> When {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCascadeSelection cascading selection} is enabled for a  tree,
     * the selected state of parent nodes always reflects the selected state of their children, and it may not be necessary or
     * desirable to explicitly record the parents' selected state in the item's value.  <P> Some specific use cases where this
     * is the case might include: <ul> <li>Creating filter criteria for a target TreeGrid where      {@link
     * com.smartgwt.client.widgets.tree.TreeGrid#getKeepParentsOnFilter TreeGrid.keepParentsOnFilter} is true. In this case
     * filter     criteria would not need to include selected parent nodes for the     children to be visible in the target
     * tree.</li> <li>Trees where leaves are of a different logical type than their     parents. If a tree structure is being
     * used to categorize data,     {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCascadeSelection
     * cascading selection} may be useful to allow     the user to easily select all items within a category but application   
     * code may not want to include the categories as part of a      MultiPickerItem's value</li> </ul> <P> This property only
     * applies when {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCascadeSelection cascadeSelection} is
     * true. If cascadeSelection is false, all selected nodes will be present in the items value regardless of their
     * parent/child relationships.
     *
     * @param includeSelectedParents New includeSelectedParents value. Default value is false
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setIncludeSelectedParents(Boolean includeSelectedParents) {
        return (MultiPickerItem)setAttribute("includeSelectedParents", includeSelectedParents);
    }

    /**
     * For multiPickerItems with {@link com.smartgwt.client.types.SelectionStyle selectionStyle:"pickTree"}, and {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCanSelectFolders canSelectFolders:true}, should selected
     * parent nodes be included in the item's value? <P> When {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCascadeSelection cascading selection} is enabled for a  tree,
     * the selected state of parent nodes always reflects the selected state of their children, and it may not be necessary or
     * desirable to explicitly record the parents' selected state in the item's value.  <P> Some specific use cases where this
     * is the case might include: <ul> <li>Creating filter criteria for a target TreeGrid where      {@link
     * com.smartgwt.client.widgets.tree.TreeGrid#getKeepParentsOnFilter TreeGrid.keepParentsOnFilter} is true. In this case
     * filter     criteria would not need to include selected parent nodes for the     children to be visible in the target
     * tree.</li> <li>Trees where leaves are of a different logical type than their     parents. If a tree structure is being
     * used to categorize data,     {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCascadeSelection
     * cascading selection} may be useful to allow     the user to easily select all items within a category but application   
     * code may not want to include the categories as part of a      MultiPickerItem's value</li> </ul> <P> This property only
     * applies when {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCascadeSelection cascadeSelection} is
     * true. If cascadeSelection is false, all selected nodes will be present in the items value regardless of their
     * parent/child relationships.
     *
     * @return Current includeSelectedParents value. Default value is false
     */
    public Boolean getIncludeSelectedParents()  {
        Boolean result = getAttributeAsBoolean("includeSelectedParents", true);
        return result == null ? false : result;
    }
    

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getInitialSort Initial sort specifiers} for this item's list of
     * options. Will be applied to the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickList pickList},
     * {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickTree pickTree} or  {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getShuttle shuttle} depending on the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionStyle selectionStyle} of this item.
     *
     * @param initialSort New initialSort value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setInitialSort(SortSpecifier... initialSort) {
        return (MultiPickerItem)setAttribute("initialSort", initialSort);
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getInitialSort Initial sort specifiers} for this item's list of
     * options. Will be applied to the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickList pickList},
     * {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickTree pickTree} or  {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getShuttle shuttle} depending on the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionStyle selectionStyle} of this item.
     *
     * @return Current initialSort value. Default value is null
     */
    public SortSpecifier[] getInitialSort()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfSortSpecifier(getAttributeAsJavaScriptObject("initialSort"));
    }
    

    /**
     * MultiPickerItems always work with array values
     *
     * @param multiple New multiple value. Default value is true
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setMultiple(Boolean multiple) {
        return (MultiPickerItem)setAttribute("multiple", multiple);
    }

    /**
     * MultiPickerItems always work with array values
     *
     * @return Current multiple value. Default value is true
     */
    public Boolean getMultiple()  {
        Boolean result = getAttributeAsBoolean("multiple", true);
        return result == null ? true : result;
    }
    
    

    /**
     * If set, this FormItem will map stored values to display values as though a {@link com.smartgwt.client.types.ValueMap}
     * were specified, by fetching records from the  specified <code>optionDataSource</code> and extracting the {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getValueField valueField} and  {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getDisplayField displayField} in loaded records, to derive one valueMap
     * entry per record loaded from the optionDataSource. <P> With the default setting of {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getFetchMissingValues fetchMissingValues}, fetches will be initiated
     * against the optionDataSource any time the FormItem has a non-null value and no corresponding display value is available.
     * This includes when the form is first initialized, as well as any subsequent calls to {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#setValue FormItem.setValue()}, such as may happen when {@link
     * com.smartgwt.client.widgets.form.DynamicForm#editRecord DynamicForm.editRecord()} is called.  Retrieved values are
     * automatically cached by the FormItem. <P> Note that if a normal, static {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getValueMap valueMap} is <b>also</b> specified for the field (either
     * directly in the form item or as part of the field definition in the dataSource), it will be preferred to the data
     * derived from the optionDataSource for whatever mappings are present. <P> In a databound form, if {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getDisplayField FormItem.displayField} is specified for a FormItem and 
     * <code>optionDataSource</code> is unset, <code>optionDataSource</code> will default to the form's current DataSource
     *
     * @param optionDataSource New optionDataSource value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.form.fields.FormItem#invalidateDisplayValueCache
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#form_controls_various" target="examples">List - Combo Box Example</a>
     */
    public MultiPickerItem setOptionDataSource(DataSource optionDataSource) {
        return (MultiPickerItem)setAttribute("optionDataSource", optionDataSource == null ? null : optionDataSource.getOrCreateJsObj());
    }

    /**
     * If set, this FormItem will map stored values to display values as though a {@link com.smartgwt.client.types.ValueMap}
     * were specified, by fetching records from the  specified <code>optionDataSource</code> and extracting the {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getValueField valueField} and  {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getDisplayField displayField} in loaded records, to derive one valueMap
     * entry per record loaded from the optionDataSource. <P> With the default setting of {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getFetchMissingValues fetchMissingValues}, fetches will be initiated
     * against the optionDataSource any time the FormItem has a non-null value and no corresponding display value is available.
     * This includes when the form is first initialized, as well as any subsequent calls to {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#setValue FormItem.setValue()}, such as may happen when {@link
     * com.smartgwt.client.widgets.form.DynamicForm#editRecord DynamicForm.editRecord()} is called.  Retrieved values are
     * automatically cached by the FormItem. <P> Note that if a normal, static {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getValueMap valueMap} is <b>also</b> specified for the field (either
     * directly in the form item or as part of the field definition in the dataSource), it will be preferred to the data
     * derived from the optionDataSource for whatever mappings are present. <P> In a databound form, if {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getDisplayField FormItem.displayField} is specified for a FormItem and 
     * <code>optionDataSource</code> is unset, <code>optionDataSource</code> will default to the form's current DataSource
     *
     * @return Current optionDataSource value. Default value is null
     * @see com.smartgwt.client.widgets.form.fields.FormItem#invalidateDisplayValueCache
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#form_controls_various" target="examples">List - Combo Box Example</a>
     */
    public DataSource getOptionDataSource()  {
        return DataSource.getOrCreateRef(getAttributeAsJavaScriptObject("optionDataSource"));
    }
    

    /**
     * If this item has a specified <code>optionDataSource</code>, and this property is not null, the context is passed to the
     * dataSource as {@link com.smartgwt.client.rpc.RPCRequest} properties when performing fetch operations on the dataSource
     * to obtain a data-value to display-value mapping, and when fetching for grid-based pickers. <p> This attribute is a
     * direct shortcut for setting fetch-request properties via
     * <code>item.pickerProperties.dataProperties.requestProperties</code>.
     *
     * @param optionFilterContext New optionFilterContext value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setOptionFilterContext(DSRequest optionFilterContext) {
        return (MultiPickerItem)setAttribute("optionFilterContext", optionFilterContext == null ? null : optionFilterContext.getJsObj());
    }

    /**
     * If this item has a specified <code>optionDataSource</code>, and this property is not null, the context is passed to the
     * dataSource as {@link com.smartgwt.client.rpc.RPCRequest} properties when performing fetch operations on the dataSource
     * to obtain a data-value to display-value mapping, and when fetching for grid-based pickers. <p> This attribute is a
     * direct shortcut for setting fetch-request properties via
     * <code>item.pickerProperties.dataProperties.requestProperties</code>.
     *
     * @return Current optionFilterContext value. Default value is null
     */
    public DSRequest getOptionFilterContext()  {
        return DSRequest.getOrCreateRef(getAttributeAsJavaScriptObject("optionFilterContext"));
    }
    

    /**
     * If this item has a specified <code>optionDataSource</code>, this attribute may be set to specify an explicit {@link
     * com.smartgwt.client.data.DSRequest#getOperationId DSRequest.operationId} when performing a fetch against the option
     * dataSource to pick up display value mapping.
     *
     * @param optionOperationId New optionOperationId value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Databinding DataBinding
     */
    public MultiPickerItem setOptionOperationId(String optionOperationId) {
        return (MultiPickerItem)setAttribute("optionOperationId", optionOperationId);
    }

    /**
     * If this item has a specified <code>optionDataSource</code>, this attribute may be set to specify an explicit {@link
     * com.smartgwt.client.data.DSRequest#getOperationId DSRequest.operationId} when performing a fetch against the option
     * dataSource to pick up display value mapping.
     *
     * @return Current optionOperationId value. Default value is null
     * @see com.smartgwt.client.docs.Databinding DataBinding
     */
    public String getOptionOperationId()  {
        return getAttributeAsString("optionOperationId");
    }
    

    /**
     * Main dropdown picker layout containing the PickList or {@link com.smartgwt.client.widgets.grid.Shuttle}.
     * <p>
     * This component is an AutoChild named "pickerLayout".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current pickerLayout value. Default value is null
     */
    public VLayout getPickerLayout()  {
        return (VLayout)VLayout.getByJSObject(getAttributeAsJavaScriptObject("pickerLayout"));
    }
    

    /**
     * Toolbar autoChild containing the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectAllButton
     * selectAllButton}, {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getDeselectAllButton deselectAllButton}
     * and {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getExpansionIcon expansionIcon}. <P> Shown within the
     * {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickerLayout pickerLayout} if {@link
     * com.smartgwt.client.types.SelectionStyle} is <code>"pickList"</code>
     * <p>
     * This component is an AutoChild named "pickerToolbar".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current pickerToolbar value. Default value is null
     */
    public HLayout getPickerToolbar()  {
        return (HLayout)HLayout.getByJSObject(getAttributeAsJavaScriptObject("pickerToolbar"));
    }
    

    /**
     * The MultiPickerItem <code>pickList</code> is a filterable ListGrid {@link com.smartgwt.client.types.AutoChild} for
     * viewing and selecting the list of available options when {@link com.smartgwt.client.types.SelectionStyle} is
     * <code>"pickList"</code>. <P> It is rendered inside the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickerLayout pickerLayout} along with the optional {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionList selectionList}
     * <p>
     * This component is an AutoChild named "pickList".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current pickList value. Default value is null
     */
    public ListGrid getPickList()  {
        return (ListGrid)ListGrid.getByJSObject(getAttributeAsJavaScriptObject("pickList"));
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getFilterPickListOnKeypress filterPickListOnKeypress}
     * is true, how long to wait in ms after the last keystroke from a user before filtering the pickList. <P> If not
     * explicitly specified, the default fetchDelay will be derived from {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFetchDelay the pickList fetchDelay}.
     *
     * @param pickListFetchDelay New pickListFetchDelay value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setPickListFetchDelay(Integer pickListFetchDelay) {
        return (MultiPickerItem)setAttribute("pickListFetchDelay", pickListFetchDelay);
    }

    /**
     * If {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getFilterPickListOnKeypress filterPickListOnKeypress}
     * is true, how long to wait in ms after the last keystroke from a user before filtering the pickList. <P> If not
     * explicitly specified, the default fetchDelay will be derived from {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFetchDelay the pickList fetchDelay}.
     *
     * @return Current pickListFetchDelay value. Default value is null
     */
    public Integer getPickListFetchDelay()  {
        return getAttributeAsInt("pickListFetchDelay");
    }
    

    /**
     * Optional list of fields for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickList pickList}.
     * This property may be used to customize the appearance of the field / fields in the pickList. <P> If not explicitly
     * specified, pick list fields will be generated automatically to show the  display field (or value field if there is no
     * display field) for each option. <P> Note that if {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCanExpand canExpand} is true, developers should use {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getExpandedPickListFields expandedPickListFields} to specify the
     * set of fields to display in the expanded view.
     *
     * @param pickListFields New pickListFields value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setPickListFields(ListGridField... pickListFields) {
        return (MultiPickerItem)setAttribute("pickListFields", pickListFields);
    }

    /**
     * Optional list of fields for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickList pickList}.
     * This property may be used to customize the appearance of the field / fields in the pickList. <P> If not explicitly
     * specified, pick list fields will be generated automatically to show the  display field (or value field if there is no
     * display field) for each option. <P> Note that if {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCanExpand canExpand} is true, developers should use {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getExpandedPickListFields expandedPickListFields} to specify the
     * set of fields to display in the expanded view.
     *
     * @return Current pickListFields value. Default value is null
     */
    public ListGridField[] getPickListFields()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfListGridField(getAttributeAsJavaScriptObject("pickListFields"));
    }
    

    /**
     * Default height for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickerLayout pickerLayout} when
     * {@link com.smartgwt.client.types.SelectionStyle} is <code>"pickList"</code>.
     *
     * @param pickListHeight New pickListHeight value. Default value is 400
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setPickListHeight(Integer pickListHeight) {
        return (MultiPickerItem)setAttribute("pickListHeight", pickListHeight);
    }

    /**
     * Default height for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickerLayout pickerLayout} when
     * {@link com.smartgwt.client.types.SelectionStyle} is <code>"pickList"</code>.
     *
     * @return Current pickListHeight value. Default value is 400
     */
    public Integer getPickListHeight()  {
        return getAttributeAsInt("pickListHeight");
    }
    

    /**
     * Default width for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickerLayout pickerLayout} when
     * {@link com.smartgwt.client.types.SelectionStyle} is <code>"pickList"</code>.
     *
     * @param pickListWidth New pickListWidth value. Default value is 250
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setPickListWidth(Integer pickListWidth) {
        return (MultiPickerItem)setAttribute("pickListWidth", pickListWidth);
    }

    /**
     * Default width for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickerLayout pickerLayout} when
     * {@link com.smartgwt.client.types.SelectionStyle} is <code>"pickList"</code>.
     *
     * @return Current pickListWidth value. Default value is 250
     */
    public Integer getPickListWidth()  {
        return getAttributeAsInt("pickListWidth");
    }
    

    /**
     * The MultiPickerItem <code>pickTree</code> is a TreeGrid {@link com.smartgwt.client.types.AutoChild} for viewing and
     * selecting a tree of available options when {@link com.smartgwt.client.types.SelectionStyle} is <code>"pickTree"</code>.
     * <P> It is rendered inside the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickerLayout
     * pickerLayout} along with the optional {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionList
     * selectionList}
     * <p>
     * This component is an AutoChild named "pickTree".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current pickTree value. Default value is null
     */
    public TreeGrid getPickTree()  {
        return (TreeGrid)TreeGrid.getByJSObject(getAttributeAsJavaScriptObject("pickTree"));
    }
    

    /**
     * Select All button {@link com.smartgwt.client.types.AutoChild}
     * <p>
     * This component is an AutoChild named "selectAllButton".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current selectAllButton value. Default value is null
     */
    public ToolStripButton getSelectAllButton()  {
        return (ToolStripButton)ToolStripButton.getByJSObject(getAttributeAsJavaScriptObject("selectAllButton"));
    }
    

    /**
     * Title for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectAllButton selectAllButton}
     *
     * @param selectAllButtonTitle New selectAllButtonTitle value. Default value is "Select All"
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setSelectAllButtonTitle(String selectAllButtonTitle) {
        return (MultiPickerItem)setAttribute("selectAllButtonTitle", selectAllButtonTitle);
    }

    /**
     * Title for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectAllButton selectAllButton}
     *
     * @return Current selectAllButtonTitle value. Default value is "Select All"
     */
    public String getSelectAllButtonTitle()  {
        return getAttributeAsString("selectAllButtonTitle");
    }
    

    /**
     * If the user has filtered the set of options available in this item, how should the "Select All" and "Clear All" buttons
     * work?
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param selectAllWhileFiltered New selectAllWhileFiltered value. Default value is "whenLoaded"
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setSelectAllWhileFiltered(FilteredSelectAllAction selectAllWhileFiltered) {
        return (MultiPickerItem)setAttribute("selectAllWhileFiltered", selectAllWhileFiltered == null ? null : selectAllWhileFiltered.getValue());
    }

    /**
     * If the user has filtered the set of options available in this item, how should the "Select All" and "Clear All" buttons
     * work?
     *
     * @return Current selectAllWhileFiltered value. Default value is "whenLoaded"
     */
    public FilteredSelectAllAction getSelectAllWhileFiltered()  {
        return EnumUtil.getEnum(FilteredSelectAllAction.values(), getAttribute("selectAllWhileFiltered"));
    }
    

    /**
     * Disabled prompt for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectAllButton
     * selectAllButton} while filtered if {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectAllWhileFiltered selectAllWhileFiltered} is set to
     * <code>"disable"</code>.
     *
     * @param selectAllWhileFiltered_disabledPrompt New selectAllWhileFiltered_disabledPrompt value. Default value is "Select All disabled while filtered"
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setSelectAllWhileFiltered_disabledPrompt(String selectAllWhileFiltered_disabledPrompt) {
        return (MultiPickerItem)setAttribute("selectAllWhileFiltered_disabledPrompt", selectAllWhileFiltered_disabledPrompt);
    }

    /**
     * Disabled prompt for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectAllButton
     * selectAllButton} while filtered if {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectAllWhileFiltered selectAllWhileFiltered} is set to
     * <code>"disable"</code>.
     *
     * @return Current selectAllWhileFiltered_disabledPrompt value. Default value is "Select All disabled while filtered"
     */
    public String getSelectAllWhileFiltered_disabledPrompt()  {
        return getAttributeAsString("selectAllWhileFiltered_disabledPrompt");
    }
    

    /**
     * Disabled prompt for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectAllButton
     * selectAllButton} while filtered if {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectAllWhileFiltered selectAllWhileFiltered} is set to
     * <code>"whenLoaded"</code> and the PickList does not have a complete data set loaded on the client.
     *
     * @param selectAllWhileFiltered_partialCachePrompt New selectAllWhileFiltered_partialCachePrompt value. Default value is "Unable to Select All as the full set of options has not been fetched from the server."
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setSelectAllWhileFiltered_partialCachePrompt(String selectAllWhileFiltered_partialCachePrompt) {
        return (MultiPickerItem)setAttribute("selectAllWhileFiltered_partialCachePrompt", selectAllWhileFiltered_partialCachePrompt);
    }

    /**
     * Disabled prompt for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectAllButton
     * selectAllButton} while filtered if {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectAllWhileFiltered selectAllWhileFiltered} is set to
     * <code>"whenLoaded"</code> and the PickList does not have a complete data set loaded on the client.
     *
     * @return Current selectAllWhileFiltered_partialCachePrompt value. Default value is "Unable to Select All as the full set of options has not been fetched from the server."
     */
    public String getSelectAllWhileFiltered_partialCachePrompt()  {
        return getAttributeAsString("selectAllWhileFiltered_partialCachePrompt");
    }
    

    /**
     * Default title for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionList selectionList}.
     *
     * @param selectedSelectionListTitle New selectedSelectionListTitle value. Default value is "Included Items"
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setSelectedSelectionListTitle(String selectedSelectionListTitle) {
        return (MultiPickerItem)setAttribute("selectedSelectionListTitle", selectedSelectionListTitle);
    }

    /**
     * Default title for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionList selectionList}.
     *
     * @return Current selectedSelectionListTitle value. Default value is "Included Items"
     */
    public String getSelectedSelectionListTitle()  {
        return getAttributeAsString("selectedSelectionListTitle");
    }
    

    /**
     * Automatically generated ListGrid displaying the current selection for {@link com.smartgwt.client.types.SelectionStyle
     * selectionStyle:"pickList"}. <P> Has {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords
     * canRemoveRecords} enabled as an alternative UI for deselecting records to unchecking the item in the PickList.
     * <p>
     * This component is an AutoChild named "selectionList".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current selectionList value. Default value is null
     */
    public ListGrid getSelectionList()  {
        return (ListGrid)ListGrid.getByJSObject(getAttributeAsJavaScriptObject("selectionList"));
    }
    

    /**
     * AutoChild to show the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectedSelectionListTitle
     * selectedSelectionListTitle}
     * <p>
     * This component is an AutoChild named "selectionListLabel".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current selectionListLabel value. Default value is null
     */
    public Label getSelectionListLabel()  {
        return (Label)Label.getByJSObject(getAttributeAsJavaScriptObject("selectionListLabel"));
    }
    

    /**
     * Should the MultiPickerItem use a {@link com.smartgwt.client.widgets.grid.Shuttle} style interface to indicate the
     * currently selected / unselected values?
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param selectionStyle New selectionStyle value. Default value is "pickList"
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setSelectionStyle(MultiPickerSelectionStyle selectionStyle) {
        return (MultiPickerItem)setAttribute("selectionStyle", selectionStyle == null ? null : selectionStyle.getValue());
    }

    /**
     * Should the MultiPickerItem use a {@link com.smartgwt.client.widgets.grid.Shuttle} style interface to indicate the
     * currently selected / unselected values?
     *
     * @return Current selectionStyle value. Default value is "pickList"
     */
    public MultiPickerSelectionStyle getSelectionStyle()  {
        return EnumUtil.getEnum(MultiPickerSelectionStyle.values(), getAttribute("selectionStyle"));
    }
    

    /**
     * Should the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getFilterForm filterForm} be shown? <P> This
     * only applies to selectionStyle "pickList".
     *
     * @param showFilterForm New showFilterForm value. Default value is true
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setShowFilterForm(boolean showFilterForm) {
        return (MultiPickerItem)setAttribute("showFilterForm", showFilterForm);
    }

    /**
     * Should the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getFilterForm filterForm} be shown? <P> This
     * only applies to selectionStyle "pickList".
     *
     * @return Current showFilterForm value. Default value is true
     */
    public boolean getShowFilterForm()  {
        Boolean result = getAttributeAsBoolean("showFilterForm", true);
        return result == null ? true : result;
    }
    

    /**
     * Should we show a {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionListLabel
     * selectionListLabel} for the  {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectedSelectionListTitle selectedSelectionListTitle} above
     * the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionList selectionList}. <P> Will never be
     * shown if {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getShowSelectionList showSelectionList} is false
     * or if selectionStyle is not "pickList".
     *
     * @param showSelectionLabel New showSelectionLabel value. Default value is true
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setShowSelectionLabel(Boolean showSelectionLabel) {
        return (MultiPickerItem)setAttribute("showSelectionLabel", showSelectionLabel);
    }

    /**
     * Should we show a {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionListLabel
     * selectionListLabel} for the  {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectedSelectionListTitle selectedSelectionListTitle} above
     * the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionList selectionList}. <P> Will never be
     * shown if {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getShowSelectionList showSelectionList} is false
     * or if selectionStyle is not "pickList".
     *
     * @return Current showSelectionLabel value. Default value is true
     */
    public Boolean getShowSelectionLabel()  {
        Boolean result = getAttributeAsBoolean("showSelectionLabel", true);
        return result == null ? true : result;
    }
    

    /**
     * Should a {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionList list of selected items} be
     * displayed below the PickList if {@link com.smartgwt.client.types.SelectionStyle} is <code>"pickList"</code>?
     *
     * @param showSelectionList New showSelectionList value. Default value is true
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setShowSelectionList(Boolean showSelectionList) {
        return (MultiPickerItem)setAttribute("showSelectionList", showSelectionList);
    }

    /**
     * Should a {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionList list of selected items} be
     * displayed below the PickList if {@link com.smartgwt.client.types.SelectionStyle} is <code>"pickList"</code>?
     *
     * @return Current showSelectionList value. Default value is true
     */
    public Boolean getShowSelectionList()  {
        Boolean result = getAttributeAsBoolean("showSelectionList", true);
        return result == null ? true : result;
    }
    

    /**
     * AutoChild {@link com.smartgwt.client.widgets.grid.Shuttle} shown in the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickerLayout pickerLayout} when {@link
     * com.smartgwt.client.types.SelectionStyle} is set to <code>"shuttle"</code>.
     * <p>
     * This component is an AutoChild named "shuttle".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current shuttle value. Default value is null
     */
    public Shuttle getShuttle()  {
        return (Shuttle)Shuttle.getByJSObject(getAttributeAsJavaScriptObject("shuttle"));
    }
    

    /**
     * Height for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickerLayout pickerLayout} when {@link
     * com.smartgwt.client.types.SelectionStyle} is <code>"shuttle"</code>.
     *
     * @param shuttleHeight New shuttleHeight value. Default value is 400
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setShuttleHeight(Integer shuttleHeight) {
        return (MultiPickerItem)setAttribute("shuttleHeight", shuttleHeight);
    }

    /**
     * Height for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickerLayout pickerLayout} when {@link
     * com.smartgwt.client.types.SelectionStyle} is <code>"shuttle"</code>.
     *
     * @return Current shuttleHeight value. Default value is 400
     */
    public Integer getShuttleHeight()  {
        return getAttributeAsInt("shuttleHeight");
    }
    

    /**
     * Width for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickerLayout pickerLayout} when {@link
     * com.smartgwt.client.types.SelectionStyle} is <code>"shuttle"</code>.
     *
     * @param shuttleWidth New shuttleWidth value. Default value is 500
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setShuttleWidth(Integer shuttleWidth) {
        return (MultiPickerItem)setAttribute("shuttleWidth", shuttleWidth);
    }

    /**
     * Width for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickerLayout pickerLayout} when {@link
     * com.smartgwt.client.types.SelectionStyle} is <code>"shuttle"</code>.
     *
     * @return Current shuttleWidth value. Default value is 500
     */
    public Integer getShuttleWidth()  {
        return getAttributeAsInt("shuttleWidth");
    }
    

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSortDirection Sort direction} for this item's list of options. Will
     * be applied to the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickList pickList}, {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickTree pickTree} or  {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getShuttle shuttle} depending on the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionStyle selectionStyle} of this item.
     *
     * @param sortDirection New sortDirection value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setSortDirection(SortDirection sortDirection) {
        return (MultiPickerItem)setAttribute("sortDirection", sortDirection == null ? null : sortDirection.getValue());
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSortDirection Sort direction} for this item's list of options. Will
     * be applied to the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickList pickList}, {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickTree pickTree} or  {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getShuttle shuttle} depending on the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionStyle selectionStyle} of this item.
     *
     * @return Current sortDirection value. Default value is null
     */
    public SortDirection getSortDirection()  {
        return EnumUtil.getEnum(SortDirection.values(), getAttribute("sortDirection"));
    }
    

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField Sort field} for this item's list of options. Will be
     * applied to the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickList pickList}, {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickTree pickTree} or  {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getShuttle shuttle} depending on the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionStyle selectionStyle} of this item.
     *
     * @param sortField New sortField value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setSortField(String sortField) {
        return (MultiPickerItem)setAttribute("sortField", sortField);
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField Sort field} for this item's list of options. Will be
     * applied to the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickList pickList}, {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickTree pickTree} or  {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getShuttle shuttle} depending on the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionStyle selectionStyle} of this item.
     *
     * @return Current sortField value. Default value is null
     */
    public String getSortField()  {
        return getAttributeAsString("sortField");
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField Sort field} for this item's list of options. Will be
     * applied to the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickList pickList}, {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickTree pickTree} or  {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getShuttle shuttle} depending on the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionStyle selectionStyle} of this item.
     *
     * @param sortField New sortField value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setSortField(String... sortField) {
        return (MultiPickerItem)setAttribute("sortField", sortField);
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField Sort field} for this item's list of options. Will be
     * applied to the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickList pickList}, {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickTree pickTree} or  {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getShuttle shuttle} depending on the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionStyle selectionStyle} of this item.
     *
     * @return Current sortField value. Default value is null
     */
    public String[] getSortFieldAsStringArray()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("sortField"));
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField Sort field} for this item's list of options. Will be
     * applied to the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickList pickList}, {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickTree pickTree} or  {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getShuttle shuttle} depending on the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionStyle selectionStyle} of this item.
     *
     * @param sortField New sortField value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setSortField(Integer sortField) {
        return (MultiPickerItem)setAttribute("sortField", sortField);
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField Sort field} for this item's list of options. Will be
     * applied to the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickList pickList}, {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickTree pickTree} or  {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getShuttle shuttle} depending on the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionStyle selectionStyle} of this item.
     *
     * @return Current sortField value. Default value is null
     */
    public Integer getSortFieldAsInt()  {
        return getAttributeAsInt("sortField");
    }
    

    /**
     * textMatchStyle to apply to {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getOptionCriteria option
     * criteria} for this item
     *
     * @param textMatchStyle New textMatchStyle value. Default value is "substring"
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public MultiPickerItem setTextMatchStyle(TextMatchStyle textMatchStyle) {
        return (MultiPickerItem)setAttribute("textMatchStyle", textMatchStyle == null ? null : textMatchStyle.getValue());
    }

    /**
     * textMatchStyle to apply to {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getOptionCriteria option
     * criteria} for this item
     *
     * @return Current textMatchStyle value. Default value is "substring"
     */
    public TextMatchStyle getTextMatchStyle()  {
        return EnumUtil.getEnum(TextMatchStyle.values(), getAttribute("textMatchStyle"));
    }
    

    /**
     * If this form item maps data values to display values by retrieving the  {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getDisplayField FormItem.displayField} values from an  {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource optionDataSource}, this property  denotes the the
     * field to use as the underlying data value in records from the  optionDataSource.<br> If not explicitly supplied, the
     * valueField name will be derived as described in {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getValueFieldName FormItem.getValueFieldName()}.
     *
     * @param valueField New valueField value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Databinding DataBinding
     */
    public MultiPickerItem setValueField(String valueField) {
        return (MultiPickerItem)setAttribute("valueField", valueField);
    }

    /**
     * If this form item maps data values to display values by retrieving the  {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getDisplayField FormItem.displayField} values from an  {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource optionDataSource}, this property  denotes the the
     * field to use as the underlying data value in records from the  optionDataSource.<br> If not explicitly supplied, the
     * valueField name will be derived as described in {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getValueFieldName FormItem.getValueFieldName()}.
     *
     * @return Getter method to retrieve the {@link com.smartgwt.client.widgets.form.fields.FormItem#getValueField FormItem.valueField}
     * for this item. For items with a specified {@link com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource
     * FormItem.optionDataSource}, this determines which field in that dataSource corresponds to the value for this item. <P>
     * If unset, if a {@link com.smartgwt.client.data.DataSourceField#getForeignKey foreignKey relationship} exists between
     * this field and the optionDataSource, this will be used, otherwise default behavior will return the {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getName FormItem.name} of this field. Default value is null
     * @see com.smartgwt.client.docs.Databinding DataBinding
     */
    public String getValueField()  {
        return getAttributeAsString("valueField");
    }
    

    // ********************* Methods ***********************
	/**
     * Getter method to retrieve the {@link com.smartgwt.client.widgets.form.fields.FormItem#getValueField FormItem.valueField}
     * for this item. For items with a specified {@link com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource
     * FormItem.optionDataSource}, this determines which field in that dataSource corresponds to the value for this item. <P>
     * If unset, if a {@link com.smartgwt.client.data.DataSourceField#getForeignKey foreignKey relationship} exists between
     * this field and the optionDataSource, this will be used, otherwise default behavior will return the {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getName FormItem.name} of this field.
     *
     * @return fieldName to use a "value field" in records from this items               {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource FormItem.optionDataSource}
     */
    public native String getValueFieldName() /*-{
        var self = this.@com.smartgwt.client.core.DataClass::getJsObj()();
        if (!this.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) return null;
        var ret = self.getValueFieldName();
        return ret;
    }-*/;


    // ********************* Static Methods ***********************

    /** 
     * Class level method to set the default properties of this class.  If set, then all
     * existing and subsequently created instances of this class will automatically have
     * default properties corresponding to
     * the properties of the class instance passed to this function.
     * This is a powerful feature that eliminates the need for users to create a separate
     * hierarchy of subclasses that only alter the default properties of this class. Can also
     * be used for skinning / styling purposes.  <P> <b>Note:</b> This method is intended for
     * setting default attributes only and will affect all instances of the underlying class
     * (including those automatically generated in JavaScript).  This method should not be used
     * to apply standard EventHandlers or override methods for a class - use a custom subclass
     * instead.  Calling this method after instances have been created can result in undefined
     * behavior, since it bypasses any setters and a class instance may have already examined 
     * a particular property and not be expecting any changes through this route.
     *
     * @param multiPickerItemProperties properties that should be used as new defaults when instances of this class are created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public static native void setDefaultProperties(MultiPickerItem multiPickerItemProperties) /*-{
        if (multiPickerItemProperties.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)(MultiPickerItem.@java.lang.Object::getClass()(), "setDefaultProperties", multiPickerItemProperties.@java.lang.Object::getClass()());
        }
        multiPickerItemProperties.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var properties = multiPickerItemProperties.@com.smartgwt.client.widgets.form.fields.FormItem::getConfig()();
        $wnd.isc.MultiPickerItem.addProperties(properties);
    }-*/;

    // ***********************************************************



    /**
     * If this MultiPickerItem is deriving its options from a dataSource, this property allows developers to specify criteria
     * for the fetch.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param optionCriteria New optionCriteria value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem MultiPickerItem} instance, for chaining setter calls
     */
    public void setOptionCriteria(Criteria optionCriteria) {
        if (optionCriteria instanceof Criterion) {
            optionCriteria.setAttribute("_constructor", "AdvancedCriteria");
        }
        setAttribute("optionCriteria", optionCriteria == null ? null : optionCriteria.getJsObj());
    }

    /**
     * If this MultiPickerItem is deriving its options from a dataSource, this property allows developers to specify criteria
     * for the fetch.
     *
     * @return Return the derived {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getOptionCriteria optionCriteria} for
     * this item. Default value is null
     */
    public Criteria getOptionCriteria()  {
        JavaScriptObject jsObj = getAttributeAsJavaScriptObject("optionCriteria");
        return jsObj == null ? null : new Criteria(jsObj);
    }

}
