/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets.form.fields;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * FormItem for uploading files using HTML5 file drop capabilities. <P> A FileUploadItem's {@link
 * com.smartgwt.client.widgets.form.fields.FileUploadItem#getCanvas canvas} is a {@link
 * com.smartgwt.client.widgets.FileDropZone}. The  value of a FileUploadItem is the JavaScript File object(s) representing
 * files the user added. <P> FileUploadItem is not the default for <code>binary</code> type fields. To use FileUploadItem
 * for binary fields, set {@link com.smartgwt.client.widgets.form.DynamicForm#getUseFileUploadItem
 * DynamicForm.useFileUploadItem} to true on the form, or specify <code>editorType:"FileUploadItem"</code> on the field.
 * <P> When the form is {@link com.smartgwt.client.widgets.form.DynamicForm#saveData saved}, files are uploaded
 * automatically. Use {@link com.smartgwt.client.widgets.form.DynamicForm#getShowUploadProgress
 * DynamicForm.showUploadProgress} to display upload progress. <P> <b>Single File Upload</b> <P> With the default setting
 * of {@link com.smartgwt.client.widgets.form.fields.FileUploadItem#getMultiple multiple:false}, a FileUploadItem allows
 * uploading a single file to a binary field on the DataSource. This is analogous to the standard {@link
 * com.smartgwt.client.widgets.form.fields.FileItem}. <P> <b>Multiple File Upload</b> <P> To upload multiple files, set
 * {@link com.smartgwt.client.widgets.form.fields.FileUploadItem#getMultiple multiple:true} and configure a {@link
 * com.smartgwt.client.data.DataSource} property pointing to a related DataSource that will store the files. This follows
 * the same master-detail pattern as {@link com.smartgwt.client.widgets.form.fields.MultiFileItem}: <ul> <li>The form's
 * DataSource is the "master" record (e.g., an email message)</li> <li>The FileUploadItem's {@link
 * com.smartgwt.client.data.DataSource} is the "detail" DataSource storing files     (e.g., email attachments)</li> <li>The
 * detail DataSource must have a {@link com.smartgwt.client.data.DataSourceField#getForeignKey foreignKey}     linking to
 * the master DataSource's primary key</li> <li>Each uploaded file creates a separate record in the detail DataSource</li>
 * </ul> <P> See {@link com.smartgwt.client.widgets.form.fields.MultiFileItem} for an example of the DataSource setup
 * required. <P> <b>Multiple Binary Fields</b> <P> A form can contain multiple FileUploadItems for different binary fields
 * in the same DataSource. When the form is saved, all files are uploaded in a single request, creating one record with all
 * binary fields populated. This differs from {@link com.smartgwt.client.widgets.form.fields.FileItem} which has a
 * limitation preventing multiple file uploads in a single form submission. <P> Note: If you want immediate upload on drop
 * (like Gmail attachments), use a {@link com.smartgwt.client.widgets.form.fields.FormItem#addChangedHandler
 * FormItem.changed()} handler to call {@link com.smartgwt.client.widgets.form.DynamicForm#saveData
 * DynamicForm.saveData()}.
 */
@BeanFactory.FrameworkClass
public class FileUploadItem extends CanvasItem {

    public static FileUploadItem getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof FileUploadItem) {
            existingObj.setJsObj(jsObj);
            return (FileUploadItem)existingObj;
        } else

        {
            return new FileUploadItem(jsObj);
        }
    }
        


    /**
     * Changes the defaults for Canvas AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults Canvas defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, Canvas defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(FileUploadItem.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "Canvas");
        }
        defaults.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
        var cleanDefaultsJS = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(defaults.@com.smartgwt.client.widgets.BaseWidget::getConfig()(), true);
        $wnd.isc.FileUploadItem.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    /**
     * Changes the defaults for FormItem AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults FormItem defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, FormItem defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(FileUploadItem.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "FormItem");
        }
        defaults.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var cleanDefaultsJS = defaults.@com.smartgwt.client.widgets.form.fields.FormItem::getEditorTypeConfig()();
        $wnd.isc.FileUploadItem.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    public static native void changePickerIconDefaults(FormItemIcon defaults) /*-{
        $wnd.isc.FileUploadItem.changeDefaults("pickerIconDefaults", defaults.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;

    public FileUploadItem(){
        setAttribute("editorType", "FileUploadItem");
    }

    public FileUploadItem(JavaScriptObject jsObj){
        super(jsObj);
    }


    public FileUploadItem(String name) {
        setName(name);
                setAttribute("editorType", "FileUploadItem");
    }


    public FileUploadItem(String name, String title) {
        setName(name);
		setTitle(title);
                setAttribute("editorType", "FileUploadItem");
    }



    // ********************* Properties / Attributes ***********************

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getAcceptedFileTypes FileDropZone.acceptedFileTypes}.
     *
     * @param acceptedFileTypes New acceptedFileTypes value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setAcceptedFileTypes(String... acceptedFileTypes) {
        return (FileUploadItem)setAttribute("acceptedFileTypes", acceptedFileTypes);
    }

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getAcceptedFileTypes FileDropZone.acceptedFileTypes}.
     *
     * @return Current acceptedFileTypes value. Default value is null
     */
    public String[] getAcceptedFileTypes()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("acceptedFileTypes"));
    }
    

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getCanAddFilesOnClick FileDropZone.canAddFilesOnClick}.
     *
     * @param canAddFilesOnClick New canAddFilesOnClick value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setCanAddFilesOnClick(Boolean canAddFilesOnClick) {
        return (FileUploadItem)setAttribute("canAddFilesOnClick", canAddFilesOnClick);
    }

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getCanAddFilesOnClick FileDropZone.canAddFilesOnClick}.
     *
     * @return Current canAddFilesOnClick value. Default value is null
     */
    public Boolean getCanAddFilesOnClick()  {
        return getAttributeAsBoolean("canAddFilesOnClick", true);
    }
    

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#cancelButtonTitle cancelButtonTitle} for this fileUploadItem's
     * canvas. If unset, the default property will be used.
     *
     * @param cancelButtonTitle New cancelButtonTitle value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setCancelButtonTitle(String cancelButtonTitle) {
        return (FileUploadItem)setAttribute("cancelButtonTitle", cancelButtonTitle);
    }

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#cancelButtonTitle cancelButtonTitle} for this fileUploadItem's
     * canvas. If unset, the default property will be used.
     *
     * @return Current cancelButtonTitle value. Default value is null
     */
    public String getCancelButtonTitle()  {
        return getAttributeAsString("cancelButtonTitle");
    }
    

    /**
     * The {@link com.smartgwt.client.widgets.FileDropZone} component that provides the drag-drop file selection UI. <P> The
     * FileDropZone is automatically created using the {@link
     * com.smartgwt.client.widgets.form.fields.FileUploadItem#getCanvasConstructor canvasConstructor} and {@link
     * com.smartgwt.client.widgets.form.fields.FileUploadItem#getCanvasDefaults canvasDefaults} properties. To customize the
     * FileDropZone, either set properties directly on the FileUploadItem (which are passed through to the FileDropZone) or
     * override {@link com.smartgwt.client.widgets.form.fields.FileUploadItem#getCanvasDefaults canvasDefaults}. <P> Access the
     * FileDropZone via <code>fileUploadItem.canvas</code> after the item is created.
     * <p>
     * This component is an AutoChild named "canvas".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current canvas value. Default value is null
     */
    public FileDropZone getCanvas()  {
        return (FileDropZone)FileDropZone.getByJSObject(getAttributeAsJavaScriptObject("canvas"));
    }
    

    /**
     * The class to use for the {@link com.smartgwt.client.widgets.Canvas} autoChild. Default is FileDropZone.
     *
     * @param canvasConstructor New canvasConstructor value. Default value is "FileDropZone"
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setCanvasConstructor(String canvasConstructor) {
        return (FileUploadItem)setAttribute("canvasConstructor", canvasConstructor);
    }

    /**
     * The class to use for the {@link com.smartgwt.client.widgets.Canvas} autoChild. Default is FileDropZone.
     *
     * @return Current canvasConstructor value. Default value is "FileDropZone"
     */
    public String getCanvasConstructor()  {
        return getAttributeAsString("canvasConstructor");
    }
    

    /**
     * Default properties for the {@link com.smartgwt.client.widgets.Canvas} autoChild FileDropZone. <P> The default
     * implementation includes handlers that forward {@link com.smartgwt.client.widgets.FileDropZone#filesAdded
     * FileDropZone.filesAdded()} and {@link com.smartgwt.client.widgets.FileDropZone#filesRemoved FileDropZone.filesRemoved()}
     * notifications to update the FormItem's value. <P> When overriding, use <code>isc.addProperties()</code> to merge with
     * the defaults rather than replacing them entirely, to preserve the value synchronization behavior.
     *
     * @param canvasDefaults New canvasDefaults value. Default value is {...}
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setCanvasDefaults(Map canvasDefaults) {
        return (FileUploadItem)setAttribute("canvasDefaults", canvasDefaults);
    }

    /**
     * Default properties for the {@link com.smartgwt.client.widgets.Canvas} autoChild FileDropZone. <P> The default
     * implementation includes handlers that forward {@link com.smartgwt.client.widgets.FileDropZone#filesAdded
     * FileDropZone.filesAdded()} and {@link com.smartgwt.client.widgets.FileDropZone#filesRemoved FileDropZone.filesRemoved()}
     * notifications to update the FormItem's value. <P> When overriding, use <code>isc.addProperties()</code> to merge with
     * the defaults rather than replacing them entirely, to preserve the value synchronization behavior.
     *
     * @return Current canvasDefaults value. Default value is {...}
     */
    public Map getCanvasDefaults()  {
        return getAttributeAsMap("canvasDefaults");
    }
    

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#clickToAddMessage clickToAddMessage} for this fileUploadItem's
     * canvas. If unset, the default property will be used.
     *
     * @param clickToAddMessage New clickToAddMessage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setClickToAddMessage(String clickToAddMessage) {
        return (FileUploadItem)setAttribute("clickToAddMessage", clickToAddMessage);
    }

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#clickToAddMessage clickToAddMessage} for this fileUploadItem's
     * canvas. If unset, the default property will be used.
     *
     * @return Current clickToAddMessage value. Default value is null
     */
    public String getClickToAddMessage()  {
        return getAttributeAsString("clickToAddMessage");
    }
    

    /**
     * DataSource where files are stored when {@link com.smartgwt.client.widgets.form.fields.FileUploadItem#getMultiple
     * multiple:true}. <P> This DataSource should contain: <ul> <li>A {@link
     * com.smartgwt.client.data.DataSourceField#getPrimaryKey primaryKey} field</li> <li>A field with a {@link
     * com.smartgwt.client.data.DataSourceField#getForeignKey foreignKey} relationship to     the primary key of the form's
     * DataSource</li> <li>A field of type "binary" for storing the uploaded file</li> </ul> <P> This follows the same pattern
     * as {@link com.smartgwt.client.widgets.form.fields.MultiFileItem#getDataSource MultiFileItem.dataSource}. See {@link
     * com.smartgwt.client.widgets.form.fields.MultiFileItem} for a complete example of the required DataSource structure. <P>
     * This property is required when {@link com.smartgwt.client.widgets.form.fields.FileUploadItem#getMultiple multiple:true}
     * is set. If omitted, a warning will be logged and the item will behave as single-file upload.
     *
     * @param dataSource New dataSource value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setDataSource(DataSource dataSource) {
        return (FileUploadItem)setAttribute("dataSource", dataSource == null ? null : dataSource.getOrCreateJsObj());
    }

    /**
     * DataSource where files are stored when {@link com.smartgwt.client.widgets.form.fields.FileUploadItem#getMultiple
     * multiple:true}. <P> This DataSource should contain: <ul> <li>A {@link
     * com.smartgwt.client.data.DataSourceField#getPrimaryKey primaryKey} field</li> <li>A field with a {@link
     * com.smartgwt.client.data.DataSourceField#getForeignKey foreignKey} relationship to     the primary key of the form's
     * DataSource</li> <li>A field of type "binary" for storing the uploaded file</li> </ul> <P> This follows the same pattern
     * as {@link com.smartgwt.client.widgets.form.fields.MultiFileItem#getDataSource MultiFileItem.dataSource}. See {@link
     * com.smartgwt.client.widgets.form.fields.MultiFileItem} for a complete example of the required DataSource structure. <P>
     * This property is required when {@link com.smartgwt.client.widgets.form.fields.FileUploadItem#getMultiple multiple:true}
     * is set. If omitted, a warning will be logged and the item will behave as single-file upload.
     *
     * @return Returns the DataSource configured for storing uploaded files when {@link
     * com.smartgwt.client.widgets.form.fields.FileUploadItem#getMultiple multiple:true}. Default value is null
     */
    public DataSource getDataSource()  {
        return DataSource.getOrCreateRef(getAttributeAsJavaScriptObject("dataSource"));
    }

    /**
     * DataSource where files are stored when {@link com.smartgwt.client.widgets.form.fields.FileUploadItem#getMultiple
     * multiple:true}. <P> This DataSource should contain: <ul> <li>A {@link
     * com.smartgwt.client.data.DataSourceField#getPrimaryKey primaryKey} field</li> <li>A field with a {@link
     * com.smartgwt.client.data.DataSourceField#getForeignKey foreignKey} relationship to     the primary key of the form's
     * DataSource</li> <li>A field of type "binary" for storing the uploaded file</li> </ul> <P> This follows the same pattern
     * as {@link com.smartgwt.client.widgets.form.fields.MultiFileItem#getDataSource MultiFileItem.dataSource}. See {@link
     * com.smartgwt.client.widgets.form.fields.MultiFileItem} for a complete example of the required DataSource structure. <P>
     * This property is required when {@link com.smartgwt.client.widgets.form.fields.FileUploadItem#getMultiple multiple:true}
     * is set. If omitted, a warning will be logged and the item will behave as single-file upload.
     *
     * @param dataSource New dataSource value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setDataSource(String dataSource) {
        return (FileUploadItem)setAttribute("dataSource", dataSource);
    }

    /**
     * DataSource where files are stored when {@link com.smartgwt.client.widgets.form.fields.FileUploadItem#getMultiple
     * multiple:true}. <P> This DataSource should contain: <ul> <li>A {@link
     * com.smartgwt.client.data.DataSourceField#getPrimaryKey primaryKey} field</li> <li>A field with a {@link
     * com.smartgwt.client.data.DataSourceField#getForeignKey foreignKey} relationship to     the primary key of the form's
     * DataSource</li> <li>A field of type "binary" for storing the uploaded file</li> </ul> <P> This follows the same pattern
     * as {@link com.smartgwt.client.widgets.form.fields.MultiFileItem#getDataSource MultiFileItem.dataSource}. See {@link
     * com.smartgwt.client.widgets.form.fields.MultiFileItem} for a complete example of the required DataSource structure. <P>
     * This property is required when {@link com.smartgwt.client.widgets.form.fields.FileUploadItem#getMultiple multiple:true}
     * is set. If omitted, a warning will be logged and the item will behave as single-file upload.
     *
     * @return Returns the DataSource configured for storing uploaded files when {@link
     * com.smartgwt.client.widgets.form.fields.FileUploadItem#getMultiple multiple:true}. Default value is null
     */
    public String getDataSourceAsString()  {
        return getAttributeAsString("dataSource");
    }
    

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#duplicateFileNameMessage duplicateFileNameMessage} for this
     * fileUploadItem's canvas. If unset, the default property will be used.
     *
     * @param duplicateFileNameMessage New duplicateFileNameMessage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setDuplicateFileNameMessage(String duplicateFileNameMessage) {
        return (FileUploadItem)setAttribute("duplicateFileNameMessage", duplicateFileNameMessage);
    }

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#duplicateFileNameMessage duplicateFileNameMessage} for this
     * fileUploadItem's canvas. If unset, the default property will be used.
     *
     * @return Current duplicateFileNameMessage value. Default value is null
     */
    public String getDuplicateFileNameMessage()  {
        return getAttributeAsString("duplicateFileNameMessage");
    }
    

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#emptyDropAreaMessage emptyDropAreaMessage} for this
     * fileUploadItem's canvas. If unset, the default property will be used.
     *
     * @param emptyDropAreaMessage New emptyDropAreaMessage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setEmptyDropAreaMessage(String emptyDropAreaMessage) {
        return (FileUploadItem)setAttribute("emptyDropAreaMessage", emptyDropAreaMessage);
    }

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#emptyDropAreaMessage emptyDropAreaMessage} for this
     * fileUploadItem's canvas. If unset, the default property will be used.
     *
     * @return Current emptyDropAreaMessage value. Default value is null
     */
    public String getEmptyDropAreaMessage()  {
        return getAttributeAsString("emptyDropAreaMessage");
    }
    

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#invalidFileTypeMessage invalidFileTypeMessage} for this
     * fileUploadItem's canvas. If unset, the default property will be used.
     *
     * @param invalidFileTypeMessage New invalidFileTypeMessage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setInvalidFileTypeMessage(String invalidFileTypeMessage) {
        return (FileUploadItem)setAttribute("invalidFileTypeMessage", invalidFileTypeMessage);
    }

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#invalidFileTypeMessage invalidFileTypeMessage} for this
     * fileUploadItem's canvas. If unset, the default property will be used.
     *
     * @return Current invalidFileTypeMessage value. Default value is null
     */
    public String getInvalidFileTypeMessage()  {
        return getAttributeAsString("invalidFileTypeMessage");
    }
    

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getMaxFiles FileDropZone.maxFiles}.
     *
     * @param maxFiles New maxFiles value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setMaxFiles(Integer maxFiles) {
        return (FileUploadItem)setAttribute("maxFiles", maxFiles);
    }

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getMaxFiles FileDropZone.maxFiles}.
     *
     * @return Current maxFiles value. Default value is null
     */
    public Integer getMaxFiles()  {
        return getAttributeAsInt("maxFiles");
    }
    

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#maxFilesErrorMessage maxFilesErrorMessage} for this
     * fileUploadItem's canvas. If unset, the default property will be used.
     *
     * @param maxFilesErrorMessage New maxFilesErrorMessage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setMaxFilesErrorMessage(String maxFilesErrorMessage) {
        return (FileUploadItem)setAttribute("maxFilesErrorMessage", maxFilesErrorMessage);
    }

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#maxFilesErrorMessage maxFilesErrorMessage} for this
     * fileUploadItem's canvas. If unset, the default property will be used.
     *
     * @return Current maxFilesErrorMessage value. Default value is null
     */
    public String getMaxFilesErrorMessage()  {
        return getAttributeAsString("maxFilesErrorMessage");
    }
    

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getMaxFileSize FileDropZone.maxFileSize}.
     *
     * @param maxFileSize New maxFileSize value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setMaxFileSize(Integer maxFileSize) {
        return (FileUploadItem)setAttribute("maxFileSize", maxFileSize);
    }

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getMaxFileSize FileDropZone.maxFileSize}.
     *
     * @return Current maxFileSize value. Default value is null
     */
    public Integer getMaxFileSize()  {
        return getAttributeAsInt("maxFileSize");
    }
    

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#maxFileSizeErrorMessage maxFileSizeErrorMessage} for this
     * fileUploadItem's canvas. If unset, the default property will be used.
     *
     * @param maxFileSizeErrorMessage New maxFileSizeErrorMessage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setMaxFileSizeErrorMessage(String maxFileSizeErrorMessage) {
        return (FileUploadItem)setAttribute("maxFileSizeErrorMessage", maxFileSizeErrorMessage);
    }

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#maxFileSizeErrorMessage maxFileSizeErrorMessage} for this
     * fileUploadItem's canvas. If unset, the default property will be used.
     *
     * @return Current maxFileSizeErrorMessage value. Default value is null
     */
    public String getMaxFileSizeErrorMessage()  {
        return getAttributeAsString("maxFileSizeErrorMessage");
    }
    

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getMaxSize FileDropZone.maxSize}.
     *
     * @param maxSize New maxSize value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setMaxSize(Integer maxSize) {
        return (FileUploadItem)setAttribute("maxSize", maxSize);
    }

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getMaxSize FileDropZone.maxSize}.
     *
     * @return Current maxSize value. Default value is null
     */
    public Integer getMaxSize()  {
        return getAttributeAsInt("maxSize");
    }
    

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#maxSizeErrorMessage maxSizeErrorMessage} for this
     * fileUploadItem's canvas. If unset, the default property will be used.
     *
     * @param maxSizeErrorMessage New maxSizeErrorMessage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setMaxSizeErrorMessage(String maxSizeErrorMessage) {
        return (FileUploadItem)setAttribute("maxSizeErrorMessage", maxSizeErrorMessage);
    }

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#maxSizeErrorMessage maxSizeErrorMessage} for this
     * fileUploadItem's canvas. If unset, the default property will be used.
     *
     * @return Current maxSizeErrorMessage value. Default value is null
     */
    public String getMaxSizeErrorMessage()  {
        return getAttributeAsString("maxSizeErrorMessage");
    }
    

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getMinSize FileDropZone.minSize}.
     *
     * @param minSize New minSize value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setMinSize(Integer minSize) {
        return (FileUploadItem)setAttribute("minSize", minSize);
    }

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getMinSize FileDropZone.minSize}.
     *
     * @return Current minSize value. Default value is null
     */
    public Integer getMinSize()  {
        return getAttributeAsInt("minSize");
    }
    

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#minSizeErrorMessage minSizeErrorMessage} for this
     * fileUploadItem's canvas. If unset, the default property will be used.
     *
     * @param minSizeErrorMessage New minSizeErrorMessage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setMinSizeErrorMessage(String minSizeErrorMessage) {
        return (FileUploadItem)setAttribute("minSizeErrorMessage", minSizeErrorMessage);
    }

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#minSizeErrorMessage minSizeErrorMessage} for this
     * fileUploadItem's canvas. If unset, the default property will be used.
     *
     * @return Current minSizeErrorMessage value. Default value is null
     */
    public String getMinSizeErrorMessage()  {
        return getAttributeAsString("minSizeErrorMessage");
    }
    

    /**
     * Whether this FileUploadItem allows multiple files to be selected. <P> When <code>multiple:true</code>, a {@link
     * com.smartgwt.client.data.DataSource} property must also be specified pointing to a related DataSource that will store
     * the uploaded files, following the same master-detail pattern as {@link
     * com.smartgwt.client.widgets.form.fields.MultiFileItem}. Each file will be uploaded as a separate record in the detail
     * DataSource after the master record is saved. <P> If <code>multiple:true</code> is set without a valid {@link
     * com.smartgwt.client.data.DataSource}, a warning will be logged and the item will behave as if
     * <code>multiple:false</code>. <P> See {@link com.smartgwt.client.widgets.FileDropZone#getMultiple FileDropZone.multiple}
     * for the underlying FileDropZone property.
     *
     * @param multiple New multiple value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setMultiple(Boolean multiple) {
        return (FileUploadItem)setAttribute("multiple", multiple);
    }

    /**
     * Whether this FileUploadItem allows multiple files to be selected. <P> When <code>multiple:true</code>, a {@link
     * com.smartgwt.client.data.DataSource} property must also be specified pointing to a related DataSource that will store
     * the uploaded files, following the same master-detail pattern as {@link
     * com.smartgwt.client.widgets.form.fields.MultiFileItem}. Each file will be uploaded as a separate record in the detail
     * DataSource after the master record is saved. <P> If <code>multiple:true</code> is set without a valid {@link
     * com.smartgwt.client.data.DataSource}, a warning will be logged and the item will behave as if
     * <code>multiple:false</code>. <P> See {@link com.smartgwt.client.widgets.FileDropZone#getMultiple FileDropZone.multiple}
     * for the underlying FileDropZone property.
     *
     * @return Current multiple value. Default value is null
     */
    public Boolean getMultiple()  {
        return getAttributeAsBoolean("multiple", true);
    }
    

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#multipleFilesErrorMessage multipleFilesErrorMessage} for this
     * fileUploadItem's canvas. If unset, the default property will be used.
     *
     * @param multipleFilesErrorMessage New multipleFilesErrorMessage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setMultipleFilesErrorMessage(String multipleFilesErrorMessage) {
        return (FileUploadItem)setAttribute("multipleFilesErrorMessage", multipleFilesErrorMessage);
    }

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#multipleFilesErrorMessage multipleFilesErrorMessage} for this
     * fileUploadItem's canvas. If unset, the default property will be used.
     *
     * @return Current multipleFilesErrorMessage value. Default value is null
     */
    public String getMultipleFilesErrorMessage()  {
        return getAttributeAsString("multipleFilesErrorMessage");
    }
    

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#processingMessage processingMessage} for this fileUploadItem's
     * canvas. If unset, the default property will be used.
     *
     * @param processingMessage New processingMessage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setProcessingMessage(String processingMessage) {
        return (FileUploadItem)setAttribute("processingMessage", processingMessage);
    }

    /**
     * Custom {@link com.smartgwt.client.widgets.FileDropZone#processingMessage processingMessage} for this fileUploadItem's
     * canvas. If unset, the default property will be used.
     *
     * @return Current processingMessage value. Default value is null
     */
    public String getProcessingMessage()  {
        return getAttributeAsString("processingMessage");
    }
    

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getReplaceFilesOnDrop FileDropZone.replaceFilesOnDrop}.
     *
     * @param replaceFilesOnDrop New replaceFilesOnDrop value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setReplaceFilesOnDrop(Boolean replaceFilesOnDrop) {
        return (FileUploadItem)setAttribute("replaceFilesOnDrop", replaceFilesOnDrop);
    }

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getReplaceFilesOnDrop FileDropZone.replaceFilesOnDrop}.
     *
     * @return Current replaceFilesOnDrop value. Default value is null
     */
    public Boolean getReplaceFilesOnDrop()  {
        return getAttributeAsBoolean("replaceFilesOnDrop", true);
    }
    

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getShowCancelButton FileDropZone.showCancelButton}.
     *
     * @param showCancelButton New showCancelButton value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setShowCancelButton(Boolean showCancelButton) {
        return (FileUploadItem)setAttribute("showCancelButton", showCancelButton);
    }

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getShowCancelButton FileDropZone.showCancelButton}.
     *
     * @return Current showCancelButton value. Default value is null
     */
    public Boolean getShowCancelButton()  {
        return getAttributeAsBoolean("showCancelButton", true);
    }
    

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getShowFileThumbnails FileDropZone.showFileThumbnails}.
     *
     * @param showFileThumbnails New showFileThumbnails value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setShowFileThumbnails(Boolean showFileThumbnails) {
        return (FileUploadItem)setAttribute("showFileThumbnails", showFileThumbnails);
    }

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getShowFileThumbnails FileDropZone.showFileThumbnails}.
     *
     * @return Current showFileThumbnails value. Default value is null
     */
    public Boolean getShowFileThumbnails()  {
        return getAttributeAsBoolean("showFileThumbnails", true);
    }
    

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getShowImagePreviews FileDropZone.showImagePreviews}.
     *
     * @param showImagePreviews New showImagePreviews value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setShowImagePreviews(Boolean showImagePreviews) {
        return (FileUploadItem)setAttribute("showImagePreviews", showImagePreviews);
    }

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getShowImagePreviews FileDropZone.showImagePreviews}.
     *
     * @return Current showImagePreviews value. Default value is null
     */
    public Boolean getShowImagePreviews()  {
        return getAttributeAsBoolean("showImagePreviews", true);
    }
    

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getThumbnailHeight FileDropZone.thumbnailHeight}.
     *
     * @param thumbnailHeight New thumbnailHeight value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setThumbnailHeight(Integer thumbnailHeight) {
        return (FileUploadItem)setAttribute("thumbnailHeight", thumbnailHeight);
    }

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getThumbnailHeight FileDropZone.thumbnailHeight}.
     *
     * @return Current thumbnailHeight value. Default value is null
     */
    public Integer getThumbnailHeight()  {
        return getAttributeAsInt("thumbnailHeight");
    }
    

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getThumbnailWidth FileDropZone.thumbnailWidth}.
     *
     * @param thumbnailWidth New thumbnailWidth value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.FileUploadItem FileUploadItem} instance, for chaining setter calls
     */
    public FileUploadItem setThumbnailWidth(Integer thumbnailWidth) {
        return (FileUploadItem)setAttribute("thumbnailWidth", thumbnailWidth);
    }

    /**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getThumbnailWidth FileDropZone.thumbnailWidth}.
     *
     * @return Current thumbnailWidth value. Default value is null
     */
    public Integer getThumbnailWidth()  {
        return getAttributeAsInt("thumbnailWidth");
    }
    

    // ********************* Methods ***********************
	/**
     * See {@link com.smartgwt.client.widgets.FileDropZone#cancelProcessing FileDropZone.cancelProcessing()}.
     */
    public native void cancelProcessing() /*-{
        var self = this.@com.smartgwt.client.core.DataClass::getJsObj()();
        self.cancelProcessing();
    }-*/;

	/**
     * See {@link com.smartgwt.client.widgets.FileDropZone#endProcessing FileDropZone.endProcessing()}.
     */
    public native void endProcessing() /*-{
        var self = this.@com.smartgwt.client.core.DataClass::getJsObj()();
        self.endProcessing();
    }-*/;

	/**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getFiles FileDropZone.getFiles()}.
     */
    public native void getFiles() /*-{
        var self = this.@com.smartgwt.client.core.DataClass::getJsObj()();
        self.getFiles();
    }-*/;

	/**
     * See {@link com.smartgwt.client.widgets.FileDropZone#getSize FileDropZone.getSize()}.
     */
    public native void getSize() /*-{
        var self = this.@com.smartgwt.client.core.DataClass::getJsObj()();
        self.getSize();
    }-*/;

	/**
     * See {@link com.smartgwt.client.widgets.FileDropZone#setFileProgress FileDropZone.setFileProgress()}.
     */
    public native void setFileProgress() /*-{
        var self = this.@com.smartgwt.client.core.DataClass::getJsObj()();
        self.setFileProgress();
    }-*/;

	/**
     * See {@link com.smartgwt.client.widgets.FileDropZone#setProcessingProgress FileDropZone.setProcessingProgress()}.
     */
    public native void setProcessingProgress() /*-{
        var self = this.@com.smartgwt.client.core.DataClass::getJsObj()();
        self.setProcessingProgress();
    }-*/;

	/**
     * See {@link com.smartgwt.client.widgets.FileDropZone#startProcessing FileDropZone.startProcessing()}.
     */
    public native void startProcessing() /*-{
        var self = this.@com.smartgwt.client.core.DataClass::getJsObj()();
        self.startProcessing();
    }-*/;


    // ********************* Static Methods ***********************

    /** 
     * Class level method to set the default properties of this class.  If set, then all
     * existing and subsequently created instances of this class will automatically have
     * default properties corresponding to
     * the properties of the class instance passed to this function.
     * This is a powerful feature that eliminates the need for users to create a separate
     * hierarchy of subclasses that only alter the default properties of this class. Can also
     * be used for skinning / styling purposes.  <P> <b>Note:</b> This method is intended for
     * setting default attributes only and will affect all instances of the underlying class
     * (including those automatically generated in JavaScript).  This method should not be used
     * to apply standard EventHandlers or override methods for a class - use a custom subclass
     * instead.  Calling this method after instances have been created can result in undefined
     * behavior, since it bypasses any setters and a class instance may have already examined 
     * a particular property and not be expecting any changes through this route.
     *
     * @param fileUploadItemProperties properties that should be used as new defaults when instances of this class are created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public static native void setDefaultProperties(FileUploadItem fileUploadItemProperties) /*-{
        if (fileUploadItemProperties.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)(FileUploadItem.@java.lang.Object::getClass()(), "setDefaultProperties", fileUploadItemProperties.@java.lang.Object::getClass()());
        }
        fileUploadItemProperties.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var properties = fileUploadItemProperties.@com.smartgwt.client.widgets.form.fields.FormItem::getConfig()();
        $wnd.isc.FileUploadItem.addProperties(properties);
    }-*/;

    // ***********************************************************

}
