
package com.smartgwt.client.docs;

/**
 * <h3>Troubleshooting GWT Development Mode</h3>
 * This topic provides details on configuring and running Development Mode and troubleshooting
 *  any problems. For an overview, including historical context, see
 * {@link com.smartgwt.client.docs.Debugging Debugging: Development Modes in GWT}. Note that GWT
 * 2.12.x is the
 *  minimum supported GWT version as of SmartGWT 14.1.
 *  <p>
 *  <h3>Development Mode in GWT 2.12.0+</h3>
 *  <p>
 *  To use Development Mode in Eclipse with SmartGWT 14.1+, you'll need to install
 * <a href='https://github.com/gwt-plugins/gwt-eclipse-plugin' target='_blank'>GWT Eclipse Plugin
 * (GEP)</a>.
 *  This provides access to the Code Server run configuration, but since the Jetty bundled with
 *  GWT isn't compatible with Jakarta/Servlet 5.0, you'll also need to install the
 * <a href='https://marketplace.eclipse.org/content/eclipse-jetty' target='_blank'>Jetty Eclipse
 * Plugin</a>
 * and set up an external <a href='https://jetty.org/download.html' target='_blank'>Jetty 11</a>.
 * (Note that
 *  the JEP may not work with Jetty 12+.)
 *  <p>
 *  It's assumed that you already have installed the
 * <a href='https://www.gwtproject.org/download.html' target='_blank'>GWT SDK</a> and Java 17+.
 * For more
 *  guidance beyond this overview and the links above, see
 * <a href='http://www.gwtproject.org/usingeclipse.html' target='_blank'>Using GWT with
 * Eclipse</a>.
 *  <p>
 *  <h3>Eclipse Setup</h3>
 *  <p>
 *  If you want to import into Eclipse the pre-built projects included with SmartGWT, such as
 *  the Built-in-DS app, and use the pre-built run configurations, some Eclipse setup is needed
 *  first:
 *  <ul>
 *  <li>Open the Classpath Variables view:<ul>
 *  <li>Windows: Window  -&gt;
 *  Preferences -&gt; Java -&gt; Build Path -&gt; Classpath Variables</li>
 *  <li>MacOS X: Eclipse -&gt;
 *  Preferences -&gt; Java -&gt; Build Path -&gt; Classpath Variables</li>
 *  </ul>
 *  <li>Set the Eclipse Classpath variable
 *  SGWTEE_HOME to point to the root directory of your Smart GWT EE
 *  installation.</li>
 *  <li>Set the Eclipse Classpath variable
 *  GWT_HOME to point to the root directory of your GWT SDK 2.12.x
 *  installation.<br>(This variable is used by the classpath in the pre-built launch
 *  configuration for the Jetty Plugin.)</li>
 *  </ul>
 *  <p>
 *  Now you can use Eclipse's File -&gt; Import, General -&gt; Existing Projects into Workspace
 *  feature to import the pre-built projects and associated run configurations.  Or you can
 *  create your own GWT project and set up the GWT Development Mode and Jetty run configurations
 *  as discussed below.
 *  </p>
 *  Note that even if you use the pre-built Jetty Plugin run configuration from one of our
 *  projects, you'll still need to set up the external Jetty 11 configuration as detailed below,
 *  and then configure its location into the Jetty Plugin run configuration via the "Use Jetty
 *  at path" Jetty Plugin run configuration setup step.
 *  <p>
 *  <h4>Setting up the Run Configurations</h4>
 *  <p>
 *  Separate run configurations are needed GWT Development Mode and for the Jetty Plugin,
 *  since we can't use GWT's built-in Jetty server with Jakarta/Servlet 5.0.
 *  <p>
 *  First create the Development Mode run configuration:
 *  <ul>
 *  <li>Right click on your project -&gt; Run As -&gt; Run Configurations...</li>
 *  <li>Double click &quot;GWT Development Mode (DevMode)&quot; to create a new configuration
 *  underneath it</li>
 *  <li>Set the title (very top) to something you'll remember</li>
 *  <li>Set the &quot;Main class&quot; to <code>com.google.gwt.dev.DevMode</code></li>
 *  <li>Click into the Server Tab and uncheck "Run built-in server" as we can't use it for
 *  Jakarta/Servlet 5.0</li>
 *  <li>In the &quot;Arguments&quot; Tab, add entries for (at a minimum) the source path and
 *  the module (package, plus name of your .gwt.xml file) - for example: <code>-src src/
 *  com.smartgwt.sample.BuiltInDS</code></li>
 *  </ul>
 *  In your external Jetty 11 installation, we need to make some
 *  modifications for the Jetty Eclipse Plugin:
 *  <ul>
 *  <li>Remove the two mortbay JARs from the <code>lib/apache-jsp</code> directory in the Jetty
 *  11 installation</li>
 *  <li>Create a new <code>lib/apache-jstl</code> directory in the installation, and populate it
 *  with the following two JARs:<ul>
 *  <li>jakarta.servlet.jsp.jstl-3.0.1.jar</li>
 *  <li>jakarta.servlet.jsp.jstl-api-3.0.2.jar</li></ul>
 *  downloaded from the
 * <a href='https://mvnrepository.com/search?q=jakarta.servlet.jsp.jstl' target='_blank'>Maven
 * Repository</a></li>
 *  </ul>
 *  Then create the Jetty Plugin run configuration:<ul>
 *  <li>Right click on your project -&gt; Run As -&gt; Run Configurations...</li>
 *  <li>Double click &quot;Jetty Webapp&quot; to create a new configuration underneath it</li>
 *  <li>In the Options Tab, click "Use Jetty at path" and then type or browse to your external
 *  Jetty 11 installation</li>
 *  <li>In the same tab, click on "Enable JNDI support" under Jetty Features</li>
 *  <li>In the Classpath Tab, make sure that GWT JARs gwt-servlet-jakarta.jar,
 *  gwt-servlet-deps.jar, and gwt-user.jar are included, but don't include the entire GWT SDK
 *  (due to conflicts).</li>
 *  </ul>
 *  If you're having trouble setting up the Jetty Plugin and its run configuration, you can
 *  always use an external installation of Jetty 11+ instead of running it inside Eclipse.
 *  <p>
 *  <h4>Running the Code Server</h4>
 *  <p>
 *  At this stage you should be able to start the Code Server:
 *  <ul>
 *  <li>Right click on your project -&gt; Run As -&gt; Run Configurations...</li>
 *  <li>Start the GWT Development Mode run configuration that was imported with your pre-built
 *  project or that you created following the instructions above</li>
 *  </ul>
 *  Observe the logging in the console as the Code Server starts.  When it's ready it will
 *  report a URL there.  Don't visit it yet.
 *  <p>
 *  <h4>Deploying your Web Application</h4>
 *  <p>
 *  You should now launch the Jetty Plugin Run Configuration:
 *  <ul>
 *  <li>Right click on your project -&gt; Run As -&gt; Run Configurations...</li>
 *  <li>Start the Jetty Webapp run configuration that was imported with your pre-built
 *  project or that you created following the instructions above</li>
 *  </ul>
 *  When Jetty has completed launching, go back to the Code Server output logging in the console
 *  tab of Eclipse, and visit that URL in your browser. Drag the &quot;Dev Mode On&quot; and
 *  &quot;Dev Mode Off&quot; buttons up to your browser bookmarks toolbar. These bookmarks allow
 *  you to easily switch to Development Mode (recompiling your Web Application) or switch back to
 *  Production Mode.
 *  <p>
 *  <h4>Entering Development Mode</h4>
 *  <p>
 *  Visit the Production Mode URL of the running Web Application. The bookmarks created earlier
 *  can now be used to enter Development Mode:<ul>
 *  <li>hit the &quot;Dev Mode On&quot; bookmark link</li>
 *  <li>on the pop-up, select the button to &quot;Compile&quot;</li>
 *  </ul>
 *  If you make code changes, you can update Development Mode using the &quot;Dev Mode On&quot;
 *  bookmark.
 *  <p>
 *  <h3>Script Tags in Development Mode</h3>
 *  <P>
 *  The official GWT Development Mode linker (the default linker since GWT 2.7.0) does not
 *  support including modules which load javascript files.  SmartGWT restores support for script
 *  tags by modifying some of the generated files with a post link step.  However, going forward
 *  it is recommended to migrate away from script tags in modules since we cannot control future
 *  changes to GWT that may introduce additional incompatibilities.
 *  <P>
 *  To avoid script tags if you're inheriting the standard module 
 *  <code>com.smartgwtee.SmartGwtEE</code>, you'll need to switch that to
 *  <code>com.smartgwtee.SmartGwtEENoScript</code>, and add the following
 *  lines to your bootstrap HTML file (under the "war" directory):
 *  <pre><code>
 *     &lt;script src="[app]/sc/modules/ISC_Core.js"&gt;          &lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_Foundation.js"&gt;    &lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_Containers.js"&gt;    &lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_Grids.js"&gt;         &lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_Forms.js"&gt;         &lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_RichTextEditor.js"&gt;&lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_Calendar.js"&gt;      &lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_DataBinding.js"&gt;   &lt;/script&gt;
 * 
 *     &lt;script src="[app]/sc/skins/[skinname]/load_skin.js"&gt;&lt;/script&gt;</code></pre>
 *  In the above lines:<ul>
 *  <li>Replace "<code>[app]</code>" with the directory containing the "sc" lib - determined by
 *  the "rename-to" attribute in your .gwt.xml file -- for example "builtinds" or "dsdmi".
 *  <li>Replace "<code>[skinname]</code>" with the name of the skin you want to use -- for
 *  example "Enterprise" or "Graphite".</ul>
 *  <p>
 *  <h4>Understanding the Relevant Behavior of SDM</h4>
 *  <p>
 *  SmartGWT's custom linker generates a file named <code>loadScriptTagFiles.js</code> in the same
 *  directory as the GWT-generated file <code>&lt;moduleName&gt;.nocache.js</code> to force-load
 *  the script tags rejected by the SuperDevMode linker.  SmartGWT attempts to load
 *  <code>loadScriptTagFiles.js</code> directly in the root HTML page (see the BuiltInDS sample
 *  project), and also injects a hook directly into
 *  <code>&lt;moduleName&gt;.nocache.js</code> to load it.  If it's not loaded, or doesn't contain
 *  the required script files (typically Smart GWT Framework JS files), the GWT page won't
 *  load, errors will appear in the console,  and the browser will show a blank page.  Thus,
 *  it's important to understand when such problems may occur.
 *  <p>
 *  If you build your GWT project (GWT 2.7.0+, non-SDM) using a command-line tool such as
 * <a href='https://ant.apache.org/' target='_blank'>Ant</a>, or run SDM in Eclipse using the
 * CodeServer
 *  approach from above (for GWT Plugin version 2.6.x), then the root HTML page should pick up
 *  the correct <code>loadScriptTagFiles.js</code>.  However, if you're running GWT SuperDevMode
 *  as a Web Application using the latest GWT Plugin, the &lt;script&gt; tag in our root HTML
 *  page that normally loads <code>&lt;moduleName&gt;.nocache.js</code> really just triggers the
 *  delayed generation and loading of that file, and neither it nor
 *  <code>loadScriptTagFiles.js</code> is ever actually written to your war directory as
 *  configured in Eclipse.
 *  <p>
 *  More broadly stated, when SDM is run as a Web Application, all of the GWT linker output,
 *  including SmartGWT's custom linker output, is only available through the CodeServer URL (e.g.
 *  something like <code>http://localhost:9876/&lt;moduleName&gt;/...</code>), and that content
 *  is generated after the page has been loaded - so after the body of the root SmartGWT HTML
 *  page as already been run.  This is part of GWT's SuperDevMode architecture, so there's no way
 *  to avoid the delayed execution.
 *  <p>
 *  <h4>Troubleshooting Script Tag Loading in SDM</h4>
 *  <p><i>How do you make sure the needed Smart GWT Framework script
 *  files are loaded when running SDM as a Web Application - that
 *  </i><code><i>loadScriptTagFiles.js</i></code><i> is valid? The
 *  easiest way is probably just to run the GWT Plugin in Legacy Dev Mode
 *  once before running SDM (and again if you change your script tags).</i>
 *  That mode can be toggled in the GWT Plugin tab of the Run or Debug
 *  Configuration in Eclipse. 
 *  </p>
 *  <h4>Using Script Tags in IntelliJ IDEA</h4>
 *  <p>
 *  You may run into problems using script tags with the IntelliJ IDEA GWT Plugin that aren't
 *  fixed by following the advice above (for Eclipse).  The problem is that in IntelliJ, the
 *  <code>loadScriptTagFiles.js</code> file generated during GWT compilation is never persisted
 *  to the file system, even in "Legacy Dev Mode", which differs from the behavior in Eclipse.
 *  <p>
 *  To ensure that script tags are loaded properly, follow these steps:<ul>
 *  <li>Start "Legacy Dev Mode" just as we suggest for Eclipse
 *  <li>Create a directory for your module under the "war" directory in your project, either via
 *  an OS command shell, or via right-clicking on the "war" directory and selecting New >>
 *  Directory.  The directory name must match the module name defined at the top of your GWT
 *  module file.  For our BuiltInDS sample project, the name is "builtinds".
 *  <li>Open the module directory you just created in a browser (Firefox tested).  You don't need
 *  the Classic GWT Plugin.  For the BuiltInDS sample project, it will be at URL: 
 *  "http://127.0.0.1:8888/builtinds/".  You should see the file 
 *  <code>loadScriptTagFiles.js</code>.  Right click to "save link as" a file inside the module
 *  directory in the actual file system.
 *  <li>Now if you stop the server, and switch to SuperDevMode, that file should be present after
 *  the compile, and the required Framework files should get loaded.</ul>
 *  <p>
 *  <h3> Browser Source Map Support</h3>
 *  Most current browsers should support source maps, required for source debugging, as discussed
 * in {@link com.smartgwt.client.docs.Debugging Debugging: Dev Mode and Super Dev Mode}.  If
 * they're not working, make
 *  sure that they're enabled in the settings of your browser's developer tools.  For example, to
 *  enable them in Chrome, make sure the "Enable JavaScript Source Maps" checkbox is ticked in
 *  the Developer Tools preferences.  When the page is loaded and you've hit the "Dev Mode On"
 *  bookmark, you should be able to browse the Java source in the debugger (under the "sources
 *  tab"), and set breakpoints in Java code.
 *  <p>
 *  <h3><u>Troubleshooting</u></h3>
 *  <table width="90%" class="normal" align="center" border="1" cellpadding="5">
 *  <tr bgcolor="#b0b0b0">
 *   <td width="30%"><b>Problem</b></td>
 *   <td width="30%"><b>Possible Causes</b></td>
 *   <td width="40%"><b>Solution</b></td>
 *  </tr><tr>
 *  <td>Missing GWT classes or JARs are reported when project is compiled.</td>
 *  <td>GWT Eclipse Plugin with GWT SDK is not installed or project was built with version
 *   different from what's configured in Eclipse and needs to be rebuilt.</td>
 *  <td>Install plugin (ticking checkbox for GWT SDK) from 
 * <a href='http://www.gwtproject.org/download.html' target='_blank'>here</a> and/or rebuild
 * project.</td>
 *  </tr><tr>
 *  <td>Errors are reported by GWT about the "linker not supporting script tags" when your
 *  project is oompiled.</td>
 *  <td>The SmartGWT Linker has been enhanced to work around this issue, so you should no
 *  longer be affected by it when migrating from earlier GWT versions.</td>
 * <td>Report any remaining issues at <a href='http://forums.smartclient.com'
 * target='_blank'>http://forums.smartclient.com</a>.</td>
 *  </tr><tr>
 *  <td>Nothing happens when you visit the "Dev Mode On" bookmark.</td>
 *  <td>The GWT Code Server is not running or the bookmark is not valid.</td>
 *  <td>Start the Code Server or create new bookmarks from the URL displayed in the Eclipse
 *  console when the Code Server launches.</td>
 *  </tr><tr>
 *  <td>When you launch your Web Application from Eclipse as directed above, you see an error
 *  in the browser indicating the GWT Plugin is missing (and perhaps that it's not available).
 *  </td><td>
 *  You've forgotten to remove the <code>gwt.codesvr</code> argument from the URL as
 *  we instructed above and the browser is not able to find the GWT Dev Mode Plugin.</td>
 *  <td>Remove the <code>gwt.codesvr</code> argument from the URL, or don't use the Eclipse GWT
 *  "Web Application" Run Configuration template (intended originally for Dev Mode) to launch
 *  your Web Application.  You may deploy your Web Application manually outside of Eclipse.</td>
 *  </tr><tr>
 *  <td>Skins aren't loaded when the application loads, resulting in missing icons and missized
 *  controls and fonts.  Failed file requests are logged by the browser, but no errors are
 *  reported by GWT in Eclipse.</td>
 *  <td>You've failed to set global variable <code>isomorphicDir</code> in the application's root
 *  HTML page, so the Framework is unable to locate the skin files.</td>
 *  <td>Add a <code>&lt;script&gt;</code> declaration in the root HTML page defining
 *  <code>isomorphicDir</code> to be "[MODULE_NAME]/sc", where the actual name of
 *  your project is substituted for the variable, as it appears in the
 *  <code>&lt;module&gt;</code> declaration in your project (gwt.xml) file.
 *  <p><br>
 *  For example, see the file <p><pre>helloworld-2.0/war/HelloWorld.html</pre><p> in the "Hello
 *  World" sample for SGWT LGPL, or the file <p><pre>built-in-ds/war/BuiltInDS.html</pre><p>
 *  in the "Built-in DS" sample for  SGWT EE.</td>
 *  </tr><tr>
 *  <td>When the SDM Server is launched in Eclipse, the SGWT Application fails to
 *  load, resource or configuration files are reported missing, or browser errors are hit
 *  because the core Smart GWT JavaScript Framework files haven't been loaded properly.  
 *  Missing symbols may be reported, such as "isc is not defined".
 *  </td><td>JavaScript Framework or linker-created files are missing from the war directory, or
 *  your GWT project uses script tags, but you're not using or have not merged your app's main
 *  page from the BuiltInDS Sample Project HTML.  The linkers used by GWT for SDM don't support
 *  script tags, but SGWT generates code to load them for you automatically.  However, this
 *  requires that your app's HTML load the file loadScriptTagFiles.js as in the BuiltInDS Sample
 *  Project.</td>
 *  <td>Make sure to run the GWT Plugin in <i>Legacy Dev Mode</i> at least once, to install the
 *  Framework resources and generate loadScriptTagFiles.js.  Then, if not already present, merge
 *  the line loading loadScriptTagFiles.js into your application's main HTML page from the
 *  BuiltInDS Sample Project.  (If you hit the latter issue, please add your opinion to the
 * <a href='https://github.com/gwtproject/gwt/issues/9149' target='_blank'>GWT Issue report</a> to
 * help
 *  get it resolved.)</td>
 *  </tr><tr>
 *  <td>You're not able to connect to the SDM Code Server from a remote machine, even though
 *  you've launched it with -bindAddress 0.0.0.0 to enable all IP addresses to connect.</td>
 * <td>You're hitting a <a href='https://github.com/gwtproject/gwt/issues/8910'
 * target='_blank'>known issue</a>
 *  with SDM in GWT that affects any situation where the fully qualified server name is not
 *  available via DNS lookup on the client, even if you access the server by IP address.</td>
 *  <td>Ensure DNS lookup is available for the server on the client, or add a binding to your
 *  hosts files.</td>
 *  </tr><tr>
 *  <td>When SuperDevMode is run, Java exceptions are thrown and the server fails to start
 *  (e.g. ExecutionException, ClassNotFoundException, IllegalStateException, ...).</td><td>
 *  JARs in the <code>WEB&#8209;INF/lib</code> directory of the filesystem are interfering with
 *  those added by the SDM server.</td><td>Remove the contents of <code>WEB&#8209;INF/lib</code>
 *  at the filesystem level, using an OS shell or file explorer.  SDM will auomatically populate
 *  the served content of that directory using the project classpath when it's run.</td>
 *  </tr><tr>
 *  <td>An exception involving org.objectweb.asm.ClassVisitor near the top frame is thrown in
 *  Eclipse, and the project won't run.</td><td>
 *  You have a version conflict involving the 
 * <a href='https://asm.ow2.io/index.html' target='_blank'>asm JAR</a>.  GWT itself as well as
 * other JARs
 *  may depend on a specific version of the asm JAR.  In Eclipse, the classpath is distinct from
 *  JARs copied into your WEB-INF/lib directory, so the problem might also be that the version
 *  of asm in your classpath is right, but it should be removed from WEB-INF/lib.</td><td>
 *  Fix your classpath in Eclipse to pick up the proper asm JAR version, based on your GWT
 *  version, and other JAR dependencies, such as Hibernate and Spring.  If possible, Remove the
 *  asm JAR from your WEB-INF/lib directory.  To verify your project JAR dependencies you can
 *  manually
 * <a href='https://mvnrepository.com/artifact/com.google.gwt/gwt-dev/2.9.0' target='_blank'>check
 * Maven</a>,
 * or to have Maven automatically manage your dependencies, see {@link
 * com.smartgwt.client.docs.MavenSupport}.
 *  To run our BuiltInDS sample project with GWT 2.12.x, ensure asm-8.x is in your classpath but
 *  not WEB-INF/lib.</td>
 *  </tr></table>
 *  <p><b>
 *  A useful discussion of some other problems and solutions related to GWT Development Mode can
 * be found <a href='http://stackoverflow.com/questions/18330001/super-dev-mode-in-gwt'
 * target='_blank'>here</a>.
 *  </b>
     * @see com.smartgwt.client.docs.Debugging
 */
public interface DevModeTroubleshooting {
}
