
package com.smartgwt.client.docs;

/**
 * <h3>Server-Side JavaScript CLI</h3>
 * Smart GWT's server-side JavaScript modules can be executed from the command line for
 *  standalone processing, batch operations, or embedding in custom applications.  This is
 * separate from {@link com.smartgwt.client.docs.ServerScript Server Scripting} which runs within
 * the servlet
 *  container.
 *  <P>
 *  <h3>Execution Modes</h3>
 *  <P>
 *  Two command-line execution modes are available:
 *  <P>
 *  <table border="1" cellpadding="5">
 *  <tr>
 *    <th>Mode</th>
 *    <th>Runtime</th>
 *    <th>Use Case</th>
 *    <th>Java Integration</th>
 *  </tr>
 *  <tr>
 *    <td><b>Node.js</b></td>
 *    <td>Node.js (v18+)</td>
 *    <td>CLI tools, build scripts, standalone processing</td>
 *    <td>None (pure JavaScript)</td>
 *  </tr>
 *  <tr>
 *    <td><b>GraalJS Polyglot</b></td>
 *    <td>GraalJS via Polyglot Context API</td>
 *    <td>Custom Java applications embedding Smart GWT JS</td>
 *    <td>Full (runs inside JVM)</td>
 *  </tr>
 *  </table>
 *  <P>
 *  <h3>Server Module Files</h3>
 *  <P>
 *  Server-side execution uses specially prepared module files that exclude browser-dependent
 *  code.  These modules are located in <code>isomorphic/system/modules/</code>:
 *  <ul>
 *  <li><code>ISC_Core_Server.js</code> - Core framework (language extensions, data structures,
 *      communications)</li>
 * <li><code>ISC_DataBinding_Server.js</code> - DataSource, RPCManager, and data binding
 * logic</li>
 *  <li><code>ISC_AI_Server.js</code> - AI module including AI integration classes</li>
 *  </ul>
 *  <P>
 *  <h3>Runtime Detection</h3>
 *  <P>
 *  Code can detect which runtime is active using {@link com.smartgwt.client.util.Browser} flags:
 *  
 *  <P>
 *  <h3>GraalJS Integration</h3>
 *  <P>
 *  For Java applications embedding Smart GWT JavaScript, two approaches are available:
 *  <ul>
 *  <li><b>Polyglot Context API</b> - Provides finest control over the JavaScript execution
 * environment.  See {@link com.smartgwt.client.docs.GraalPolyglotDMI} for detailed examples,
 * required JARs,
 *      and setup instructions.</li>
 *  <li><b>JSR-223 ScriptEngine</b> - Standard Java Scripting API; simpler but less flexible.
 *      See {@link com.smartgwt.client.docs.ServerScript} for configuration details.</li>
 *  </ul>
 *  <P>
 *  <h3>JSEngineManager</h3>
 *  <P>
 *  Smart GWT provides <code>JSEngineManager</code> for automatic engine detection.  It
 *  detects available engines and selects the best option:
 *  <pre>
 *  EngineInfo info = JSEngineManager.detectEngines(getClass().getClassLoader());
 *  ScriptEngine engine = JSEngineManager.createEngine(getClass().getClassLoader());
 *  </pre>
 *  <P>
 *  <b>Engine Selection Priority:</b>
 *  <ol>
 *  <li>GraalJS Polyglot mode (preferred - best Java interop and performance)</li>
 *  <li>GraalJS via JSR-223 ScriptEngine</li>
 *  <li>V8 via J2V8 (if available with platform-specific native libraries)</li>
 *  <li>Nashorn (OpenJDK standalone JAR for Java 15+, or Oracle built-in for Java 8-14)</li>
 *  </ol>
 *  <P>
 *  <h3>Nashorn Compatibility</h3>
 *  <P>
 *  Scripts written for Oracle Nashorn can run on GraalJS with Nashorn compatibility shims.
 *  Smart GWT automatically provides shims for common Nashorn constructs:
 *  <ul>
 *  <li><code>java.lang.*</code>, <code>java.util.*</code> - Package shortcuts</li>
 *  <li><code>Java.type()</code> - Class loading (native to GraalJS)</li>
 *  <li><code>importClass()</code>, <code>importPackage()</code> - Legacy import functions</li>
 *  </ul>
 *  <P>
 * See {@link com.smartgwt.client.docs.GraalPolyglotDMI} for using the Polyglot API from DMI
 * within a servlet
 * container, and {@link com.smartgwt.client.docs.ServerScript} for using the JSR-223 ScriptEngine
 * API for
 *  declarative scripts in .ds.xml files.
 */
public interface ServerJSCLI {
}
