
package com.smartgwt.client.docs;

/**
 * <h3>Logging migration</h3>
 * In Smartclient version 13.1 and later Apache Log4j 2.x is used for {@link
 * com.smartgwt.client.docs.ServerLogging}. See the  recommendations below on how to migrate to
 * the new logging system. <h4>Migrate from Log4j 1.x used directly</h4> If you were using Log4j
 * 1.x directly, you should take any custom settings you want to retain from 
 * <i>log4j.isc.config.xml</i> Log4j 1.x configuration file (old) and move them over to
 * <i>log4j2.isc.config.xml</i>  Log4j 2.x configuration file (new) according to the Apache's  <a
 * href='https://logging.apache.org/log4j/2.x/manual/migration.html' target='_blank'>Migrating
 * from Log4j 1.x to 2.x</a> guide. <h4>Migrate from logging system used over the Slf4j
 * bridge</h4> If you were using logging system over the Slf4j bridge, you may switch to the Log4j
 * 2.x API instead as it is now  separated from the implementation, so Log4j 2.x may be used as a
 * bridge to other logging systems, including Slf4j. <h4>Continue using Log4j 1.x</h4>  If you are
 * forced to continue to use Log4j 1.x, you may redirect Smartclient loggin to Slf4j as described
 * in  {@link com.smartgwt.client.docs.ServerLogging Redirecting logging to Slf4j framework} with
 * the Slf4j to Log4j 1.x bridge, or use the  default Smartclient Log4j 2.x logging and pass it to
 * the Slf4j by using the  <a
 * href='https://logging.apache.org/log4j/2.x/log4j-to-slf4j/index.html' target='_blank'>Log4j 2.x
 * to Slf4j adapter</a>, and then  use the Slf4j to Log4j 1.x bridge. <p> Alternatively you may do
 * this by using the Log4j 1.x bridge as described in  <a
 * href='https://logging.apache.org/log4j/2.x/manual/migration.html#Log4j1.2Bridge'
 * target='_blank'>Log4j 2.x migration docs</a>.
 */
public interface LoggingMigration {
}
