package com.smartgwt.sample.showcase.client.tree;

import com.smartgwt.client.widgets.Canvas;
import com.google.gwt.i18n.client.NumberFormat;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.ButtonItem;
import com.smartgwt.client.widgets.form.fields.CheckboxItem;
import com.smartgwt.client.widgets.form.fields.events.ChangeEvent;
import com.smartgwt.client.widgets.form.fields.events.ChangeHandler;
import com.smartgwt.client.widgets.form.fields.events.ClickEvent;
import com.smartgwt.client.widgets.form.fields.events.ClickHandler;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.client.widgets.grid.CellFormatter;
import com.smartgwt.client.widgets.grid.ListGridRecord;
import com.smartgwt.client.widgets.tree.TreeGrid;
import com.smartgwt.client.widgets.tree.TreeGridField;
import com.smartgwt.client.data.AdvancedCriteria;
import com.smartgwt.client.data.Criteria;
import com.smartgwt.client.data.Criterion;
import com.smartgwt.client.types.FetchMode;
import com.smartgwt.client.types.ListGridFieldType;
import com.smartgwt.client.types.OperatorId;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.data.EmployeeXmlDS;

public class TreeFilteringSample extends ShowcasePanel {
    private static final String DESCRIPTION = "Trees can be filtered without server-side support. "+
        "Parent nodes can be dropped if they don't match the criteria or they can be retained if matching "+
        "children are present. Click on the \"filter\" buttons to change the filter criteria."+
        "Note that if \"keep parents\" is not checked, keepParentsOnFilter will be false for the TreeGrid in the "+
        "sample, excluding all nodes not matching the criteria, and all nodes below the excluded nodes in the "+
        "TreeGrid. (So if the filter excludes the root node, no nodes will be visible.)";

    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
            TreeFilteringSample panel = new TreeFilteringSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
          return DESCRIPTION;
        }
    }
    
	private TreeGrid employeeTreeGrid;
	private VLayout mainLayout;
	
    public Canvas getViewPanel() {
        mainLayout = new VLayout();
        mainLayout.setWidth100();
        mainLayout.setHeight100();
        mainLayout.setMembersMargin(5);
	        
        DynamicForm form = new DynamicForm();  
        form.setWidth(600);
        form.setNumCols(8);

        ButtonItem showAllButton = new ButtonItem();
        showAllButton.setTitle("Show all");
        showAllButton.setStartRow(false);
        showAllButton.setEndRow(false);
        showAllButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                employeeTreeGrid.filterData(new Criteria());
            }
        });
        		
        ButtonItem showContractButton = new ButtonItem();
        showContractButton.setTitle("Show Contract");
        showContractButton.setStartRow(false);
        showContractButton.setEndRow(false);
        showContractButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                Criteria criteria = new Criteria();
                criteria.addCriteria("EmployeeType", "contract");
                employeeTreeGrid.filterData(criteria);
            }
        });
        ButtonItem showFullTimeButton = new ButtonItem();
        showFullTimeButton.setTitle("Show Full Time");
        showFullTimeButton.setStartRow(false);
        showFullTimeButton.setEndRow(false);
        showFullTimeButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                Criteria criteria = new Criteria();
                criteria.addCriteria("EmployeeType", "full time");
                employeeTreeGrid.filterData(criteria);
            }
        });
        ButtonItem showEngineersButton = new ButtonItem();
        showEngineersButton.setTitle("Show Engineers");
        showEngineersButton.setStartRow(false);
        showEngineersButton.setEndRow(false);
        showEngineersButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                AdvancedCriteria adCriteria = new AdvancedCriteria(OperatorId.AND, new Criterion[]{
                    new Criterion("Job", OperatorId.ICONTAINS, "engineer")
                });
				
                employeeTreeGrid.filterData(adCriteria);
            }
        });
		
        final CheckboxItem keepParents = new CheckboxItem("keepParents", "Keep parents");  
        keepParents.setDefaultValue(true);  
        keepParents.addChangeHandler(new ChangeHandler() {  
            public void onChange(ChangeEvent event) {  
                Criteria criteria = employeeTreeGrid.getCriteria();
                boolean selected = keepParents.getValueAsBoolean();  
            	
                if (criteria !=null && criteria.getValues().size() != 0) recreateListGrid(criteria, selected);
            }  
        });  
        
        form.setFields(showAllButton, showFullTimeButton, showContractButton, showEngineersButton, keepParents);  
        
        mainLayout.addMember(form);
        
        recreateListGrid(new Criteria(), true);
        
        return mainLayout;
    }
    
    private void recreateListGrid (Criteria criteria, boolean keepParents) { 
		
        if (mainLayout.hasMember(employeeTreeGrid)) mainLayout.removeMember(employeeTreeGrid);
		 
        employeeTreeGrid = new TreeGrid();  
        employeeTreeGrid.setLoadDataOnDemand(false);  
        employeeTreeGrid.setWidth(600);  
        employeeTreeGrid.setHeight(400);  
        employeeTreeGrid.setDataSource(EmployeeXmlDS.getInstance());  
        employeeTreeGrid.setShowFilterEditor(true);  
        employeeTreeGrid.setFilterOnKeypress(true);  
        employeeTreeGrid.setKeepParentsOnFilter(keepParents);  
        employeeTreeGrid.setInitialCriteria(criteria);  
        employeeTreeGrid.setAutoOpenTree("all");  
        employeeTreeGrid.setAutoFetchData(true);
        employeeTreeGrid.setNodeIcon("icons/16/person.png");  
        employeeTreeGrid.setFolderIcon("icons/16/person.png");  
        employeeTreeGrid.setShowOpenIcons(false);  
        employeeTreeGrid.setShowDropIcons(false);  
        employeeTreeGrid.setClosedIconSuffix(""); 
        employeeTreeGrid.setDataFetchMode(FetchMode.LOCAL);
        employeeTreeGrid.setShowSelectedIcons(true);
		 
        TreeGridField nameField = new TreeGridField("Name", 150);  
        TreeGridField jobField = new TreeGridField("Job", 150);  
        TreeGridField employeeTypeField = new TreeGridField("EmployeeType");  
        TreeGridField salaryField = new TreeGridField("Salary");
        salaryField.setType(ListGridFieldType.FLOAT);
        salaryField.setWidth(100);
        salaryField.setCellFormatter(new CellFormatter() {  
            public String format(Object value, ListGridRecord record, int rowNum, int colNum) {  
                if (value != null) {  
                    NumberFormat nf = NumberFormat.getFormat("#,##0");  
                    try {  
                        return "$" + nf.format(((Number) value).longValue());  
                    } catch (Exception e) {  
                        return value.toString();  
                    }  
                } else {  
                    return null;  
                }  
            }  
        });  
        employeeTreeGrid.setFields(nameField, jobField, employeeTypeField, salaryField);  
	        
        mainLayout.addMember(employeeTreeGrid);
    }
    

    public String getIntro() {
        return DESCRIPTION;
    }
}
