package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * Indicates the category of "generated fields" the Smart GWT Server should write values to, if defined on a {@link
 * com.smartgwt.client.data.DSRequest} - see  {@link com.smartgwt.client.data.DSRequest#getWriteToGeneratedFields
 * writeToGeneratedFields}.  At the time of writing we  only support one such category, but this may be extended in the
 * future.
 */
public enum WriteToGeneratedFields implements ValueEnum {
    /**
     * Write <code>dsRequest</code>-provided values for fields of type <code>modifier</code>,  <code>creator</code>,
     * <code>modifierTimestamp</code> and <code>creatorTimestamp</code>
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "modifiersAndTimestamps".
     */
    MODIFIERSANDTIMESTAMPS("modifiersAndTimestamps");
    private String value;

    WriteToGeneratedFields(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
