/*

  SmartClient Ajax RIA system
  Version SNAPSHOT_v15.0d_2025-12-01/LGPL Deployment (2025-12-01)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//>DEBUG
// This lets us label methods with a name within addMethods
Number.prototype.Class = "Number";
  //<DEBUG 


//> @object Number
// Extra methods added to the Number object, available on all number variables.  Attributes,
// parameters, or return values declared as <code>Number</code> may be null.
// @treeLocation Client Reference/System
// @see type:Integer
// @see type:Double
// @see type:Float
// @visibility external
//<

isc.addMethods(Number, {
setStandardFormatter : function (functionName) {
    isc.NumberUtil.setStandardFormatter(functionName);
},
setStandardLocaleStringFormatter : function (functionName) {
    isc.NumberUtil.setStandardLocaleStringFormatter(functionName);
}
});

// Polyfill Number.isNaN for Internet Explorer

if (Number.isNaN == null) {
Number.isNaN = function(value) {
    return value !== value;
}
}


if (Number.isInteger == null) {
Number.isInteger = function (value) {
    return typeof value == "number" && value != Infinity && value != -Infinity && Math.floor(value) == value;
};
}



//> @type Integer
// A whole number, for example, 5.  Decimal numbers, for example 5.5, are not allowed.  Null is
// allowed.
// @treeLocation Client Reference/System
// @baseType Number
// @see type:int
// @see type:PositiveInteger
// @visibility external
//<

//> @type int
// A whole number, for example, 5.  Decimal numbers, for example 5.5, are not allowed.  May not
// be null.
// @treeLocation Client Reference/System
// @baseType Integer
// @visibility external
//<

//> @type PositiveInteger
// A positive whole number or 0, for example, 5.  Negative values are not allowed.  Null is
// allowed.
// @treeLocation Client Reference/System
// @baseType Integer
// @visibility external
//<

//> @type Float
// A decimal (or "floating point") number, for example, 5.5.  Null is allowed.
// @treeLocation Client Reference/System
// @baseType Number
// @see type:float
// @visibility external
//<

//> @type Double
// A decimal (or "floating point") number, for example, 5.5.  Null is allowed.
// @treeLocation Client Reference/System
// @baseType Number
// @see type:double
// @visibility external
//<

//> @type float
// A decimal (or "floating point") number, for example, 5.5.  May not be null.
// @treeLocation Client Reference/System
// @baseType Float
// @visibility external
//<

//> @type double
// A decimal (or "floating point") number, for example, 5.5.  May not be null.
// @treeLocation Client Reference/System
// @baseType Double
// @visibility external
//<

//
// add methods to all Numbers
//
isc.addMethods(Number.prototype, {


stringify : isc.NumberUtil._stringify,

//> @method number.isBetween()
// Returns true if the number parameter falls between the 'first' and 'second' paramters.
//
// @param number (number) Number object to be evaluated
// @param [first] (number) Number at the lower boundary
// @param [second] (number) Number at the upper boundary
// @param [inclusive] (number) Whether or not the numbers at either end of the boundary should be included in the comparison
// @return (Boolean) True if the given <code>number</code> falls inside the given range, false otherwise
// @example n = 3; bool = n.isBetween(3, 3, 6, true); // true
// @example n = 3; bool = n.isBetween(3, 3, 6);       // false
// @visibility external
//<
isBetween : isc.NumberUtil._isBetween,



toCurrencyString : isc.NumberUtil._toCurrencyString

// NOTE:
// We don't provide 'setFormatter' or 'setStandardFormatter' instance methods for Numbers.
// This is because 
// a) we don't want to confuse the issue of where formatters are stored (we have a pattern here
//    and on Dates of having standard formatters for all instances only)
// b) (at least in IE), numbers are not allocated as "true instances", so having a 
//     number instance (var theVar = 2;) does not mean that you can set up properties on it, 
//     such as theVar.formatter -- when you next refer to 'theVar', you are really given 
//     another '2' instance, so your properties have been wiped out.

});

//
// add class-methods to the Number object
//  Moved to NumberUtil.js

isc.addProperties(Number.prototype, {
    
// doc and implementation moved to NumberUtil
iscToLocaleString : function () {
    var result = isc.NumberUtil.iscToLocaleString(this);
    return result;
},

// doc and implementation moved to NumberUtil
toFormattedString : function (formatter) {
    var result = isc.NumberUtil.toFormattedString(this, formatter)
    return result;
},

// doc and implementation moved to NumberUtil
toLocalizedString : function (decimalPrecision, decimalSymbol, groupingSymbol, negativeSymbol) {
    var result = isc.NumberUtil.toLocalizedString(this, decimalPrecision, decimalSymbol, 
                groupingSymbol, negativeSymbol);
    return result;
},


toUSString : function(decimalPrecision) {
    var result = isc.NumberUtil.toUSString(this, decimalPrecision);
    return result;
},
toUSDollarString : function (decimalPrecision) {
    return isc.NumberUtil.toUSCurrencyString(this, decimalPrecision);
},
toUSCurrencyString : function(decimalPrecision) {
    var result = isc.NumberUtil.toUSCurrencyString(this, decimalPrecision);
    return result;
}

}); // end addProperties(Number.prototype) for localizable number formatter



isc.defineClass("Format");

isc.Format.addClassMethods({
    toUSString : function (theNum, decimalPrecision) { 
        if (!isc.isA.Number(theNum)) return theNum;
        return isc.NumberUtil.toUSString(theNum, decimalPrecision) 
    },
    toUSCurrencyString : function (theNum, decimalPrecision) { 
        if (!isc.isA.Number(theNum)) return theNum;
        return isc.NumberUtil.toUSCurrencyString(theNum, decimalPrecision) 
    },
    toUSDollarString : function (theNum, decimalPrecision) { 
        if (!isc.isA.Number(theNum)) return theNum;
        return isc.NumberUtil.toUSCurrencyString(theNum, decimalPrecision) 
    },
    toCurrencyString : function (theNum, currencyChar, decimalChar, 
                                 padDecimal, currencyCharLast) {
        if (!isc.isA.Number(theNum)) return theNum;
        return isc.NumberUtil._toCurrencyString(currencyChar, decimalChar, 
                                       padDecimal, currencyCharLast, theNum);
    }
});

// Instance of this class can hold numeric value of any size and precision.
isc.defineClass("BigDecimal");

isc.BigDecimal.addProperties({
    // RegExp to parse number. exec() result array values:
    // 0 - parsed value
    // 1 - sign
    // 2 - whole number (if entered witout fraction)
    // 3 - whole number (if entered with fraction)
    // 4 - fraction part (if entered with fraction)
    // 5 - exponent sing
    // 6 - exponent value
    // 7 - Infinity
    r : /^(?:(?:NaN|([+|-]?)(?:(?:(\d+)\.*|(\d*)\.(\d+))(?:[E|e]([+|-]?)(\d+))?|(Infinity))))$/,
    // Holds true if value is NaN
    // new BigDecimal starts as NaN
    nanValue: true,
    // Holds true if value is positive or negative Infinity
    infinityValue: false,
    // 1: "+"
    //-1: "-"
    sign: 1,
    // Holds significant digits of number:
    // for value 12.345: num="12345";
    // for value 607000: num="607";
    // for value 0.00809: num="809";
    num: "",
    // Holds exponent
    // realValue=num*10^exp
    exp: 0
});

isc.BigDecimal.addMethods({
    // Returns true if instance holds value which does not represent valid number.
    isNaN : function() {
        return this.nanValue;
    },
    // Returns true if instance holds Infinity (positive or negative).
    isInfinity : function() {
        return !this.nanValue && this.infinityValue;
    },
    // Returns 1 if holds positive value or -1 if holds negative value.
    getSign : function() {
        return (this.nanValue)?1:this.sign;
    },
    // Returns significant digits of number.
    getNum : function() {
        return (this.nanValue)?"0":this.num;
    },
    // Returns exponent
    getExp : function() {
        return (this.nanValue)?0:this.exp;
    },
    // Normalizes state of number: trims leading/trailing zeroes and adjusts exponent accordingly:
    // 00012300e2 becomes 123e4
    // Value is not changed - method changes only internal representation of the seam value.
    normalize : function() {
        if (this.nanValue) {
            // Reset all internals for NaN
            this.infinityValue = false;
            this.sign = 1;
            this.num = "";
            this.exp = 0;
        } else {
            if (this.infinityValue) {
                // Infinity does not have number representation - reset it
                this.num = "";
                this.exp = 0;
            } else {
                // Trim leading zeroes
                this.num = this.num.replace(/^0*/, "");
                // Trim trailing zeroes
                var trail = /0*$/.exec(this.num);
                if (trail) {
                    this.num = this.num.replace(/0*$/, "");
                    // Adjust exponent
                    this.exp += trail[0].length;
                }
                if (this.num === "") {
                    this.num = "0";
                    this.exp = 0;
                }
            }
        }
        return this;
    },
    toString : function() {
        return this.getStringValue();
    },
    // Returns value as a string.
    // If exponent parameter is true - return value in exponent representation
    getStringValue : function(exponent) {
        if (this.nanValue) {
            return "NaN";
        }
        if (this.infinityValue) {
            return (this.sign === 1?"":"-") + "Infinity";
        }
        if (exponent) {
            if (this.num.length === 1) {
                return (this.sign === 1?"":"-") + this.num + "e" + this.exp;
            }
            var res = this.num.substr(0, 1) + "." + this.num.substr(1);
            return (this.sign === 1?"":"-") + res + "e" + (this.exp + (this.num.length - 1));
        } else {
            var res = this.num;
            if (this.exp >= 0) {
                res += "0".repeat(this.exp);
            } else {
                if (res.length < Math.abs(this.exp) + 1) {
                    res = "0".repeat(Math.abs(this.exp) - res.length + 1) + res;
                }
                res = res.substr(0, res.length + this.exp) + "." + res.substr(res.length + this.exp);
            }
            return (this.sign === 1?"":"-") + res;
        }
    },
    // Returns value as Number
    // Loss of precision can occur.
    getNumberValue : function() {
        if (this.nanValue) {
            return NaN;
        } else if (this.infinityValue) {
            return Infinity * this.sign;
        } else {
            return new Number(this.getStringValue());
        }
    },
    // If THIS number is greater than parameter - return 1;
    // If THIS number equals to parameter - return 0;
    // If THIS number is less than parameter - return -1;
    // Special cases:
    //      if parameter can not be converted to number it is treated as zero;
    //      NaN treated as zero
    compareTo : function(number) {
        if (!(isc.isA.BigDecimal(number))) {
            number = isc.BigDecimal.create(number);
        }
        var thisNanValue = this.isNaN();
        var thisInfinityValue = this.isInfinity();
        var thisSign = this.getSign();
        var thisNum = this.getNum();
        var thisExp = this.getExp();
        var otherNanValue = number.isNaN();
        var otherInfinityValue = number.isInfinity();
        var otherSign = number.getSign();
        var otherNum = number.getNum();
        var otherExp = number.getExp();
        if (thisInfinityValue) {
            if (otherInfinityValue) {
                if (thisSign > otherSign) {
                    return 1;
                } else if (thisSign === otherSign) {
                    return 0;
                } else {
                    return -1;
                }
            } else {
                if (thisSign > 0) {
                    return 1;
                } else {
                    return -1;
                }
            }
        }
        if (otherInfinityValue) {
            if (otherSign < 0) {
                return 1;
            } else {
                return -1;
            }
        }
        if (thisExp > otherExp) {
            thisNum += "0".repeat(thisExp - otherExp);
        } else {
            otherNum += "0".repeat(otherExp - thisExp);
        }
        if (thisNum.length > otherNum.length) {
            otherNum = "0".repeat(thisNum.length - otherNum.length) + otherNum;
        } else {
            thisNum = "0".repeat(otherNum.length - thisNum.length) + thisNum;
        }
        if (thisNum > otherNum) {
            if (thisSign > otherSign) {
                return 1;
            } else if (thisSign === otherSign) {
                return 1;
            } else {
                return -1;
            }
        } else if (thisNum === otherNum) {
            if (thisSign > otherSign) {
                return 1;
            } else if (thisSign === otherSign) {
                return 0;
            } else {
                return -1;
            }
        } else {
            if (thisSign > otherSign) {
                return 1;
            } else if (thisSign === otherSign) {
                return -1;
            } else {
                return -1;
            }
        }
    },
    // Negates number
    // Returns new instance
    negate : function() {
        var ret = isc.BigDecimal.create(this);
        if (!ret.isNaN()) {
            if (ret.sign === 1) {
                ret.sign = -1;
            } else {
                ret.sign = 1;
            }
        }
        return ret;
    },
    // Add specified number to THIS number
    // Returns new instance
    add : function(number) {
        if (!(isc.isA.BigDecimal(number))) {
            number = isc.BigDecimal.create(number);
        }
        var thisNanValue = this.isNaN();
        var thisInfinityValue = this.isInfinity();
        var thisSign = this.getSign();
        var thisNum = this.getNum();
        var thisExp = this.getExp();
        var otherNanValue = number.isNaN();
        var otherInfinityValue = number.isInfinity();
        var otherSign = number.getSign();
        var otherNum = number.getNum();
        var otherExp = number.getExp();
        // If both values are NaN - return NaN.
        if (thisNanValue && otherNanValue) {
            return isc.BigDecimal.create();
        }
        // +Infinity-Infinity or -Infinity+Infinity results in NaN.
        if (thisInfinityValue && otherInfinityValue && thisSign != otherSign) {
            return isc.BigDecimal.create();
        }
        var ret = isc.BigDecimal.create("0");
        // If this value is (+/-)Infinity - adding anything to (+/-)Infinity equals (+/-)Infinity
        if (thisInfinityValue) {
            ret.sign = this.sign;
            ret.infinityValue = true;
            return ret.normalize();
        }
        // If other value is (+/-)Infinity - adding (+/-)Infinity to anything equals (+/-)Infinity
        if (otherInfinityValue) {
            ret.sign = number.sign;
            ret.infinityValue = true;
            return ret.normalize();
        }
        if (thisExp > otherExp) {
            thisNum += "0".repeat(thisExp - otherExp);
            thisExp = otherExp;
        } else {
            otherNum += "0".repeat(otherExp - thisExp);
            otherExp = thisExp;
        }
        if (thisNum.length > otherNum.length) {
            otherNum = "0".repeat(thisNum.length - otherNum.length) + otherNum;
        } else {
            thisNum = "0".repeat(otherNum.length - thisNum.length) + thisNum;
        }
        ret.sign = thisSign;
        ret.exp = thisExp;
        if (thisSign === otherSign) {
            var res = "";
            var carry = 0;
            // Optimization: do addition in 15 digit long chunks
            var i = thisNum.length;
            while (i >= 0) {
                var tn = thisNum.substring(Math.max(0, i - 15), i);
                var on = otherNum.substring(Math.max(0, i - 15), i);
                var s = parseInt(tn) + parseInt(on) + carry;
                var r = "000000000000000" + (s % 1000000000000000);
                res = r.substring(r.length - 15) + res;
                carry = Math.floor(s / 1000000000000000);
                i -= 15;
            }
// Code for doing addition digit by digit
//            for (var i = thisNum.length - 1; i >= 0; i--) {
//                var s = parseInt(thisNum[i]) + parseInt(otherNum[i]) + carry;
//                res = "" + (s % 10) + res;
//                carry = Math.floor(s / 10);
//            }
            if (carry > 0) {
                res = "" + carry + res;
            }
            ret.num = res;
        } else {
            if (thisNum < otherNum) {
                var tmp = thisNum;
                thisNum = otherNum;
                otherNum = tmp;
                ret.sign = otherSign;
            }
            var res = "";
            var carry = 0;
            // Optimization: do subtraction in 15 digit long chunks
            var i = thisNum.length;
            while (i >= 0) {
                var tn = thisNum.substring(Math.max(0, i - 15), i);
                var on = otherNum.substring(Math.max(0, i - 15), i);
                var s = 1000000000000000 + parseInt(tn) - parseInt(on) - carry;
                var r = "000000000000000" + (s % 1000000000000000);
                res = r.substring(r.length - 15) + res;
                carry = (Math.floor(s / 1000000000000000) >= 1)?0:1;
                i -= 15;
            }
// Code for doing subtraction digit by digit
//            for (var i = thisNum.length - 1; i >= 0; i--) {
//                var s = 10 + parseInt(thisNum[i]) - parseInt(otherNum[i]) - carry;
//                res = "" + (s % 10) + res;
//                carry = (Math.floor(s / 10) >= 1)?0:1;
//            }
            ret.num = res;
        }
        return ret.normalize();
    },
    // Subtracts specified number from THIS number.
    // Returns new instance
    subtract : function(number) {
        number = isc.BigDecimal.create(number);
        number = number.negate();
        return this.add(number);
    },
    multiply : function(number) {
        if (!(isc.isA.BigDecimal(number))) {
            number = isc.BigDecimal.create(number);
        }
        // If any is NaN - return NaN
        if (this.isNaN() || number.isNaN()) {
            return isc.BigDecimal.create();
        }
        // Multiplying any Infinity by 0 gives NaN
        if ((this.compareTo(0) === 0 && number.isInfinity())
            || (this.isInfinity() && number.compareTo(0) === 0)) {
            return isc.BigDecimal.create();
        }
        // Multiplying any Infinity by any number gives Infinity
        if (this.isInfinity() || number.isInfinity()) {
            var ret = isc.BigDecimal.create("Infinity");
            if (this.sign !== number.sign) {
                ret.sign = -1;
            }
            return ret;
        }
        // Multiplying any number by 0 gives 0
        if (this.compareTo(0) === 0 || number.compareTo(0) === 0) {
            return isc.BigDecimal.create(0);
        }
        // Inflate num values (from both sides) that they would represent
        // numbers of same magnitude.
        var tNum = this.num;
        var oNum = number.num;
        tNum += "0".repeat(Math.max(this.exp - number.exp, 0));
        oNum += "0".repeat(Math.max(number.exp - this.exp, 0));
        tNum = "0".repeat(Math.max(oNum.length - tNum.length, 0)) + tNum;
        oNum = "0".repeat(Math.max(tNum.length - oNum.length, 0)) + oNum;
        // Multiply 7-digit chunks: result would be maximum 14 digits long -
        // JS can handle this.
        var a = [];
        while (tNum.length > 0) {
            var tm = parseInt(tNum.substring(Math.max(tNum.length - 7, 0)));
            var tmpONum = oNum;
            var r1 = [];
            var r2 = [];
            while (tmpONum.length > 0) {
                var om = parseInt(tmpONum.substring(Math.max(tmpONum.length - 7, 0)));
                var r = tm * om;
                r1.push(r % 10000000);
                r1.push(0);
                r2.push(0);
                r2.push(Math.floor(r / 10000000));
                tmpONum = tmpONum.substring(0, Math.max(tmpONum.length - 7, 0));
            }
            a.push(r1);
            a.push(r2);
            tNum = tNum.substring(0, Math.max(tNum.length - 7, 0));
        }
        // If resulting array has more than 10 rows we have to use BigDecimal
        // to sum. Summing more than 10 we can get result exceeding
        // 15 digits thus loose precision.
        var useBD = true;
        if (a.length < 10) {
            useBD = false;
        }
        var y = 0;
        var x = 0;
        // Carry
        var c = (useBD)?isc.BigDecimal.create("0"):0;
        var resA = [];
        while (y < a.length) {
            var s = (useBD)?isc.BigDecimal.create("0"):0;
            var xx = x;
            var yy = y;
            while ((a[yy] !== undefined) && (a[yy][xx] !== undefined)) {
                if (useBD) {
                    s = s.add(a[yy++][xx--]);
                } else {
                    s += a[yy++][xx--];
                }
            }
            // Add previous carry and save chunk 7 digits long.
            // Higher digits saved to next carry.
            if (useBD) {
                s = s.add(c);
                var sNum = "00000000" + s.num + "0".repeat(s.exp);
                c = isc.BigDecimal.create(sNum.substring(0, sNum.length - 7));
                s = isc.BigDecimal.create(sNum.substring(sNum.length - 7));
            } else {
                s += c;
                c = Math.floor(s / 10000000);
                s = s % 10000000;
            }
            resA.push(s);
            if (x < a[0].length - 2) {
                x = x + 2;
            } else {
                if (x < a[0].length - 1) {
                    y++
                } else {
                    y = y + 2;
                }
                x = a[0].length - 1;
            }
        }
        resA.push(c);
        var resNum = "";
        for (var i = resA.length - 1; i >= 0; i--) {
            var sNum;
            if (useBD) {
                sNum = "00000000" + resA[i].num + "0".repeat(resA[i].exp);
            } else {
                sNum = "00000000" + resA[i]
            }
            // Each chunk is 7 digits long
            resNum += sNum.substring(sNum.length - 7);
        }
        var rSign = "";
        if (this.sign !== number.sign) {
            rSign = "-";
        }
        // Resulting exponent
        var rExp = Math.min(this.exp, number.exp) * 2;
        return isc.BigDecimal.create(rSign + resNum + "e" + rExp);
    },
    round : function(precision, mode) {
        // NaN, Infinity, Zero - there is nothing to round
        if (this.isNaN() || this.isInfinity() || this.num === "0") {
            return isc.BigDecimal.create(this);
        }
        if (!precision) {
            precision = 0;
        }
        // Number is already at required precision
        if ((-1 * precision) <= this.exp) {
            return isc.BigDecimal.create(this);
        }
        var leftPart;
        var rightPart;
        if ((-1 * precision) >= (this.exp + this.num.length)) {
            leftPart = "0";
            rightPart = "0".repeat((-1 * precision) - (this.exp + this.num.length)) + this.num;
        } else {
            leftPart = this.num.substring(0, this.exp + this.num.length + precision);
            rightPart = this.num.substring(this.exp + this.num.length + precision);
        }
        if (!mode) {
            mode = "round";
        }
        var left = isc.BigDecimal.create(leftPart);
        var right = isc.BigDecimal.create("0." + rightPart);
        if (mode === "round") {
            var c = right.compareTo("0.5");
            if (this.sign >= 0) {
                if (c >= 0) {
                    left = left.add(1);
                }
            } else {
                if (c > 0) {
                    left = left.add(1);
                }
                left = left.negate();
            }
            left.exp += (-1 * precision);
            return left.normalize();
        } else if (mode === "ceil" || mode == "java_ceil") {
            if (this.sign >= 0) {
                left = left.add(1);
            } else {
                left = left.negate();
            }
            left.exp += (-1 * precision);
            return left.normalize();
        } else if (mode === "floor" || mode == "java_floor") {
            if (this.sign < 0) {
                left = left.add(1).negate();
            }
            left.exp += (-1 * precision);
            return left.normalize();
        } else if (mode == "java_up") {
            left = left.add(1);
            if (this.sign < 0) {
                left = left.negate();
            }
            left.exp += (-1 * precision);
            return left.normalize();
        } else if (mode == "java_down") {
            if (this.sign < 0) {
                left = left.negate();
            }
            left.exp += (-1 * precision);
            return left.normalize();
        } else if (mode == "java_halfUp") {
            var c = right.compareTo("0.5");
            if (c >= 0) {
                left = left.add(1);
            }
            if (this.sign < 0) {
                left = left.negate();
            }
            left.exp += (-1 * precision);
            return left.normalize();
        } else if (mode == "java_halfDown") {
            var c = right.compareTo("0.5");
            if (c > 0) {
                left = left.add(1);
            }
            if (this.sign < 0) {
                left = left.negate();
            }
            left.exp += (-1 * precision);
            return left.normalize();
        } else if (mode == "java_halfEven") {
            var c = right.compareTo("0.5");
            if (c > 0) {
                left = left.add(1);
            } else if (c === 0) {
                var lastDigit = leftPart.substring(leftPart.length - 1);
                if (lastDigit === "1" || lastDigit === "3" || lastDigit === "5" || lastDigit === "7" || lastDigit === "9") {
                    left = left.add(1);
                }
            }
            if (this.sign < 0) {
                left = left.negate();
            }
            left.exp += (-1 * precision);
            return left.normalize();
        }
        return isc.BigDecimal.create(this);
    },
    ceil : function(precision) {
        return this.round(precision, "ceil");
    },
    floor : function(precision) {
        return this.round(precision, "floor");
    },
    // Divides two numbers by subtracting divisor from dividend.
    // Should be used only for similar numbers when
    // number of subtractions is less than 10.
    // Returns array with two string elements: 0 - quotient; 1 - remainder
    _divideBySubtracting : function(dividend, divisor) {
    var ret = [];
        ret[0] = 0;
        ret[1] = isc.BigDecimal.create(dividend);
        var subtrahend = isc.BigDecimal.create(divisor);
        while (ret[1].compareTo(subtrahend) >= 0) {
            var minuend = ret[1];
            ret[0]++;
            ret[1] = minuend.subtract(subtrahend);
        }
        return ret;
    },
    // Divides two numbers of same magnitude.
    // Returns array with two string elements: 0 - quotient; 1 - remainder
    _divide : function(dividend, divisor, precision) {
        var remainders = [];
        var ret = [];
        ret[0] = "";
        ret[1] = "";
        var div = dividend.substring(0, Math.min (dividend.length, divisor.length));
        if (div.length >= dividend.length) {
            dividend = ""
        } else {
            dividend = dividend.substring(div.length);
        }
        while (true) {
            var r = this._divideBySubtracting(div, divisor);
            ret[0] += r[0];
            ret[1] = r[1].getStringValue();
            if (dividend.length <= 0) {
                break;
            }
            div = ret[1] + dividend.substring(0, 1);
            dividend = dividend.substring(1);
        }
        if (precision > 0) {
            ret[0] += ".";
            var periodic = false;
            do {
                remainders.push(ret[1]);
                var div = ret[1] + "0";
                var r = this._divideBySubtracting(div, divisor);
                ret[0] += r[0];
                ret[1] = r[1].getStringValue();
                if (!isFinite(precision)) {
                    for (var i = 0; i < remainders.length; i++) {
                        if (remainders[i] === ret[1]) {
                            periodic = true;
                        }
                    }
                } else {
                    --precision;
                }
            } while ((isFinite(precision) && precision > 0) || (!isFinite(precision) && !periodic));
        }
        return ret;
    },
    divide : function(number, precision, mode) {
        if (!(isc.isA.BigDecimal(number))) {
            number = isc.BigDecimal.create(number);
        }
        // If any is NaN - return NaN
        if (this.isNaN() || number.isNaN()) {
            return isc.BigDecimal.create();
        }
        // Dividing any Infinity by any Infinity gives NaN
        if (this.isInfinity() && number.isInfinity()) {
            return isc.BigDecimal.create();
        }
        // Dividing any number by any Infinity gives 0
        if (number.isInfinity()) {
            return isc.BigDecimal.create("0");
        }
        // Dividing any Infinity by any number gives Infinity
        if (this.isInfinity()) {
            var ret = isc.BigDecimal.create("Infinity");
            if (this.sign !== number.sign) {
                ret.sign = -1;
            }
            return ret;
        }
        // Inflate num values that they would represent
        // numbers of same magnitude.
        var tNum = this.num;
        var oNum = number.num;
        tNum += "0".repeat(Math.max(this.exp - number.exp, 0));
        oNum += "0".repeat(Math.max(number.exp - this.exp, 0));
        if (!precision) {
            precision = 0;
        }
        // We divide with higher precision so we could round.
        var r = this._divide(tNum, oNum, precision + 1);
        if (r[1] !== "0") {
            // If remainder is not 0 we add 1 to least significant position:
            // if quotient was 123.45 then we get 123.451
            // We do not try to be correct here because it wont appear
            // final result. It is important rounding but not exact value.
            if (r[0].indexOf(".") === -1) {
                r[0] += ".";
            }
            r[0] += "1";
        }
        if (this.sign !== number.sign) {
            r[0] = "-" + r[0];
        }
        var ret = isc.BigDecimal.create(r[0]);
        return ret.round(precision, mode);
    },
    remainder : function(number) {
        if (!(isc.isA.BigDecimal(number))) {
            number = isc.BigDecimal.create(number);
        }
        // If any is NaN - return NaN
        if (this.isNaN() || number.isNaN()) {
            return isc.BigDecimal.create();
        }
        // Dividing any Infinity by any number gives NaN
        if (this.isInfinity()) {
            return isc.BigDecimal.create();
        }
        // Dividing any number by any Infinity gives exact same number
        if (number.isInfinity()) {
            return isc.BigDecimal.create(this);
        }
        // Inflate num values that they would represent
        // numbers of same magnitude.
        var tNum = this.num;
        var oNum = number.num;
        tNum += "0".repeat(Math.max(this.exp - number.exp, 0));
        oNum += "0".repeat(Math.max(number.exp - this.exp, 0));
        var r = this._divide(tNum, oNum, 0);
        if (this.sign === -1) {
            r[1] = "-" + r[1];
        }
        var ret = isc.BigDecimal.create(r[1]);
        ret.exp = Math.min(this.exp, number.exp);
        return ret;
    },
    // Parses provided parameter
    init : function () {
        this.Super("init", arguments);
        if (arguments && arguments[0]) {
            var value = arguments[0];
            if (isc.isA.Number(value)) {
                value = value.toExponential(20);
            }
            if (isc.isA.BigDecimal(value)) {
                this.nanValue = value.isNaN();
                this.infinityValue = value.isInfinity();
                this.sign = value.getSign();
                this.num = value.getNum();
                this.exp = value.getExp();
                this.normalize();
            } else if (isc.isA.String(value)) {
                var parts = this.r.exec(value);
                if (parts) {
                    if (parts[0] !== "NaN") {
                        this.nanValue = false;
                        if (parts[1] !== undefined) {
                            this.sign = (parts[1] === "-"?-1:1);
                        }
                        if (parts[7] !== undefined) {
                            this.infinityValue = true;
                        } else {
                            if (parts[6] !== undefined) {
                                this.exp = new Number(parts[6]);
                                if (parts[5] === '-') {
                                    this.exp *= -1;
                                }
                            }
                            if (parts[2] !== undefined) {
                                this.num = parts[2];
                                this.num = this.num.replace(/^0*/, "");
                            } else {
                                this.num = parts[3];
                                this.num = this.num.replace(/^0*/, "");
                                if (parts[4] !== undefined) {
                                    parts[4] = parts[4].replace(/0*$/, "");
                                    this.exp -= parts[4].length;
                                    this.num += parts[4];
                                    this.num = this.num.replace(/^0*/, "");
                                }
                            }
                            this.normalize();
                        }
                    }
                }
            } else if (value === Infinity) {
                this.nanValue = false;
                this.sign = 1;
                this.infinityValue = true;
            } else if (value === -Infinity) {
                this.nanValue = false;
                this.sign = -1;
                this.infinityValue = true;
            }
        }
    }
});
