/*

  SmartClient Ajax RIA system
  Version SNAPSHOT_v15.0d_2025-11-05/LGPL Deployment (2025-11-05)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//> @class SchemaValidator
// A validator for a field of component schema.
//
// @treeLocation Concepts/Reify/Component Schema
// @inheritsFrom Validator
// @group componentSchema
//<
isc.defineClass("SchemaValidator", "Validator");

isc.SchemaValidator.addClassProperties({
    create : isc.Validator.getSuperClass().create, // to skip logging the warning about creating a Validator instance

    __schemaValidatorsToInstall: [],
    _installSchemaValidators : function () {
        var schemaValidatorsToInstall = this.__schemaValidatorsToInstall;
        // Iterate through `__schemaValidatorsToInstall` in reverse order, because installation
        // of a schema validator may still need to be deferred if the component schema isn't
        // loaded (in which case, it will be added back to `__schemaValidatorsToInstall`).
        for (var rv = schemaValidatorsToInstall.length; rv > 0; --rv) {
            var v = rv - 1,
                schemaValidator = schemaValidatorsToInstall.removeAt(v);
            schemaValidator.__install();
        }
    },

    //> @classMethod SchemaValidator._getDefaultValueOrChildNode()
    // Returns the value for the specified schema field, either from
    // +link{PaletteNode.defaults, the PaletteNode defaults} or, if <code>node</code> is
    // provided, child node(s) whose '_parentProperty' equals the name of the schema field.
    // <p>
    // If provided schema field is a +link{Field} object with +link{Field.multiple, multiple}:<code>true</code>,
    // then the return value will either be <code>null</code> or an array.
    //
    // @param schemaField (Field | FieldName) The schema field, or the schema field name.
    // @param defaults (Object) +link{PaletteNode} defaults object.
    // @param [node] (PaletteNode) The palette node.
    // @return (Any) the value for the schema field
    //<
    _getDefaultValueOrChildNode : function (schemaField, defaults, node) {
        var name,
            multiple;
        if (isc.isA.String(schemaField)) {
            name = schemaField;
            multiple = false; // assume multiple:false
        } else {
            name = schemaField.name;
            multiple = schemaField.multiple == true;
        }

        if (name in defaults) {
            var value = defaults[name];
            if (multiple && value != null && !isc.isAn.Array(value)) {
                value = [value];
            }
            return value;
        }
        if (node) {
            var children = node.children;
            if (isc.isA.List(children)) {
                if (multiple) {
                    return children.findAll("_parentProperty", name);
                }

                var c = children.findIndex("_parentProperty", name);
                if (c >= 0) {
                    
                    return children[c];
                }
            }
        }
    },

    _getDataSourceProperty : function (schemaField, defaults, node) {
        var dataSource = this._getDefaultValueOrChildNode(schemaField, defaults, node);
        if (dataSource) {
            if (isc.isA.String(dataSource)) {
                dataSource = isc.DS.get(dataSource);
            } else if (isc.isAn.Object(dataSource) && !isc.isA.DataSource(dataSource)) {
                if (isc.isA.DataSource(dataSource.liveObject)) {
                    dataSource = dataSource.liveObject;
                } else {
                    var dsDefaults = dataSource._origDefaults || dataSource.defaults;
                    dataSource = !dsDefaults ? null : isc.DS.get(dsDefaults.ID);
                }
            }
        }
        return dataSource;
    }
});

isc.SchemaValidator.addProperties({
    _generated: true,
    clientOnly: true,
    defaultErrorMessage: "Must conform to schema",

    //typeName: null,
    //schemaFieldName: null,

    init : function () {
        this.Super("init", arguments);

        var typeName = this.typeName;
        if (!isc.isA.nonemptyString(typeName)) {
            this.logError("'typeName' is required to be a non-empty string.", "schemaValidation");
            return;
        }
        var schemaFieldName = this.schemaFieldName;
        if (!isc.isA.nonemptyString(schemaFieldName)) {
            this.logError("'schemaFieldName' is required to be a non-empty string.", "schemaValidation");
            return;
        }

        this._dsValidator = true;

        
        var type = this.type;
        if (isc.Validator.getValidatorDefinition(type)) {
            this.logWarn("Validator type \"" + type + "\" is already registered. Creating a new type...", "schemaValidation");
            type = null;
        }
        if (!isc.isA.nonemptyString(type)) {
            var counter = 1;
            do {
                type = typeName + "." + schemaFieldName + " schema validator #" + (counter++);
            } while (isc.Validator.getValidatorDefinition(type));
        }
        isc.Validator.addValidatorDefinition(type, this);
        
        this.type = type;

        this.__install();
    },

    __install : function () {
        var schemaDS = isc.DS && isc.DS.get(this.typeName);
        if (!schemaDS) {
            this.logDebug("Deferring installation of this '" + this.typeName + "." +
                    this.schemaFieldName + "' schema validator", "schemaValidation");
            isc.SchemaValidator.__schemaValidatorsToInstall.push(this);
            return;
        }

        // Get the component schema's own local field.
        // For inherited fields, the same `ComponentSchemaField` object is being shared among
        // potentially multiple schemas' merged fields, meaning that adding the validator to
        // the 'validators' array potentially adds the validator to other schemas as well, as
        // a side effect. This might cause problems, so require the schema field to be a local
        // field.
        var schemaField = schemaDS.fields[this.schemaFieldName];
        if (!schemaField) {
            this.logError("The schema for '" + this.typeName + "' does not have its own '" + this.schemaFieldName + "' field.", "schemaValidation");
            return;
        }

        var validators = schemaField.validators;
        if (!validators) validators = schemaField.validators = [];
        validators.push(this);
    },

    condition : function (schemaField, thisValidator, valueOrNode, defaults, additionalContext) {
        // It's easy to forget to use `thisValidator` when wanting to refer to the validator
        // instance; so, for convenience, a SchemaValidator can implement checkValue(),
        // which is invoked with the proper `this`.
        return thisValidator.checkValue(schemaField, valueOrNode, defaults, additionalContext);
    },

    checkValue : function (schemaField, valueOrNode, defaults, additionalContext) {
        return true;
    },

    _getDefaultValueOrChildNode : function (schemaField, defaults, additionalContext) {
        return isc.SchemaValidator._getDefaultValueOrChildNode(schemaField, defaults, additionalContext.node);
    },

    _getDataSourceProperty : function (schemaField, defaults, additionalContext) {
        return isc.SchemaValidator._getDataSourceProperty(schemaField, defaults, additionalContext.node);
    }
});
