/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.ai;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Settings for a data question.
 * @see com.smartgwt.client.docs.AnswerEngine Answer Engine
 */
@BeanFactory.FrameworkClass
public class DataQuestionSettings extends DataClass {

    public static DataQuestionSettings getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        return new DataQuestionSettings(jsObj);
    }
        


    public DataQuestionSettings(){
        
    }

    public DataQuestionSettings(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * A human-readable (and thus AI-readable) description of the purpose of the application.
     *
     * @param applicationPurpose New applicationPurpose value. Default value is null
     * @return {@link com.smartgwt.client.ai.DataQuestionSettings DataQuestionSettings} instance, for chaining setter calls
     */
    public DataQuestionSettings setApplicationPurpose(String applicationPurpose) {
        return (DataQuestionSettings)setAttribute("applicationPurpose", applicationPurpose);
    }

    /**
     * A human-readable (and thus AI-readable) description of the purpose of the application.
     *
     * @return Current applicationPurpose value. Default value is null
     */
    public String getApplicationPurpose()  {
        return getAttributeAsString("applicationPurpose");
    }
    

    /**
     * The IDs of available data sources.
     *
     * @param dataSourceNames New dataSourceNames value. Default value is null
     * @return {@link com.smartgwt.client.ai.DataQuestionSettings DataQuestionSettings} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.GlobalId GlobalId 
     */
    public DataQuestionSettings setDataSourceNames(String... dataSourceNames) {
        return (DataQuestionSettings)setAttribute("dataSourceNames", dataSourceNames);
    }

    /**
     * The IDs of available data sources.
     *
     * @return Current dataSourceNames value. Default value is null
     * @see com.smartgwt.client.docs.GlobalId GlobalId 
     */
    public String[] getDataSourceNames()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("dataSourceNames"));
    }
    

    /**
     * The maximum number of attempts to have AI generate valid code and/or data.
     *
     * @param maxFixAttempts New maxFixAttempts value. Default value is null
     * @return {@link com.smartgwt.client.ai.DataQuestionSettings DataQuestionSettings} instance, for chaining setter calls
     */
    public DataQuestionSettings setMaxFixAttempts(Integer maxFixAttempts) {
        return (DataQuestionSettings)setAttribute("maxFixAttempts", maxFixAttempts);
    }

    /**
     * The maximum number of attempts to have AI generate valid code and/or data.
     *
     * @return Current maxFixAttempts value. Default value is null
     */
    public Integer getMaxFixAttempts()  {
        return getAttributeAsInt("maxFixAttempts");
    }
    

    /**
     * The reference date &amp; time considered to be the present. <p> If not provided, then the current date &amp; time is
     * used.
     *
     * @param referenceTime New referenceTime value. Default value is null
     * @return {@link com.smartgwt.client.ai.DataQuestionSettings DataQuestionSettings} instance, for chaining setter calls
     */
    public DataQuestionSettings setReferenceTime(Date referenceTime) {
        return (DataQuestionSettings)setAttribute("referenceTime", referenceTime);
    }

    /**
     * The reference date &amp; time considered to be the present. <p> If not provided, then the current date &amp; time is
     * used.
     *
     * @return Current referenceTime value. Default value is null
     */
    public Date getReferenceTime()  {
        return getAttributeAsDate("referenceTime");
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
