/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.tools.stream;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
* <b><i><span style='color:red'>Note: this is currently an experimental feature and not
* covered by normal support guarantees. See {@link com.smartgwt.client.docs.Experimental
* Experimental Features} for more information.</span></i></b><br><br>
 * A <code>EventStream</code> captures event details as JavaScript objects as they are handled by the {@link
 * com.smartgwt.client.util.EventHandler}.  The event target {@link com.smartgwt.client.widgets.Canvas canvas} ID and 
 * class name as well the {@link com.smartgwt.client.docs.AutoTestLocator locator} are included, as available. 
 * Event-specific data (for example, the String for keyboard events) are also included where appropriate.  See {@link
 * com.smartgwt.client.tools.stream.EventStreamEvent} for more information. <P> You can configure the stream to capture
 * most DOM event types and other useful events, such as {@link com.smartgwt.client.docs.Relogin relogins} and JavaScript
 * errors that are triggered by events: <table border="1"><thead><tr><th>Event Category</th><th>Includes (source DOM <span
 * style="font-family:courier">eventType(s)</span> or description)</th> <th>Controlling Attribute</th><th>From DOM
 * Event?</tr><thead><tbody> <tr><td>click events</td><td><code>mouseDown</code>, <code>mouseUp</code>, <code>click</code>,
 * <code>dblClick</code></td><td>{@link com.smartgwt.client.tools.stream.EventStream#getCaptureClickEvents
 * captureClickEvents}</td><td>Y</td></tr> <tr><td>move events</td><td><code>mouseMove</code>, <code>mouseOut</code>
 * </td><td>{@link com.smartgwt.client.tools.stream.EventStream#getCaptureMoveEvents captureMoveEvents}</td><td>Y</td></tr>
 * <tr><td>key events</td><td><code>keyDown</code>, <code>keyPress</code>, <code>keyUp</code></td><td>{@link
 * com.smartgwt.client.tools.stream.EventStream#getCaptureKeyEvents captureKeyEvents}</td> <td>Y</td></tr> <tr><td>drag
 * events</td><td><code>dragStart</code>, <code>dragMove</code>, <code>dragStop</code></td><td>{@link
 * com.smartgwt.client.tools.stream.EventStream#getCaptureDragEvents captureDragEvents}</td> <td>Y</td></tr>
 * <tr><td>context menu events</td><td><code>contextMenu</code></td><td> {@link
 * com.smartgwt.client.tools.stream.EventStream#getCaptureMenuEvents captureMenuEvents}</td><td>Y</td></tr> <tr><td>mouse
 * wheel events</td><td><code>mouseWheel</code></td><td> {@link
 * com.smartgwt.client.tools.stream.EventStream#getCaptureWheelEvents captureWheelEvents}</td><td>Y</td></tr> <tr><td>page
 * events</td><td><code>load</code>, <code>unload</code>, <code>resize</code></td> <td>{@link
 * com.smartgwt.client.tools.stream.EventStream#getCapturePageEvents capturePageEvents}</td><td>Y</td></tr> <tr><td>login
 * events</td><td>Successful {@link com.smartgwt.client.docs.Relogin relogin} via the {@link
 * com.smartgwt.client.rpc.RPCManager}</td><td>{@link com.smartgwt.client.tools.stream.EventStream#getCaptureLoginEvents
 * captureLoginEvents}</td> <td>N</td></tr> <tr><td>{@link com.smartgwt.client.docs.Reify Reify} file events</td>
 * <td>Project and screen (auto)saves and loads</td><td>{@link
 * com.smartgwt.client.tools.stream.EventStream#getCaptureDSFileEvents captureDSFileEvents}</td><td>N</td></tr>
 * <tr><td>event errors</td><td>JavaScript exceptions</td><td> {@link
 * com.smartgwt.client.tools.stream.EventStream#getCaptureEventErrors captureEventErrors}</td><td>N</td></tr>
 * </tbody></table> (Pointer and touch equivalents to mouse events have not been listed above.  See the associated
 * attribute for a more inclusive list.) <P> Note that several types of DOM events can be collapsed so that one event is
 * reported instead of many if they occur over the same target.  You can enable collapsing for {@link
 * com.smartgwt.client.tools.stream.EventStream#getCollapseMoveEvents move and drag events}, {@link
 * com.smartgwt.client.tools.stream.EventStream#getCollapseKeyEvents key events}, {@link
 * com.smartgwt.client.tools.stream.EventStream#getCollapseWheelEvents wheel events}, and {@link
 * com.smartgwt.client.tools.stream.EventStream#getCollapsePageEvents page events}.  A {@link
 * com.smartgwt.client.tools.stream.EventStream#getMaxSize stream capture limit} is also supported via circular buffering,
 * so that only the most recent events are preserved.  All available events can be returned as an array of {@link
 * com.smartgwt.client.tools.stream.EventStreamEvent} via {@link com.smartgwt.client.tools.stream.EventStream#getEvents
 * getEvents()}. <P> A <code>EventStream</code> will start capturing events as soon as it's created by default, but if you
 * set {@link com.smartgwt.client.tools.stream.EventStream#getAutoStart autoStart}: false, you can start capturing manually
 * by calling {@link com.smartgwt.client.tools.stream.EventStream#start start()}.  Calling {@link
 * com.smartgwt.client.tools.stream.EventStream#end end()} will end capturing and return the {@link
 * com.smartgwt.client.tools.stream.EventStreamData}.
 * @see com.smartgwt.client.util.EventHandler
 * @see com.smartgwt.client.rpc.RPCManager
 * @see com.smartgwt.client.docs.Reify Reify Overview
 * @see com.smartgwt.client.docs.Experimental Experimental Features
 */
@BeanFactory.FrameworkClass
@BeanFactory.ScClassName("EventStream")
public class EventStream extends BaseClass {

    public static EventStream getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        BaseClass obj = BaseClass.getRef(jsObj);
        if(obj != null) {
            return (EventStream) obj;
        } else {
            return new EventStream(jsObj);
        }
    }

    public void setJavaScriptObject(JavaScriptObject jsObj) {
        internalSetID(jsObj);
        JSOHelper.setObjectAttribute(jsObj, SC.REF, this);
        JSOHelper.setObjectAttribute(jsObj, SC.MODULE, BeanFactory.getSGWTModule());
        if (!JSOHelper.isScClassInstance(jsObj)) {
            setConfig(jsObj);
            return;
        }
        JSOHelper.setObjectAttribute(getConfig(), SC.REF, this);
        JSOHelper.setObjectAttribute(getConfig(), SC.MODULE, BeanFactory.getSGWTModule());
        this.jsObj = jsObj;
        onBind();
    }
        


    public EventStream(){
        scClassName = "EventStream";
    }

    public EventStream(JavaScriptObject jsObj){
        scClassName = "EventStream";
        setJavaScriptObject(jsObj);
    }

    public native JavaScriptObject create()/*-{
        var config = this.@com.smartgwt.client.core.BaseClass::getConfig()();
        var scClassName = this.@com.smartgwt.client.core.BaseClass::scClassName;
        return $wnd.isc[scClassName].create(config);
    }-*/;

    private JavaScriptObject jsObj;
    
    @Override
    public boolean isCreated(){
        return this.jsObj != null;
    }

    @Override
    public JavaScriptObject getJsObj(){
        return this.jsObj;
    }

    @Override
    public JavaScriptObject getOrCreateJsObj() {
        if (!isCreated()) {
            this.jsObj = createJsObj();
            doInit();
        }
        return this.jsObj;
    }



    // ********************* Properties / Attributes ***********************

    /**
     * Whether the stream should automatically begin capturing events.  If false, the steam won't start capturing events until
     * {@link com.smartgwt.client.tools.stream.EventStream#start start()} is called.
     *
     * @param autoStart New autoStart value. Default value is true
     * @return {@link com.smartgwt.client.tools.stream.EventStream EventStream} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public EventStream setAutoStart(boolean autoStart)  throws IllegalStateException {
        return (EventStream)setAttribute("autoStart", autoStart, false);
    }

    /**
     * Whether the stream should automatically begin capturing events.  If false, the steam won't start capturing events until
     * {@link com.smartgwt.client.tools.stream.EventStream#start start()} is called.
     *
     * @return Current autoStart value. Default value is true
     */
    public boolean getAutoStart()  {
        Boolean result = getAttributeAsBoolean("autoStart");
        return result == null ? true : result;
    }
    

    /**
     * Whether mouse button-driven events (or their touch equivalents) should be captured by the stream. <P> Includes such
     * {@link com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType}s as <code>mouseDown</code>,
     * <code>mouseUp</code>, <code>click</code>, <code>doubleClk</code>, <code>pointerDown</code>, <code>pointerUp</code>,
     * <code>pointerCancel</code>, <code>touchStart</code>, <code>touchEnd</code>, and <code>touchCancel</code>.
     *
     * @param captureClickEvents New captureClickEvents value. Default value is true
     * @return {@link com.smartgwt.client.tools.stream.EventStream EventStream} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public EventStream setCaptureClickEvents(boolean captureClickEvents)  throws IllegalStateException {
        return (EventStream)setAttribute("captureClickEvents", captureClickEvents, false);
    }

    /**
     * Whether mouse button-driven events (or their touch equivalents) should be captured by the stream. <P> Includes such
     * {@link com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType}s as <code>mouseDown</code>,
     * <code>mouseUp</code>, <code>click</code>, <code>doubleClk</code>, <code>pointerDown</code>, <code>pointerUp</code>,
     * <code>pointerCancel</code>, <code>touchStart</code>, <code>touchEnd</code>, and <code>touchCancel</code>.
     *
     * @return Current captureClickEvents value. Default value is true
     */
    public boolean getCaptureClickEvents()  {
        Boolean result = getAttributeAsBoolean("captureClickEvents");
        return result == null ? true : result;
    }
    

    /**
     * Whether dragging-related events should be captured by the stream.  Multiple "drag move" type events that have the same
     * {@link com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType} and {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getTargetID targetID} will be collapsed into one if {@link
     * com.smartgwt.client.tools.stream.EventStream#getCollapseMoveEvents collapseMoveEvents} is true. <P> Includes such {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType}s as:<ul> <li><code>dragStart</code>,
     * <code>dragRepositionStart</code>, <code>dragResizeStart</code>, <code>dragSelectStart</code>, <li>
     * <code>dragMove</code>, <code>dragRepositionMove</code>, <code>dragResizeMove</code>, <code>dragSelectMove</code>,
     * <li><code>dragStop</code>, <code>dragRepositionStop</code>, <code>dragResizeStop</code>, <code>dragSelectStop</code>,
     * <li><code>drop</code>, <code>dropOver</code>, and <code>dragLeave</code>. </ul>
     *
     * @param captureDragEvents New captureDragEvents value. Default value is true
     * @return {@link com.smartgwt.client.tools.stream.EventStream EventStream} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public EventStream setCaptureDragEvents(boolean captureDragEvents)  throws IllegalStateException {
        return (EventStream)setAttribute("captureDragEvents", captureDragEvents, false);
    }

    /**
     * Whether dragging-related events should be captured by the stream.  Multiple "drag move" type events that have the same
     * {@link com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType} and {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getTargetID targetID} will be collapsed into one if {@link
     * com.smartgwt.client.tools.stream.EventStream#getCollapseMoveEvents collapseMoveEvents} is true. <P> Includes such {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType}s as:<ul> <li><code>dragStart</code>,
     * <code>dragRepositionStart</code>, <code>dragResizeStart</code>, <code>dragSelectStart</code>, <li>
     * <code>dragMove</code>, <code>dragRepositionMove</code>, <code>dragResizeMove</code>, <code>dragSelectMove</code>,
     * <li><code>dragStop</code>, <code>dragRepositionStop</code>, <code>dragResizeStop</code>, <code>dragSelectStop</code>,
     * <li><code>drop</code>, <code>dropOver</code>, and <code>dragLeave</code>. </ul>
     *
     * @return Current captureDragEvents value. Default value is true
     */
    public boolean getCaptureDragEvents()  {
        Boolean result = getAttributeAsBoolean("captureDragEvents");
        return result == null ? true : result;
    }
    

    /**
     * Whether to capture JavaScript errors.  If an already-captured event triggered the error, the details will attached to
     * that event.  Otherwise, a separate event will be created, with the {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType} of the last dispatched DOM event (i.e., there
     * is no special "error" {@link com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType}.) <P> {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent} records annotated or specially-reported with error details will
     * contain an {@link com.smartgwt.client.tools.stream.EventStreamEvent#getErrorTrace errorTrace} with the error stack
     * trace, and a {@link com.smartgwt.client.tools.stream.EventStreamEvent#getThreadCode threadCode} reporting the thread ID
     * from the {@link com.smartgwt.client.util.EventHandler} responsible for the error.
     *
     * @param captureEventErrors New captureEventErrors value. Default value is true
     * @return {@link com.smartgwt.client.tools.stream.EventStream EventStream} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public EventStream setCaptureEventErrors(boolean captureEventErrors)  throws IllegalStateException {
        return (EventStream)setAttribute("captureEventErrors", captureEventErrors, false);
    }

    /**
     * Whether to capture JavaScript errors.  If an already-captured event triggered the error, the details will attached to
     * that event.  Otherwise, a separate event will be created, with the {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType} of the last dispatched DOM event (i.e., there
     * is no special "error" {@link com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType}.) <P> {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent} records annotated or specially-reported with error details will
     * contain an {@link com.smartgwt.client.tools.stream.EventStreamEvent#getErrorTrace errorTrace} with the error stack
     * trace, and a {@link com.smartgwt.client.tools.stream.EventStreamEvent#getThreadCode threadCode} reporting the thread ID
     * from the {@link com.smartgwt.client.util.EventHandler} responsible for the error.
     *
     * @return Current captureEventErrors value. Default value is true
     */
    public boolean getCaptureEventErrors()  {
        Boolean result = getAttributeAsBoolean("captureEventErrors");
        return result == null ? true : result;
    }
    

    /**
     * Whether keyboard input events should be captured by the stream.  For non-modifier keys, which includes all the
     * self-inserting visible keyboard characters, we capture only the <code>keyPress</code>, as
     * <code>keyDown</code>/<code>keyUp</code> are generally not useful.  Conversely, for modifier keys (e.g. Shift), we
     * capture <i>only</i> the <code>keyDown</code> and <code>keyUp</code>. events, and not the <code>keyPress</code>. <P> If
     * {@link com.smartgwt.client.tools.stream.EventStream#getCollapseKeyEvents collapseKeyEvents} is true, multiple adjacent
     * keyPress events may be collapsed into a single event for greater readability and a more compact event trace. <P> Note
     * that if an error is thrown while handling an event, it will get reported regardless of this setting and the above
     * capturing rules, but see {@link com.smartgwt.client.tools.stream.EventStream#getMinErrorReportingInterval
     * minErrorReportingInterval}. So for example an error handling a <code>keyDown</code> would still generally end up in the
     * event trace, even for a self-inserting key such as "A".
     *
     * @param captureKeyEvents New captureKeyEvents value. Default value is false
     * @return {@link com.smartgwt.client.tools.stream.EventStream EventStream} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public EventStream setCaptureKeyEvents(boolean captureKeyEvents)  throws IllegalStateException {
        return (EventStream)setAttribute("captureKeyEvents", captureKeyEvents, false);
    }

    /**
     * Whether keyboard input events should be captured by the stream.  For non-modifier keys, which includes all the
     * self-inserting visible keyboard characters, we capture only the <code>keyPress</code>, as
     * <code>keyDown</code>/<code>keyUp</code> are generally not useful.  Conversely, for modifier keys (e.g. Shift), we
     * capture <i>only</i> the <code>keyDown</code> and <code>keyUp</code>. events, and not the <code>keyPress</code>. <P> If
     * {@link com.smartgwt.client.tools.stream.EventStream#getCollapseKeyEvents collapseKeyEvents} is true, multiple adjacent
     * keyPress events may be collapsed into a single event for greater readability and a more compact event trace. <P> Note
     * that if an error is thrown while handling an event, it will get reported regardless of this setting and the above
     * capturing rules, but see {@link com.smartgwt.client.tools.stream.EventStream#getMinErrorReportingInterval
     * minErrorReportingInterval}. So for example an error handling a <code>keyDown</code> would still generally end up in the
     * event trace, even for a self-inserting key such as "A".
     *
     * @return Current captureKeyEvents value. Default value is false
     */
    public boolean getCaptureKeyEvents()  {
        Boolean result = getAttributeAsBoolean("captureKeyEvents");
        return result == null ? false : result;
    }
    

    /**
     * Whether {@link com.smartgwt.client.docs.Relogin relogin}s are captured by the stream.  Login events are non-DOM events
     * originating from the {@link com.smartgwt.client.rpc.RPCManager} rather than the {@link
     * com.smartgwt.client.util.EventHandler}.  Login events have a {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getURL transaction URL}. <P> Includes the {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType} <code>relogin</code>.
     *
     * @param captureLoginEvents New captureLoginEvents value. Default value is true
     * @return {@link com.smartgwt.client.tools.stream.EventStream EventStream} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public EventStream setCaptureLoginEvents(boolean captureLoginEvents)  throws IllegalStateException {
        return (EventStream)setAttribute("captureLoginEvents", captureLoginEvents, false);
    }

    /**
     * Whether {@link com.smartgwt.client.docs.Relogin relogin}s are captured by the stream.  Login events are non-DOM events
     * originating from the {@link com.smartgwt.client.rpc.RPCManager} rather than the {@link
     * com.smartgwt.client.util.EventHandler}.  Login events have a {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getURL transaction URL}. <P> Includes the {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType} <code>relogin</code>.
     *
     * @return Current captureLoginEvents value. Default value is true
     */
    public boolean getCaptureLoginEvents()  {
        Boolean result = getAttributeAsBoolean("captureLoginEvents");
        return result == null ? true : result;
    }
    

    /**
     * Whether opening a context menu should be captured by the stream.  This may occur due to mouse or keyboard interaction.
     * <P> Includes the {@link com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType}
     * <code>contextMenu</code>.
     *
     * @param captureMenuEvents New captureMenuEvents value. Default value is true
     * @return {@link com.smartgwt.client.tools.stream.EventStream EventStream} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public EventStream setCaptureMenuEvents(boolean captureMenuEvents)  throws IllegalStateException {
        return (EventStream)setAttribute("captureMenuEvents", captureMenuEvents, false);
    }

    /**
     * Whether opening a context menu should be captured by the stream.  This may occur due to mouse or keyboard interaction.
     * <P> Includes the {@link com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType}
     * <code>contextMenu</code>.
     *
     * @return Current captureMenuEvents value. Default value is true
     */
    public boolean getCaptureMenuEvents()  {
        Boolean result = getAttributeAsBoolean("captureMenuEvents");
        return result == null ? true : result;
    }
    

    /**
     * Whether mouse or touch motion-related events (other than dragging) should be captured by the stream.  Multple adjacent
     * "move events" having the same {@link com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType} and
     * {@link com.smartgwt.client.tools.stream.EventStreamEvent#getTargetID targetID} will be collapsed into one if {@link
     * com.smartgwt.client.tools.stream.EventStream#getCollapseMoveEvents collapseMoveEvents} is true. <P> Includes such {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType}s as <code>mouseMove</code>,
     * <code>pointerMove</code>, <code>touchMove</code>, and <code>mouseOut</code>.
     *
     * @param captureMoveEvents New captureMoveEvents value. Default value is false
     * @return {@link com.smartgwt.client.tools.stream.EventStream EventStream} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public EventStream setCaptureMoveEvents(boolean captureMoveEvents)  throws IllegalStateException {
        return (EventStream)setAttribute("captureMoveEvents", captureMoveEvents, false);
    }

    /**
     * Whether mouse or touch motion-related events (other than dragging) should be captured by the stream.  Multple adjacent
     * "move events" having the same {@link com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType} and
     * {@link com.smartgwt.client.tools.stream.EventStreamEvent#getTargetID targetID} will be collapsed into one if {@link
     * com.smartgwt.client.tools.stream.EventStream#getCollapseMoveEvents collapseMoveEvents} is true. <P> Includes such {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType}s as <code>mouseMove</code>,
     * <code>pointerMove</code>, <code>touchMove</code>, and <code>mouseOut</code>.
     *
     * @return Current captureMoveEvents value. Default value is false
     */
    public boolean getCaptureMoveEvents()  {
        Boolean result = getAttributeAsBoolean("captureMoveEvents");
        return result == null ? false : result;
    }
    

    /**
     * Whether page-level events such as a page load or resize should be captured by the stream. Multple adjacent page events
     * having the same eventType will be collapsed into one if {@link
     * com.smartgwt.client.tools.stream.EventStream#getCollapsePageEvents collapsePageEvents} is true. <P> Includes such {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType}s as <code>load</code>, <code>unload</code>,
     * and <code>resize</code>.
     *
     * @param capturePageEvents New capturePageEvents value. Default value is false
     * @return {@link com.smartgwt.client.tools.stream.EventStream EventStream} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public EventStream setCapturePageEvents(boolean capturePageEvents)  throws IllegalStateException {
        return (EventStream)setAttribute("capturePageEvents", capturePageEvents, false);
    }

    /**
     * Whether page-level events such as a page load or resize should be captured by the stream. Multple adjacent page events
     * having the same eventType will be collapsed into one if {@link
     * com.smartgwt.client.tools.stream.EventStream#getCollapsePageEvents collapsePageEvents} is true. <P> Includes such {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType}s as <code>load</code>, <code>unload</code>,
     * and <code>resize</code>.
     *
     * @return Current capturePageEvents value. Default value is false
     */
    public boolean getCapturePageEvents()  {
        Boolean result = getAttributeAsBoolean("capturePageEvents");
        return result == null ? false : result;
    }
    

    /**
     * Whether mouse wheel events should be captured by the stream.  If the preceding "wheel event" has the same {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getTargetID targetID} and scroll directions, it will be replaced by
     * the current one, subject to {@link com.smartgwt.client.tools.stream.EventStream#getCollapseWheelEvents
     * collapseWheelEvents}, with the {@link com.smartgwt.client.tools.stream.EventStreamEvent#getDeltaX delta offsets} in the
     * "collapsed" event getting adjusted to be the sum of those from all the original events. <P> Includes the {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType} <code>mouseWheel</code>.
     *
     * @param captureWheelEvents New captureWheelEvents value. Default value is true
     * @return {@link com.smartgwt.client.tools.stream.EventStream EventStream} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public EventStream setCaptureWheelEvents(boolean captureWheelEvents)  throws IllegalStateException {
        return (EventStream)setAttribute("captureWheelEvents", captureWheelEvents, false);
    }

    /**
     * Whether mouse wheel events should be captured by the stream.  If the preceding "wheel event" has the same {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getTargetID targetID} and scroll directions, it will be replaced by
     * the current one, subject to {@link com.smartgwt.client.tools.stream.EventStream#getCollapseWheelEvents
     * collapseWheelEvents}, with the {@link com.smartgwt.client.tools.stream.EventStreamEvent#getDeltaX delta offsets} in the
     * "collapsed" event getting adjusted to be the sum of those from all the original events. <P> Includes the {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType} <code>mouseWheel</code>.
     *
     * @return Current captureWheelEvents value. Default value is true
     */
    public boolean getCaptureWheelEvents()  {
        Boolean result = getAttributeAsBoolean("captureWheelEvents");
        return result == null ? true : result;
    }
    

    /**
     * Whether to collapse adjacent <code>keyPress</code> events into one event where possible. Self-inserting keys will
     * generally be collapsed by concatenating them into a single string, {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getKeyNames EventStreamEvent.keyNames}.  On the other hand, special
     * keys such as "Esc" and "Backspace" will only be collapsed for repeating sequences of the same key, which will be
     * reported as {@link com.smartgwt.client.tools.stream.EventStreamEvent#getCount EventStreamEvent.count}. <P> Note that if
     * an error is thrown while handling an event, it won't be collapsed, but see {@link
     * com.smartgwt.client.tools.stream.EventStream#getMinErrorReportingInterval minErrorReportingInterval}.
     *
     * @param collapseKeyEvents New collapseKeyEvents value. Default value is true
     * @return {@link com.smartgwt.client.tools.stream.EventStream EventStream} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.tools.stream.EventStream#setCaptureKeyEvents
     */
    public EventStream setCollapseKeyEvents(boolean collapseKeyEvents)  throws IllegalStateException {
        return (EventStream)setAttribute("collapseKeyEvents", collapseKeyEvents, false);
    }

    /**
     * Whether to collapse adjacent <code>keyPress</code> events into one event where possible. Self-inserting keys will
     * generally be collapsed by concatenating them into a single string, {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getKeyNames EventStreamEvent.keyNames}.  On the other hand, special
     * keys such as "Esc" and "Backspace" will only be collapsed for repeating sequences of the same key, which will be
     * reported as {@link com.smartgwt.client.tools.stream.EventStreamEvent#getCount EventStreamEvent.count}. <P> Note that if
     * an error is thrown while handling an event, it won't be collapsed, but see {@link
     * com.smartgwt.client.tools.stream.EventStream#getMinErrorReportingInterval minErrorReportingInterval}.
     *
     * @return Current collapseKeyEvents value. Default value is true
     * @see com.smartgwt.client.tools.stream.EventStream#getCaptureKeyEvents
     */
    public boolean getCollapseKeyEvents()  {
        Boolean result = getAttributeAsBoolean("collapseKeyEvents");
        return result == null ? true : result;
    }
    

    /**
     * Whether mouse or touch-motion related events (including dragging) with the same {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType} and {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getTargetID targetID} should be collapsed into a single event. <P>
     * Note that if an error is thrown while handling an event, it won't be collapsed, but see {@link
     * com.smartgwt.client.tools.stream.EventStream#getMinErrorReportingInterval minErrorReportingInterval}.
     *
     * @param collapseMoveEvents New collapseMoveEvents value. Default value is true
     * @return {@link com.smartgwt.client.tools.stream.EventStream EventStream} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.tools.stream.EventStream#setCaptureMoveEvents
     */
    public EventStream setCollapseMoveEvents(boolean collapseMoveEvents)  throws IllegalStateException {
        return (EventStream)setAttribute("collapseMoveEvents", collapseMoveEvents, false);
    }

    /**
     * Whether mouse or touch-motion related events (including dragging) with the same {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType} and {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getTargetID targetID} should be collapsed into a single event. <P>
     * Note that if an error is thrown while handling an event, it won't be collapsed, but see {@link
     * com.smartgwt.client.tools.stream.EventStream#getMinErrorReportingInterval minErrorReportingInterval}.
     *
     * @return Current collapseMoveEvents value. Default value is true
     * @see com.smartgwt.client.tools.stream.EventStream#getCaptureMoveEvents
     */
    public boolean getCollapseMoveEvents()  {
        Boolean result = getAttributeAsBoolean("collapseMoveEvents");
        return result == null ? true : result;
    }
    

    /**
     * Whether adjacgent page events with the same {@link com.smartgwt.client.tools.stream.EventStreamEvent#getEventType
     * eventType} should be collapsed into a single event. <P> Note that if an error is thrown while handling an event, it
     * won't be collapsed, but see {@link com.smartgwt.client.tools.stream.EventStream#getMinErrorReportingInterval
     * minErrorReportingInterval}.
     *
     * @param collapsePageEvents New collapsePageEvents value. Default value is true
     * @return {@link com.smartgwt.client.tools.stream.EventStream EventStream} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.tools.stream.EventStream#setCapturePageEvents
     */
    public EventStream setCollapsePageEvents(boolean collapsePageEvents)  throws IllegalStateException {
        return (EventStream)setAttribute("collapsePageEvents", collapsePageEvents, false);
    }

    /**
     * Whether adjacgent page events with the same {@link com.smartgwt.client.tools.stream.EventStreamEvent#getEventType
     * eventType} should be collapsed into a single event. <P> Note that if an error is thrown while handling an event, it
     * won't be collapsed, but see {@link com.smartgwt.client.tools.stream.EventStream#getMinErrorReportingInterval
     * minErrorReportingInterval}.
     *
     * @return Current collapsePageEvents value. Default value is true
     * @see com.smartgwt.client.tools.stream.EventStream#getCapturePageEvents
     */
    public boolean getCollapsePageEvents()  {
        Boolean result = getAttributeAsBoolean("collapsePageEvents");
        return result == null ? true : result;
    }
    

    /**
     * Whether mouse wheel events with the same {@link com.smartgwt.client.tools.stream.EventStreamEvent#getTargetID targetID}
     * and scroll directions should be collapsed into a single event, containing a sum of the {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getDeltaX delta offsets} from the original events. <P> Note that if an
     * error is thrown while handling an event, it won't be collapsed, but see {@link
     * com.smartgwt.client.tools.stream.EventStream#getMinErrorReportingInterval minErrorReportingInterval}.
     *
     * @param collapseWheelEvents New collapseWheelEvents value. Default value is true
     * @return {@link com.smartgwt.client.tools.stream.EventStream EventStream} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.tools.stream.EventStream#setCaptureWheelEvents
     */
    public EventStream setCollapseWheelEvents(boolean collapseWheelEvents)  throws IllegalStateException {
        return (EventStream)setAttribute("collapseWheelEvents", collapseWheelEvents, false);
    }

    /**
     * Whether mouse wheel events with the same {@link com.smartgwt.client.tools.stream.EventStreamEvent#getTargetID targetID}
     * and scroll directions should be collapsed into a single event, containing a sum of the {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getDeltaX delta offsets} from the original events. <P> Note that if an
     * error is thrown while handling an event, it won't be collapsed, but see {@link
     * com.smartgwt.client.tools.stream.EventStream#getMinErrorReportingInterval minErrorReportingInterval}.
     *
     * @return Current collapseWheelEvents value. Default value is true
     * @see com.smartgwt.client.tools.stream.EventStream#getCaptureWheelEvents
     */
    public boolean getCollapseWheelEvents()  {
        Boolean result = getAttributeAsBoolean("collapseWheelEvents");
        return result == null ? true : result;
    }
    

    /**
     * Maximum number of events that will be stored by this <code>EventStream</code>.  After <code>maxSize</code> events are
     * captured, the oldest events will be overwritten. Set this property to <code>null</code> to capture events without ever
     * overwriting.
     *
     * @param maxSize New maxSize value. Default value is 10000
     * @return {@link com.smartgwt.client.tools.stream.EventStream EventStream} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public EventStream setMaxSize(Integer maxSize)  throws IllegalStateException {
        return (EventStream)setAttribute("maxSize", maxSize, false);
    }

    /**
     * Maximum number of events that will be stored by this <code>EventStream</code>.  After <code>maxSize</code> events are
     * captured, the oldest events will be overwritten. Set this property to <code>null</code> to capture events without ever
     * overwriting.
     *
     * @return Current maxSize value. Default value is 10000
     */
    public Integer getMaxSize()  {
        return getAttributeAsInt("maxSize");
    }
    

    /**
     * Number of seconds that must elapse before another event error will be reported.  This allows you to avoid the stream
     * getting flooded with likely duplicate errors that may be rapidly and repeatedly reported, due to mouseMove or repeatedly
     * executing code. Setting the property to zero disables it (avoiding any timestamp checking). <P> Note that when an error
     * is reported by the Framework, this property will be ignored if the last captured event triggered the error and has no
     * {@link com.smartgwt.client.tools.stream.EventStreamEvent#getErrorTrace errorTrace}, so that it effectively only prevents
     * adding new events to the stream specifically to report errors.  However, an {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getErrorTrace errorTrace} attached to an event within the reporting
     * interval of the previous error won't prevent that event from being {@link
     * com.smartgwt.client.tools.stream.EventStream#getCollapseMoveEvents collapsed}.
     *
     * @param minErrorReportingInterval New minErrorReportingInterval value. Default value is 10
     * @return {@link com.smartgwt.client.tools.stream.EventStream EventStream} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.tools.stream.EventStream#setCollapseMoveEvents
     * @see com.smartgwt.client.tools.stream.EventStream#setCollapseKeyEvents
     * @see com.smartgwt.client.tools.stream.EventStream#setCollapseWheelEvents
     * @see com.smartgwt.client.tools.stream.EventStream#setCollapsePageEvents
     */
    public EventStream setMinErrorReportingInterval(int minErrorReportingInterval)  throws IllegalStateException {
        return (EventStream)setAttribute("minErrorReportingInterval", minErrorReportingInterval, false);
    }

    /**
     * Number of seconds that must elapse before another event error will be reported.  This allows you to avoid the stream
     * getting flooded with likely duplicate errors that may be rapidly and repeatedly reported, due to mouseMove or repeatedly
     * executing code. Setting the property to zero disables it (avoiding any timestamp checking). <P> Note that when an error
     * is reported by the Framework, this property will be ignored if the last captured event triggered the error and has no
     * {@link com.smartgwt.client.tools.stream.EventStreamEvent#getErrorTrace errorTrace}, so that it effectively only prevents
     * adding new events to the stream specifically to report errors.  However, an {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getErrorTrace errorTrace} attached to an event within the reporting
     * interval of the previous error won't prevent that event from being {@link
     * com.smartgwt.client.tools.stream.EventStream#getCollapseMoveEvents collapsed}.
     *
     * @return Current minErrorReportingInterval value. Default value is 10
     * @see com.smartgwt.client.tools.stream.EventStream#getCollapseMoveEvents
     * @see com.smartgwt.client.tools.stream.EventStream#getCollapseKeyEvents
     * @see com.smartgwt.client.tools.stream.EventStream#getCollapseWheelEvents
     * @see com.smartgwt.client.tools.stream.EventStream#getCollapsePageEvents
     */
    public int getMinErrorReportingInterval()  {
        return getAttributeAsInt("minErrorReportingInterval");
    }
    

    // ********************* Methods ***********************
	/**
     * Ends event capturing and returns the {@link com.smartgwt.client.tools.stream.EventStreamData}.  Once ended, capturing
     * cannot be restarted without losing all stored events.
     *
     * @return 
     * @see com.smartgwt.client.tools.stream.EventStream#getAutoStart
     * @see com.smartgwt.client.tools.stream.EventStream#start
     */
    public native EventStreamData end() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "end", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.end();
        if(ret == null) return null;
        return @com.smartgwt.client.tools.stream.EventStreamData::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Creates and returns Selenese that represents the events captured by the stream as an array of {@link
     * com.smartgwt.client.tools.stream.SeleniumCommand Selenium commands}.  Compare with {@link
     * com.smartgwt.client.tools.stream.EventStream#getAsSeleneseHTML getAsSeleneseHTML()}, where you'll also find more common
     * details. <P> Just as when retrieving the Selenese as HTML, if a {@link
     * com.smartgwt.client.tools.stream.EventStream#transformSelenese transformSelenese()} function has been defined, it's
     * called before returning the Selenese.
     *
     * @return 
     * @see com.smartgwt.client.docs.AutomatedTesting Automated Testing
     */
    public native SeleniumCommand[] getAsSeleneseCommands() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getAsSeleneseCommands", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getAsSeleneseCommands();
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfSeleniumCommand(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Creates and returns Selenese that represents the events captured by the stream as an array of {@link
     * com.smartgwt.client.tools.stream.SeleniumCommand Selenium commands}.  Compare with {@link
     * com.smartgwt.client.tools.stream.EventStream#getAsSeleneseHTML getAsSeleneseHTML()}, where you'll also find more common
     * details. <P> Just as when retrieving the Selenese as HTML, if a {@link
     * com.smartgwt.client.tools.stream.EventStream#transformSelenese transformSelenese()} function has been defined, it's
     * called before returning the Selenese.
     * @param settings 
     *
     * @return 
     * @see com.smartgwt.client.docs.AutomatedTesting Automated Testing
     */
    public native SeleniumCommand[] getAsSeleneseCommands(SeleneseSettings settings) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getAsSeleneseCommands", "SeleneseSettings");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getAsSeleneseCommands(settings == null ? null : settings.@com.smartgwt.client.core.DataClass::getJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfSeleniumCommand(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;
	
	/**
     * Creates and returns Selenese that represents the events captured by the stream.  This
     *  Selenese contains Smart GWT-specific locators (scLocators), and Smart GWT command
     *  extensions (e.g. "waitForElementClickable") that are discussed in our
     *  {@link com.smartgwt.client.docs.UsingSelenium Selenium} overview.
     *  <P>
     *  This method returns the Selenese as a string of HTML table rows, just as in an rctest.html
     *  file that you can directly execute with Selenium.  Does not include the leading or trailing
     *  HTML, such as the &lt;BODY&gt; and &lt;TBODY&gt; tags; you'll need to wrap what's returned
     *  with the appropriate outer HTML tags to properly embed the table.  If you'd rather have the
     *  Selenese returned as an array of {@link com.smartgwt.client.tools.stream.SeleniumCommand Selenium commands}, call
     *  {@link com.smartgwt.client.tools.stream.EventStream#getAsSeleneseCommands getAsSeleneseCommands()} instead.
     *  <P>
     * To customize the returned Selenese, see {@link com.smartgwt.client.tools.stream.EventStream#transformSelenese
     * transformSelenese()}.  Note that if the
     * stream has {@link com.smartgwt.client.tools.stream.EventStream#getMaxSize rolled over}, the Selenese for the lost events
     * will not be
     *  returned.
     *  <P>
     *  
     *  For example, in your <code>Entrypoint</code> class definition, you can declare a stream
     *  member like:
     *  <pre>
     *      EventStream eventStream = new EventStream();    
     *  </pre>
     *  <i>... time passes where end user is interacting with your app ....</i>
     *  Then to retrieve the Selenese you can call something like:
     *  
     *  <pre>
     *      String rcTestHTML = "&lt;html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en"&gt;" +
     *                          "&lt;body&gt;&lt;table&gt;&lt;tbody&gt;" +
     *                          MyApp.eventStream.getAsSeleneseHTML(true) +
     *                          "&lt;/tbody&gt;&lt;/table&gt;&lt;/body&gt;&lt;/html&gt;";    
     *  </pre>
     * 
     *
     * @return 
     * See {@link com.smartgwt.client.docs.HTML HTML}
     * @see com.smartgwt.client.docs.AutomatedTesting Automated Testing
     */
    public native String getAsSeleneseHTML() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getAsSeleneseHTML", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getAsSeleneseHTML();
        return ret;
    }-*/;

	/**
     * Creates and returns Selenese that represents the events captured by the stream.  This
     *  Selenese contains Smart GWT-specific locators (scLocators), and Smart GWT command
     *  extensions (e.g. "waitForElementClickable") that are discussed in our
     *  {@link com.smartgwt.client.docs.UsingSelenium Selenium} overview.
     *  <P>
     *  This method returns the Selenese as a string of HTML table rows, just as in an rctest.html
     *  file that you can directly execute with Selenium.  Does not include the leading or trailing
     *  HTML, such as the &lt;BODY&gt; and &lt;TBODY&gt; tags; you'll need to wrap what's returned
     *  with the appropriate outer HTML tags to properly embed the table.  If you'd rather have the
     *  Selenese returned as an array of {@link com.smartgwt.client.tools.stream.SeleniumCommand Selenium commands}, call
     *  {@link com.smartgwt.client.tools.stream.EventStream#getAsSeleneseCommands getAsSeleneseCommands()} instead.
     *  <P>
     * To customize the returned Selenese, see {@link com.smartgwt.client.tools.stream.EventStream#transformSelenese
     * transformSelenese()}.  Note that if the
     * stream has {@link com.smartgwt.client.tools.stream.EventStream#getMaxSize rolled over}, the Selenese for the lost events
     * will not be
     *  returned.
     *  <P>
     *  
     *  For example, in your <code>Entrypoint</code> class definition, you can declare a stream
     *  member like:
     *  <pre>
     *      EventStream eventStream = new EventStream();    
     *  </pre>
     *  <i>... time passes where end user is interacting with your app ....</i>
     *  Then to retrieve the Selenese you can call something like:
     *  
     *  <pre>
     *      String rcTestHTML = "&lt;html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en"&gt;" +
     *                          "&lt;body&gt;&lt;table&gt;&lt;tbody&gt;" +
     *                          MyApp.eventStream.getAsSeleneseHTML(true) +
     *                          "&lt;/tbody&gt;&lt;/table&gt;&lt;/body&gt;&lt;/html&gt;";    
     *  </pre>
     * 
     * @param settings 
     *
     * @return 
     * See {@link com.smartgwt.client.docs.HTML HTML}
     * @see com.smartgwt.client.docs.AutomatedTesting Automated Testing
     */
    public native String getAsSeleneseHTML(SeleneseSettings settings) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getAsSeleneseHTML", "SeleneseSettings");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getAsSeleneseHTML(settings == null ? null : settings.@com.smartgwt.client.core.DataClass::getJsObj()());
        return ret;
    }-*/;
	
	/**
     * Builds a full Cypress test file by framing event commands in describe/it blocks. It adds a beforeEach with cy.visit,
     * viewport setup, optional waits, and then the test steps.
     * @param eventStream Stream of events to convert.
     *
     * @return Complete Cypress spec code ready to paste into a `.spec.js`.
     * @see com.smartgwt.client.tools.stream.EventStream#getCypressEventScript
     * @see com.smartgwt.client.tools.stream.EventStream#getCypressScriptFromData
     * @see com.smartgwt.client.docs.SmartClientCypress Integrating SmartClient with Cypress
     */
    public native String getCypressScript(EventStream eventStream) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getCypressScript", "EventStream");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getCypressScript(eventStream == null ? null : eventStream.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()());
        return ret;
    }-*/;

    /**
     * @see EventStream#getCypressScript
     */
    public String getCypressScript(EventStream eventStream, String targetUrl){
        return getCypressScript(eventStream, targetUrl, null, null);
    }

    /**
     * @see EventStream#getCypressScript
     */
    public String getCypressScript(EventStream eventStream, String targetUrl, String testName){
        return getCypressScript(eventStream, targetUrl, testName, null);
    }

	/**
     * Builds a full Cypress test file by framing event commands in describe/it blocks. It adds a beforeEach with cy.visit,
     * viewport setup, optional waits, and then the test steps.
     * @param eventStream Stream of events to convert.
     * @param targetUrl URL to visit in beforeEach; defaults to current page.
     * @param testName Name of the it() block; defaults to "Test".
     * @param testDescription Description of the describe() block; defaults to "Testing".
     *
     * @return Complete Cypress spec code ready to paste into a `.spec.js`.
     * @see com.smartgwt.client.tools.stream.EventStream#getCypressEventScript
     * @see com.smartgwt.client.tools.stream.EventStream#getCypressScriptFromData
     * @see com.smartgwt.client.docs.SmartClientCypress Integrating SmartClient with Cypress
     */
    public native String getCypressScript(EventStream eventStream, String targetUrl, String testName, String testDescription) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getCypressScript", "EventStream,String,String,String");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getCypressScript(eventStream == null ? null : eventStream.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()(), targetUrl, testName, testDescription);
        return ret;
    }-*/;
	
	/**
     * Returns all available captured events, oldest first.  At most {@link
     * com.smartgwt.client.tools.stream.EventStream#getMaxSize maxSize} events will be returned.
     *
     * @return 
     * @see com.smartgwt.client.tools.stream.EventStream#end
     */
    public native EventStreamEvent[] getEvents() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getEvents", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getEvents();
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfEventStreamEvent(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Returns when this stream started capturing events (i.e. when {@link com.smartgwt.client.tools.stream.EventStream#start
     * start()} got called).
     *
     * @return 
     * @see com.smartgwt.client.tools.stream.EventStream#start
     * @see com.smartgwt.client.tools.stream.EventStream#getAutoStart
     */
    public native Date getStartTime() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getStartTime", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getStartTime();
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toDate(D)(ret.getTime());
    }-*/;

	/**
     * Installs a callback that will be called when the EventStream reports an {@link
     * com.smartgwt.client.tools.stream.EventStream#getCaptureEventErrors event error}, subject to the {@link
     * com.smartgwt.client.tools.stream.EventStream#getMinErrorReportingInterval error reporting interval}.  The callback will
     * be passed all retained {@link com.smartgwt.client.tools.stream.EventStreamEvent}s captured by the stream since the last
     * time it was called.
     * @param callback Callback to fire when the stream encounters an event                                      error, subject to the
     * reporting interval
     * @see com.smartgwt.client.tools.stream.EventStream#getMaxSize
     * @see com.smartgwt.client.tools.stream.EventStream#getMinErrorReportingInterval
     */
    public native void setEventErrorListener(EventErrorCallback callback) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "setEventErrorListener", "EventErrorCallback");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.setEventErrorListener(
			$entry( function(data, nEvents) { 
				if(callback!=null) callback.@com.smartgwt.client.callbacks.EventErrorCallback::execute(Lcom/smartgwt/client/tools/stream/EventStreamData;I)(
					data != null ? @com.smartgwt.client.tools.stream.EventStreamData::new(Lcom/google/gwt/core/client/JavaScriptObject;)(data) : null, 
					nEvents
				);
			}));
    }-*/;

	/**
     * Starts capturing all enabled events.  See the overview of {@link com.smartgwt.client.tools.stream.EventStream} for a
     * list of filter properties you can configure to control which events are captured. <P> If called after {@link
     * com.smartgwt.client.tools.stream.EventStream#end end()}, capturing will restart, but all previously stored events will
     * be lost.
     * @see com.smartgwt.client.tools.stream.EventStream#getAutoStart
     * @see com.smartgwt.client.tools.stream.EventStream#end
     */
    public native void start() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "start", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.start();
    }-*/;


    // ********************* Static Methods ***********************

	/**
     * Generates a Cypress command snippet for a single event using our custom SC commands.
     * @param event The event to translate into a Cypress command.
     *
     * @return A snippet like 'cy.getSC(locator).click()' or '.dblclick()', assuming our custom commands are loaded.
     * @see com.smartgwt.client.tools.stream.EventStream#getCypressScriptFromData
     */
    public static native String getCypressEventScript(EventStreamEvent event) /*-{
        var ret = $wnd.isc.EventStream.getCypressEventScript(event.@com.smartgwt.client.core.DataClass::getJsObj()());
        return ret;
    }-*/;


	/**
     * Translates an array of EventStreamEvent objects into an array of Cypress command strings.
     * @param events Array of events to convert.
     *
     * @return List of Cypress command snippets.
     * @see com.smartgwt.client.tools.stream.EventStream#getCypressEventScript
     * @see com.smartgwt.client.tools.stream.EventStream#getCypressScript
     */
    public static native String[] getCypressScriptFromData(EventStreamEvent... events) /*-{
        var ret = $wnd.isc.EventStream.getCypressScriptFromData(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(events));
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfString(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;


	/**
     * Replays a sequence of recorded events in the live UI and logs each step.
     * @param events Events to replay one by one.
     * @param speed Milliseconds delay between each event.
     * @param textAreaLog Component where outcomes will be logged.
     * @param callback Invoked once all events have been processed.
     * @see com.smartgwt.client.tools.stream.EventStream#getCypressScript
     */
    public static native void runEvents(EventStreamEvent[] events, int speed, TextAreaItem textAreaLog, Function callback) /*-{
        $wnd.isc.EventStream.runEvents(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(events), speed, textAreaLog.@com.smartgwt.client.core.DataClass::getJsObj()(), 
			$entry( function() { 
				if(callback!=null) callback.@com.smartgwt.client.core.Function::execute()(
				);
			}));
    }-*/;


    // ***********************************************************

}
