/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import com.isomorphic.webdriver.SeleneseTestCase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.tags.LinkTag;
import org.htmlparser.tags.TableRow;
import org.htmlparser.tags.TitleTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SeleneseSuite {
    private static final String FILENAME_PATTERN = "(.*\\Q" + File.separator + "\\E)?[^.\\Q" + File.separator + "\\E]+\\.html";
    public static final String XML_INDENT_PROP = "{http://xml.apache.org/xslt}indent-amount";
    public static final int XML_INDENT_VALUE = 4;
    private String title;
    private List<SeleneseTestCase> testCases = new ArrayList<SeleneseTestCase>();
    private String reportFilename;

    public static boolean isASuiteFile(String filename) {
        return filename.matches(FILENAME_PATTERN);
    }

    public SeleneseSuite(String suiteFilename, String reportFilename) throws FileNotFoundException {
        this.reportFilename = reportFilename;
        try {
            Path suitePath = Paths.get(suiteFilename, new String[0]);
            FileInputStream suiteStream = new FileInputStream(suiteFilename);
            Page page = new Page((InputStream)suiteStream, "UTF-8");
            Parser parser = new Parser(new Lexer(page));
            NodeList nodes = parser.parse((NodeFilter)new SeleneseNodeFilter());
            SimpleNodeIterator nodeIter = nodes.elements();
            while (nodeIter.hasMoreNodes()) {
                Node linkTag;
                Node node = nodeIter.nextNode();
                if (node instanceof TitleTag) {
                    this.title = ((TitleTag)node).getTitle();
                    continue;
                }
                Node column = node.getFirstChild();
                if (column == null || !((linkTag = column.getFirstChild()) instanceof LinkTag)) continue;
                String localUrl = ((LinkTag)linkTag).getLink();
                String testName = ((LinkTag)linkTag).getLinkText();
                Path testPath = suitePath.resolveSibling(Paths.get(localUrl, new String[0]));
                SeleneseTestCase testCase = new SeleneseTestCase(testPath.toString(), testName);
                this.testCases.add(testCase);
            }
        }
        catch (UnsupportedEncodingException | ParserException e) {
            System.err.println("!!! Cannot parse test suite file " + suiteFilename + "\n");
        }
    }

    SeleneseTestCase getTestCase(int index) {
        return this.testCases.get(index);
    }

    List<String> getTestFiles() {
        return this.testCases.stream().map(SeleneseTestCase::getTestFile).collect(Collectors.toList());
    }

    private Document getXMLDocument() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element testSuites = doc.createElement("testsuites");
        doc.appendChild(testSuites);
        Element testSuite = doc.createElement("testsuite");
        testSuites.appendChild(testSuite);
        Attr tests = doc.createAttribute("tests");
        tests.setValue(Integer.toString(this.testCases.size()));
        testSuite.setAttributeNode(tests);
        Attr failures = doc.createAttribute("failures");
        failures.setValue(Integer.toString(this.getFailureCount()));
        testSuite.setAttributeNode(failures);
        Attr errors = doc.createAttribute("errors");
        errors.setValue(Integer.toString(this.getErrorCount()));
        testSuite.setAttributeNode(errors);
        for (SeleneseTestCase testCase : this.testCases) {
            Element testCaseElement = testCase.getXMLElement(doc);
            testSuite.appendChild(testCaseElement);
        }
        return doc;
    }

    public String getTitle() {
        return this.title;
    }

    public int getFailureCount() {
        return this.testCases.stream().mapToInt(testCase -> testCase.hasFailures() ? 1 : 0).sum();
    }

    public int getErrorCount() {
        return this.testCases.stream().mapToInt(testCase -> testCase.hasErrors() ? 1 : 0).sum();
    }

    public void writeJUnitXMLReport() {
        if (this.reportFilename == null) {
            return;
        }
        try {
            DOMSource source = new DOMSource(this.getXMLDocument());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("doctype-public", "yes");
            transformer.setOutputProperty(XML_INDENT_PROP, Integer.toString(4));
            transformer.setOutputProperty("cdata-section-elements", SeleneseTestCase.CDATA_ELEMENTS);
            StreamResult result = new StreamResult(new File(this.reportFilename));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            System.err.println("!!! Unable to create JUnit XML report for suite " + this.title);
            e.printStackTrace();
        }
    }

    static class SeleneseNodeFilter
    implements NodeFilter {
        SeleneseNodeFilter() {
        }

        public boolean accept(Node node) {
            return node instanceof TitleTag || node instanceof TableRow;
        }
    }
}

