package com.smartgwt.sample.showcase.client.tree;

import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.ButtonItem;
import com.smartgwt.client.widgets.form.fields.CheckboxItem;
import com.smartgwt.client.widgets.form.fields.events.ChangeEvent;
import com.smartgwt.client.widgets.form.fields.events.ChangeHandler;
import com.smartgwt.client.widgets.form.fields.events.ClickEvent;
import com.smartgwt.client.widgets.form.fields.events.ClickHandler;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.client.widgets.tree.TreeGrid;
import com.smartgwt.client.widgets.tree.TreeGridField;
import com.smartgwt.client.data.AdvancedCriteria;
import com.smartgwt.client.data.Criteria;
import com.smartgwt.client.data.Criterion;
import com.smartgwt.client.types.OperatorId;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;


public class KeepParentsLODSample extends ShowcasePanel {

    private static final String DESCRIPTION = "The sample demonstrates <code>keepParentsOnFilter</code> in combination with <code>"+
        "loadDataOnDemand</code>. "+
        "<p>"+
        "When you filter the tree, matching leaf nodes are retained along with all necessary "+
        "ancestors, even if those ancestors don’t match the filter. This is achieved via a "+
        "client-driven skeleton-building algorithm that walks up from matching leaves to root nodes."+
        "<p>"+
        "SmartClient automatically manages this complex algorithm, so you can achieve this kind "+
        "of filtering with even a simple REST service - no server-side programming required."+
        "<p>"+
        "Press \"Show Contract\" or \"Show Full Time\" or \"Show Engineers\" to see specific subsets "+
        "of the tree, or type in our own criteria in the filter row."+
        "<p>"+
        "You can uncheck \"Keep Parents\" to see how filtering would behave without this feature."+
        "<p>"+
        "If you use the SmartClient Server, the entire algorithm is achieved in a single server "+
        "turnaround - through the powerful <i>Transaction Chaining</i> feature - even if your "+
        "DataSource has limited filtering capabilities.  Then, if you use our <code>SQLDataSource</code>, "+
        "the default implementation is yet more efficient.";

    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
            KeepParentsLODSample panel = new KeepParentsLODSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }
	
    private TreeGrid employeeTreeGrid;
    private VLayout mainLayout;
	
    public Canvas getViewPanel() {

        mainLayout = new VLayout();
        mainLayout.setWidth100();
        mainLayout.setHeight100();
        mainLayout.setMembersMargin(5);
	        
        DynamicForm form = new DynamicForm();  
        form.setWidth(600);
        form.setNumCols(8);
		
        ButtonItem showContractButton = new ButtonItem();
        showContractButton.setTitle("Show Contract");
        showContractButton.setStartRow(false);
        showContractButton.setEndRow(false);
        showContractButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                Criteria criteria = new Criteria();
                criteria.addCriteria("EmployeeType", "contract");
                employeeTreeGrid.filterData(criteria);
            }
        });
        ButtonItem showFullTimeButton = new ButtonItem();
        showFullTimeButton.setTitle("Show Full Time");
        showFullTimeButton.setStartRow(false);
        showFullTimeButton.setEndRow(false);
        showFullTimeButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                Criteria criteria = new Criteria();
                criteria.addCriteria("EmployeeType", "full time");
                employeeTreeGrid.filterData(criteria);
            }
        });
        ButtonItem showEngineersButton = new ButtonItem();
        showEngineersButton.setTitle("Show Engineers");
        showEngineersButton.setStartRow(false);
        showEngineersButton.setEndRow(false);
        showEngineersButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                AdvancedCriteria adCriteria = new AdvancedCriteria(OperatorId.AND, new Criterion[]{
                    new Criterion("Job", OperatorId.ICONTAINS, "engineer")
                });
				
                employeeTreeGrid.filterData(adCriteria);
            }
        });
		
        final CheckboxItem keepParents = new CheckboxItem("keepParents", "Keep parents");  
        keepParents.setDefaultValue(true);  
        keepParents.addChangeHandler(new ChangeHandler() {  
            public void onChange(ChangeEvent event) {  
                Criteria criteria = employeeTreeGrid.getCriteria();
                boolean selected = keepParents.getValueAsBoolean();  
            	
                if (criteria !=null && criteria.getValues().size() != 0) recreateListGrid(criteria, selected);
            }  
        });  
        
        form.setFields(showContractButton, showFullTimeButton, showEngineersButton, keepParents);  
        
        mainLayout.addMember(form);
        
        recreateListGrid(new Criteria(), true);
        
        return mainLayout;
    }

    private void recreateListGrid (Criteria criteria, boolean keepParents) { 
		
        if (mainLayout.hasMember(employeeTreeGrid)) mainLayout.removeMember(employeeTreeGrid);
		 
        employeeTreeGrid = new TreeGrid();  
        employeeTreeGrid.setLoadDataOnDemand(true);  
        employeeTreeGrid.setWidth(600);  
        employeeTreeGrid.setHeight(400);  
        employeeTreeGrid.setDataSource(DataSource.get("employees"));  
        employeeTreeGrid.setShowFilterEditor(true);  
        employeeTreeGrid.setFilterOnKeypress(true);  
        employeeTreeGrid.setKeepParentsOnFilter(keepParents);  
        employeeTreeGrid.setInitialCriteria(criteria);  
        employeeTreeGrid.setAutoOpenTree("all");  
        employeeTreeGrid.setAutoFetchData(true);
		 
        TreeGridField nameField = new TreeGridField("Name", 150);  
        TreeGridField jobField = new TreeGridField("Job", 150);  
        TreeGridField employeeTypeField = new TreeGridField("EmployeeType");  
	  
        employeeTreeGrid.setFields(nameField, jobField, employeeTypeField);  
	        
        mainLayout.addMember(employeeTreeGrid);
    }
    
    public String getIntro() {
        return DESCRIPTION;
    }
    
}
