/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
package com.smartgwt.sample.showcase.client.componentXML.applications;

import com.smartgwt.client.rpc.LoadScreenCallback;
import com.smartgwt.client.rpc.RPCManager;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class IssueTrackingAppSampleXML extends ShowcasePanel {

    private static final String DESCRIPTION =
        " This application shows you how to build simple dashboard information into top-level "+
        "statistics using workflows, shows all data management operations (Add, Update, Remove, Fetch), "+
        "how to embed screens within grids (using grid expansion features) and stores a complete history "+
        "of actions taken, again using advanced workflows to directly update data."+
        "<P>"+
        "To add issues, just click the + icon above the grid, add your issue, and hit Save to see your new "+
        "issue in the grid. Also, see how the notifications that appear hold the details of your newly created issue."+
        "<P>"+
        "Click the right arrow next to any row in the grid and see the full history of this issue. Issue history is "+
        "added using Workflow based DataSource tasks where you can perform all 4 CRUD (create, retrieve update, and edit) "+
        "operations directly."+
        "<P>"+
        "Double-clicking any record allows you to edit that issue. You will notice that if you try to edit a closed issue, "+
        "all of the fields are read-only. This is made possible by using the properties readOnlyWhen and readOnlyDisplay, "+
        "which allow you to conditionally set field states.";

    public static class Factory implements PanelFactory {

        private String id;

        public ShowcasePanel create() {
            IssueTrackingAppSampleXML panel = new IssueTrackingAppSampleXML();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    @Override
    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {
        final Canvas layout = new Canvas();
        layout.setHeight100();
        layout.setWidth100();
        RPCManager.loadScreen("issueTrackingApp", new LoadScreenCallback() {
            @Override
            public void execute() {
                layout.addChild(this.getScreen());
                RPCManager.cacheScreens(new String[] {"historyScreen"}, null);
            }
        });
        return layout;
    }

    @Override
    public String getIntro() {
        return DESCRIPTION;
    }
    
    @Override
    protected boolean isFullscreenMode() {
        return true;
    }

    @Override
    public SourceEntity[] getSourceUrls() {
        return new SourceEntity[]{
            new SourceEntity("issueTrackingApp.ui.xml", XML, "source/issueTrackingApp.ui.xml.html", true),
            new SourceEntity("historyScreen.ui.xml", XML, "source/historyScreen.ui.xml.html", true),
            new SourceEntity("iss_IssueMaster.ds.xml", XML, "source/iss_IssueMaster.ds.xml.html", true),
            new SourceEntity("iss_IssueHistory.ds.xml", XML, "source/iss_IssueHistory.ds.xml.html", true),
            new SourceEntity("iss_Users.ds.xml", XML, "source/iss_Users.ds.xml.html", true),
            new SourceEntity("iss_IssueStatus.ds.xml", XML, "source/iss_IssueStatus.ds.xml.html", true),
            new SourceEntity("iss_IssueType.ds.xml", XML, "source/iss_IssueType.ds.xml.html", true),
            new SourceEntity("iss_Priority.ds.xml", XML, "source/iss_Priority.ds.xml.html", true)
        };
    }
}
