package com.smartgwt.sample.client;

import com.smartgwt.client.types.*;
import com.smartgwt.client.util.PageKeyHandler;
import com.smartgwt.client.util.Page;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.data.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.SelectionUpdatedEvent;
import com.smartgwt.client.widgets.grid.events.SelectionUpdatedHandler;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.form.fields.events.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.browser.window.events.*;

public class WindowActionForm extends VLayout {
    DynamicForm selectorForm;
    ListGrid windowsGrid;
    DynamicForm actionForm;

    public WindowActionForm() {
        setIsGroup(true);
        setGroupTitle("Take an Action on a Window");

        selectorForm = new DynamicForm();
        //selectorForm.setDisabled(true);
        RadioGroupItem radioGroup = new RadioGroupItem("target", "Select Target");
        radioGroup.setValueMap("This Window", "Another Window");
        radioGroup.setDefaultValue("This Window");
        radioGroup.setVertical(false);
        radioGroup.addChangeHandler(new ChangeHandler() {
            public void onChange(ChangeEvent event) {
                if ("Another Window".equals(event.getValue())) {
                    if (windowsGrid.getTotalRows() == 0) {
                        event.cancel();
                    } else {
                        Record record = windowsGrid.getSelectedRecord();
                        if (record == null) windowsGrid.selectRecord(0);
                    }
                } else {
                    windowsGrid.deselectAllRecords();
                }
            }
        });
        selectorForm.setItems(radioGroup);

        windowsGrid = new ListGrid();
        windowsGrid.setHeight(100);
        // windowsGrid.setDisabled(true);
        windowsGrid.setShowHeader(false);
        windowsGrid.setSelectionType(SelectionStyle.SINGLE);
        windowsGrid.setDataSource(new OtherWindowsDataSource());
        windowsGrid.addSelectionUpdatedHandler(new SelectionUpdatedHandler() {
            public void onSelectionUpdated(SelectionUpdatedEvent event) {
                Record record = windowsGrid.getSelectedRecord();
                selectorForm.setValue("target", record != null ? "Another Window" : "This Window");
            }
        });

        updateOtherWindowsRecords(MultiWindow.getOtherWindows());

        actionForm = new DynamicForm();
        actionForm.setWidth(1);
        actionForm.setNumCols(6);
        ButtonItem closeButton        = new ActionButtonItem("close","Close");
        ButtonItem hideButton         = new ActionButtonItem("hide","Hide");
        ButtonItem showButton         = new ActionButtonItem("show","Show");
        ButtonItem activateButton     = new ActionButtonItem("activate","Activate");
        ButtonItem deactivateButton   = new ActionButtonItem("deactivate","Deactivate");
        ButtonItem bringToFrontButton = new ActionButtonItem("bringToFront","Bring to Front");
        closeButton.setCellHeight(50);

        ButtonItem moveButton = new ActionButtonItem("move", "Move");
        moveButton.setEndRow(false);
        moveButton.setWidth(100);

        RadioGroupItem positionItem = new RadioGroupItem("position");
        positionItem.setValueMap("Left/Top", "Right/Top", "Right/Bottom", "Left/Bottom");
        positionItem.setDefaultValue("Left/Top");
        positionItem.setVertical(false);
        //        positionItem.setShowTitle(true);
        positionItem.setTitle("Destination");
        positionItem.setColSpan(4);
        positionItem.setCellHeight(50);

        ButtonItem resizeButton = new ActionButtonItem("resize", "Resize");
        resizeButton.setEndRow(false);
        resizeButton.setWidth(100);

        SliderItem sliderItem = new SliderItem("height", "Height (px)");
        sliderItem.setAutoChildProperties("slider", new Canvas().setWidth(350));
        //sliderItem.setShowTitle(false);
        sliderItem.setColSpan(4);
        sliderItem.setNumValues(11);
        sliderItem.setMinValue(500);
        sliderItem.setMaxValue(1000);

        actionForm.setItems(closeButton, hideButton, showButton, activateButton,
                            deactivateButton, bringToFrontButton, moveButton,
                            /*new SpacerItem(),*/ positionItem, resizeButton, sliderItem);

        setMembers(selectorForm, windowsGrid, actionForm);
    }

    void updateOtherWindowsRecords(RemoteWindow[] otherWindows) {
        ListGridRecord[] records = new ListGridRecord[otherWindows.length];
        for (int i = 0; i < otherWindows.length; i++ ) {
            ListGridRecord record = records[i] = new ListGridRecord();
            record.setAttribute("name", otherWindows[i].getName());
            record.setAttribute("remoteWindow", otherWindows[i]);
        }
        String selectionState = windowsGrid.getSelectedState();
        windowsGrid.setData(records);
        windowsGrid.setSelectedState(selectionState);
        //selectorForm.setDisabled(windowsGrid.getTotalRows() == 0);
    }

    RemoteWindow getTargetWindow() {
        if ("Another Window".equals(selectorForm.getValue("target"))) {
            Record record = windowsGrid.getSelectedRecord();
            if (record != null) {
                RemoteWindow target = MultiWindow.find(record.getAttribute("name"));
                if (target != null) return target;
            }
        }
        return MultiWindow.getLocalWindow();
    }

    public class OtherWindowsDataSource extends DataSource {
        public OtherWindowsDataSource() {
            setClientOnly(true);

            DataSourceField nameField = new DataSourceField("name", FieldType.TEXT);
            nameField.setPrimaryKey(true);
            setFields(nameField);
        }
    }

    public class ActionButtonItem extends ButtonItem implements ClickHandler {
        public ActionButtonItem(String name, String title) {
            super(name, title);
            setStartRow(false);
            setEndRow(false);
            setWidth(100);

            addClickHandler(this);
        }

        public void onClick(ClickEvent event) {
            RemoteWindow remoteWindow = getTargetWindow();
            String windowName = remoteWindow.getName();
            switch (getName()) {
            case "close":
                MultiWindow.close(windowName);
                break;
            case "hide":
                MultiWindow.hide(windowName);
                break;
            case "show":
                MultiWindow.show(windowName);            
                break;
            case "activate":
                MultiWindow.activate(windowName);
                break;
            case "deactivate":
                MultiWindow.deactivate(windowName);
                break;
            case "bringToFront":
                MultiWindow.bringToFront(windowName);
                break;
            case "move":
                int right  = Page.getScreenWidth()  - remoteWindow.getBrowserWidth()  - 100;
                int bottom = Page.getScreenHeight() - remoteWindow.getBrowserHeight() - 100;
                switch (getForm().getValueAsString("position")) {
                case "Left/Top":
                    MultiWindow.move(windowName, 100, 100);
                    break;
                case "Right/Top":
                    MultiWindow.move(windowName, right, 100);
                    break;
                case "Right/Bottom":
                    MultiWindow.move(windowName, right, bottom);
                    break;
                case "Left/Bottom":
                    MultiWindow.move(windowName, 100, bottom);
                    break;
                }
                break;
            case "resize":
                int height = (int)getForm().getValue("height");
                MultiWindow.resize(windowName, height + 300, height);
                break;
            }
        }
        
    }

}

