/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import java.io.File;

public class PathUtils {
    public static String findInPath(String executableName) {
        String[] pathDirs;
        String pathEnv = System.getenv("PATH");
        if (pathEnv == null || pathEnv.isEmpty()) {
            return null;
        }
        for (String dir : pathDirs = pathEnv.split(File.pathSeparator)) {
            File candidate = new File(dir, executableName);
            if (!candidate.exists() || !candidate.canExecute()) continue;
            return candidate.getAbsolutePath();
        }
        return null;
    }

    public static String findFirstInPath(String ... executableNames) {
        for (String name : executableNames) {
            String path = PathUtils.findInPath(name);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    public static boolean existsInPath(String executableName) {
        return PathUtils.findInPath(executableName) != null;
    }
}

