/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.lang.reflect.Array;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.conf.PlainParquetConfiguration;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.convert.GroupRecordConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class ParquetDataSource
extends BasicDataSource {
    @Override
    protected boolean isValidSubclass() {
        return true;
    }

    @Override
    public void init(Map theConfig, DSRequest dsRequest) throws Exception {
        boolean requestedAutoDerive;
        LinkedHashMap<String, Object> cfg = new LinkedHashMap<String, Object>(theConfig);
        Object autoDeriveObj = cfg.get("autoDeriveSchema");
        boolean bl = requestedAutoDerive = autoDeriveObj != null && "true".equalsIgnoreCase(String.valueOf(autoDeriveObj).trim());
        if (requestedAutoDerive) {
            Object rawFields = cfg.get("fields");
            boolean needsDerive = rawFields == null || rawFields instanceof List && ((List)rawFields).isEmpty();
            boolean appendMissingColumns = true;
            if (needsDerive || appendMissingColumns) {
                List<Map<String, Object>> existing = ParquetDataSource.normalizeFieldsList(rawFields);
                HashSet<String> existingNames = new HashSet<String>();
                for (Map<String, Object> f : existing) {
                    Object n = f.get("name");
                    if (n == null) continue;
                    existingNames.add(String.valueOf(n));
                }
                List<Map<String, Object>> derived = ParquetDataSource.deriveParquetSchemaFromConfig(cfg);
                for (Map<String, Object> fd : derived) {
                    String name = String.valueOf(fd.get("name"));
                    if (existingNames.contains(name)) continue;
                    existing.add(fd);
                }
                cfg.put("fields", existing);
            }
            cfg.put("autoDeriveSchema", Boolean.FALSE);
        }
        super.init(cfg, dsRequest);
        if (requestedAutoDerive) {
            this.dsConfig.put("autoDeriveSchema", true);
        }
    }

    private static List<Map<String, Object>> normalizeFieldsList(Object rawFields) {
        ArrayList<Map<String, Object>> out = new ArrayList<Map<String, Object>>();
        if (rawFields instanceof List) {
            for (Object o : (List)rawFields) {
                if (!(o instanceof Map)) continue;
                out.add((Map)o);
            }
        }
        return out;
    }

    private static List<Map<String, Object>> deriveParquetSchemaFromConfig(Map cfg) throws Exception {
        String dataURL = ParquetDataSource.asString(cfg.get("dataURL"));
        if (dataURL == null || dataURL.trim().isEmpty()) {
            throw new IllegalArgumentException("No dataURL in DS config (required for parquet schema derivation)");
        }
        InputFile input = ParquetDataSource.resolveInputFileFromDataURL(dataURL, "config");
        MessageType schema = ParquetDataSource.readParquetSchema(input);
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        for (Type f : schema.getFields()) {
            LinkedHashMap<String, String> fd = new LinkedHashMap<String, String>();
            String name = f.getName();
            fd.put("name", name);
            fd.put("title", ParquetDataSource.formatTitle(name));
            String type = "text";
            if (f.isPrimitive()) {
                PrimitiveType.PrimitiveTypeName pt = f.asPrimitiveType().getPrimitiveTypeName();
                type = ParquetDataSource.mapType(pt);
            }
            fd.put("type", type);
            fields.add(fd);
        }
        return fields;
    }

    private static String asString(Object o) {
        if (o == null) {
            return null;
        }
        String s = String.valueOf(o);
        return s.isEmpty() ? null : s;
    }

    private static String mapType(PrimitiveType.PrimitiveTypeName pt) {
        switch (pt) {
            case INT32: 
            case INT64: {
                return "integer";
            }
            case FLOAT: 
            case DOUBLE: {
                return "float";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case INT96: {
                return "datetime";
            }
        }
        return "text";
    }

    private static String formatTitle(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            return fieldName;
        }
        StringBuilder title = new StringBuilder();
        boolean capNext = true;
        for (char c : fieldName.toCharArray()) {
            if (c == '_' || c == '-') {
                title.append(' ');
                capNext = true;
                continue;
            }
            if (capNext) {
                title.append(Character.toUpperCase(c));
                capNext = false;
                continue;
            }
            title.append(c);
        }
        return title.toString();
    }

    @Override
    public DSResponse executeFetch(DSRequest req) throws Exception {
        return this.executeParquetFetch(req);
    }

    public DSResponse executeParquetFetch(DSRequest req) throws Exception {
        DSResponse res = new DSResponse();
        ArrayList<Map<String, Object>> allRows = new ArrayList<Map<String, Object>>();
        long totalRows = 0L;
        try {
            int n;
            int endRow;
            int n2;
            List sortCriteria;
            ArrayList<Map<String, Object>> filteredRows;
            InputFile inputFile = this.resolveParquetInputFileFromDS();
            ParquetReadOptions options = ParquetDataSource.createDefaultParquetReadOptions();
            ParquetMeta meta = ParquetDataSource.readParquetMeta(inputFile, options);
            MessageType schema = meta.schema;
            totalRows = meta.totalRows;
            ParquetDataSource.forEachParquetRow(inputFile, schema, options, null, g -> {
                HashMap<String, Object> row = new HashMap<String, Object>();
                for (Type t : schema.getFields()) {
                    String fld = t.getName();
                    int idx = schema.getFieldIndex(fld);
                    Object value = ParquetDataSource.convertParquetValue(g, idx, t);
                    row.put(fld, value);
                }
                allRows.add(row);
            });
            Map critObj = req.getCriteria();
            Map simpleCrit = null;
            if (critObj instanceof Map) {
                simpleCrit = critObj;
            }
            if (simpleCrit != null && !simpleCrit.isEmpty()) {
                filteredRows = new ArrayList();
                for (Map map : allRows) {
                    boolean matches = true;
                    for (Map.Entry entry : simpleCrit.entrySet()) {
                        Object critVal;
                        Object rowVal = map.get(entry.getKey());
                        if (ParquetDataSource.valueMatches(rowVal, critVal = entry.getValue())) continue;
                        matches = false;
                        break;
                    }
                    if (!matches) continue;
                    filteredRows.add(map);
                }
            } else {
                filteredRows = allRows;
            }
            if ((sortCriteria = req.getSortByFields()) != null && !sortCriteria.isEmpty()) {
                ParquetDataSource.sortRows(filteredRows, sortCriteria);
            }
            if ((n2 = (int)Math.max(0L, req.getStartRow())) > (endRow = req.getEndRow() < 0L ? filteredRows.size() : (int)Math.min((long)filteredRows.size(), req.getEndRow()))) {
                n = endRow;
            }
            ArrayList<Map> pageRows = new ArrayList<Map>();
            for (int i = n; i < endRow; ++i) {
                pageRows.add((Map)filteredRows.get(i));
            }
            int actualEndRow = n + pageRows.size();
            res.setData(pageRows);
            res.setStartRow(n);
            res.setEndRow(actualEndRow);
            res.setTotalRows((int)totalRows);
            res.setStatus(0);
        }
        catch (Exception e) {
            System.err.println("Error in executeFetch: " + e.getMessage());
            e.printStackTrace();
            HashMap<String, String> errorMap = new HashMap<String, String>();
            errorMap.put("error", e.getMessage());
            ArrayList<HashMap<String, String>> err = new ArrayList<HashMap<String, String>>();
            err.add(errorMap);
            res.setData(err);
            res.setStatus(-1);
        }
        return res;
    }

    private static Object convertParquetValue(Group g, int idx, Type type) {
        try {
            if (g.getFieldRepetitionCount(idx) == 0) {
                return null;
            }
            PrimitiveType primitiveType = type.asPrimitiveType();
            switch (primitiveType.getPrimitiveTypeName()) {
                case INT32: {
                    return g.getInteger(idx, 0);
                }
                case INT64: {
                    return g.getLong(idx, 0);
                }
                case FLOAT: {
                    return Float.valueOf(g.getFloat(idx, 0));
                }
                case DOUBLE: {
                    return g.getDouble(idx, 0);
                }
                case BOOLEAN: {
                    return g.getBoolean(idx, 0);
                }
                case BINARY: {
                    return g.getString(idx, 0);
                }
                case INT96: {
                    Binary binary = g.getInt96(idx, 0);
                    return binary.toString();
                }
            }
            return g.getValueToString(idx, 0);
        }
        catch (Exception e) {
            return g.getValueToString(idx, 0);
        }
    }

    public static void sortRows(List<Map<String, Object>> rows, List<String> criteria) {
        rows.sort((r1, r2) -> {
            for (String crit : criteria) {
                Object val2;
                boolean desc = crit.startsWith("-");
                String field = desc ? crit.substring(1) : crit;
                Object val1 = r1.get(field);
                int cmp = ParquetDataSource.compareValues(val1, val2 = r2.get(field));
                if (cmp == 0) continue;
                return desc ? -cmp : cmp;
            }
            return 0;
        });
    }

    private static int compareValues(Object a, Object b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a.getClass().equals(b.getClass()) && a instanceof Comparable) {
            return ((Comparable)a).compareTo(b);
        }
        if (ParquetDataSource.isNumeric(a) && ParquetDataSource.isNumeric(b)) {
            try {
                Double d1 = Double.parseDouble(a.toString());
                Double d2 = Double.parseDouble(b.toString());
                return d1.compareTo(d2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return a.toString().compareTo(b.toString());
    }

    private static boolean isNumeric(Object obj) {
        if (obj instanceof Number) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        String str = obj.toString().trim();
        if (str.isEmpty()) {
            return false;
        }
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean valueMatches(Object rowVal, Object critVal) {
        String s;
        if (critVal == null) {
            return true;
        }
        if (rowVal == null) {
            return false;
        }
        if (critVal instanceof Collection) {
            for (Object v : (Collection)critVal) {
                if (!ParquetDataSource.singleValueMatch(rowVal, v)) continue;
                return true;
            }
            return false;
        }
        if (critVal.getClass().isArray()) {
            int len = Array.getLength(critVal);
            for (int i = 0; i < len; ++i) {
                Object v = Array.get(critVal, i);
                if (!ParquetDataSource.singleValueMatch(rowVal, v)) continue;
                return true;
            }
            return false;
        }
        if (critVal instanceof String && ((s = ((String)critVal).trim()).contains("|") || s.contains(","))) {
            for (String token : s.split("\\s*[|,]\\s*")) {
                if (token.isEmpty() || !ParquetDataSource.singleValueMatch(rowVal, token)) continue;
                return true;
            }
            return false;
        }
        return ParquetDataSource.singleValueMatch(rowVal, critVal);
    }

    private static boolean singleValueMatch(Object rowVal, Object critVal) {
        String rStr = String.valueOf(rowVal).trim();
        String cStr = String.valueOf(critVal).trim();
        if (rStr.isEmpty() || cStr.isEmpty()) {
            return false;
        }
        if (ParquetDataSource.looksNumeric(rStr)) {
            NumericFilter nf = ParquetDataSource.parseNumericFilter(cStr);
            if (nf != null) {
                Double rv = ParquetDataSource.safeToDouble(rStr);
                return rv != null && nf.test(rv);
            }
            if (ParquetDataSource.looksNumeric(cStr)) {
                Double d1 = ParquetDataSource.safeToDouble(rStr);
                Double d2 = ParquetDataSource.safeToDouble(cStr);
                if (d1 != null && d2 != null) {
                    return Double.compare(d1, d2) == 0;
                }
            }
        }
        Boolean rb = ParquetDataSource.asBooleanOrNull(rStr);
        Boolean cb = ParquetDataSource.asBooleanOrNull(cStr);
        if (rb != null && cb != null) {
            return rb.equals(cb);
        }
        return rStr.toLowerCase().contains(cStr.toLowerCase());
    }

    private static boolean looksNumeric(String s) {
        return s.matches("[+-]?\\d+(\\.\\d+)?");
    }

    private static Double safeToDouble(String s) {
        try {
            return Double.valueOf(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Boolean asBooleanOrNull(String s) {
        if (s.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static NumericFilter parseNumericFilter(String s) {
        Double v;
        if ((s = s.trim()).contains("..")) {
            String[] parts = s.split("\\.{2}");
            if (parts.length == 2) {
                Double a = ParquetDataSource.safeToDouble(parts[0].trim());
                Double b = ParquetDataSource.safeToDouble(parts[1].trim());
                if (a != null && b != null) {
                    return new NumericFilter(a, b);
                }
            }
            return null;
        }
        String op = null;
        String num = null;
        if (s.startsWith(">=")) {
            op = ">=";
            num = s.substring(2);
        } else if (s.startsWith("<=")) {
            op = "<=";
            num = s.substring(2);
        } else if (s.startsWith(">")) {
            op = ">";
            num = s.substring(1);
        } else if (s.startsWith("<")) {
            op = "<";
            num = s.substring(1);
        } else if (ParquetDataSource.looksNumeric(s)) {
            op = "==";
            num = s;
        }
        if (op != null && (v = ParquetDataSource.safeToDouble(num.trim())) != null) {
            return new NumericFilter(op, v);
        }
        return null;
    }

    private InputFile resolveParquetInputFileFromDS(DataSource ds) throws Exception {
        if (ds == null) {
            throw new IllegalArgumentException("DataSource is null.");
        }
        String dataURL = ds.getProperty("dataURL");
        return this.resolveParquetInputFile(dataURL, ds.getID());
    }

    private InputFile resolveParquetInputFileFromDS() throws Exception {
        String dataURL = (String)this.dsConfig.get("dataURL");
        return this.resolveParquetInputFile(dataURL, this.dsName);
    }

    private InputFile resolveParquetInputFile(String dataURL, String dsId) throws Exception {
        dataURL = ParquetDataSource.trimToNull(dataURL);
        if ((dsId = ParquetDataSource.trimToNull(dsId)) == null) {
            throw new IllegalArgumentException("No DataSource id/name provided (dsId is null/blank).");
        }
        if (dataURL == null) {
            throw new IllegalArgumentException("No dataURL provided for DataSource: " + dsId + ". Expected dataURL like file:/examples/... or https://...");
        }
        return ParquetDataSource.resolveInputFileFromDataURL(dataURL, dsId);
    }

    private static InputFile resolveInputFileFromDataURL(String dataURL, String dsId) throws IOException {
        URI uri;
        String s = ParquetDataSource.trimToNull(dataURL);
        if (s == null) {
            throw new IOException("Missing dataURL for DataSource: " + dsId);
        }
        if (!ParquetDataSource.hasScheme(s)) {
            File f = ParquetDataSource.resolveWebRootRelativeFile(s, dsId);
            return ParquetDataSource.openLocalParquetInputFile(f);
        }
        try {
            uri = new URI(s);
        }
        catch (Exception e) {
            throw new IOException("Invalid dataURL URI for DataSource " + dsId + ": " + s, e);
        }
        String scheme = uri.getScheme();
        String host = uri.getHost();
        String path = uri.getPath();
        if ("https".equalsIgnoreCase(scheme)) {
            if (host == null || host.trim().isEmpty()) {
                throw new IOException("Invalid https dataURL (missing host) for DataSource " + dsId + ": " + s);
            }
            return ParquetDataSource.openHttpParquetInputFile(uri.toURL().toString());
        }
        if ("file".equalsIgnoreCase(scheme)) {
            Object rel;
            if (host != null && !host.isEmpty()) {
                String p;
                String string = p = path == null ? "" : path;
                if (p.startsWith("/")) {
                    p = p.substring(1);
                }
                rel = host + (String)(p.isEmpty() ? "" : "/" + p);
            } else {
                rel = path == null ? "" : path;
            }
            File f = ParquetDataSource.resolveWebRootRelativeFile((String)rel, dsId);
            return ParquetDataSource.openLocalParquetInputFile(f);
        }
        throw new IOException("Unsupported dataURL scheme '" + scheme + "' for DataSource " + dsId + ". Allowed: https:// or file:// (webRoot-relative) or plain relative path. Got: " + s);
    }

    private static File resolveWebRootRelativeFile(String relOrAbsLike, String dsId) throws IOException {
        String webRoot;
        String p = ParquetDataSource.trimToNull(relOrAbsLike);
        if (p == null) {
            throw new IOException("Empty file path for DataSource: " + dsId);
        }
        while (p.startsWith("/")) {
            p = p.substring(1);
        }
        Object wr = Config.getGlobal().get("webRoot");
        String string = webRoot = wr == null ? "" : String.valueOf(wr);
        if (webRoot.isEmpty() || "null".equals(webRoot)) {
            throw new IOException("Config webRoot is not set; cannot resolve local dataURL for DataSource: " + dsId);
        }
        File base = new File(webRoot);
        return new File(base, p);
    }

    private static InputFile openLocalParquetInputFile(File file) throws IOException {
        if (file == null) {
            throw new IOException("Local file is null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("Parquet file not found: " + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new IOException("Not a file: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IOException("Cannot read file: " + file.getAbsolutePath());
        }
        return new LocalParquetInputFile(file);
    }

    public static InputFile openHttpParquetInputFile(String url) throws IOException {
        return new HttpParquetInputFile(new URL(url));
    }

    public CreateSQLDSResult createSQLDS() throws Exception {
        String url = ParquetDataSource.trimToNull((String)this.dsConfig.get("dataURL"));
        if (url == null) {
            throw new IllegalArgumentException("dataURL is required");
        }
        return this.createSQLDS(url, null, null, null, null, null);
    }

    public CreateSQLDSResult createSQLDS(String dataURL, String explicitDsId, String explicitTableName, String dsOutputRelDir, String dataOutputRelDir, Integer maxRows) throws Exception {
        String dataDirRel;
        SqlDsContext ctx = ParquetDataSource.buildSqlDsContext(dataURL, explicitDsId, explicitTableName, null);
        Object dataFileName = ctx.dataFileName != null ? ctx.dataFileName : ctx.recordTag + ".data.xml";
        Object wr = Config.getGlobal().get("webRoot");
        String webRoot = ParquetDataSource.trimToNull(wr == null ? null : String.valueOf(wr));
        if (webRoot == null) {
            throw new IllegalStateException("Config webRoot is not set; cannot write generated files");
        }
        String dsDirRel = ParquetDataSource.trimToNull(dsOutputRelDir);
        if (dsDirRel == null) {
            dsDirRel = "examples/shared/ds";
        }
        if ((dataDirRel = ParquetDataSource.trimToNull(dataOutputRelDir)) == null) {
            dataDirRel = "examples/shared/ds/test_data";
        }
        String dsFileName = ctx.dsId + ".ds.xml";
        File dsDir = new File(new File(webRoot), ParquetDataSource.stripLeadingSlashes(dsDirRel));
        File dataDir = new File(new File(webRoot), ParquetDataSource.stripLeadingSlashes(dataDirRel));
        if (!dsDir.exists() && !dsDir.mkdirs()) {
            throw new IOException("Failed to create output dir: " + dsDir.getAbsolutePath());
        }
        if (!dataDir.exists() && !dataDir.mkdirs()) {
            throw new IOException("Failed to create output dir: " + dataDir.getAbsolutePath());
        }
        File dsOut = new File(dsDir, dsFileName);
        File dataOut = new File(dataDir, (String)dataFileName);
        InputFile input = ParquetDataSource.resolveInputFileFromDataURL(ctx.dataURL, ctx.dsId);
        ParquetReadOptions options = ParquetDataSource.createDefaultParquetReadOptions();
        MessageType schema = ParquetDataSource.readParquetSchema(input, options);
        String dsXml = ParquetDataSource.getSQLDSXML(ctx.dsId, ctx.tableName, (String)dataFileName, schema);
        ParquetDataSource.writeUtf8(dsOut, dsXml);
        long written = ParquetDataSource.writeParquetDataFile(dataOut, CopyDataFormat.XML, ctx.recordTag, schema, input, options, maxRows);
        return new CreateSQLDSResult(ctx.dsId, ctx.tableName, ctx.recordTag, dataURL, dsOut.getAbsolutePath(), dataOut.getAbsolutePath(), written);
    }

    public String getSQLDSXML() throws Exception {
        String url = ParquetDataSource.trimToNull((String)this.dsConfig.get("dataURL"));
        return this.getSQLDSXML(url, this.dsName, null);
    }

    public String getSQLDSXML(String dataURL, String explicitDsId, String explicitTableName) throws Exception {
        SqlDsContext ctx = ParquetDataSource.buildSqlDsContext(dataURL, explicitDsId, explicitTableName, null);
        InputFile input = ParquetDataSource.resolveInputFileFromDataURL(ctx.dataURL, ctx.dsId);
        ParquetReadOptions options = ParquetDataSource.createDefaultParquetReadOptions();
        MessageType schema = ParquetDataSource.readParquetSchema(input, options);
        return ParquetDataSource.getSQLDSXML(ctx.dsId, ctx.tableName, ctx.dataFileName, schema);
    }

    public static String getSQLDSXML(String dsId, String tableName, String testFileName, MessageType schema) {
        StringBuilder xml = new StringBuilder();
        xml.append("<DataSource\n").append("    ID=\"").append(ParquetDataSource.xmlEscape(dsId)).append("\"\n").append("    serverType=\"sql\"\n").append("    tableName=\"").append(ParquetDataSource.xmlEscape(tableName)).append("\"\n");
        testFileName = ParquetDataSource.trimToNull(testFileName);
        if (testFileName != null) {
            xml.append("    testFileName=\"").append(ParquetDataSource.xmlEscape(testFileName)).append("\"\n");
        }
        xml.append(">\n");
        xml.append("    <fields>\n");
        xml.append("        <field name=\"pk\" type=\"sequence\" hidden=\"true\" primaryKey=\"true\" />\n");
        for (Type f : schema.getFields()) {
            String name = f.getName();
            String title = ParquetDataSource.formatTitle(name);
            String type = "text";
            if (f.isPrimitive()) {
                PrimitiveType.PrimitiveTypeName pt = f.asPrimitiveType().getPrimitiveTypeName();
                type = ParquetDataSource.mapType(pt);
            }
            xml.append("        <field name=\"").append(ParquetDataSource.xmlEscape(name)).append("\"").append(" type=\"").append(ParquetDataSource.xmlEscape(type)).append("\"").append(" title=\"").append(ParquetDataSource.xmlEscape(title)).append("\"").append(" />\n");
        }
        xml.append("    </fields>\n");
        xml.append("</DataSource>\n");
        return xml.toString();
    }

    private static long writeParquetDataFile(File out, CopyDataFormat format, String recordTag, MessageType schema, InputFile input, ParquetReadOptions options, Integer maxRows) throws Exception {
        ParquetDataFileWriter dfw = ParquetDataFileWriter.create(format, recordTag, schema);
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), StandardCharsets.UTF_8));){
            dfw.start(w);
            long written = ParquetDataSource.forEachParquetRow(input, schema, options, maxRows, g -> dfw.writeRecord(w, g));
            dfw.finish(w);
            long l = written;
            return l;
        }
    }

    private static void writeXmlRecord(Writer w, String recordTag, MessageType schema, Group g) throws IOException {
        w.write("<");
        w.write(recordTag);
        w.write(">\n");
        for (Type t : schema.getFields()) {
            Object value;
            String fld = t.getName();
            int idx = schema.getFieldIndex(fld);
            try {
                value = ParquetDataSource.convertParquetValue(g, idx, t);
            }
            catch (Exception ignore) {
                value = null;
            }
            if (value == null) continue;
            w.write("    <");
            w.write(ParquetDataSource.xmlEscape(fld));
            w.write(">");
            w.write(ParquetDataSource.xmlEscape(String.valueOf(value)));
            w.write("</");
            w.write(ParquetDataSource.xmlEscape(fld));
            w.write(">\n");
        }
        w.write("</");
        w.write(recordTag);
        w.write(">\n");
    }

    private static void writeJsonRecord(Writer w, MessageType schema, Group g) throws IOException {
        w.write("{");
        boolean first = true;
        for (Type t : schema.getFields()) {
            Object value;
            String fld = t.getName();
            int idx = schema.getFieldIndex(fld);
            try {
                value = ParquetDataSource.convertParquetValue(g, idx, t);
            }
            catch (Exception ignore) {
                value = null;
            }
            if (value == null) continue;
            if (!first) {
                w.write(",");
            }
            first = false;
            w.write("\"");
            w.write(ParquetDataSource.jsonEscape(fld));
            w.write("\":");
            ParquetDataSource.writeJsonValue(w, value);
        }
        w.write("}");
    }

    private static void writeJsonValue(Writer w, Object v) throws IOException {
        if (v == null) {
            w.write("null");
            return;
        }
        if (v instanceof Number || v instanceof Boolean) {
            w.write(String.valueOf(v));
            return;
        }
        w.write("\"");
        w.write(ParquetDataSource.jsonEscape(String.valueOf(v)));
        w.write("\"");
    }

    private static String jsonEscape(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\r", "\\r").replace("\n", "\\n").replace("\t", "\\t");
    }

    private static SqlDsContext buildSqlDsContext(String dataURL, String explicitDsId, String explicitTableName, String explicitDataFileName) {
        String tableName;
        String dsId;
        String url = ParquetDataSource.trimToNull(dataURL);
        if (url == null) {
            throw new IllegalArgumentException("dataURL is required");
        }
        String baseName = ParquetDataSource.deriveBaseNameFromDataURL(url);
        if (baseName == null) {
            baseName = "ParquetExport";
        }
        if ((dsId = ParquetDataSource.trimToNull(explicitDsId)) == null) {
            dsId = ParquetDataSource.toSafeIdentifier(baseName + "DS");
        }
        if ((tableName = ParquetDataSource.trimToNull(explicitTableName)) == null) {
            tableName = dsId;
        }
        String recordTag = ParquetDataSource.deriveRecordTag(dsId);
        String dataFileName = ParquetDataSource.trimToNull(explicitDataFileName);
        return new SqlDsContext(url, dsId, tableName, recordTag, dataFileName);
    }

    private static ParquetReadOptions createDefaultParquetReadOptions() {
        return new ParquetReadOptions.Builder((ParquetConfiguration)new PlainParquetConfiguration()).build();
    }

    private static MessageType readParquetSchema(InputFile input) throws Exception {
        return ParquetDataSource.readParquetSchema(input, ParquetDataSource.createDefaultParquetReadOptions());
    }

    private static MessageType readParquetSchema(InputFile input, ParquetReadOptions options) throws Exception {
        try (ParquetFileReader r = ParquetFileReader.open((InputFile)input, (ParquetReadOptions)options);){
            ParquetMetadata meta = r.getFooter();
            MessageType messageType = meta.getFileMetaData().getSchema();
            return messageType;
        }
    }

    private static ParquetMeta readParquetMeta(InputFile input, ParquetReadOptions options) throws Exception {
        try (ParquetFileReader r = ParquetFileReader.open((InputFile)input, (ParquetReadOptions)options);){
            ParquetMetadata meta = r.getFooter();
            MessageType schema = meta.getFileMetaData().getSchema();
            long totalRows = 0L;
            for (BlockMetaData b : meta.getBlocks()) {
                totalRows += b.getRowCount();
            }
            ParquetMeta parquetMeta = new ParquetMeta(schema, totalRows);
            return parquetMeta;
        }
    }

    private static long forEachParquetRow(InputFile input, MessageType schema, ParquetReadOptions options, Integer maxRows, ParquetRowVisitor visitor) throws Exception {
        long visited;
        block11: {
            long limit = maxRows == null ? -1L : maxRows.longValue();
            visited = 0L;
            ParquetFileReader reader = ParquetFileReader.open((InputFile)input, (ParquetReadOptions)options);
            block6: while (true) {
                PageReadStore pages = reader.readNextRowGroup();
                if (pages != null) {
                    long groupRowCount = pages.getRowCount();
                    MessageColumnIO columnIO = new ColumnIOFactory().getColumnIO(schema);
                    RecordReader recordReader = columnIO.getRecordReader(pages, (RecordMaterializer)new GroupRecordConverter(schema));
                    long i = 0L;
                    while (true) {
                        if (i >= groupRowCount) continue block6;
                        if (limit >= 0L && visited >= limit) {
                            long l = visited;
                            return l;
                        }
                        Group g = (Group)recordReader.read();
                        visitor.visit(g);
                        ++visited;
                        ++i;
                    }
                }
                break block11;
                break;
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        return visited;
    }

    private static void writeUtf8(File out, String content) throws IOException {
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), StandardCharsets.UTF_8));){
            w.write(content);
        }
    }

    private static String deriveBaseNameFromDataURL(String dataURL) {
        try {
            String name;
            String path;
            int h;
            String s = dataURL;
            int q = s.indexOf(63);
            if (q >= 0) {
                s = s.substring(0, q);
            }
            if ((h = s.indexOf(35)) >= 0) {
                s = s.substring(0, h);
            }
            if (ParquetDataSource.hasScheme(s)) {
                URI uri = new URI(s);
                path = uri.getPath();
                if (path == null) {
                    path = s;
                }
            } else {
                path = s;
            }
            if (path == null) {
                return null;
            }
            int slash = path.lastIndexOf(47);
            String string = name = slash >= 0 ? path.substring(slash + 1) : path;
            if (name.endsWith(".parquet")) {
                name = name.substring(0, name.length() - ".parquet".length());
            }
            name = ParquetDataSource.trimToNull(name);
            return name;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String deriveRecordTag(String dsId) {
        String s = dsId;
        if (s.endsWith("DS") && s.length() > 2) {
            s = s.substring(0, s.length() - 2);
        }
        if (s.length() == 1) {
            return s.toLowerCase();
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    private static String toSafeIdentifier(String s) {
        if (s == null) {
            return null;
        }
        Object out = s.replaceAll("[^A-Za-z0-9_]", "_");
        if (((String)out).matches("^[0-9].*")) {
            out = "_" + (String)out;
        }
        return out;
    }

    private static String stripLeadingSlashes(String p) {
        if (p == null) {
            return null;
        }
        while (p.startsWith("/")) {
            p = p.substring(1);
        }
        return p;
    }

    private static boolean hasScheme(String s) {
        int colon = s.indexOf(58);
        if (colon <= 0) {
            return false;
        }
        int slash = s.indexOf(47);
        return slash == -1 || colon < slash;
    }

    private static String trimToNull(String s) {
        if (s == null) {
            return null;
        }
        return (s = s.trim()).isEmpty() ? null : s;
    }

    private static String xmlEscape(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
    }

    private static final class ParquetMeta {
        final MessageType schema;
        final long totalRows;

        ParquetMeta(MessageType schema, long totalRows) {
            this.schema = schema;
            this.totalRows = totalRows;
        }
    }

    private static interface ParquetRowVisitor {
        public void visit(Group var1) throws Exception;
    }

    private static final class NumericFilter {
        final Kind kind;
        final String op;
        final Double a;
        final Double b;

        NumericFilter(String op, Double a) {
            this.kind = Kind.OP;
            this.op = op;
            this.a = a;
            this.b = null;
        }

        NumericFilter(Double a, Double b) {
            this.kind = Kind.RANGE;
            this.op = null;
            this.a = a;
            this.b = b;
        }

        boolean test(double x) {
            if (this.kind == Kind.RANGE) {
                return x >= this.a && x <= this.b;
            }
            switch (this.op) {
                case ">": {
                    return x > this.a;
                }
                case ">=": {
                    return x >= this.a;
                }
                case "<": {
                    return x < this.a;
                }
                case "<=": {
                    return x <= this.a;
                }
                case "==": {
                    return Double.compare(x, this.a) == 0;
                }
            }
            return false;
        }

        static enum Kind {
            OP,
            RANGE;

        }
    }

    private static final class LocalParquetInputFile
    implements InputFile {
        private final File file;

        LocalParquetInputFile(File file) {
            this.file = file;
        }

        public long getLength() throws IOException {
            return Files.size(this.file.toPath());
        }

        public SeekableInputStream newStream() throws IOException {
            final RandomAccessFile raf = new RandomAccessFile(this.file, "r");
            return new AbstractSeekableInputStream(){

                public long getPos() throws IOException {
                    return raf.getFilePointer();
                }

                public void seek(long newPos) throws IOException {
                    raf.seek(newPos);
                }

                public int read() throws IOException {
                    return raf.read();
                }

                public int read(byte[] b, int off, int len) throws IOException {
                    return raf.read(b, off, len);
                }

                public void close() throws IOException {
                    raf.close();
                }
            };
        }
    }

    private static final class HttpParquetInputFile
    implements InputFile {
        private final byte[] data;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HttpParquetInputFile(URL url) throws IOException {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(60000);
            try (InputStream in = conn.getInputStream();){
                int r;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[65536];
                while ((r = in.read(buf)) != -1) {
                    baos.write(buf, 0, r);
                }
                this.data = baos.toByteArray();
            }
            finally {
                conn.disconnect();
            }
        }

        public long getLength() {
            return this.data.length;
        }

        public SeekableInputStream newStream() {
            return new AbstractSeekableInputStream(){
                private final ByteArrayInputStream bais;
                {
                    this.bais = new ByteArrayInputStream(data);
                }

                public long getPos() {
                    return (long)data.length - (long)this.bais.available();
                }

                public void seek(long pos) throws IOException {
                    long skipped;
                    long s;
                    if (pos < 0L || pos > (long)data.length) {
                        throw new IOException("Invalid seek: " + pos);
                    }
                    this.bais.reset();
                    for (skipped = 0L; skipped < pos && (s = this.bais.skip(pos - skipped)) > 0L; skipped += s) {
                    }
                    if (skipped != pos) {
                        throw new IOException("Failed to seek to: " + pos);
                    }
                }

                public int read() {
                    return this.bais.read();
                }

                public int read(byte[] b, int off, int len) {
                    return this.bais.read(b, off, len);
                }

                public void close() throws IOException {
                    this.bais.close();
                }
            };
        }
    }

    public final class CreateSQLDSResult {
        private final String dsId;
        private final String tableName;
        private final String recordTag;
        private final String dataURL;
        private final String dsXmlPath;
        private final String dataXmlPath;
        private final long rowsWritten;

        public CreateSQLDSResult(String dsId, String tableName, String recordTag, String dataURL, String dsXmlPath, String dataXmlPath, long rowsWritten) {
            this.dsId = dsId;
            this.tableName = tableName;
            this.recordTag = recordTag;
            this.dataURL = dataURL;
            this.dsXmlPath = dsXmlPath;
            this.dataXmlPath = dataXmlPath;
            this.rowsWritten = rowsWritten;
        }

        public String getDsId() {
            return this.dsId;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getRecordTag() {
            return this.recordTag;
        }

        public String getDataURL() {
            return this.dataURL;
        }

        public String getDsXmlPath() {
            return this.dsXmlPath;
        }

        public String getDataXmlPath() {
            return this.dataXmlPath;
        }

        public long getRowsWritten() {
            return this.rowsWritten;
        }

        public String toString() {
            return "CreateSQLDSResult{dsId='" + this.dsId + "', tableName='" + this.tableName + "', recordTag='" + this.recordTag + "', dataURL='" + this.dataURL + "', dsXmlPath='" + this.dsXmlPath + "', dataXmlPath='" + this.dataXmlPath + "', rowsWritten=" + this.rowsWritten + "}";
        }
    }

    private static final class SqlDsContext {
        final String dataURL;
        final String dsId;
        final String tableName;
        final String recordTag;
        final String dataFileName;

        SqlDsContext(String dataURL, String dsId, String tableName, String recordTag, String dataFileName) {
            this.dataURL = dataURL;
            this.dsId = dsId;
            this.tableName = tableName;
            this.recordTag = recordTag;
            this.dataFileName = dataFileName;
        }
    }

    public static enum CopyDataFormat {
        XML,
        JSON;

    }

    private static final class ParquetDataFileWriter {
        private final CopyDataFormat format;
        private final String recordTag;
        private final MessageType schema;
        private boolean firstJsonRecord = true;

        private ParquetDataFileWriter(CopyDataFormat format, String recordTag, MessageType schema) {
            this.format = format == null ? CopyDataFormat.XML : format;
            this.recordTag = recordTag;
            this.schema = schema;
        }

        static ParquetDataFileWriter create(CopyDataFormat format, String recordTag, MessageType schema) {
            return new ParquetDataFileWriter(format, recordTag, schema);
        }

        void start(Writer w) throws IOException {
            if (this.format == CopyDataFormat.JSON) {
                w.write("[\n");
                this.firstJsonRecord = true;
            } else {
                w.write("<List>\n\n");
            }
        }

        void writeRecord(Writer w, Group g) throws IOException {
            if (this.format == CopyDataFormat.JSON) {
                if (!this.firstJsonRecord) {
                    w.write(",\n");
                }
                this.firstJsonRecord = false;
                ParquetDataSource.writeJsonRecord(w, this.schema, g);
            } else {
                ParquetDataSource.writeXmlRecord(w, this.recordTag, this.schema, g);
            }
        }

        void finish(Writer w) throws IOException {
            if (w == null) {
                return;
            }
            if (this.format == CopyDataFormat.JSON) {
                w.write("\n]\n");
            } else {
                w.write("\n</List>\n");
            }
        }
    }

    private static abstract class AbstractSeekableInputStream
    extends SeekableInputStream {
        private AbstractSeekableInputStream() {
        }

        public int read(ByteBuffer buf) throws IOException {
            if (!buf.hasRemaining()) {
                return 0;
            }
            if (buf.hasArray()) {
                int off = buf.arrayOffset() + buf.position();
                int len = buf.remaining();
                int r = this.read(buf.array(), off, len);
                if (r > 0) {
                    buf.position(buf.position() + r);
                }
                return r;
            }
            byte[] tmp = new byte[buf.remaining()];
            int r = this.read(tmp, 0, tmp.length);
            if (r > 0) {
                buf.put(tmp, 0, r);
            }
            return r;
        }

        public void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length);
        }

        public void readFully(byte[] b, int off, int len) throws IOException {
            int r;
            for (int n = 0; n < len; n += r) {
                r = this.read(b, off + n, len - n);
                if (r >= 0) continue;
                throw new IOException("EOF while reading fully");
            }
        }

        public void readFully(ByteBuffer buf) throws IOException {
            while (buf.hasRemaining()) {
                int r = this.read(buf);
                if (r >= 0) continue;
                throw new IOException("EOF while reading fully");
            }
        }
    }
}

