/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.DSField;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DSFieldFormula {
    private static Logger log = new Logger(DSFieldFormula.class);
    private static final List<String> timeZoneSensitiveFunctions = new ArrayList(){
        {
            this.add("now");
            this.add("year");
            this.add("month");
            this.add("day");
            this.add("hour");
            this.add("minute");
        }
    };
    private static final Pattern timeZoneSensitivePattern = DSFieldFormula.getPattern("\\b(?:(" + String.join((CharSequence)"|", timeZoneSensitiveFunctions) + "))\\s*\\(");
    private static Map<String, Pattern> patternCache;

    private static void validateReplacementsMap(Map<String, String> replacements) {
        if (replacements != null) {
            for (Map.Entry<String, String> e : replacements.entrySet()) {
                String value;
                if (e.getKey().trim().endsWith("()") || (value = e.getValue().trim()).contains("(")) continue;
                replacements.put(e.getKey(), value + "(");
            }
        }
    }

    private static Pattern getPattern(String patternString) {
        Pattern pattern;
        if (patternCache == null) {
            patternCache = new HashMap<String, Pattern>();
        }
        if ((pattern = patternCache.get(patternString)) == null) {
            pattern = Pattern.compile(patternString, 2);
            patternCache.put(patternString, pattern);
        }
        return pattern;
    }

    public static Pattern createPattern(Map<String, String> replacements) {
        DSFieldFormula.validateReplacementsMap(replacements);
        Object full = "";
        Object open = "";
        for (String key : replacements.keySet()) {
            String func;
            if (key.endsWith("()")) {
                func = key.substring(0, key.indexOf("(")).trim();
                full = (String)full + (((String)full).isEmpty() ? "" : "|") + Pattern.quote(func);
                continue;
            }
            func = key;
            if (key.contains("(")) {
                func = key.substring(0, key.indexOf("(")).trim();
            }
            open = (String)open + (((String)open).isEmpty() ? "" : "|") + Pattern.quote(func);
        }
        return DSFieldFormula.getPattern((String)(((String)full).trim().isEmpty() ? "" : "\\b(?:(" + (String)full + ")\\s*\\(\\s*\\))") + (String)(((String)open).trim().isEmpty() ? "" : "|\\b(?:(" + (String)open + "))\\s*\\("));
    }

    public static String transformFormula(String formula, Pattern pattern, Map<String, String> replacements) {
        Result res = DSFieldFormula.processFormula(formula, pattern, replacements, false);
        return res != null ? res.transformedFormula : null;
    }

    private static Result processFormula(String formula, Pattern pattern, Map<String, String> replacements, boolean justCheck) {
        if (formula == null || formula.isEmpty()) {
            return null;
        }
        if (pattern == null || pattern.pattern().isEmpty()) {
            return null;
        }
        if ((replacements == null || replacements.isEmpty()) && !justCheck) {
            return null;
        }
        if (!pattern.matcher(formula).find()) {
            return null;
        }
        int n = formula.length();
        StringBuilder out = new StringBuilder(n + 16);
        boolean transformed = false;
        int i = 0;
        while (i < n) {
            int end;
            char cj;
            int j;
            char c = formula.charAt(i);
            if (c == '\'') {
                j = i + 1;
                while (j < n) {
                    cj = formula.charAt(j);
                    if (cj == '\'') {
                        if (j + 1 < n && formula.charAt(j + 1) == '\'') {
                            j += 2;
                            continue;
                        }
                        ++j;
                        break;
                    }
                    ++j;
                }
                out.append(formula, i, Math.min(j, n));
                i = Math.min(j, n);
                continue;
            }
            if (c == '\"') {
                j = i + 1;
                while (j < n) {
                    cj = formula.charAt(j);
                    if (cj == '\"') {
                        if (j + 1 < n && formula.charAt(j + 1) == '\"') {
                            j += 2;
                            continue;
                        }
                        ++j;
                        break;
                    }
                    ++j;
                }
                out.append(formula, i, Math.min(j, n));
                i = Math.min(j, n);
                continue;
            }
            int nextQuote = DSFieldFormula.indexOfEither(formula, i, '\'', '\"');
            int n2 = end = nextQuote == -1 ? n : nextQuote;
            if (end > i) {
                CharSequence slice = formula.subSequence(i, end);
                Matcher m = pattern.matcher(slice);
                int last = 0;
                while (m.find()) {
                    if (justCheck) {
                        return new Result(null, true);
                    }
                    transformed = true;
                    out.append(slice, last, m.start());
                    String rep = null;
                    if (m.group(1) != null) {
                        rep = replacements.get(m.group(1).trim().toLowerCase());
                    } else if (m.group(2) != null) {
                        String func = m.group(2);
                        int bracketIndex = func.indexOf("(");
                        if (bracketIndex > 0) {
                            func = func.substring(0, bracketIndex);
                        }
                        rep = replacements.get(func.trim().toLowerCase());
                    }
                    if (rep == null) {
                        rep = m.group();
                    }
                    out.append(rep);
                    last = m.end();
                }
                out.append(slice, last, slice.length());
            }
            i = end;
        }
        if (!transformed) {
            return null;
        }
        return new Result(out.toString(), true);
    }

    private static int indexOfEither(String s, int from, char a, char b) {
        int ia = s.indexOf(a, from);
        int ib = s.indexOf(b, from);
        if (ia == -1) {
            return ib;
        }
        if (ib == -1) {
            return ia;
        }
        return Math.min(ia, ib);
    }

    public static boolean isFormulaTimeZoneSensitive(DSField field) {
        if (field != null) {
            Result res = DSFieldFormula.processFormula(field.getString("formula"), timeZoneSensitivePattern, null, true);
            return res != null && res.matches;
        }
        return false;
    }

    private static class Result {
        String transformedFormula;
        boolean matches;

        Result(String t, boolean m) {
            this.transformedFormula = t;
            this.matches = m;
        }
    }
}

