/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import org.hibernate.collection.spi.PersistentArrayHolder;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class CollectionAssembler
implements DomainResultAssembler {
    private final PluralAttributeMapping fetchedMapping;
    protected final CollectionInitializer initializer;

    public CollectionAssembler(PluralAttributeMapping fetchedMapping, CollectionInitializer initializer) {
        this.fetchedMapping = fetchedMapping;
        this.initializer = initializer;
    }

    public Object assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        PersistentCollection<?> collectionInstance = this.initializer.getCollectionInstance();
        if (collectionInstance instanceof PersistentArrayHolder) {
            return collectionInstance.getValue();
        }
        return collectionInstance;
    }

    public JavaType<?> getAssembledJavaType() {
        return this.fetchedMapping.getJavaType();
    }

    @Override
    public CollectionInitializer getInitializer() {
        return this.initializer;
    }
}

