/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExcelFormulaParser {
    private static Logger log = new Logger(ExcelFormulaParser.class.getName());
    private static final Map<String, FormulaTransformer> formulaTransformers = new HashMap<String, FormulaTransformer>();

    public static void main(String[] args) throws Exception {
        String formula = "round(\"ceil(A)/2\"+\")\" + (ceil(floor(CAB)) + round(2)) % ceil(1) + 1*round(C-2)) + log(1,2) round(random() + 2 +param3   -    param4)";
        System.out.println("before: " + formula);
        String result = ExcelFormulaParser.transform(formula);
        System.out.println("after: " + result);
    }

    public static String transform(String formula) {
        String result = formula;
        for (String key : formulaTransformers.keySet()) {
            FormulaTransformer transformer = formulaTransformers.get(key);
            try {
                result = transformer.transform(result);
            }
            catch (Exception ex) {
                log.warn((Object)("Excel formula transformer '" + transformer.getName() + "' failed."), ex);
            }
        }
        return result;
    }

    private static int find(String formula, String search) {
        return ExcelFormulaParser.find(formula, search, 0, false);
    }

    private static int find(String formula, String search, int startIndex) {
        return ExcelFormulaParser.find(formula, search, startIndex, false);
    }

    private static int find(String formula, String search, int startIndex, boolean ignoreBrackets) {
        return ExcelFormulaParser.find(formula, search, startIndex, ignoreBrackets, false);
    }

    private static int find(String formula, String search, int startIndex, boolean ignoreBrackets, boolean inverted) {
        return ExcelFormulaParser.find(formula, new String[]{search}, startIndex, ignoreBrackets, inverted);
    }

    private static int find(String formula, String[] search, int startIndex, boolean ignoreBrackets, boolean inverted) {
        int i;
        int retValue = -1;
        boolean inString = false;
        int openedBrackets = 0;
        int n = i = inverted ? startIndex : 0;
        while (inverted ? i >= 0 : i < formula.length()) {
            String s;
            if (!inString && openedBrackets == 0 && (inverted && i >= 0 || !inverted && i >= startIndex)) {
                for (String searchItem : search) {
                    String word = formula.substring(i, Math.min(formula.length(), i + searchItem.length()));
                    if (!searchItem.equals(word)) continue;
                    retValue = i;
                    return retValue;
                }
            }
            if ("\"".equals(s = formula.substring(i, i + 1))) {
                inString = !inString;
            } else if (!ignoreBrackets && !inString && "(".equals(s) && (inverted && i >= 0 || !inverted && i >= startIndex)) {
                openedBrackets = inverted ? --openedBrackets : ++openedBrackets;
            } else if (!ignoreBrackets && !inString && ")".equals(s) && (inverted && i >= 0 || !inverted && i >= startIndex)) {
                openedBrackets = inverted ? ++openedBrackets : --openedBrackets;
            }
            i = inverted ? i - 1 : i + 1;
        }
        return retValue;
    }

    private static List<String> getParams(String formula, int start, int end) throws Exception {
        int paramFrom = start + 1;
        int paramTo = ExcelFormulaParser.find(formula, ",", paramFrom);
        ArrayList<String> params = new ArrayList<String>();
        while (true) {
            String param;
            if (paramTo > end || paramTo == -1) {
                param = formula.substring(paramFrom, end);
                if (param.startsWith(",")) {
                    param = param.substring(1);
                }
                params.add(param);
                break;
            }
            if (paramTo == -1) break;
            param = formula.substring(paramFrom, paramTo);
            if (param.startsWith(",")) {
                param = param.substring(1);
            }
            params.add(param);
            paramFrom = paramTo + 1;
            paramTo = ExcelFormulaParser.find(formula, ",", paramFrom);
        }
        if (start < 0 || end < 0) {
            throw new Exception("Formula parsing error");
        }
        return params;
    }

    public static void addFormulaTransformer(FormulaTransformer transformer) {
        formulaTransformers.put(transformer.getName(), transformer);
    }

    static {
        ExcelFormulaParser.addFormulaTransformer(new Round());
        ExcelFormulaParser.addFormulaTransformer(new Ceil());
        ExcelFormulaParser.addFormulaTransformer(new Floor());
        ExcelFormulaParser.addFormulaTransformer(new Log());
        ExcelFormulaParser.addFormulaTransformer(new Mod());
        ExcelFormulaParser.addFormulaTransformer(new Random());
        ExcelFormulaParser.addFormulaTransformer(new Power());
        ExcelFormulaParser.addFormulaTransformer(new Increment());
        ExcelFormulaParser.addFormulaTransformer(new Decrement());
    }

    public static interface FormulaTransformer {
        public String getName();

        public String transform(String var1) throws Exception;
    }

    static class Round
    extends AddParameter {
        public Round() {
            super("round", "0", 2);
        }
    }

    static class Ceil
    extends AddParameter {
        public Ceil() {
            super("ceil", "1", 2);
        }
    }

    static class Floor
    extends AddParameter {
        public Floor() {
            super("floor", "1", 2);
        }
    }

    static class Log
    extends AbstractFormulaTransformer {
        Log() {
            super("log");
        }

        @Override
        public void transformRecursive(String formula, int startIndex) throws Exception {
            int end;
            int formulaIndex = ExcelFormulaParser.find(formula.toLowerCase(), this.name, startIndex, true);
            if (formulaIndex == -1) {
                return;
            }
            int start = ExcelFormulaParser.find(formula, "(", formulaIndex);
            List<String> params = ExcelFormulaParser.getParams(formula, start, end = ExcelFormulaParser.find(formula, ")", start + 1));
            if (params.size() != 2) {
                throw new Exception("\"log\" function should have 2 parameters, but instead " + params.size() + " parameter(s) detected. Skipping conversion to Excel formula format.");
            }
            String replacement = "(" + params.get(1) + "," + params.get(0) + ")";
            this.newFormula = formula.substring(0, start) + replacement + formula.substring(end + 1);
            this.transformRecursive(this.newFormula, formulaIndex + this.name.length());
        }
    }

    static class Mod
    extends AbstractFormulaTransformer {
        public Mod() {
            super("%");
        }

        @Override
        public void transformRecursive(String formula, int startIndex) throws Exception {
            int formulaIndex = ExcelFormulaParser.find(formula.toLowerCase(), this.name, startIndex, true);
            if (formulaIndex <= 0) {
                return;
            }
            int start = ExcelFormulaParser.find(formula, new String[]{"%", "+", "-", "*", ",", "("}, formulaIndex - 1, false, true);
            int end = ExcelFormulaParser.find(formula, new String[]{"%", "+", "-", "*", ",", ")"}, formulaIndex + 1, false, false);
            if (end == -1) {
                end = formula.length();
            }
            String param1 = formula.substring(start + 1, formulaIndex);
            String param2 = formula.substring(formulaIndex + 1, end);
            this.newFormula = formula.substring(0, start + 1) + "mod(" + param1 + "," + param2 + ")" + formula.substring(end);
            this.transformRecursive(this.newFormula, 0);
        }
    }

    static class Random
    extends Rename {
        public Random() {
            super("random", "rand");
        }
    }

    static class Power
    extends Rename {
        public Power() {
            super("pow", "power");
        }
    }

    static class Increment
    extends Rename {
        public Increment() {
            super("++", "+1");
        }
    }

    static class Decrement
    extends Rename {
        public Decrement() {
            super("--", "-1");
        }
    }

    static abstract class AddParameter
    extends AbstractFormulaTransformer {
        String addParamValue = null;
        int paramCount;

        AddParameter(String name, String addParamValue, int paramCount) {
            super(name);
            this.addParamValue = addParamValue;
            this.paramCount = paramCount;
        }

        @Override
        public void transformRecursive(String formula, int startIndex) throws Exception {
            int end;
            int formulaIndex = ExcelFormulaParser.find(formula.toLowerCase(), this.name, startIndex, true);
            if (formulaIndex == -1) {
                return;
            }
            int start = ExcelFormulaParser.find(formula, "(", formulaIndex);
            List<String> params = ExcelFormulaParser.getParams(formula, start, end = ExcelFormulaParser.find(formula, ")", start + 1));
            if (params.size() < this.paramCount) {
                String replacement = null;
                for (String param : params) {
                    if (replacement == null) {
                        replacement = "(" + param;
                        continue;
                    }
                    replacement = (String)replacement + "," + param;
                }
                replacement = replacement + "," + this.addParamValue + ")";
                this.newFormula = formula.substring(0, start) + replacement + formula.substring(end + 1);
            } else {
                this.newFormula = formula;
            }
            this.transformRecursive(this.newFormula, formulaIndex + this.name.length());
        }
    }

    static abstract class Rename
    extends AbstractFormulaTransformer {
        String newName;

        Rename(String name, String newName) {
            super(name);
            this.newName = newName;
        }

        @Override
        public void transformRecursive(String formula, int startIndex) throws Exception {
            int formulaIndex = ExcelFormulaParser.find(formula.toLowerCase(), this.name, startIndex, true);
            if (formulaIndex == -1) {
                return;
            }
            if (this.newName.startsWith(this.name) && this.newName.equals(formula.substring(formulaIndex, formulaIndex + this.newName.length()))) {
                this.transformRecursive(formula, formulaIndex + this.name.length());
                return;
            }
            this.newFormula = formula.substring(0, formulaIndex) + this.newName + formula.substring(formulaIndex + this.name.length());
            this.transformRecursive(this.newFormula, formulaIndex + this.name.length());
        }
    }

    static abstract class AbstractFormulaTransformer
    implements FormulaTransformer {
        String newFormula = null;
        String name = null;

        public AbstractFormulaTransformer(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public abstract void transformRecursive(String var1, int var2) throws Exception;

        @Override
        public String transform(String formula) throws Exception {
            try {
                this.transformRecursive(formula, 0);
                String string = this.newFormula != null ? this.newFormula : formula;
                return string;
            }
            finally {
                this.newFormula = null;
            }
        }
    }
}

