/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DSTransaction;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.hibernate.HibernateDSGenerator;
import com.isomorphic.jpa.JPADSGenerator;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDSGenerator;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLTransaction;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DataSourceTools
extends Base {
    public static Map getDataSourceConfigFromTable(String tableName, String schema, String serverType, String dbName, String timestampType, boolean returnSQLTypes) throws Exception {
        if ("hibernate".equals(serverType)) {
            return HibernateDSGenerator.getConfigFromTable((String)tableName, (String)schema);
        }
        SQLDSGenerator gen = new SQLDSGenerator(tableName, schema, dbName, serverType, timestampType, returnSQLTypes);
        return gen.generate();
    }

    public static Map getDataSourceConfigFromHibernateMapping(String entityName) throws Exception {
        return HibernateDSGenerator.getConfigFromMapping((String)entityName, null, (boolean)false, (boolean)false);
    }

    public static Map getDataSourceConfigFromJPAClass(String className) throws Exception {
        return JPADSGenerator.getDataSourceConfigFromJPAClass((String)className, (boolean)false);
    }

    public static Object getDataSourceConfigFromJavaClass(String className) throws Exception {
        return DataSourceTools._getDataSourceConfigFromJavaClass(className);
    }

    static Object _getDataSourceConfigFromJavaClass(String className) throws Exception {
        Class c = Reflection.classForName((String)className);
        if (c == null) {
            Package p = Package.getPackage(className);
            if (p == null) {
                return "Package not found for Class: " + className;
            }
            return "Class not found: " + className;
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("ID", className.substring(className.lastIndexOf(46) + 1));
        config.put("dataSourceVersion", String.valueOf(1));
        config.put("serverType", "generic");
        config.put("beanClassName", className);
        config.put("xmlFromConfig", "true");
        Config iscConfig = Config.getGlobal();
        if (iscConfig != null) {
            String version = iscConfig.getString((Object)"iscVersion") + " " + iscConfig.getString((Object)"iscPackageDate");
            config.put("generatedBy", version);
        }
        List fields = Reflection.getBeanFields((String)className);
        config.put("fields", fields);
        return config;
    }

    public static CopyDataSourceResult copyRecords(String sourceDS, String targetDS, CopyOptions options) throws Exception {
        if (sourceDS == null || sourceDS.trim().isEmpty()) {
            return CopyDataSourceResult.empty("sourceDS is required");
        }
        if (targetDS == null || targetDS.trim().isEmpty()) {
            return CopyDataSourceResult.empty("targetDS is required");
        }
        DataSource s = DataSourceManager.getDataSource((String)sourceDS);
        if (s == null) {
            throw new Exception("Source DataSource " + sourceDS + " not found.");
        }
        DataSource t = DataSourceManager.getDataSource((String)targetDS);
        if (t == null) {
            throw new Exception("Target DataSource " + targetDS + " not found.");
        }
        return DataSourceTools.copyRecords(s, t, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CopyDataSourceResult copyRecords(DataSource sourceDS, DataSource targetDS, CopyOptions options) throws Exception {
        Logger log = new Logger(DataSourceTools.class.getName());
        Objects.requireNonNull(sourceDS, "sourceDS");
        Objects.requireNonNull(targetDS, "targetDS");
        if (options == null) {
            options = new CopyOptions();
        }
        int pageSize = options.pageSize == null || options.pageSize <= 0 ? 500 : options.pageSize;
        TransactionMode txMode = options.transactionMode == null ? TransactionMode.NONE : options.transactionMode;
        boolean stopOnError = Boolean.TRUE.equals(options.stopOnError);
        boolean streamResults = options.streamResults == null ? true : options.streamResults;
        log.info((Object)("copyRecords: source=" + sourceDS.getID() + ", target=" + targetDS.getID() + ", txMode=" + String.valueOf((Object)txMode) + ", pageSize=" + pageSize + ", streamResults=" + streamResults + ", targetDS type: " + targetDS.getClass().getName()));
        HashSet<String> targetFieldNames = new HashSet<String>();
        List tFields = targetDS.getFields();
        if (tFields != null) {
            for (DSField f : tFields) {
                if (f == null || f.getName() == null) continue;
                targetFieldNames.add(f.getName());
            }
        }
        int startRow = 0;
        long fetched = 0L;
        long inserted = 0L;
        int fetchCalls = 0;
        ArrayList<CopyDataSourceResult.RowFailure> failures = new ArrayList<CopyDataSourceResult.RowFailure>();
        TransactionSupport.TxContext txAll = null;
        if (txMode == TransactionMode.ALL) {
            log.info((Object)"Starting ALL transaction for entire copy operation");
            txAll = TransactionSupport.begin(targetDS, log);
            log.info((Object)("ALL transaction created: " + (String)(txAll != null ? "success, started=" + txAll.started : "null")));
        } else {
            log.info((Object)("TransactionMode is " + String.valueOf((Object)txMode) + ", no ALL transaction will be created"));
        }
        try {
            long endRow;
            long totalRows;
            do {
                log.debug((Object)("Fetching batch starting at row " + startRow));
                DSRequest fetchReq = new DSRequest(sourceDS.getID(), "fetch");
                fetchReq.setStartRow((long)startRow);
                fetchReq.setEndRow((long)(startRow + pageSize));
                fetchReq.setStreamResults(streamResults);
                DSResponse fetchRes = fetchReq.execute();
                log.debug((Object)("Fetch call #" + ++fetchCalls + " completed, status=" + fetchRes.getStatus()));
                if (fetchRes.getStatus() != 0) {
                    throw new Exception("Fetch failed from " + sourceDS.getID() + " status=" + fetchRes.getStatus() + " errors=" + String.valueOf(fetchRes.getErrors()));
                }
                List rows = fetchRes.getDataList();
                if (rows == null || rows.isEmpty()) {
                    log.info((Object)"No more rows to fetch, ending copy operation");
                    break;
                }
                log.info((Object)("Fetched " + rows.size() + " rows in this batch"));
                TransactionSupport.TxContext txBatch = null;
                if (txMode == TransactionMode.PER_BATCH) {
                    log.info((Object)("Starting PER_BATCH transaction for batch starting at row " + startRow));
                    txBatch = TransactionSupport.begin(targetDS, log);
                    log.info((Object)("PER_BATCH transaction created: " + (String)(txBatch != null ? "success, started=" + txBatch.started : "null")));
                }
                boolean batchFailed = false;
                try {
                    for (Map row : rows) {
                        Map<String, Object> values = DataSourceTools.filterToTargetFields(row, targetFieldNames);
                        log.debug((Object)("Processing row #" + ++fetched + ", filtered fields: " + String.valueOf(values.keySet())));
                        DSRequest addReq = new DSRequest(targetDS.getID(), "add");
                        addReq.setValues(values);
                        if (txAll != null) {
                            TransactionSupport.attach(addReq, txAll, log);
                            log.debug((Object)("Attached ALL transaction to add request for row #" + fetched));
                        }
                        if (txBatch != null) {
                            TransactionSupport.attach(addReq, txBatch, log);
                            log.debug((Object)("Attached PER_BATCH transaction to add request for row #" + fetched));
                        }
                        if (txAll == null && txBatch == null) {
                            log.debug((Object)("No transaction attached (NONE mode) for row #" + fetched));
                        }
                        DSResponse addRes = addReq.execute();
                        log.debug((Object)("Add request for row #" + fetched + " completed, status=" + addRes.getStatus()));
                        if (addRes.getStatus() == 0) {
                            log.debug((Object)("Row #" + fetched + " inserted successfully (total inserted: " + ++inserted + ")"));
                            continue;
                        }
                        log.warn((Object)("Row #" + fetched + " failed to insert, status=" + addRes.getStatus() + ", errors=" + String.valueOf(addRes.getErrors())));
                        failures.add(new CopyDataSourceResult.RowFailure(fetched, addRes.getStatus(), addRes.getErrors()));
                        batchFailed = true;
                        if (!stopOnError) continue;
                        log.info((Object)"stopOnError is true, breaking on first failure");
                        break;
                    }
                }
                finally {
                    if (txBatch != null) {
                        if (batchFailed || stopOnError && !failures.isEmpty()) {
                            log.info((Object)("Rolling back PER_BATCH transaction (batchFailed=" + batchFailed + ", failures=" + failures.size() + ")"));
                            TransactionSupport.rollback(txBatch, log);
                        } else {
                            log.info((Object)("Committing PER_BATCH transaction (inserted " + (fetched - (long)startRow) + " rows in this batch)"));
                            TransactionSupport.commit(txBatch, log);
                        }
                    } else {
                        log.debug((Object)("No PER_BATCH transaction to commit/rollback (mode is " + String.valueOf((Object)txMode) + ")"));
                    }
                }
                if (stopOnError && !failures.isEmpty()) break;
                startRow += rows.size();
                totalRows = fetchRes.getTotalRows();
                endRow = fetchRes.getEndRow();
            } while (totalRows < 0L || endRow < totalRows);
            if (txAll != null) {
                if (!failures.isEmpty() && stopOnError) {
                    log.info((Object)("Rolling back ALL transaction due to stopOnError with failures (" + failures.size() + " failures)"));
                    TransactionSupport.rollback(txAll, log);
                } else if (!failures.isEmpty() && txMode == TransactionMode.ALL) {
                    log.info((Object)("Rolling back ALL transaction due to failures in ALL mode (" + failures.size() + " failures)"));
                    TransactionSupport.rollback(txAll, log);
                } else {
                    log.info((Object)("Committing ALL transaction (inserted " + inserted + " rows total)"));
                    TransactionSupport.commit(txAll, log);
                }
            } else {
                log.info((Object)("No ALL transaction to commit (mode is " + String.valueOf((Object)txMode) + ", total inserted: " + inserted + ")"));
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception during copyRecords: " + e.getMessage()), (Throwable)e);
            if (txAll != null) {
                log.info((Object)"Rolling back ALL transaction due to exception");
                try {
                    TransactionSupport.rollback(txAll, log);
                }
                catch (Exception ignore) {
                    log.error((Object)("Failed to rollback ALL transaction: " + ignore.getMessage()));
                }
            }
            throw e;
        }
        CopyDataSourceResult result = new CopyDataSourceResult(sourceDS.getID(), targetDS.getID(), fetched, inserted, fetchCalls, failures);
        log.info((Object)("copyRecords completed: fetched=" + fetched + ", inserted=" + inserted + ", failures=" + failures.size()));
        return result;
    }

    private static Map<String, Object> filterToTargetFields(Map<String, Object> row, Set<String> targetFields) {
        if (row == null) {
            return new LinkedHashMap<String, Object>();
        }
        if (targetFields == null || targetFields.isEmpty()) {
            return new LinkedHashMap<String, Object>(row);
        }
        LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> e : row.entrySet()) {
            String k = e.getKey();
            if (k == null || !targetFields.contains(k)) continue;
            out.put(k, e.getValue());
        }
        return out;
    }

    public static ExportRecordsResult exportRecords(String dsId, Writer writer, ExportFormat format, String recordTag, Integer maxRows, Integer pageSize) throws Exception {
        if (dsId == null || dsId.trim().isEmpty()) {
            throw new IllegalArgumentException("dsId is required");
        }
        DataSource ds = DataSourceManager.getDataSource((String)dsId);
        if (ds == null) {
            throw new Exception("DataSource " + dsId + " not found.");
        }
        return DataSourceTools.exportRecords(ds, writer, format, recordTag, maxRows, pageSize);
    }

    public static ExportRecordsResult exportRecords(DataSource ds, Writer writer, ExportFormat format, String recordTag, Integer maxRows, Integer pageSize) throws Exception {
        Objects.requireNonNull(ds, "ds");
        Objects.requireNonNull(writer, "writer");
        if (format == null) {
            format = ExportFormat.XML;
        }
        if (recordTag == null) {
            recordTag = DataSourceTools.deriveRecordTag(ds.getID());
        }
        long limit = maxRows == null || maxRows < 0 ? -1L : maxRows.longValue();
        int pSize = pageSize == null || pageSize <= 0 ? 500 : pageSize;
        long written = 0L;
        int fetchCalls = 0;
        int startRow = 0;
        if (format == ExportFormat.JSON) {
            writer.write("[\n");
        } else {
            writer.write("<List>\n\n");
        }
        boolean firstJson = true;
        while (limit < 0L || written < limit) {
            DSRequest fetchReq = new DSRequest(ds.getID(), "fetch");
            fetchReq.setStartRow((long)startRow);
            fetchReq.setEndRow((long)(startRow + pSize));
            DSResponse fetchRes = fetchReq.execute();
            ++fetchCalls;
            if (fetchRes.getStatus() != 0) {
                throw new Exception("Fetch failed from " + ds.getID() + " status=" + fetchRes.getStatus() + " errors=" + String.valueOf(fetchRes.getErrors()));
            }
            List rows = fetchRes.getDataList();
            if (rows == null || rows.isEmpty()) break;
            for (Map row : rows) {
                if (limit >= 0L && written >= limit) break;
                if (format == ExportFormat.JSON) {
                    if (!firstJson) {
                        writer.write(",\n");
                    }
                    firstJson = false;
                    DataSourceTools.writeJsonObject(writer, row);
                } else {
                    DataSourceTools.writeXmlRecord(writer, recordTag, row);
                }
                ++written;
            }
            startRow += rows.size();
            long totalRows = fetchRes.getTotalRows();
            long endRow = fetchRes.getEndRow();
            if (totalRows < 0L || endRow < totalRows) continue;
            break;
        }
        if (format == ExportFormat.JSON) {
            writer.write("\n]\n");
        } else {
            writer.write("\n</List>\n");
        }
        writer.flush();
        return new ExportRecordsResult(ds.getID(), format, written, fetchCalls);
    }

    public static ExportDataSourceResult exportRecordsToFile(String dsId, ExportOptions options) throws Exception {
        if (dsId == null || dsId.trim().isEmpty()) {
            throw new IllegalArgumentException("dsId is required");
        }
        DataSource ds = DataSourceManager.getDataSource((String)dsId);
        if (ds == null) {
            throw new Exception("DataSource " + dsId + " not found.");
        }
        return DataSourceTools.exportRecordsToFile(ds, options);
    }

    public static ExportDataSourceResult exportRecordsToFile(DataSource ds, ExportOptions options) throws Exception {
        String recordTag;
        String baseName;
        File outDir;
        Objects.requireNonNull(ds, "ds");
        if (options == null) {
            options = new ExportOptions();
        }
        ExportFormat format = options.format != null ? options.format : ExportFormat.XML;
        Object wr = Config.getGlobal().get((Object)"webRoot");
        String webRoot = DataSourceTools.trimToNull(wr == null ? null : String.valueOf(wr));
        if (webRoot == null) {
            throw new IllegalStateException("Config webRoot is not set; cannot export DataSource to file");
        }
        String outDirRel = DataSourceTools.trimToNull(options.outputRelDir);
        if (outDirRel == null) {
            outDirRel = "examples/shared/ds/test_data";
        }
        if (!(outDir = new File(new File(webRoot), DataSourceTools.stripLeadingSlashes(outDirRel))).exists() && !outDir.mkdirs()) {
            throw new Exception("Failed to create output dir: " + outDir.getAbsolutePath());
        }
        String dsId = DataSourceTools.trimToNull(ds.getID());
        if (dsId == null) {
            dsId = "DataSourceExport";
        }
        if ((baseName = DataSourceTools.trimToNull(options.fileBaseName)) == null) {
            baseName = dsId;
        }
        if ((recordTag = DataSourceTools.trimToNull(options.recordTag)) == null) {
            recordTag = DataSourceTools.deriveRecordTag(dsId);
        }
        String ext = format == ExportFormat.JSON ? ".json" : ".data.xml";
        File outFile = new File(outDir, baseName + ext);
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), StandardCharsets.UTF_8));){
            ExportRecordsResult coreResult = DataSourceTools.exportRecords(ds, (Writer)w, format, recordTag, options.maxRows, options.pageSize);
            ExportDataSourceResult exportDataSourceResult = new ExportDataSourceResult(coreResult.dataSourceId, coreResult.format, outDir.getAbsolutePath(), outFile.getAbsolutePath(), coreResult.rowsWritten, coreResult.fetchCalls);
            return exportDataSourceResult;
        }
    }

    public static void writeXmlRecord(Writer w, String recordTag, Map<String, Object> row) throws Exception {
        w.write("<");
        w.write(DataSourceTools.xmlEscape(recordTag));
        w.write(">\n");
        if (row != null) {
            for (Map.Entry<String, Object> e : row.entrySet()) {
                String name = e.getKey();
                if (name == null) continue;
                w.write("  <");
                w.write(DataSourceTools.xmlEscape(name));
                w.write(">");
                Object val = e.getValue();
                if (val != null) {
                    w.write(DataSourceTools.xmlEscape(String.valueOf(val)));
                }
                w.write("</");
                w.write(DataSourceTools.xmlEscape(name));
                w.write(">\n");
            }
        }
        w.write("</");
        w.write(DataSourceTools.xmlEscape(recordTag));
        w.write(">\n\n");
    }

    public static void writeJsonObject(Writer w, Map<String, Object> row) throws Exception {
        w.write("{");
        boolean first = true;
        if (row != null) {
            for (Map.Entry<String, Object> e : row.entrySet()) {
                String k = e.getKey();
                if (k == null) continue;
                if (!first) {
                    w.write(",");
                }
                first = false;
                w.write("\"");
                w.write(DataSourceTools.jsonEscape(k));
                w.write("\":");
                Object v = e.getValue();
                w.write(DataSourceTools.toJsonValue(v));
            }
        }
        w.write("}");
    }

    private static String toJsonValue(Object v) {
        if (v == null) {
            return "null";
        }
        if (v instanceof Number || v instanceof Boolean) {
            return String.valueOf(v);
        }
        return "\"" + DataSourceTools.jsonEscape(String.valueOf(v)) + "\"";
    }

    private static String xmlEscape(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
    }

    private static String jsonEscape(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\r", "\\r").replace("\n", "\\n").replace("\t", "\\t");
    }

    private static String trimToNull(String s) {
        if (s == null) {
            return null;
        }
        return (s = s.trim()).isEmpty() ? null : s;
    }

    private static String stripLeadingSlashes(String s) {
        if (s == null) {
            return null;
        }
        while (s.startsWith("/") || s.startsWith("\\")) {
            s = s.substring(1);
        }
        return s;
    }

    private static String deriveRecordTag(String dsId) {
        if (dsId == null) {
            return "record";
        }
        String s = dsId;
        if (s.endsWith("DS")) {
            s = s.substring(0, s.length() - 2);
        }
        if (s.endsWith("SQL")) {
            s = s.substring(0, s.length() - 3);
        }
        if (s.isEmpty()) {
            return "record";
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static final class CopyDataSourceResult {
        public final String sourceId;
        public final String targetId;
        public final long rowsFetched;
        public final long rowsInserted;
        public final int fetchCalls;
        public final List<RowFailure> failures;

        public CopyDataSourceResult(String sourceId, String targetId, long rowsFetched, long rowsInserted, int fetchCalls, List<RowFailure> failures) {
            this.sourceId = sourceId;
            this.targetId = targetId;
            this.rowsFetched = rowsFetched;
            this.rowsInserted = rowsInserted;
            this.fetchCalls = fetchCalls;
            this.failures = failures != null ? Collections.unmodifiableList(new ArrayList<RowFailure>(failures)) : Collections.emptyList();
        }

        public static CopyDataSourceResult empty(String reason) {
            return new CopyDataSourceResult(null, null, 0L, 0L, 0, List.of(new RowFailure(0L, -1, Map.of("reason", reason))));
        }

        public static final class RowFailure {
            public final long rowNumber;
            public final int status;
            public final Object errors;

            public RowFailure(long rowNumber, int status, Object errors) {
                this.rowNumber = rowNumber;
                this.status = status;
                this.errors = errors;
            }
        }
    }

    public static final class CopyOptions {
        public Integer pageSize;
        public TransactionMode transactionMode;
        public Boolean stopOnError;
        public Boolean streamResults;

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public void setTransactionMode(TransactionMode mode) {
            this.transactionMode = mode;
        }

        public void setStopOnError(Boolean stopOnError) {
            this.stopOnError = stopOnError;
        }

        public void setStreamResults(Boolean streamResults) {
            this.streamResults = streamResults;
        }
    }

    public static enum TransactionMode {
        NONE,
        PER_BATCH,
        ALL;

    }

    private static final class TransactionSupport {
        private TransactionSupport() {
        }

        static TxContext begin(DataSource targetDS, Logger log) throws Exception {
            if (targetDS == null) {
                if (log != null) {
                    log.warn((Object)"begin() called with null targetDS");
                }
                return null;
            }
            DSTransaction tx = new DSTransaction();
            if (log != null) {
                log.debug((Object)("Created new DSTransaction: " + String.valueOf(tx)));
            }
            if (targetDS instanceof SQLDataSource) {
                String dbName;
                SQLDataSource sqlDS;
                block30: {
                    block29: {
                        Object v;
                        DataTypeMap cfg;
                        block28: {
                            block27: {
                                sqlDS = (SQLDataSource)targetDS;
                                if (log != null) {
                                    log.debug((Object)"Target is SQLDataSource, will start SQL transaction");
                                }
                                dbName = null;
                                try {
                                    dbName = (String)sqlDS.getClass().getMethod("getDbName", new Class[0]).invoke((Object)sqlDS, new Object[0]);
                                    if (log != null) {
                                        log.debug((Object)("Got dbName from getDbName(): " + dbName));
                                    }
                                }
                                catch (Throwable t) {
                                    if (log == null) break block27;
                                    log.debug((Object)("getDbName() method not available or failed: " + t.getMessage()));
                                }
                            }
                            if (dbName == null) {
                                try {
                                    cfg = sqlDS.getConfig();
                                    if (cfg instanceof Map && (v = ((Map)cfg).get("dbName")) != null) {
                                        dbName = String.valueOf(v);
                                        if (log != null) {
                                            log.debug((Object)("Got dbName from config.dbName: " + dbName));
                                        }
                                    }
                                }
                                catch (Throwable t) {
                                    if (log == null) break block28;
                                    log.debug((Object)("Failed to get dbName from config.dbName: " + t.getMessage()));
                                }
                            }
                        }
                        if (dbName == null) {
                            try {
                                cfg = sqlDS.getConfig();
                                if (cfg instanceof Map && (v = ((Map)cfg).get("database")) != null) {
                                    dbName = String.valueOf(v);
                                    if (log != null) {
                                        log.debug((Object)("Got dbName from config.database: " + dbName));
                                    }
                                }
                            }
                            catch (Throwable t) {
                                if (log == null) break block29;
                                log.debug((Object)("Failed to get dbName from config.database: " + t.getMessage()));
                            }
                        }
                    }
                    if (dbName == null) {
                        try {
                            Object db = sqlDS.getClass().getMethod("getDatabase", new Class[0]).invoke((Object)sqlDS, new Object[0]);
                            if (db != null) {
                                dbName = String.valueOf(db);
                                if (log != null) {
                                    log.debug((Object)("Got dbName from getDatabase(): " + dbName));
                                }
                            }
                        }
                        catch (Throwable t) {
                            if (log == null) break block30;
                            log.debug((Object)("getDatabase() method not available or failed: " + t.getMessage()));
                        }
                    }
                }
                if (dbName == null && log != null) {
                    log.warn((Object)("Could not determine dbName for SQLDataSource " + targetDS.getID() + ". Transaction may not work correctly. Config: " + String.valueOf(sqlDS.getConfig())));
                }
                if (log != null) {
                    log.info((Object)("Starting SQL transaction with dbName=" + dbName));
                }
                boolean started = SQLTransaction.startTransaction((DSTransaction)tx, (String)dbName);
                if (log != null) {
                    log.info((Object)("SQLTransaction.startTransaction returned: " + started));
                }
                return new TxContext(tx, dbName, started);
            }
            if (log != null) {
                log.info((Object)("Target is non-SQL DataSource (" + targetDS.getClass().getName() + "), transaction support may be limited"));
            }
            return new TxContext(tx, null, false);
        }

        static void attach(DSRequest req, TxContext ctx, Logger log) {
            if (req == null || ctx == null || ctx.dsTransaction == null) {
                if (log != null && req != null) {
                    log.debug((Object)"Cannot attach transaction: ctx or dsTransaction is null");
                }
                return;
            }
            req.setDSTransaction(ctx.dsTransaction);
            if (log != null) {
                log.debug((Object)("Attached DSTransaction to request: " + String.valueOf(ctx.dsTransaction)));
            }
        }

        static void commit(TxContext ctx, Logger log) throws Exception {
            block13: {
                if (ctx == null || ctx.dsTransaction == null) {
                    if (log != null) {
                        log.warn((Object)"commit() called with null ctx or dsTransaction");
                    }
                    return;
                }
                if (log != null) {
                    log.info((Object)("Committing transaction, dbName=" + ctx.dbName + ", started=" + ctx.started));
                }
                try {
                    if (ctx.dbName != null) {
                        SQLTransaction.commitTransaction((DSTransaction)ctx.dsTransaction, (String)ctx.dbName);
                        if (log != null) {
                            log.info((Object)("SQLTransaction.commitTransaction completed for dbName=" + ctx.dbName));
                        }
                        break block13;
                    }
                    SQLTransaction.commitTransaction((DSTransaction)ctx.dsTransaction);
                    if (log != null) {
                        log.info((Object)"SQLTransaction.commitTransaction(dsTransaction) completed");
                    }
                    try {
                        SQLTransaction.endTransaction((DSTransaction)ctx.dsTransaction);
                        if (log != null) {
                            log.info((Object)"SQLTransaction.endTransaction completed");
                        }
                    }
                    catch (Exception e) {
                        if (log != null) {
                            log.warn((Object)("Failed to end transaction: " + e.getMessage()));
                        }
                    }
                }
                catch (Exception e) {
                    if (log != null) {
                        log.error((Object)("Error during commit: " + e.getMessage()), (Throwable)e);
                    }
                    throw e;
                }
            }
        }

        static void rollback(TxContext ctx, Logger log) throws Exception {
            block13: {
                if (ctx == null || ctx.dsTransaction == null) {
                    if (log != null) {
                        log.warn((Object)"rollback() called with null ctx or dsTransaction");
                    }
                    return;
                }
                if (log != null) {
                    log.info((Object)("Rolling back transaction, dbName=" + ctx.dbName + ", started=" + ctx.started));
                }
                try {
                    if (ctx.dbName != null) {
                        SQLTransaction.rollbackTransaction((DSTransaction)ctx.dsTransaction, (String)ctx.dbName);
                        if (log != null) {
                            log.info((Object)("SQLTransaction.rollbackTransaction completed for dbName=" + ctx.dbName));
                        }
                        break block13;
                    }
                    SQLTransaction.rollbackTransaction((DSTransaction)ctx.dsTransaction);
                    if (log != null) {
                        log.info((Object)"SQLTransaction.rollbackTransaction(dsTransaction) completed");
                    }
                    try {
                        SQLTransaction.endTransaction((DSTransaction)ctx.dsTransaction);
                        if (log != null) {
                            log.info((Object)"SQLTransaction.endTransaction completed");
                        }
                    }
                    catch (Exception e) {
                        if (log != null) {
                            log.warn((Object)("Failed to end transaction: " + e.getMessage()));
                        }
                    }
                }
                catch (Exception e) {
                    if (log != null) {
                        log.error((Object)("Error during rollback: " + e.getMessage()), (Throwable)e);
                    }
                    throw e;
                }
            }
        }

        private static Object tryInvokeStatic(String className, String methodName) {
            try {
                Class<?> c = Class.forName(className);
                Method m = c.getMethod(methodName, new Class[0]);
                return m.invoke(null, new Object[0]);
            }
            catch (Throwable t) {
                return null;
            }
        }

        private static boolean tryInvokeStatic(String className, String methodName, Object arg) {
            try {
                Class<?> c = Class.forName(className);
                try {
                    Method m = c.getMethod(methodName, arg.getClass());
                    m.invoke(null, arg);
                    return true;
                }
                catch (NoSuchMethodException nsme) {
                    Method m = c.getMethod(methodName, Object.class);
                    m.invoke(null, arg);
                    return true;
                }
            }
            catch (Throwable t) {
                return false;
            }
        }

        private static boolean tryInvoke(Object target, String methodName, Class<?>[] paramTypes, Object[] args) {
            try {
                Method m = target.getClass().getMethod(methodName, paramTypes);
                m.invoke(target, args);
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }

        private static int asInt(Object token) {
            if (token instanceof Number) {
                return ((Number)token).intValue();
            }
            try {
                return Integer.parseInt(String.valueOf(token));
            }
            catch (Exception e) {
                return 0;
            }
        }

        private static Integer asInteger(Object token) {
            if (token instanceof Integer) {
                return (Integer)token;
            }
            if (token instanceof Number) {
                return ((Number)token).intValue();
            }
            try {
                return Integer.valueOf(String.valueOf(token));
            }
            catch (Exception e) {
                return 0;
            }
        }

        static final class TxContext {
            final DSTransaction dsTransaction;
            final String dbName;
            final boolean started;

            TxContext(DSTransaction dsTransaction, String dbName, boolean started) {
                this.dsTransaction = dsTransaction;
                this.dbName = dbName;
                this.started = started;
            }
        }
    }

    public static enum ExportFormat {
        XML,
        JSON;

    }

    public static final class ExportRecordsResult {
        public final String dataSourceId;
        public final ExportFormat format;
        public final long rowsWritten;
        public final int fetchCalls;

        public ExportRecordsResult(String dataSourceId, ExportFormat format, long rowsWritten, int fetchCalls) {
            this.dataSourceId = dataSourceId;
            this.format = format;
            this.rowsWritten = rowsWritten;
            this.fetchCalls = fetchCalls;
        }
    }

    public static final class ExportOptions {
        public ExportFormat format;
        public String outputRelDir;
        public String fileBaseName;
        public String recordTag;
        public Integer maxRows;
        public Integer pageSize;
    }

    public static final class ExportDataSourceResult {
        public final String dataSourceId;
        public final ExportFormat format;
        public final String outputDir;
        public final String outputFile;
        public final long rowsWritten;
        public final int fetchCalls;

        public ExportDataSourceResult(String dataSourceId, ExportFormat format, String outputDir, String outputFile, long rowsWritten, int fetchCalls) {
            this.dataSourceId = dataSourceId;
            this.format = format;
            this.outputDir = outputDir;
            this.outputFile = outputFile;
            this.rowsWritten = rowsWritten;
            this.fetchCalls = fetchCalls;
        }
    }
}

