/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.naming;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

public class MockInitialContextFactory
implements InitialContextFactory {
    private static Context context;

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        return context;
    }

    public static void bind(String name, Object obj) {
        try {
            context.bind(name, obj);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            context = new InitialContext(true){
                Map<String, Object> bindings = new HashMap<String, Object>();

                @Override
                public void bind(String name, Object obj) throws NamingException {
                    this.bindings.put(name, obj);
                }

                @Override
                public void rebind(String name, Object obj) throws NamingException {
                    this.bindings.put(name, obj);
                }

                @Override
                public Context createSubcontext(String name) throws NamingException {
                    this.bindings.put(name, new HashMap());
                    return null;
                }

                @Override
                public Object lookup(String name) throws NamingException {
                    return this.bindings.get(name);
                }

                @Override
                public Object lookup(Name name) throws NamingException {
                    return this.lookup(name.toString());
                }

                @Override
                public NameParser getNameParser(String name) throws NamingException {
                    return new NameParser(){

                        @Override
                        public Name parse(String name) throws NamingException {
                            return new CompositeName(name);
                        }
                    };
                }
            };
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }
}

