/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.store.DataStructCache;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SystemSchemaTranslation {
    private static final Config config = Config.getGlobal();
    protected static final Logger staticLog = new Logger(SystemSchemaTranslation.class);
    protected static List<String> dsDirPaths;
    private static CacheInvalidatorService cacheInvalidatorService;
    private static String translatedSystemSchema;

    public static synchronized String getTranslatedSystemSchema() throws Exception {
        if (translatedSystemSchema == null) {
            SystemSchemaTranslation.maybeInit();
            staticLog.debug("Generating `translatedSystemSchema`");
            StringWriter out = new StringWriter();
            SystemSchemaTranslation.outputSystemSchema(out);
            translatedSystemSchema = out.toString();
        } else {
            staticLog.debug("Re-using cached `translatedSystemSchema`");
        }
        return translatedSystemSchema;
    }

    public static synchronized void finish() {
        if (cacheInvalidatorService != null) {
            cacheInvalidatorService.finish();
        }
        translatedSystemSchema = null;
        cacheInvalidatorService = null;
        dsDirPaths = null;
    }

    public static List<String> getFrameworkDataSources() {
        SystemSchemaTranslation.maybeInit();
        ArrayList<String> dsList = new ArrayList<String>();
        for (String dsDirPath : dsDirPaths) {
            File dsDir = new File(dsDirPath);
            String[] files = dsDir.list();
            if (files == null) {
                staticLog.error("getFrameworkDataSources(): the following path listed in 'framework.datasources' is not a directory: " + dsDirPath);
                continue;
            }
            for (int i = 0; i < files.length; ++i) {
                String filename = files[i];
                if (filename.matches("[^A-Za-z_].*") || filename.equals("Object.ds.xml") || filename.equals("FileAssembly.ds.xml") || filename.equals("FileAssemblyEntry.ds.xml") || filename.equals("Filesystem.ds.xml") || filename.equals("StreamDataSource.ds.xml") || filename.equals("ISCLogEvent.ds.xml") || filename.equals("DataSourceDataChanged.ds.xml") || !filename.endsWith(".ds.xml")) continue;
                String dsName = filename.substring(0, filename.lastIndexOf(".ds.xml"));
                dsList.add(dsName);
            }
        }
        return dsList;
    }

    private static synchronized void maybeInit() {
        if (dsDirPaths == null) {
            List<String> paths = config.getCommaSeparatedList("framework.datasources");
            if (paths == null) {
                dsDirPaths = Collections.emptyList();
            } else {
                dsDirPaths = new ArrayList<String>(paths.size());
                for (String path : paths) {
                    if (path == null || path.isEmpty()) continue;
                    String dsDirPath = ISCFile.canonicalizePath(path);
                    dsDirPaths.add(dsDirPath);
                }
            }
            if (dsDirPaths.isEmpty()) {
                staticLog.error("static init: could not get a non-empty 'framework.datasources' list from the configuration");
            }
        }
        assert (dsDirPaths != null);
        if (cacheInvalidatorService == null && !dsDirPaths.isEmpty()) {
            try {
                cacheInvalidatorService = new WatchServiceBasedInvalidatorService();
                staticLog.debug("Using a WatchService-based invalidator service");
            }
            catch (Throwable t) {
                cacheInvalidatorService = new IntervalInvalidatorService();
                staticLog.debug((Object)"Using an interval invalidator service", t);
            }
            cacheInvalidatorService.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void outputSystemSchema(Writer out) throws Exception {
        JSTranslater jsTrans = JSTranslater.get();
        ValidationContext vc = new ValidationContext();
        DSRequest stubRequest = new DSRequest();
        vc.setDSRequest(stubRequest);
        HashSet<String> loadedSoFar = new HashSet<String>();
        loadedSoFar.add("DataBoundComponent");
        DataStructCache.disableDsPaths();
        try {
            out.write("\rif(window.isc&&!window.isc.module_SystemSchema){isc.module_SystemSchema=1;");
            out.write("isc.loadingSystemSchema=true;\r");
            for (String name : SystemSchemaTranslation.getFrameworkDataSources()) {
                SystemSchemaTranslation.outputDSForName(name, out, jsTrans, loadedSoFar, vc);
            }
        }
        finally {
            out.write("\risc.loadingSystemSchema=false;}\r");
            DataStructCache.enableDsPaths();
            vc.freeResources();
            stubRequest.setRequestStarted(true);
            stubRequest.freeAllResources();
        }
    }

    private static void outputDSForName(String dataSourceId, Writer out, JSTranslater jsTrans, Set<String> loadedSoFar, ValidationContext vc) throws Exception {
        BasicDataSource ds = null;
        if (loadedSoFar.contains(dataSourceId)) {
            return;
        }
        ds = vc.getType(dataSourceId);
        if (ds == null) {
            throw new Exception("No datasource for name: " + dataSourceId);
        }
        String superDSName = ds.getSuperDSName();
        if (superDSName != null && !"Object".equals(superDSName)) {
            SystemSchemaTranslation.outputDSForName(superDSName, out, jsTrans, loadedSoFar, vc);
        }
        ds.setComponentSchema(true);
        jsTrans.toJS(ds, out);
        loadedSoFar.add(dataSourceId);
        out.write(";\r");
    }

    private static abstract class CacheInvalidatorService
    extends Thread {
        private boolean finished = false;

        public CacheInvalidatorService() {
            this.setDaemon(true);
        }

        protected abstract void awaitInvalidation() throws InterruptedException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            do {
                try {
                    this.awaitInvalidation();
                }
                catch (InterruptedException e) {
                    staticLog.debug((Object)"Cache invalidator interrupted", e);
                }
                catch (Throwable t) {
                    staticLog.error((Object)"An unexpected Throwable was thrown. Switching to an interval invalidator service.", t);
                    cacheInvalidatorService = new IntervalInvalidatorService();
                    cacheInvalidatorService.start();
                    this.finished = true;
                }
                Class<SystemSchemaTranslation> clazz = SystemSchemaTranslation.class;
                // MONITORENTER : com.isomorphic.datasource.SystemSchemaTranslation.class
                translatedSystemSchema = null;
                // MONITOREXIT : clazz
            } while (!this.finished);
        }

        public void finish() {
            this.finished = true;
            this.interrupt();
        }
    }

    private static class WatchServiceBasedInvalidatorService
    extends CacheInvalidatorService {
        private WatchService watchService;
        private Map<WatchKey, Path> pathForKey = new HashMap<WatchKey, Path>();

        public WatchServiceBasedInvalidatorService() throws IOException {
            try {
                FileSystem defaultFileSystem = FileSystems.getDefault();
                this.watchService = defaultFileSystem.newWatchService();
                for (String dsDirPath : dsDirPaths) {
                    Path path = defaultFileSystem.getPath(dsDirPath, new String[0]);
                    if (path == null) {
                        staticLog.info("Skipping WatchService registration: null Path for " + dsDirPath);
                        continue;
                    }
                    File pathFile = path.toFile();
                    if (pathFile == null || !pathFile.isDirectory()) {
                        staticLog.info("Skipping WatchService registration for non-existent directory: " + dsDirPath);
                        continue;
                    }
                    WatchKey key = path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                    this.pathForKey.put(key, path);
                }
            }
            catch (Throwable t) {
                staticLog.error((Object)"Failed to create the WatchService", t);
                try {
                    if (this.watchService != null) {
                        this.watchService.close();
                    }
                }
                catch (Throwable t2) {
                    staticLog.error((Object)"Failed to close a partially-created WatchService", t2);
                }
                this.watchService = null;
                throw new IOException(t);
            }
        }

        @Override
        public void awaitInvalidation() throws InterruptedException {
            boolean valid;
            WatchKey key = this.watchService.take();
            Path path = this.pathForKey.get(key);
            if (path == null) {
                throw new RuntimeException("Received an unexpected WatchKey " + String.valueOf(key));
            }
            if (staticLog.isDebugEnabled()) {
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    staticLog.debug("Received a " + String.valueOf(kind) + " watch event for path '" + String.valueOf(path) + "'. context: " + String.valueOf(event.context()));
                }
            }
            if (!(valid = key.reset())) {
                throw new RuntimeException("The WatchKey for path '" + String.valueOf(path) + "' is no longer valid.");
            }
        }

        @Override
        public void run() {
            super.run();
            try {
                if (this.watchService != null) {
                    this.watchService.close();
                }
            }
            catch (Throwable t) {
                staticLog.error((Object)"Failed to close the WatchService", t);
            }
            this.watchService = null;
        }
    }

    private static class IntervalInvalidatorService
    extends CacheInvalidatorService {
        private long intervalMillis = config.getLong((Object)"framework.datasources.invalidationInterval", 5000L);

        @Override
        public void awaitInvalidation() throws InterruptedException {
            IntervalInvalidatorService.sleep(this.intervalMillis);
        }
    }
}

