/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.Relation;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.util.DataTools;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLTableClause
extends Base {
    private static Logger log = new Logger(SQLTableClause.class.getName());
    private List dataSources;
    private boolean skipFirstRelation = false;
    private List customValueFields = null;
    private List customCriteriaFields = null;
    private DSRequest dsRequest;
    private List includeFrom;
    private Boolean useAnsiJoins;

    public SQLTableClause(DSRequest req, SQLDataSource ds) throws Exception {
        this(req, DataTools.makeList((Object)((Object)ds)));
    }

    public SQLTableClause(DSRequest req, List dataSources) throws Exception {
        this.dsRequest = req;
        this.includeFrom = this.dsRequest.getIncludeFrom();
        if (req.isSummaryFunction() && this.includeFrom != null && this.includeFrom.size() > 0) {
            this.skipFirstRelation = true;
        } else {
            this.dataSources = dataSources;
        }
        this.useAnsiJoins = DataTools.asBooleanObject((Object)this.dsRequest.getDataSource().getConfig().get((Object)"useAnsiJoins"));
        if (this.useAnsiJoins == null) {
            this.useAnsiJoins = config.getBoolean((Object)"sql.useAnsiJoins", false);
        }
    }

    public String getSQLString() throws Exception {
        if (this.dataSources == null && this.includeFrom == null) {
            log.debug((Object)"No datasources, can't generate table clause");
            return "";
        }
        StringBuffer buf = new StringBuffer();
        Map allDataSources = this.collectDataSources();
        Iterator i = allDataSources.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object obj = allDataSources.get(key);
            SQLDataSource ds = null;
            String alias = null;
            if (obj instanceof SQLDataSource) {
                ds = (SQLDataSource)((Object)obj);
            } else {
                Map map = (Map)obj;
                ds = (SQLDataSource)((Object)map.get("ds"));
                alias = (String)map.get("alias");
            }
            String schema = ds.getSchemaName();
            if (schema != null) {
                buf.append(schema);
                buf.append(ds.getDriver().getQualifiedSchemaSeparator());
            }
            String tableName = ds.getTable().getNameQuotedIfNecessary(ds);
            buf.append(tableName);
            if (alias != null) {
                buf.append(" ");
                buf.append(alias);
            }
            if (!i.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    private Map collectDataSources() throws Exception {
        HashMap allDataSources = new HashMap();
        if (this.dataSources != null) {
            for (SQLDataSource ds : this.dataSources) {
                if (this.addDataSource(ds.getName(), (DataSource)ds, this.dsRequest.getForcedAlias(), allDataSources)) {
                    return allDataSources;
                }
                if (!DataSource.isModificationOperation((String)this.dsRequest.getOperationType())) continue;
                break;
            }
        }
        if (!DataSource.isModificationOperation((String)this.dsRequest.getOperationType()) && this.includeFrom != null) {
            for (IncludeFromDefinition incFrom : this.includeFrom) {
                String includeSummaryFunction;
                if (incFrom.isInError() || !(incFrom.getDataSource() instanceof SQLDataSource) || incFrom.isSummaryFunction() && !this.dsRequest.isSummaryFunction() && !this.dsRequest.isConcatFetchRequest() || incFrom.isValueOperation() && !this.dsRequest.isValueOperation()) continue;
                boolean skip = false;
                for (IncludeFromDefinition _incFrom = incFrom.getTargetIncludeFrom(); _incFrom != null; _incFrom = _incFrom.getTargetIncludeFrom()) {
                    if ((!_incFrom.isSummaryFunction() || this.dsRequest.isSummaryFunction() || this.dsRequest.isConcatFetchRequest()) && (!_incFrom.isValueOperation() || this.dsRequest.isValueOperation())) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                String string = includeSummaryFunction = incFrom.getThisField() == null ? null : incFrom.getThisField().getProperty("includeSummaryFunction");
                if (!this.dsRequest.isSummary() && !this.dsRequest.isSummaryFunction() && !this.dsRequest.isConcatFetchRequest() && includeSummaryFunction != null && !"CONCAT".equalsIgnoreCase(includeSummaryFunction) && !"ARRAY".equalsIgnoreCase(includeSummaryFunction)) continue;
                DSField thisField = incFrom.getThisField();
                if (thisField != null && thisField.getBoolean("customSQL")) {
                    Iterator j;
                    String thisFieldName = incFrom.getThisFieldName();
                    boolean skipField = true;
                    if (this.customValueFields != null) {
                        j = this.customValueFields.iterator();
                        while (j.hasNext()) {
                            if (!j.next().equals(thisFieldName)) continue;
                            skipField = false;
                            break;
                        }
                    }
                    if (skipField && this.customCriteriaFields != null) {
                        j = this.customCriteriaFields.iterator();
                        while (j.hasNext()) {
                            if (!j.next().equals(thisFieldName)) continue;
                            skipField = false;
                            break;
                        }
                    }
                    if (skipField) continue;
                }
                String alias = incFrom.getRelation().getFromAlias();
                Object allDSKey = incFrom.getRelation().getFromDataSource().getName();
                if (this.addDataSource((String)(allDSKey = (String)allDSKey + (String)(alias != null ? "*" + alias : "")), incFrom.getRelation().getFromDataSource(), alias, allDataSources)) {
                    return allDataSources;
                }
                if (this.addDataSourcesFromJoiningRelations(incFrom.getRelation(), allDataSources)) {
                    return allDataSources;
                }
                IncludeFromDefinition target = incFrom.getTargetIncludeFrom();
                while (target != null && target.getDataSource() instanceof SQLDataSource) {
                    alias = target.getRelation().getFromAlias();
                    allDSKey = target.getRelation().getFromDataSource().getName();
                    if (this.addDataSource((String)(allDSKey = (String)allDSKey + (String)(alias != null ? "*" + alias : "")), target.getRelation().getFromDataSource(), alias, allDataSources)) {
                        return allDataSources;
                    }
                    incFrom = target;
                    if (this.addDataSourcesFromJoiningRelations(incFrom.getRelation(), allDataSources)) {
                        return allDataSources;
                    }
                    target = incFrom.getTargetIncludeFrom();
                }
            }
        }
        if (this.addDataSourcesFromJoiningRelations(this.dsRequest.getSubqueryRelations(), allDataSources)) {
            return allDataSources;
        }
        return allDataSources;
    }

    private boolean addDataSourcesFromJoiningRelations(Relation r, Map relatedDataSources) {
        while (r != null) {
            if (r.isValid()) {
                String alias = r.getToAlias();
                Object allDSKey = r.getToDataSource().getName();
                if (this.addDataSource((String)(allDSKey = (String)allDSKey + (String)(alias != null ? "*" + alias : "")), r.getToDataSource(), alias, relatedDataSources)) {
                    return true;
                }
            }
            r = r.getNextRelation();
        }
        return false;
    }

    public boolean addDataSource(String key, DataSource ds, String alias, Map allDataSources) {
        if (this.skipFirstRelation) {
            this.skipFirstRelation = false;
            return false;
        }
        if (!allDataSources.containsKey(key)) {
            if (alias == null) {
                allDataSources.put(key, ds);
            } else {
                HashMap<String, Object> allDSMap = new HashMap<String, Object>();
                allDSMap.put("ds", ds);
                allDSMap.put("alias", alias);
                allDataSources.put(key, allDSMap);
            }
        }
        return this.useAnsiJoins != false && allDataSources.size() == 1;
    }

    public List getCustomValueFields() {
        return this.customValueFields;
    }

    public void setCustomValueFields(List fields) {
        this.customValueFields = fields;
    }

    public List getCustomCriteriaFields() {
        return this.customCriteriaFields;
    }

    public void setCustomCriteriaFields(List fields) {
        this.customCriteriaFields = fields;
    }
}

