/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.log.Level;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;

public class SQLLogger {
    private static Logger sql = new Logger("com.isomorphic.SQL");
    private static Logger driver = new Logger(SQLDriver.class.getName());
    private static Logger ds = new Logger(SQLDataSource.class.getName());

    private static Logger getLogger(Level level) {
        if (sql.isEnabledFor(level)) {
            return sql;
        }
        if (driver.isEnabledFor(level)) {
            return driver;
        }
        return ds;
    }

    private SQLLogger() {
    }

    public static void info(Object message, Throwable t) {
        SQLLogger.getLogger(Logger.INFO).info(message, t);
    }

    public static void info(Object message) {
        SQLLogger.getLogger(Logger.INFO).info(message);
    }

    public static void info(Object message, Object o) {
        SQLLogger.getLogger(Logger.INFO).info(message, o);
    }

    public static boolean isInfoEnabled() {
        return SQLLogger.getLogger(Logger.INFO).isInfoEnabled();
    }

    public static void debug(String message, Throwable t) {
        SQLLogger.getLogger(Logger.DEBUG).debug((Object)message, t);
    }

    public static void debug(String message) {
        SQLLogger.getLogger(Logger.DEBUG).debug((Object)message);
    }

    public static void debug(Object message, Object o) {
        SQLLogger.getLogger(Logger.DEBUG).debug(message, o);
    }

    public static boolean isDebugEnabled() {
        return SQLLogger.getLogger(Logger.DEBUG).isDebugEnabled();
    }
}

