/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.base.Config;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.criteria.Operator;
import com.isomorphic.criteria.criterion.SetCriterion;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.hibernate.HibernateDSGenerator;
import com.isomorphic.hibernate.HibernateDataSource;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLMetaData;
import com.isomorphic.tools.AdminConsole;
import com.isomorphic.tools.SQLTestException;
import com.isomorphic.util.DataTools;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DatabaseTools {
    static Logger log = new Logger(DatabaseTools.class);
    static Config config = Config.getGlobal();
    static final String CREATE_TEST = "CREATE TABLE isc_admin_test (foo varchar(1))";
    static final String DROP_TEST = "DROP TABLE isc_admin_test";

    public static List getDefinedDatabases() throws Exception {
        return DatabaseTools.getDefinedDatabases(false);
    }

    public static List getDefinedDatabases(boolean testConnection) throws Exception {
        return DatabaseTools.getDefinedDatabases(testConnection, (AdvancedCriteria)null);
    }

    public static List getDefinedDatabases(boolean testConnection, Map criteria) throws Exception {
        return DatabaseTools.getDefinedDatabases(testConnection, AdvancedCriteria.fromCollections((Object)criteria));
    }

    public static List getDefinedDatabases(boolean testConnection, AdvancedCriteria criteria) throws Exception {
        boolean hideJndi = config.getBoolean((Object)"dbBrowser.hide.jndi.connections", false);
        List dbList = new ArrayList();
        List dbNames = SQLConnectionManager.getDefinedDatabaseNames();
        String defaultDatabase = config.getString((Object)"sql.defaultDatabase");
        for (String dbName : dbNames) {
            Config dbConfig = config.getSubtree("sql." + dbName);
            if (dbConfig.getBoolean((Object)"dbBrowserHidden", false)) continue;
            SQLDriver driver = null;
            try {
                driver = SQLDriver.instance((String)dbName);
            }
            catch (Exception e) {
                dbConfig.put((Object)"dbStatus", (Object)e.getMessage());
            }
            if (driver != null) {
                dbConfig = driver.getSqlConfig();
                if (hideJndi && dbConfig != null && "jndi".equals(dbConfig.get((Object)"interface.type"))) continue;
                if (!testConnection) {
                    dbConfig.put((Object)"dbStatus", (Object)"Not tested");
                } else {
                    try {
                        DatabaseTools.testDBCore(dbName, null, (Map)dbConfig);
                        dbConfig.put((Object)"dbStatus", (Object)"OK");
                    }
                    catch (AdminConsole.SQLTestWarningException e) {
                        dbConfig.put((Object)"dbStatus", (Object)"OK, Read-Only");
                    }
                    catch (SQLTestException e) {
                        dbConfig.put((Object)"dbStatus", (Object)e.error);
                    }
                }
            } else if (dbName.indexOf("/") != -1 && hideJndi) continue;
            dbConfig.put((Object)"dbName", (Object)dbName);
            if (dbName.equals(defaultDatabase)) {
                dbConfig.put((Object)"isDefault", (Object)Boolean.TRUE);
            }
            LinkedHashMap<String, Object> alteredConfig = new LinkedHashMap<String, Object>();
            for (String key : dbConfig.keySet()) {
                Object value = dbConfig.get((Object)key);
                key = key.replace('.', '_');
                alteredConfig.put(key, value);
            }
            dbList.add(alteredConfig);
        }
        Collections.sort(dbList, new Comparator(){

            public int compare(Object o1, Object o2) {
                Map m1 = (Map)o1;
                Map m2 = (Map)o2;
                if ("true".equals(m1.get("driver.autoConfigured")) && !"true".equals(m1.get("driver.autoConfigured"))) {
                    return 1;
                }
                return ((String)m1.get("dbName")).compareTo((String)m2.get("dbName"));
            }
        });
        if (criteria != null) {
            dbList = criteria.filter(dbList);
        }
        return dbList;
    }

    public static List getTables(String serverType, String dbName, boolean includeTables, boolean includeViews, String schema, List include, List exclude) throws Exception {
        ArrayList<SetCriterion> criterions = new ArrayList<SetCriterion>();
        if (include != null && !include.isEmpty()) {
            criterions.add(new SetCriterion("TABLE_NAME", DefaultOperators.InSet, (Collection)include));
        }
        if (exclude != null && !exclude.isEmpty()) {
            criterions.add(new SetCriterion("TABLE_NAME", DefaultOperators.NotInSet, (Collection)exclude));
        }
        AdvancedCriteria criteria = new AdvancedCriteria((Operator)DefaultOperators.And, criterions.toArray(new Criterion[0]));
        return DatabaseTools.getTables(serverType, dbName, includeTables, includeViews, schema, criteria);
    }

    public static List getTables(AdvancedCriteria criteria) throws Exception {
        return DatabaseTools.getTables("sql", (String)config.get((Object)"sql.defaultDatabase"), true, true, null, criteria);
    }

    public static List getTables(String dbName) throws Exception {
        return DatabaseTools.getTables("sql", dbName, true, true, null, null, null);
    }

    public static List getTables(String dbName, AdvancedCriteria criteria) throws Exception {
        return DatabaseTools.getTables("sql", dbName, true, true, null, criteria);
    }

    public static List getTables(String dbName, String schema, AdvancedCriteria criteria) throws Exception {
        return DatabaseTools.getTables("sql", dbName != null ? dbName : (String)config.get((Object)"sql.defaultDatabase"), true, true, schema, criteria);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getTables(String serverType, String dbName, boolean includeTables, boolean includeViews, String schema, AdvancedCriteria criteria) throws Exception {
        ArrayList<String> types = new ArrayList<String>();
        if (includeTables) {
            types.add("TABLE");
        }
        if (includeViews) {
            types.add("VIEW");
        }
        Connection conn = null;
        conn = "hibernate".equals(serverType) ? HibernateDataSource.getConnection() : SQLConnectionManager.getConnection((String)dbName);
        try {
            List criteriaFilteredTables;
            SQLMetaData md = new SQLMetaData(conn);
            List tables = md.getTableNamesAndRemarks(null, schema, types);
            List list = criteriaFilteredTables = criteria == null ? tables : criteria.filter(tables);
            return list;
        }
        finally {
            if ("hibernate".equals(serverType)) {
                HibernateDataSource.freeConnection((Connection)conn);
            } else {
                SQLConnectionManager.free((Connection)conn);
            }
        }
    }

    public static List getSchemas(String serverType, String dbName, Map criteria) throws Exception {
        AdvancedCriteria ac = null;
        if (criteria != null && !criteria.isEmpty()) {
            ac = AdvancedCriteria.fromCollections((Object)criteria);
        }
        return DatabaseTools.getSchemas(serverType, dbName, ac);
    }

    public static List getSchemas(String serverType, String dbName, AdvancedCriteria ac) throws Exception {
        List schemas = DatabaseTools.getSchemas(serverType, dbName);
        if (ac != null) {
            schemas = ac.filter(schemas);
        }
        return schemas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getSchemas(String serverType, String dbName) throws Exception {
        Connection conn = null;
        List schemas = null;
        try {
            conn = "hibernate".equals(serverType) ? HibernateDataSource.getConnection() : SQLConnectionManager.getConnection((String)dbName);
            SQLMetaData md = new SQLMetaData(conn);
            schemas = md.getSchemas();
            log.warn((Object)("schemas: " + String.valueOf(schemas)));
        }
        catch (Exception e) {
            log.warn((Object)"Error calling getSchemas()", (Throwable)e);
        }
        finally {
            if ("hibernate".equals(serverType)) {
                HibernateDataSource.freeConnection((Connection)conn);
            } else {
                SQLConnectionManager.free((Connection)conn);
            }
        }
        return schemas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void testDBCore(String dbName, Config dbConfig, Map result) throws SQLTestException {
        Connection conn = null;
        try {
            conn = DatabaseTools.getConnectionForConfig(dbName, dbConfig);
            if (result != null) {
                SQLMetaData smd = new SQLMetaData(conn);
                Map pv = smd.getProductNameAndVersion();
                result.put("dbProductName", pv.get("productName"));
                result.put("dbProductVersion", pv.get("productVersion"));
            }
            if (conn == null) {
                throw new Exception("Can't get connection to '" + dbName + "'");
            }
            Statement s = null;
            try {
                s = conn.createStatement();
                s.executeUpdate(CREATE_TEST);
            }
            catch (SQLException se) {
                try {
                    try {
                        s.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    s = conn.createStatement();
                    s.executeUpdate(DROP_TEST);
                    s.executeUpdate(CREATE_TEST);
                }
                catch (SQLException se2) {
                    throw new AdminConsole.SQLTestWarningException("Limited: User has insufficient privileges to create or drop tables", se2);
                }
            }
            finally {
                block60: {
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                    s = conn.createStatement();
                    s.executeUpdate(DROP_TEST);
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                    break block60;
                    catch (SQLException sQLException) {
                        try {
                            s.close();
                        }
                        catch (Exception exception) {}
                        catch (Throwable throwable) {
                            try {
                                s.close();
                            }
                            catch (Exception exception) {}
                            throw throwable;
                        }
                    }
                }
            }
        }
        catch (AdminConsole.SQLTestWarningException stwe) {
            throw stwe;
        }
        catch (Exception e) {
            log.info((Object)("testDB (" + dbName + ") error: " + e.toString()));
            if (e.toString().indexOf("ClassNotFoundException") != -1) {
                throw new SQLTestException("JDBC Driver not installed", e);
            }
            throw new SQLTestException("Unable to connect", e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Connection getConnectionForConfig(String dbName, Config dbConfig) throws Exception {
        log.debug((Object)("Testing DB connection for database: " + dbName + " with config: " + DataTools.prettyPrint((Object)dbConfig)));
        if (dbConfig != null) {
            SQLDriver.configure((String)dbName, (Config)dbConfig);
        }
        return SQLDriver.instance((String)dbName).rawConnection();
    }

    public static String getDataSourceJSONFromTable(String tableName, String serverType, String dbName, String ID, Map properties, String schema) throws Exception {
        DataSource ds = DatabaseTools.getDataSourceFromTable(tableName, serverType, dbName, ID, properties, schema);
        ds.getConfig().remove((Object)"__autoConstruct");
        StringWriter sw = new StringWriter();
        JSTranslater jst = JSTranslater.get();
        jst.enablePrettyPrinting(false);
        ds.toJSON((Writer)sw, jst);
        return sw.toString();
    }

    public static DataSource getDataSourceFromTable(String tableName, String serverType, String dbName, String ID) throws Exception {
        return DatabaseTools.getDataSourceFromTable(tableName, serverType, dbName, ID, null, null);
    }

    public static DataSource getDataSourceFromTable(String tableName, String serverType, String dbName, String ID, Map properties, String schema) throws Exception {
        if (ID == null) {
            ID = tableName;
        }
        if (schema == null) {
            String defaultDB = config.getString((Object)"sql.defaultDatabase");
            schema = config.getString((Object)("sql." + (dbName == null ? defaultDB : dbName) + ".driver.schema"));
        }
        DataSource ds = null;
        if ("hibernate".equals(serverType)) {
            ds = HibernateDSGenerator.fromTable((String)tableName, (String)schema, (String)ID);
        } else {
            Connection conn = SQLConnectionManager.getConnection((String)dbName);
            ds = SQLDataSource.fromTable((Connection)conn, (String)tableName, (String)schema, (String)ID, (String)"sql", (String)dbName, (Map)properties);
            SQLConnectionManager.free((Connection)conn);
        }
        return ds;
    }

    public static String getDataSourceJSONFromHibernateMapping(String entityName, String ID) throws Exception {
        DataSource ds = DatabaseTools.getDataSourceFromHibernateMapping(entityName, ID);
        ds.getConfig().remove((Object)"__autoConstruct");
        StringWriter sw = new StringWriter();
        JSTranslater jst = JSTranslater.get();
        jst.enablePrettyPrinting(false);
        ds.toJSON((Writer)sw, jst);
        return sw.toString();
    }

    public static DataSource getDataSourceFromHibernateMapping(String entityName, String ID) throws Exception {
        if (ID == null) {
            ID = entityName;
        }
        return HibernateDSGenerator.fromMapping((String)entityName, (String)ID);
    }

    public static List getFieldsFromTable(String tableName, String schema, String serverType, String dbName) throws Exception {
        Connection conn = null;
        conn = "hibernate".equals(serverType) ? HibernateDataSource.getConnection() : SQLConnectionManager.getConnection((String)dbName);
        List fields = SQLDataSource.getFieldsFromTable((Connection)conn, (String)tableName, (String)schema, (String)dbName);
        if ("hibernate".equals(serverType)) {
            HibernateDataSource.freeConnection((Connection)conn);
        } else {
            SQLConnectionManager.free((Connection)conn);
        }
        return fields;
    }

    public static String getDefaultDatabase() throws Exception {
        return config.getString((Object)"sql.defaultDatabase");
    }
}

