package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * Enumerated status indicating whether a ResultSet has an accurate {@link com.smartgwt.client.data.ResultSet#getRowCount
 * ResultSet.getRowCount()} row count for the data set. <P> This is a feature associated with {@link
 * com.smartgwt.client.data.DataSource#getProgressiveLoading progressive loading of data}. When progressive loading is
 * active, the {@link com.smartgwt.client.data.ResultSet#getLength length} may not indicate the true size of the data set.
 * In this case a different total row count may be maintained by the ResultSet data object and retrieved via {@link
 * com.smartgwt.client.data.ResultSet#getRowCount ResultSet.getRowCount()}. This status code indicates whether this row
 * count is an exact value or not.
 */
public enum RowCountStatus implements ValueEnum {
    /**
     * The size of the data set is known and the current row count is accurate. This always will be the case if {@link
     * com.smartgwt.client.data.DataSource#getProgressiveLoading progressiveLoading}  is not active. If progressiveLoading is
     * active, we may have an accurate row count in the following scenarios: <ul> <li>{@link
     * com.smartgwt.client.data.ResultSet#setFullLength ResultSet.setFullLength()} was explicitly invoked to tell the resultSet
     * its total length.<br> In this case {@link com.smartgwt.client.data.ResultSet#getLength ResultSet.getLength()} will
     * return the same value as  {@link com.smartgwt.client.data.ResultSet#getRowCount ResultSet.getRowCount()}</li> <li>The
     * user has scrolled all the way to the true end of the progressively loaded data set such that the length is now
     * known.<br> In this case {@link com.smartgwt.client.data.ResultSet#getLength ResultSet.getLength()} will return the same
     * value as  {@link com.smartgwt.client.data.ResultSet#getRowCount ResultSet.getRowCount()}</li> <li>A successful row count
     * fetch was performed via  {@link com.smartgwt.client.data.ResultSet#fetchRowCount ResultSet.fetchRowCount()}.<br> In this
     * case {@link com.smartgwt.client.data.ResultSet#getLength ResultSet.getLength()} will return the same value as  {@link
     * com.smartgwt.client.data.ResultSet#getRowCount ResultSet.getRowCount()} if {@link
     * com.smartgwt.client.data.ResultSet#getApplyRowCountToLength ResultSet.applyRowCountToLength}  is true, otherwise the
     * values may differ.</li> <li>The dataSource fetch response to a request for rows within the  resultSet included a {@link
     * com.smartgwt.client.data.DSResponse#getEstimatedTotalRows DSResponse.estimatedTotalRows} value with an exact value<br>
     * In this case {@link com.smartgwt.client.data.ResultSet#getLength ResultSet.getLength()} will return the same value as 
     * {@link com.smartgwt.client.data.ResultSet#getRowCount ResultSet.getRowCount()} if {@link
     * com.smartgwt.client.data.ResultSet#getApplyRowCountToLength ResultSet.applyRowCountToLength}  is true, otherwise the
     * values may differ.</li> </ul>
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "exact".
     */
    EXACT("exact"),
    /**
     * The current row count is unknown. This value indicates {@link com.smartgwt.client.data.ResultSet#lengthIsKnown
     * ResultSet.lengthIsKnown()} returns false.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "unknown".
     */
    UNKNOWN("unknown"),
    /**
     * This value indicates that the ResultSet is waiting for an active {@link com.smartgwt.client.data.ResultSet#fetchRowCount
     * row count fetch} to complete.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "loading".
     */
    LOADING("loading"),
    /**
     * The current row count is a minimum - there are at least this many records in the data set. Note that when {@link
     * com.smartgwt.client.data.DataSource#getProgressiveLoading progressiveLoading} is active, this  will be the status if no
     * explicit {@link com.smartgwt.client.data.DSResponse#getEstimatedTotalRows DSResponse.estimatedTotalRows} was available,
     * so {@link com.smartgwt.client.data.DSResponse#getTotalRows DSResponse.totalRows} is a minimum, or if  {@link
     * com.smartgwt.client.data.DSResponse#getEstimatedTotalRows DSResponse.estimatedTotalRows} contained a value in the format
     *  <code><i>"[rowCount]+"</i></code>.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "minimum".
     */
    MINIMUM("minimum"),
    /**
     * The current row count is an approximation. This will be the status if {@link
     * com.smartgwt.client.data.DataSource#getProgressiveLoading progressiveLoading} is active and a fetch request contained an
     * explicit {@link com.smartgwt.client.data.DSResponse#getEstimatedTotalRows DSResponse.estimatedTotalRows} in the format 
     * <code><i>"~[rowCount]"</i></code>.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "approximate".
     */
    APPROXIMATE("approximate"),
    /**
     * The current row count is a maximum - there are no more than this many records in the data set. This will be the status
     * if {@link com.smartgwt.client.data.DataSource#getProgressiveLoading progressiveLoading} is active and a fetch request
     * contained an explicit {@link com.smartgwt.client.data.DSResponse#getEstimatedTotalRows DSResponse.estimatedTotalRows} in
     * the format  <code><i>"-[rowCount]"</i></code>.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "maximum".
     */
    MAXIMUM("maximum"),
    /**
     * The data object knows the total number of records in the data set lies within a particular range. In this case {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowCountRange ListGrid.getRowCountRange()}  may be used to retrieve the
     * upper and lower bound of this range, and  {@link com.smartgwt.client.widgets.grid.ListGrid#getRowCount
     * ListGrid.getRowCount()} will return the lower bound. This will be the status if {@link
     * com.smartgwt.client.data.DataSource#getProgressiveLoading progressiveLoading} is active and a fetch request contained an
     * explicit {@link com.smartgwt.client.data.DSResponse#getEstimatedTotalRows DSResponse.estimatedTotalRows} in the format 
     * <code><i>"[minRowCount]-[maxRowCount]"</i></code>.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "range".
     */
    RANGE("range");
    private String value;

    RowCountStatus(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
