/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */

package com.smartgwt.sample.showcase.client.dataintegration.java.sql;

import com.google.gwt.user.client.Timer;
import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DSResponse;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.types.DSOperationType;
import com.smartgwt.client.data.ResponseTransformer;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.data.Criteria;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.IButton;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class ServerFormattingSample extends ShowcasePanel {

    private static final String DESCRIPTION =
        "The dataSourceField.template property allows you to create formatted values on the server. "+
        "In this sample, the \"Full Name\" field is generated by combining two other field values "+
        "($lastName and $firstName) with a template configured directly in the DataSource. "+
        "Since the formatted value is created on the server, "+
        "sorting and filtering may be applied to the records based on the generated values."+
        "<ol><li>This sample is backed by a large data set which is only partially loaded on the client. "+
        "    Try filtering and sorting by the Full Name field and note how the server returns the "+
        "    appropriate data to service these requests.</li>"+
        "<li>The \"Define client-side format\" button allows you to generate a formatted field on the "+
        "    client. For instance, try combining $extension and $email to show contact information "+
        "    for employees in a new field. Notice how filtering and sorting cannot be supported on "+
        "    this new field as the full data set has not been loaded into the browser.</li>"+
        "</ol>";

    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
            ServerFormattingSample panel = new ServerFormattingSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    protected boolean isTopIntro() {
        return true;
    }

    private Label serverCountLabel;
    
    private class ServerCountLabel extends Label {
        private int count = 0;  
  
        public ServerCountLabel() {  
            setWidth100();
            setHeight(40);
            setPadding(10);
            setBorder("1px solid grey");
            setContents("<b>Number of server trips: 0</b>");
        }  
  
        public void updateContent (int totalRows, int startRow, int endRow) {
            count++;
            serverCountLabel.setContents("Number of server trips: " + this.count + 
                                         "<br/>Total rows in this filter set: " + totalRows + 
                                         "<br/>Last range of records returned: " + startRow + " to " + endRow);
        }
    } 
    
    public Canvas getViewPanel() {

        DataSource ds = DataSource.get("employees_template", null, new ResponseTransformer() {
            protected void transformResponse(DSResponse response, DSRequest request, Object data) {
                if(request.getOperationType() == DSOperationType.FETCH) {
                    int totalRows = response.getTotalRows(); 
                    int startRow = response.getStartRow(); 
                    int endRow = response.getEndRow(); 
                    ((ServerCountLabel) serverCountLabel).updateContent(totalRows, startRow, endRow); 
                    serverCountLabel.setBackgroundColor("#ffff77"); 
                    new Timer() { 
                        public void run() { 
                            serverCountLabel.setBackgroundColor("#ffffff"); 
                        } 
                    }.schedule(500); 
                }
                defaultTransformResponse(response, request, data);
            }
        });
        
        ListGrid employeeGrid = new ListGrid();
        employeeGrid.setDataSource(ds);
        employeeGrid.setWidth(900);
        employeeGrid.setHeight(300);
        employeeGrid.setAutoFetchData(true);
        employeeGrid.setCanAddSummaryFields(true);
        employeeGrid.setShowFilterEditor(true);
        employeeGrid.setFilterOnKeypress(true);
        employeeGrid.setShowAllColumns(true);
    	
        IButton formatButton = new IButton();
        formatButton.setTitle("Define client-side format");
        formatButton.setAutoFit(true);
        formatButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                employeeGrid.addSummaryField();
            }
        }); 	
    	
        serverCountLabel = new ServerCountLabel();
        
        VLayout vLayout = new VLayout();
        vLayout.setHeight100();
        vLayout.setWidth100();
        vLayout.setMembersMargin(10);
        vLayout.addMembers(formatButton, employeeGrid, serverCountLabel);
    	
        return vLayout;
    }

    public String getIntro() {
        return DESCRIPTION;
    }

}
