package com.smartgwt.sample.client;

import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.widgets.grid.*;

public class WindowEventRecord extends ListGridRecord {
    public WindowEventRecord(MultiWindowEvent eventType) {
        setAttribute("eventName", eventType.getValue());
    }

    public MultiWindowEvent getEventType() {
        String eventName = getAttributeAsString("eventName");
        return MultiWindowEvent.valueOf(eventName.toUpperCase());
    }

    public void setEventRegistrationID(int id) {
        setAttribute("registeredID", id);
    }

    public void clearEventRegistrationID() {
        setAttribute("registeredID", (Integer)null);
    }

    public Integer getEventRegistrationID() {
       return getAttributeAsInt("registeredID");
    }
}
