<!doctype html>
<%@ taglib uri="http://www.smartclient.com/taglib" prefix="isomorphic" %>

<html>
<head><title>
        Theme Editor PreviewPane
</title>
</head>

<body style="overflow:hidden;">

<!-- preload material-icons -->
<link rel="preload" as="font" href="https://fonts.gstatic.com/s/materialicons/v81/flUhRq6tzZclQEJ-Vdg-IuiaDsNc.woff2" type="font/woff2" crossorigin="anonymous">

<%
String skin = request.getParameter("theme");
if (skin == null || "".equals(skin)) skin = "Tahoe";

String skinToolsDir = request.getRequestURI();
skinToolsDir = skinToolsDir.replaceFirst("[^\\/]*$", "");

String isomorphicURI = (String)request.getAttribute("isomorphicURI");
if (isomorphicURI != null) skinToolsDir = isomorphicURI + "../tools/skinTools/";

String locationDir = skinToolsDir + "../visualBuilder/sampleDS";

if (isomorphicURI != null) {
%>
<isomorphic:loadModules isomorphicURI="<%=isomorphicURI%>" modulesDir="system/development/" 
                        includeModules="RichTextEditor,FileLoader,Analytics,Calendar,SkinUtil,Tools,Charts"/>
<%
} else {
%>
<isomorphic:loadModules modulesDir="system/development/" 
                        includeModules="RichTextEditor,FileLoader,Analytics,Calendar,SkinUtil,Tools,Charts"/>
<%
}
%>
<script>

<isomorphic:loadDS ID='registeredFonts' />

// disallow this iframe from stealing focus from main app - this hurts user workflow
window.isc_suppressFocus = true; 

var skin = "<%=skin%>";

var skinPath = isc.Page.getIsomorphicDir() + "skins/" + skin;
if (!isc.Browser.isIE) {
    isc.FileLoader.loadCSSFile(skinPath + "/skin_styles_editor.css");
} else {
    isc.FileLoader.loadCSSFile(skinPath + "/skin_styles.css");
}
isc.FileLoader.markSkinCSSLoaded(skin);
isc.FontLoader.loadRegisteredFonts();
isc.FileLoader.loadSkinJS(skin, function () {
    // apply density changes
    if (isc.params && isc.params.density) {
        var density = isc.Canvas.skinDensityMap[isc.params.density];
        if (density != null) {
            // do the size increase here - the font-increase is special for this use-case,
            // applied in a custom fashion in skinEditor.jsp
            if (density.fontIncrease != null) {
                //isc.Canvas.resizeTextPadding(null, density.fontIncrease);
            }
            if (density.sizeIncrease != null) {
                // we want icon-sizes to scale up for "controls" relationships
                isc.Canvas.autoResizeIcons = true;
                isc.Canvas.resizeControls(density.sizeIncrease);

                // Skin Editor doesn't use Canvas.resizefonts() to scale fonts - but we still
                // want the framework to think fonts have been scaled officially, so that
                // SVGs can use the fontIncrease to auto-scale sizes from src-strings
                isc.Canvas.fontIncrease = density.fontIncrease;

                // we don't want to scale fonts themselves, but we do want to scale 
                // icon-sizes for "fonts" relationships
                isc.Canvas.resizeIcons("fonts", density.fontIncrease);
            }
        }
    }
    // onload handler
    startUtil();
});

function unloadSkinStyles () {
    var ssHandler = isc.StyleSheetHandler.create({});
    ssHandler.loadSkinStyleSheet(true);
    if (ssHandler.styleSheet) {
        ssHandler.unload();
    }
    ssHandler.destroy();
}

//isc.parseSkinURLParams(4, 2);
function showPane(paneName, backgroundColor) {
    // make sure the dataSources have been loaded if this method runs after changing density
    var ds = isc.DS.get("sp_employee");
    if (!ds) isc.createSkinEditorDataSources();
    
    var methodName = "get" + paneName + "Pane";
    var pane = isc[methodName]();
    if (pane == null) isc.say("Unknown preview type: " + paneName);
    if (window.currentPane) window.currentPane.hide();
    window.currentPane = pane;
    if (backgroundColor) window.currentPane.setBackgroundColor(backgroundColor);
    // re-apply disabled state
    if (window.window.currentDisabledState != null) showDisabledState(window.currentDisabledState);
    window.currentPane.show();
        var layout = window.currentPane;
    if (!isc.isA.FlowLayout(layout)) layout = layout.getMember(1);
    if (layout.reLayout) layout.reLayout();
    if (this.paneChangedCallback) this.paneChangedCallback(window.currentPane);
}
function showDisabledState(disable) {
    window.currentDisabledState = disable;
    isc.Menu.hideAllMenus();
    if (window.currentPane) window.currentPane.setDisabled(disable);
}
function startUtil () {
    if (isc.params.startView) showPane(isc.params.startView, isc.params.bgColor);
    if (window.parent && window.parent.appState && window.parent.appState.previewLoadComplete) {
        // let the themeEditor know the preview has finished loading (styles can be changed)
        window.parent.appState.previewLoadComplete();
        // allow the previewPane to take focus again
        window.isc_suppressFocus = false; 
    }
}
window.onbeforeunload = function () {
    window.currentPane = null;
    isc.FontLoader.unloadRegisteredFonts();
};

// called whenever a custom skin is saved, after this preview-window is reloaded, to 
// create a thumbnail image for the skin as it now looks. It creates a Layout with some members
// (a TabSet containing a grid and a button), shows the Layout off-screen, screenshots it and 
// returns the image as a PNG dataURL - this is stored on DS records as "thumbnail"
function captureCustomThumbnail (themeName, autoCallback, userCallback) {
    var style = isc.Element.getComputedStyle(document.body, ["background-color"]);
    var bg = style && style["background-color"];

    var thumbnailLayout = isc.VLayout.create({
        ID: "thumbnailCaptureLayout",
        //top: 100,
        top: -1000,
        width: 432,
        height: 432,
        layoutMargin: 10,
        backgroundColor: bg,
        members: [
            isc.TabSet.create({
                width: "100%",
                height: "100%",
                tabs: [
                    { 
                        name: themeName, 
                        title: themeName, 
                        pane: isc.VLayout.create({
                            width: "100%",
                            height: "100%",
                            layoutMargin: 10,
                            membersMargin: 10,
                            members: [
                                isc.ListGrid.create({
                                    ID: "thumbnailCaptureGrid",
                                    width: "100%",
                                    height: "*",
                                    fields: [
                                        { name: "countryName" },
                                        { name: "capital" },
                                        { name: "continent" }
                                    ],
                                    data: [
                                        { countryName: "United States", capital: "Washington D.C.", continent: "North America" },
                                        { countryName: "Brazil", capital: "Brasilia", continent: "South America" },
                                        { countryName: "Canada", capital: "Ottawa", continent: "North America" },
                                        { countryName: "China", capital: "Beijing", continent: "Asia" },
                                        { countryName: "France", capital: "Paris", continent: "Europe" },
                                        { countryName: "Germany", capital: "Berlin", continent: "Europe" },
                                        { countryName: "Japan", capital: "Tokyo", continent: "Asia" },
                                        { countryName: "United Kingdom", capital: "London", continent: "Europe" }
                                    ]
                                }),
                                isc.HLayout.create({
                                    ID: "thumbnailCaptureButtonLayout",
                                    width: "100%",
                                    height: 40,
                                    align: "left",
                                    membersMargin: 10,
                                    defaultLayoutAlign: "center",
                                    members: [
                                        isc.IButton.create({ title: "View Somethimg" }),
                                        isc.IButton.create({ title: "Edit Something" })
                                    ]
                                })
                            ]
                        })
                    },
                    { name: "tab2", title: "Tab 2"}
                ]
            })
        ]
    });

    // pause half a second to let the grid render
    isc.Timer.setTimeout(function () {
        isc.Element.handleToImage(thumbnailLayout.getClipHandle(), 
            function (dataURL) {
                if (thumbnailLayout) {
                    thumbnailLayout.destroy()
                    thumbnailLayout = null;
                }
                autoCallback(dataURL, userCallback)
            }, { scale: .33 });
    }, 500)

}


</script>

</body></html>
<%@ page import="com.isomorphic.util.*" %>