/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.scripting;

import com.isomorphic.log.Logger;
import com.isomorphic.scripting.ScriptXBase;
import java.util.List;

public class ScriptJS
extends ScriptXBase {
    private static Logger log;
    private static boolean useMozillaCompat;

    @Override
    public String getImportDirectives(List imports) throws Exception {
        Object ret;
        Object object = ret = useMozillaCompat ? "try{load(\"nashorn:mozilla_compat.js\");}catch(ignoredBackCompatOnly){};\n" : "";
        if (imports != null) {
            for (String impFullLine : imports) {
                if (impFullLine == null) continue;
                for (String impSplitted : impFullLine.split(";")) {
                    for (String imp : impSplitted.split(" ")) {
                        if ((imp = imp.trim()).equals("")) continue;
                        if (imp.endsWith(";")) {
                            imp = imp.substring(0, imp.length() - 1).trim();
                        }
                        if (!imp.endsWith(".*")) {
                            if (useMozillaCompat) {
                                ret = (String)ret + "importClass(" + imp + ")";
                            } else {
                                String className = imp.substring(imp.lastIndexOf(46) + 1);
                                ret = (String)ret + "var " + className + " = " + imp + ";";
                            }
                        } else if (useMozillaCompat) {
                            ret = (String)ret + "importPackage(Packages." + imp.substring(0, imp.length() - 2) + ")";
                        }
                        ret = (String)ret + "\n";
                    }
                }
            }
            ret = (String)ret + "\n";
        }
        return ret;
    }

    static {
        String defaultImports;
        log = new Logger(ScriptJS.class.getName());
        useMozillaCompat = config.getBoolean((Object)"script.javascript.useMozillaCompat", true);
        if (!useMozillaCompat && (defaultImports = config.getString("script.defaultImports")) != null && defaultImports.indexOf(".*;") != -1) {
            log.warn("ScriptJS is configured to NOT use Mozilla-compatibility mode.  This means it cannot handle wildcard package imports (eg java.util.*), but there is at least one such import specified in property 'script.defaultImports'.  Scan the client docs for 'useMozillaCompat' for more information");
        }
    }
}

