/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.scripting;

import com.isomorphic.base.Base;
import com.isomorphic.base.IScriptSource;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.scripting.IScript;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractScript
extends Base
implements IScript {
    private static Logger log = new Logger(AbstractScript.class.getName());
    protected String engineName;
    protected String script;
    protected List imports;
    protected Map bindingsClassName;
    protected Map bindings;
    protected boolean captureOutput;
    protected String importDirectives;
    protected String headerFilename;
    protected String header;
    protected String footerFilename;
    protected String footer;
    protected IScriptSource scriptSource;
    protected Map scriptSourceContext;
    protected String scriptSourceName;
    protected String scriptSourceFilename;

    @Override
    public Map eval(DataTypeMap data) throws Exception {
        this.configure(data);
        return this.evalScript();
    }

    protected void configure(DataTypeMap data) throws Exception {
        this.engineName = data.getString("engineName");
        this.script = data.getString("script");
        this.captureOutput = data.getBoolean((Object)"captureOutput", false);
        this.bindings = data.getMap("bindings");
        this.bindingsClassName = data.getMap("bindingsClassName");
        this.imports = new ArrayList(data.getList("imports", new ArrayList()));
        String defaultImports = config.getString("script.defaultImports", null);
        if (defaultImports != null) {
            this.imports.add(defaultImports);
        }
        this.importDirectives = this.getImportDirectives(this.imports);
        this.headerFilename = config.getPath("script." + this.engineName + ".header");
        this.header = AbstractScript.readFile(this.headerFilename);
        this.footerFilename = config.getPath("script." + this.engineName + ".footer");
        this.footer = AbstractScript.readFile(this.footerFilename);
        this.scriptSource = (IScriptSource)data.get("scriptSource");
        if (this.scriptSource == null) {
            this.scriptSource = new DefaultScriptSource();
        }
        this.scriptSourceContext = (Map)data.get("scriptSourceContext");
        if (this.scriptSourceContext == null) {
            this.scriptSourceContext = new HashMap();
        }
        this.scriptSourceContext.put("script", this.script);
        this.scriptSourceName = this.scriptSource.getScriptSourceName(this.scriptSourceContext);
        this.scriptSourceFilename = this.scriptSource.getScriptSourceFilename(this.scriptSourceContext);
    }

    protected String getImportDirectives(List imports) throws Exception {
        return null;
    }

    private static String readFile(String fileName) {
        String result = null;
        try {
            ISCFile headerFile = ISCFile.newInstance(fileName);
            if (headerFile.exists()) {
                result = headerFile.getAsString();
            }
        }
        catch (Exception e) {
            log.info("Unable to include file: " + fileName);
        }
        return result;
    }

    protected abstract Map evalScript() throws Exception;

    static class DefaultScriptSource
    implements IScriptSource {
        DefaultScriptSource() {
        }

        @Override
        public String getScriptSourceName(Map scriptSourceContext) throws Exception {
            Object scriptSourceName = scriptSourceContext.get("scriptSourceName");
            if (scriptSourceName == null) {
                return "In-memory script";
            }
            return scriptSourceName.toString();
        }

        @Override
        public String getScriptSourceFilename(Map scriptSourceContext) throws Exception {
            Object scriptSourceFilename = scriptSourceContext.get("scriptSourceFilename");
            if (scriptSourceFilename == null) {
                return "In-memory script";
            }
            return scriptSourceFilename.toString();
        }

        @Override
        public int getScriptSourceOffset(Map scriptSourceContext) throws Exception {
            Object scriptSourceOffset = scriptSourceContext.get("scriptSourceOffset");
            if (scriptSourceOffset == null) {
                return 0;
            }
            return Integer.parseInt(scriptSourceOffset.toString());
        }
    }
}

