/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.io.file;

import com.isomorphic.base.Config;
import com.isomorphic.criteria.Evaluator;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.util.AtomicFileOutputStream;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ISCNativeFile
extends ISCFile {
    private static Logger log = new Logger(ISCNativeFile.class.getName());
    protected File file;
    public static boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
    private static Set illegalCharFilenames = new HashSet();

    public ISCNativeFile(String filename, DSRequest request) {
        super(filename, request);
        String unqualified;
        if (filename == null) {
            return;
        }
        String canonicalized = ISCNativeFile.canonicalizePath(filename);
        int lastSlash = canonicalized.lastIndexOf(47);
        String string = unqualified = lastSlash == -1 ? canonicalized : canonicalized.substring(lastSlash + 1);
        if (Config.getGlobal().getBoolean((Object)"allow.illegal.filename.characters", false) || ISCNativeFile.isSafeFilename(unqualified)) {
            this.file = new File(canonicalized);
        } else {
            File file = this.file = isWindows ? new File("NUL:\\INVALID_FILENAME") : new File("/dev/null/INVALID_FILENAME");
            if (!illegalCharFilenames.contains(unqualified)) {
                log.info("Not attempting to create a File object for filename '" + unqualified + "' because it contains a character that is not allowed in the Windows OS.  Set property 'allow.illegal.filename.characters' true in your server.properties file to suppress this condition");
                illegalCharFilenames.add(unqualified);
            }
        }
    }

    public ISCNativeFile(String path) {
        this(path, null);
    }

    public ISCNativeFile(File file, DSRequest request) {
        super(null, request);
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        this.file = file;
    }

    public ISCNativeFile(File file) {
        this(file, null);
    }

    @Override
    public Object getNativeHandler() {
        return this.file;
    }

    @Override
    public boolean delete() {
        return this.file.delete();
    }

    @Override
    public boolean exists() {
        try {
            return DataTools.caseSensitiveFileExists(this.filename, this.file);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    @Override
    public boolean renameTo(ISCFile destination) {
        Object handler = destination.getNativeHandler();
        if (handler instanceof File) {
            File nativeDestination = (File)handler;
            try {
                boolean result = IOUtil.atomicMove(this.file, nativeDestination);
                if (result) {
                    this.file = nativeDestination;
                    if (this.filename != null) {
                        this.filename = this.file.getCanonicalPath();
                    }
                }
                return result;
            }
            catch (Exception ex) {
                log.warn(ex.toString());
                return false;
            }
        }
        log.warn("renameTo destination was not ISCNativeFile");
        return false;
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this.file.getCanonicalPath();
    }

    @Override
    public boolean canRead() {
        return this.file.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.file.canWrite();
    }

    @Override
    public boolean mkdir() {
        return this.file.mkdir();
    }

    @Override
    public boolean mkdirs() {
        return this.file.mkdirs();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new AtomicFileOutputStream(this.file);
    }

    @Override
    public long length() throws IOException {
        return this.file.length();
    }

    @Override
    public long lastModified() throws IOException {
        return this.file.lastModified();
    }

    @Override
    public boolean setLastModified(long time) {
        return this.file.setLastModified(time);
    }

    @Override
    public boolean isDirectory() throws IOException {
        return this.file.isDirectory();
    }

    @Override
    public List<Map<String, Object>> findChildAttributes(Object criteria, DSRequest request) throws Exception {
        if (request == null) {
            request = this.requestContext;
        }
        Evaluator eval = new Evaluator(criteria, "exact");
        File[] allChildren = this.file.listFiles();
        if (allChildren == null) {
            log.warn("findChildAttributes: attempt to listFiles() in: " + this.file.getCanonicalPath() + " returned null - not a directory?");
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(allChildren.length);
        for (File eachChild : allChildren) {
            ISCNativeFile child = new ISCNativeFile(eachChild, request);
            Map<String, Object> attributes = child.readAttributes();
            if (!eval.valuesMatchCriteria(attributes)) continue;
            result.add(attributes);
        }
        return result;
    }

    @Override
    public List<ISCFile> findChildren(Object criteria, DSRequest request) throws Exception {
        if (request == null) {
            request = this.requestContext;
        }
        Evaluator eval = new Evaluator(criteria, "exact");
        File[] allChildren = this.file.listFiles();
        if (allChildren == null) {
            log.warn("findChildren(): attempt to listFiles() in: " + this.file.getCanonicalPath() + " returned null - not a directory?");
            return new ArrayList<ISCFile>();
        }
        ArrayList<ISCFile> result = new ArrayList<ISCFile>(allChildren.length);
        for (File eachChild : allChildren) {
            ISCNativeFile child = new ISCNativeFile(eachChild, request);
            Map<String, Object> attributes = child.readAttributes();
            if (!eval.valuesMatchCriteria(attributes)) continue;
            result.add(child);
        }
        return result;
    }

    @Override
    public ISCFile getChild(Map<String, Object> primaryKeys, DSRequest request) {
        Set<String> keys;
        if (request == null) {
            request = this.requestContext;
        }
        if ((keys = primaryKeys.keySet()).containsAll(DataSource.FS_PRIMARY_KEYS)) {
            return this.getChild(ISCNativeFile.expandFileExtensions(primaryKeys), request);
        }
        try {
            List<ISCFile> children = this.findChildren(primaryKeys, request);
            if (children.size() == 0) {
                return this.getChild(ISCNativeFile.expandFileExtensions(primaryKeys), request);
            }
            if (children.size() > 1) {
                log.warn("getChild found more than one file -- returning first");
            }
            return children.get(0);
        }
        catch (Exception ex) {
            log.warn(ex.toString());
            return this.getChild(ISCNativeFile.expandFileExtensions(primaryKeys), request);
        }
    }

    @Override
    public ISCFile getChild(String path, DSRequest request) {
        if (request == null) {
            request = this.requestContext;
        }
        File child = new File(this.file, path);
        return new ISCNativeFile(child, request);
    }
}

