/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.FileParquetDataSource;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.conf.PlainParquetConfiguration;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.convert.GroupRecordConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class ParquetDataFetch
extends DataSource {
    @Override
    protected boolean isValidSubclass() {
        return true;
    }

    @Override
    public DSResponse executeFetch(DSRequest req) throws Exception {
        DSResponse res = new DSResponse();
        long startRowL = req.getStartRow();
        long endRowL = req.getEndRow();
        ArrayList allRows = new ArrayList();
        long totalRows = 0L;
        try {
            List sortCriteria;
            MessageType schema;
            DataSource ds = req.getDataSource();
            String fetchUrl = ds.getProperty("fetchUrl");
            FileParquetDataSource inputFile = new FileParquetDataSource(new URL(fetchUrl));
            ParquetReadOptions options = new ParquetReadOptions.Builder((ParquetConfiguration)new PlainParquetConfiguration()).build();
            try (ParquetFileReader metaReader = ParquetFileReader.open((InputFile)inputFile, (ParquetReadOptions)options);){
                ParquetMetadata meta = metaReader.getFooter();
                schema = meta.getFileMetaData().getSchema();
                totalRows = meta.getBlocks().stream().mapToLong(BlockMetaData::getRowCount).sum();
            }
            try (ParquetFileReader reader = ParquetFileReader.open((InputFile)inputFile, (ParquetReadOptions)options);){
                PageReadStore pages;
                while ((pages = reader.readNextRowGroup()) != null) {
                    long groupRowCount = pages.getRowCount();
                    MessageColumnIO messageColumnIO = new ColumnIOFactory().getColumnIO(schema);
                    RecordReader recordReader = messageColumnIO.getRecordReader(pages, (RecordMaterializer)new GroupRecordConverter(schema));
                    for (long i = 0L; i < groupRowCount; ++i) {
                        Group g = (Group)recordReader.read();
                        HashMap<String, Object> row = new HashMap<String, Object>();
                        for (Type t : schema.getFields()) {
                            String fld = t.getName();
                            int idx = schema.getFieldIndex(fld);
                            Object value = this.convertParquetValue(g, idx, t);
                            row.put(fld, value);
                        }
                        allRows.add(row);
                    }
                }
            }
            Map critObj = req.getCriteria();
            Map simpleCrit = null;
            if (critObj instanceof Map) {
                simpleCrit = critObj;
            }
            ArrayList<Map<String, Object>> filteredRows = new ArrayList<Map<String, Object>>();
            if (simpleCrit != null && !simpleCrit.isEmpty()) {
                for (Map map : allRows) {
                    boolean matches = true;
                    for (Map.Entry entry : simpleCrit.entrySet()) {
                        Object critVal;
                        String field = (String)entry.getKey();
                        Object rowVal = map.get(entry.getKey());
                        boolean ok = ParquetDataFetch.valueMatches(rowVal, critVal = entry.getValue());
                        if (ok) continue;
                        matches = false;
                        break;
                    }
                    if (!matches) continue;
                    filteredRows.add(map);
                }
            } else {
                filteredRows = allRows;
            }
            if ((sortCriteria = req.getSortByFields()) != null && !sortCriteria.isEmpty()) {
                ParquetDataFetch.sortRows(filteredRows, sortCriteria);
            }
            ArrayList<Map> arrayList = new ArrayList<Map>();
            int startRow = (int)Math.max(0L, startRowL);
            int endRow = (int)Math.min((long)filteredRows.size(), endRowL);
            for (int i = startRow; i < endRow && i < filteredRows.size(); ++i) {
                arrayList.add((Map)filteredRows.get(i));
            }
            int returnedRows = arrayList.size();
            int actualEndRow = startRow + returnedRows;
            res.setData(arrayList.toArray(new Map[0]));
            res.setStartRow(startRow);
            res.setEndRow(actualEndRow);
            res.setTotalRows((int)totalRows);
            res.setStatus(0);
        }
        catch (Exception e) {
            System.err.println("Error in executeFetch: " + e.getMessage());
            e.printStackTrace();
            HashMap<String, String> errorMap = new HashMap<String, String>();
            errorMap.put("error", e.getMessage());
            res.setData(new Map[]{errorMap});
            res.setStatus(-1);
        }
        return res;
    }

    private Object convertParquetValue(Group g, int idx, Type type) {
        try {
            if (g.getFieldRepetitionCount(idx) == 0) {
                return null;
            }
            PrimitiveType primitiveType = type.asPrimitiveType();
            switch (primitiveType.getPrimitiveTypeName()) {
                case INT32: {
                    return g.getInteger(idx, 0);
                }
                case INT64: {
                    return g.getLong(idx, 0);
                }
                case FLOAT: {
                    return Float.valueOf(g.getFloat(idx, 0));
                }
                case DOUBLE: {
                    return g.getDouble(idx, 0);
                }
                case BOOLEAN: {
                    return g.getBoolean(idx, 0);
                }
                case BINARY: {
                    return g.getString(idx, 0);
                }
                case INT96: {
                    Binary binary = g.getInt96(idx, 0);
                    return binary.toString();
                }
            }
            return g.getValueToString(idx, 0);
        }
        catch (Exception e) {
            return g.getValueToString(idx, 0);
        }
    }

    public static void sortRows(List<Map<String, Object>> rows, List<String> criteria) {
        rows.sort((r1, r2) -> {
            for (String crit : criteria) {
                Object val2;
                boolean desc = crit.startsWith("-");
                String field = desc ? crit.substring(1) : crit;
                Object val1 = r1.get(field);
                int cmp = ParquetDataFetch.compareValues(val1, val2 = r2.get(field));
                if (cmp == 0) continue;
                return desc ? -cmp : cmp;
            }
            return 0;
        });
    }

    private static int compareValues(Object a, Object b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a.getClass().equals(b.getClass()) && a instanceof Comparable) {
            return ((Comparable)a).compareTo(b);
        }
        if (ParquetDataFetch.isNumeric(a) && ParquetDataFetch.isNumeric(b)) {
            try {
                Double d1 = Double.parseDouble(a.toString());
                Double d2 = Double.parseDouble(b.toString());
                return d1.compareTo(d2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return a.toString().compareTo(b.toString());
    }

    private static boolean isNumeric(Object obj) {
        if (obj instanceof Number) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        String str = obj.toString().trim();
        if (str.isEmpty()) {
            return false;
        }
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean valueMatches(Object rowVal, Object critVal) {
        String s;
        if (critVal == null) {
            return true;
        }
        if (rowVal == null) {
            return false;
        }
        if (critVal instanceof Collection) {
            for (Object v : (Collection)critVal) {
                if (!ParquetDataFetch.singleValueMatch(rowVal, v)) continue;
                return true;
            }
            return false;
        }
        if (critVal.getClass().isArray()) {
            int len = Array.getLength(critVal);
            for (int i = 0; i < len; ++i) {
                Object v = Array.get(critVal, i);
                if (!ParquetDataFetch.singleValueMatch(rowVal, v)) continue;
                return true;
            }
            return false;
        }
        if (critVal instanceof String && ((s = ((String)critVal).trim()).contains("|") || s.contains(","))) {
            for (String token : s.split("\\s*[|,]\\s*")) {
                if (token.isEmpty() || !ParquetDataFetch.singleValueMatch(rowVal, token)) continue;
                return true;
            }
            return false;
        }
        return ParquetDataFetch.singleValueMatch(rowVal, critVal);
    }

    private static boolean singleValueMatch(Object rowVal, Object critVal) {
        String rStr = String.valueOf(rowVal).trim();
        String cStr = String.valueOf(critVal).trim();
        if (rStr.isEmpty() || cStr.isEmpty()) {
            return false;
        }
        if (ParquetDataFetch.looksNumeric(rStr)) {
            NumericFilter nf = ParquetDataFetch.parseNumericFilter(cStr);
            if (nf != null) {
                Double rv = ParquetDataFetch.safeToDouble(rStr);
                return rv != null && nf.test(rv);
            }
            if (ParquetDataFetch.looksNumeric(cStr)) {
                Double d1 = ParquetDataFetch.safeToDouble(rStr);
                Double d2 = ParquetDataFetch.safeToDouble(cStr);
                if (d1 != null && d2 != null) {
                    return Double.compare(d1, d2) == 0;
                }
            }
        }
        Boolean rb = ParquetDataFetch.asBooleanOrNull(rStr);
        Boolean cb = ParquetDataFetch.asBooleanOrNull(cStr);
        if (rb != null && cb != null) {
            return rb.equals(cb);
        }
        return rStr.toLowerCase().contains(cStr.toLowerCase());
    }

    private static boolean looksNumeric(String s) {
        return s.matches("[+-]?\\d+(\\.\\d+)?");
    }

    private static Double safeToDouble(String s) {
        try {
            return Double.valueOf(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Boolean asBooleanOrNull(String s) {
        if (s.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static NumericFilter parseNumericFilter(String s) {
        Double v;
        if ((s = s.trim()).contains("..")) {
            String[] parts = s.split("\\.\\.");
            if (parts.length == 2) {
                Double a = ParquetDataFetch.safeToDouble(parts[0].trim());
                Double b = ParquetDataFetch.safeToDouble(parts[1].trim());
                if (a != null && b != null) {
                    return new NumericFilter(a, b);
                }
            }
            return null;
        }
        String op = null;
        String num = null;
        if (s.startsWith(">=")) {
            op = ">=";
            num = s.substring(2);
        } else if (s.startsWith("<=")) {
            op = "<=";
            num = s.substring(2);
        } else if (s.startsWith(">")) {
            op = ">";
            num = s.substring(1);
        } else if (s.startsWith("<")) {
            op = "<";
            num = s.substring(1);
        } else if (ParquetDataFetch.looksNumeric(s)) {
            op = "==";
            num = s;
        }
        if (op != null && (v = ParquetDataFetch.safeToDouble(num.trim())) != null) {
            return new NumericFilter(op, v);
        }
        return null;
    }

    private static final class NumericFilter {
        final Kind kind;
        final String op;
        final Double a;
        final Double b;

        NumericFilter(String op, Double a) {
            this.kind = Kind.OP;
            this.op = op;
            this.a = a;
            this.b = null;
        }

        NumericFilter(Double a, Double b) {
            this.kind = Kind.RANGE;
            this.op = null;
            this.a = a;
            this.b = b;
        }

        boolean test(double x) {
            if (this.kind == Kind.RANGE) {
                return x >= this.a && x <= this.b;
            }
            switch (this.op) {
                case ">": {
                    return x > this.a;
                }
                case ">=": {
                    return x >= this.a;
                }
                case "<": {
                    return x < this.a;
                }
                case "<=": {
                    return x <= this.a;
                }
                case "==": {
                    return Double.compare(x, this.a) == 0;
                }
            }
            return false;
        }

        static enum Kind {
            OP,
            RANGE;

        }
    }
}

