/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.core.client.impl.Impl;
import javaemul.internal.ArrayHelper;

public class StackTraceCreator {
    private static final int DROP_FRAME_LIMIT = 5;
    private static final int LINE_NUMBER_UNKNOWN = -1;
    private static final String ANONYMOUS = "anonymous";
    private static final String UNKNOWN = "Unknown";
    static final Collector collector;

    private static native int parseInt(String var0);

    public static void captureStackTrace(Object error) {
        collector.collect(error);
    }

    public static StackTraceElement[] constructJavaStackTrace(Throwable thrown) {
        StackTraceElement[] stackTrace = collector.getStackTrace(thrown);
        return StackTraceCreator.dropInternalFrames(stackTrace);
    }

    private static StackTraceElement[] dropInternalFrames(StackTraceElement[] stackTrace) {
        String dropFrameUntilFnName = Impl.getNameOf("@com.google.gwt.core.client.impl.StackTraceCreator::captureStackTrace(*)");
        String dropFrameUntilFnName2 = Impl.getNameOf("@java.lang.Throwable::initializeBackingError(*)");
        int numberOfFramesToSearch = Math.min(stackTrace.length, 5);
        for (int i = numberOfFramesToSearch - 1; i >= 0; --i) {
            if (!stackTrace[i].getMethodName().equals(dropFrameUntilFnName) && !stackTrace[i].getMethodName().equals(dropFrameUntilFnName2)) continue;
            StackTraceCreator.splice(stackTrace, i + 1);
            break;
        }
        return stackTrace;
    }

    private static <T> void splice(Object[] arr, int length) {
        if (arr.length >= length) {
            ArrayHelper.removeFrom(arr, 0, length);
        }
    }

    private static native boolean supportsErrorStack();

    private static native JsArrayString getFnStack(Object var0);

    private static native String getFunctionName(JavaScriptObject var0);

    static native String extractFunctionName(String var0);

    private static native JsArrayString split(Object var0);

    static {
        boolean enforceLegacy = !StackTraceCreator.supportsErrorStack();
        Collector c = (Collector)GWT.create(Collector.class);
        collector = c instanceof CollectorModern && enforceLegacy ? new CollectorLegacy() : c;
    }

    static abstract class Collector {
        Collector() {
        }

        public abstract void collect(Object var1);

        public abstract StackTraceElement[] getStackTrace(Object var1);
    }

    static class CollectorModern
    extends Collector {
        CollectorModern() {
        }

        @Override
        public void collect(Object error) {
        }

        @Override
        public StackTraceElement[] getStackTrace(Object t) {
            JsArrayString stack = StackTraceCreator.split(t);
            StackTraceElement[] stackTrace = new StackTraceElement[]{};
            int addIndex = 0;
            int length = stack.length();
            if (length == 0) {
                return stackTrace;
            }
            StackTraceElement ste = this.parse(stack.get(0));
            if (!ste.getMethodName().equals(StackTraceCreator.ANONYMOUS)) {
                stackTrace[addIndex++] = ste;
            }
            for (int i = 1; i < length; ++i) {
                stackTrace[addIndex++] = this.parse(stack.get(i));
            }
            return stackTrace;
        }

        private StackTraceElement parse(String stString) {
            int index;
            String location = "";
            if (stString.isEmpty()) {
                return this.createSte(StackTraceCreator.UNKNOWN, StackTraceCreator.ANONYMOUS, -1, -1);
            }
            String toReturn = stString.trim();
            if (toReturn.startsWith("at ")) {
                toReturn = toReturn.substring(3);
            }
            if ((index = (toReturn = this.stripSquareBrackets(toReturn)).indexOf("(")) == -1) {
                index = toReturn.indexOf("@");
                if (index == -1) {
                    location = toReturn;
                    toReturn = "";
                } else {
                    location = toReturn.substring(index + 1).trim();
                    toReturn = toReturn.substring(0, index).trim();
                }
            } else {
                int closeParen = toReturn.indexOf(")", index);
                location = toReturn.substring(index + 1, closeParen);
                toReturn = toReturn.substring(0, index).trim();
            }
            index = toReturn.indexOf(46);
            if (index != -1) {
                toReturn = toReturn.substring(index + 1);
            }
            String ieAnonymousFunctionName = "Anonymous function";
            if (toReturn.isEmpty() || toReturn.equals("Anonymous function")) {
                toReturn = StackTraceCreator.ANONYMOUS;
            }
            int lastColonIndex = location.lastIndexOf(58);
            int endFileUrlIndex = location.lastIndexOf(58, lastColonIndex - 1);
            int line = -1;
            int col = -1;
            String fileName = StackTraceCreator.UNKNOWN;
            if (lastColonIndex != -1 && endFileUrlIndex != -1) {
                fileName = location.substring(0, endFileUrlIndex);
                line = StackTraceCreator.parseInt(location.substring(endFileUrlIndex + 1, lastColonIndex));
                col = StackTraceCreator.parseInt(location.substring(lastColonIndex + 1));
            }
            return this.createSte(fileName, toReturn, line, col);
        }

        protected StackTraceElement createSte(String fileName, String method, int line, int col) {
            return new StackTraceElement(StackTraceCreator.UNKNOWN, method, fileName + "@" + col, line < 0 ? -1 : line);
        }

        private native String stripSquareBrackets(String var1);
    }

    static class CollectorLegacy
    extends Collector {
        CollectorLegacy() {
        }

        @Override
        public native void collect(Object var1);

        @Override
        public StackTraceElement[] getStackTrace(Object t) {
            JsArrayString stack = StackTraceCreator.getFnStack(t);
            int length = stack.length();
            StackTraceElement[] stackTrace = new StackTraceElement[length];
            for (int i = 0; i < length; ++i) {
                stackTrace[i] = new StackTraceElement(StackTraceCreator.UNKNOWN, stack.get(i), null, -1);
            }
            return stackTrace;
        }
    }

    static class CollectorNull
    extends Collector {
        CollectorNull() {
        }

        @Override
        public void collect(Object error) {
        }

        @Override
        public StackTraceElement[] getStackTrace(Object ignored) {
            return new StackTraceElement[0];
        }
    }

    static class CollectorModernNoSourceMap
    extends CollectorModern {
        CollectorModernNoSourceMap() {
        }

        @Override
        protected StackTraceElement createSte(String fileName, String method, int line, int col) {
            return new StackTraceElement(StackTraceCreator.UNKNOWN, method, fileName, -1);
        }
    }

    static final class CollectorEmulated
    extends Collector {
        CollectorEmulated() {
        }

        @Override
        public native void collect(Object var1);

        @Override
        public StackTraceElement[] getStackTrace(Object t) {
            JsArray stack = (JsArray)StackTraceCreator.getFnStack(t).cast();
            StackTraceElement[] stackTrace = new StackTraceElement[stack.length()];
            for (int i = 0; i < stackTrace.length; ++i) {
                JsArrayString frame = (JsArrayString)stack.get(i);
                String name = frame.get(0);
                String location = frame.get(1);
                String fileName = null;
                int lineNumber = -1;
                if (location != null) {
                    int idx = location.indexOf(58);
                    if (idx != -1) {
                        fileName = location.substring(0, idx);
                        lineNumber = StackTraceCreator.parseInt(location.substring(idx + 1));
                    } else {
                        lineNumber = StackTraceCreator.parseInt(location);
                    }
                }
                stackTrace[i] = new StackTraceElement(StackTraceCreator.UNKNOWN, name, fileName, lineNumber);
            }
            return stackTrace;
        }
    }
}

