/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client.impl;

import com.google.gwt.core.client.Duration;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.core.client.Scheduler;

public class SchedulerImpl
extends Scheduler {
    public static final SchedulerImpl INSTANCE = (SchedulerImpl)GWT.create(SchedulerImpl.class);
    private static final int FLUSHER_DELAY = 1;
    private static final int RESCUE_DELAY = 50;
    private static final double TIME_SLICE = 16.0;
    Flusher flusher;
    Rescuer rescue;
    JsArray<Task> deferredCommands;
    JsArray<Task> entryCommands;
    JsArray<Task> finallyCommands;
    JsArray<Task> incrementalCommands;
    private boolean flushRunning = false;
    private boolean shouldBeRunning = false;

    private static JsArray<Task> createQueue() {
        return (JsArray)JavaScriptObject.createArray().cast();
    }

    private static boolean execute(Scheduler.RepeatingCommand cmd) {
        return cmd.execute();
    }

    private static JsArray<Task> push(JsArray<Task> queue, Task task) {
        if (queue == null) {
            queue = SchedulerImpl.createQueue();
        }
        queue.push(task);
        return queue;
    }

    private static JsArray<Task> runScheduledTasks(JsArray<Task> tasks, JsArray<Task> rescheduled) {
        assert (tasks != null) : "tasks";
        int j = tasks.length();
        for (int i = 0; i < j; ++i) {
            assert (tasks.length() == j) : "Working array length changed " + tasks.length() + " != " + j;
            Task t = tasks.get(i);
            try {
                if (t.isRepeating()) {
                    if (!t.executeRepeating()) continue;
                    rescheduled = SchedulerImpl.push(rescheduled, t);
                    continue;
                }
                t.executeScheduled();
                continue;
            }
            catch (Throwable e) {
                GWT.reportUncaughtException(e);
            }
        }
        return rescheduled;
    }

    private static native void scheduleFixedDelayImpl(Scheduler.RepeatingCommand var0, int var1);

    private static native void scheduleFixedPeriodImpl(Scheduler.RepeatingCommand var0, int var1);

    public void flushEntryCommands() {
        if (this.entryCommands != null) {
            JsArray<Task> rescheduled = null;
            do {
                JsArray<Task> oldQueue = this.entryCommands;
                this.entryCommands = null;
                rescheduled = SchedulerImpl.runScheduledTasks(oldQueue, rescheduled);
            } while (this.entryCommands != null);
            this.entryCommands = rescheduled;
        }
    }

    public void flushFinallyCommands() {
        if (this.finallyCommands != null) {
            JsArray<Task> rescheduled = null;
            do {
                JsArray<Task> oldQueue = this.finallyCommands;
                this.finallyCommands = null;
                rescheduled = SchedulerImpl.runScheduledTasks(oldQueue, rescheduled);
            } while (this.finallyCommands != null);
            this.finallyCommands = rescheduled;
        }
    }

    @Override
    public void scheduleDeferred(Scheduler.ScheduledCommand cmd) {
        this.deferredCommands = SchedulerImpl.push(this.deferredCommands, Task.create(cmd));
        this.maybeSchedulePostEventPumpCommands();
    }

    @Override
    public void scheduleEntry(Scheduler.RepeatingCommand cmd) {
        this.entryCommands = SchedulerImpl.push(this.entryCommands, Task.create(cmd));
    }

    @Override
    public void scheduleEntry(Scheduler.ScheduledCommand cmd) {
        this.entryCommands = SchedulerImpl.push(this.entryCommands, Task.create(cmd));
    }

    @Override
    public void scheduleFinally(Scheduler.RepeatingCommand cmd) {
        this.finallyCommands = SchedulerImpl.push(this.finallyCommands, Task.create(cmd));
    }

    @Override
    public void scheduleFinally(Scheduler.ScheduledCommand cmd) {
        this.finallyCommands = SchedulerImpl.push(this.finallyCommands, Task.create(cmd));
    }

    @Override
    public void scheduleFixedDelay(Scheduler.RepeatingCommand cmd, int delayMs) {
        SchedulerImpl.scheduleFixedDelayImpl(cmd, delayMs);
    }

    @Override
    public void scheduleFixedPeriod(Scheduler.RepeatingCommand cmd, int delayMs) {
        SchedulerImpl.scheduleFixedPeriodImpl(cmd, delayMs);
    }

    @Override
    public void scheduleIncremental(Scheduler.RepeatingCommand cmd) {
        this.deferredCommands = SchedulerImpl.push(this.deferredCommands, Task.create(cmd));
        this.maybeSchedulePostEventPumpCommands();
    }

    Duration createDuration() {
        return new Duration();
    }

    void flushPostEventPumpCommands() {
        if (this.deferredCommands != null) {
            JsArray<Task> oldDeferred = this.deferredCommands;
            this.deferredCommands = null;
            if (this.incrementalCommands == null) {
                this.incrementalCommands = SchedulerImpl.createQueue();
            }
            SchedulerImpl.runScheduledTasks(oldDeferred, this.incrementalCommands);
        }
        if (this.incrementalCommands != null) {
            this.incrementalCommands = this.runRepeatingTasks(this.incrementalCommands);
        }
    }

    boolean isWorkQueued() {
        return this.deferredCommands != null || this.incrementalCommands != null;
    }

    private void maybeSchedulePostEventPumpCommands() {
        if (!this.shouldBeRunning) {
            this.shouldBeRunning = true;
            if (this.flusher == null) {
                this.flusher = new Flusher();
            }
            SchedulerImpl.scheduleFixedDelayImpl(this.flusher, 1);
            if (this.rescue == null) {
                this.rescue = new Rescuer();
            }
            SchedulerImpl.scheduleFixedDelayImpl(this.rescue, 50);
        }
    }

    private JsArray<Task> runRepeatingTasks(JsArray<Task> tasks) {
        int i;
        assert (tasks != null) : "tasks";
        int length = tasks.length();
        if (length == 0) {
            return null;
        }
        boolean canceledSomeTasks = false;
        Duration duration = this.createDuration();
        while ((double)duration.elapsedMillis() < 16.0) {
            boolean executedSomeTask = false;
            for (i = 0; i < length; ++i) {
                assert (tasks.length() == length) : "Working array length changed " + tasks.length() + " != " + length;
                Task t = tasks.get(i);
                if (t == null) continue;
                executedSomeTask = true;
                assert (t.isRepeating()) : "Found a non-repeating Task";
                if (t.executeRepeating()) continue;
                tasks.set(i, null);
                canceledSomeTasks = true;
            }
            if (executedSomeTask) continue;
            break;
        }
        if (canceledSomeTasks) {
            JsArray<Task> newTasks = SchedulerImpl.createQueue();
            for (i = 0; i < length; ++i) {
                if (tasks.get(i) == null) continue;
                newTasks.push(tasks.get(i));
            }
            assert (newTasks.length() < length);
            return newTasks.length() == 0 ? null : newTasks;
        }
        return tasks;
    }

    static final class Task
    extends JavaScriptObject {
        public static native Task create(Scheduler.RepeatingCommand var0);

        public static native Task create(Scheduler.ScheduledCommand var0);

        protected Task() {
        }

        public boolean executeRepeating() {
            return this.getRepeating().execute();
        }

        public void executeScheduled() {
            this.getScheduled().execute();
        }

        public native Scheduler.RepeatingCommand getRepeating();

        public native Scheduler.ScheduledCommand getScheduled();

        public native boolean isRepeating();
    }

    private final class Flusher
    implements Scheduler.RepeatingCommand {
        private Flusher() {
        }

        @Override
        public boolean execute() {
            SchedulerImpl.this.flushRunning = true;
            SchedulerImpl.this.flushPostEventPumpCommands();
            SchedulerImpl.this.flushRunning = false;
            return SchedulerImpl.this.shouldBeRunning = SchedulerImpl.this.isWorkQueued();
        }
    }

    private final class Rescuer
    implements Scheduler.RepeatingCommand {
        private Rescuer() {
        }

        @Override
        public boolean execute() {
            if (SchedulerImpl.this.flushRunning) {
                SchedulerImpl.this.scheduleFixedDelay(SchedulerImpl.this.flusher, 1);
            }
            return SchedulerImpl.this.shouldBeRunning;
        }
    }
}

