/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import org.hibernate.engine.jdbc.cursor.spi.RefCursorSupport;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.exec.spi.JdbcCallRefCursorExtractor;

public class JdbcCallRefCursorExtractorImpl
implements JdbcCallRefCursorExtractor {
    private final String jdbcParameterName;
    private final int jdbcParameterPosition;

    public JdbcCallRefCursorExtractorImpl(String jdbcParameterName, int jdbcParameterPosition) {
        this.jdbcParameterName = jdbcParameterName;
        this.jdbcParameterPosition = jdbcParameterPosition;
    }

    @Override
    public ResultSet extractResultSet(CallableStatement callableStatement, SharedSessionContractImplementor session) {
        boolean useNamed;
        boolean supportsNamedParameters = session.getJdbcServices().getJdbcEnvironment().getExtractedDatabaseMetaData().supportsNamedParameters();
        boolean bl = useNamed = supportsNamedParameters && this.jdbcParameterName != null;
        if (useNamed) {
            return session.getFactory().getServiceRegistry().requireService(RefCursorSupport.class).getResultSet(callableStatement, this.jdbcParameterName);
        }
        return session.getFactory().getServiceRegistry().requireService(RefCursorSupport.class).getResultSet(callableStatement, this.jdbcParameterPosition);
    }
}

