/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.util;

import jakarta.persistence.LockModeType;
import org.hibernate.LockMode;
import org.hibernate.internal.util.LockModeConverter;

public final class LockModeTypeHelper {
    private LockModeTypeHelper() {
    }

    public static LockModeType getLockModeType(LockMode lockMode) {
        return LockModeConverter.convertToLockModeType(lockMode);
    }

    public static LockMode getLockMode(LockModeType lockModeType) {
        return LockModeConverter.convertToLockMode(lockModeType);
    }

    public static LockMode interpretLockMode(Object value) {
        if (value == null) {
            return LockMode.NONE;
        }
        if (value instanceof LockMode) {
            return (LockMode)((Object)value);
        }
        if (value instanceof LockModeType) {
            return LockModeTypeHelper.getLockMode((LockModeType)value);
        }
        if (value instanceof String) {
            return LockMode.fromExternalForm((String)value);
        }
        throw new IllegalArgumentException("Unknown lock mode source: '" + value + "'; can't convert from value of type " + value.getClass());
    }
}

