/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.spring;

import com.isomorphic.log.Logger;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;

public class ContextLoaderListener
extends org.springframework.web.context.ContextLoaderListener {
    private static Logger log = new Logger(ContextLoaderListener.class.getName());
    public static final String STOP_ON_ERROR_PARAM = "stopOnError";

    public void contextInitialized(ServletContextEvent sce) {
        try {
            super.contextInitialized(sce);
        }
        catch (RuntimeException e) {
            log.error((Object)"Spring context init failed", (Throwable)e);
            this.propagateExceptionIfConfigured(sce, e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        try {
            super.contextDestroyed(sce);
        }
        catch (RuntimeException e) {
            log.error((Object)"Spring context destroy failed", (Throwable)e);
            this.propagateExceptionIfConfigured(sce, e);
        }
    }

    private void propagateExceptionIfConfigured(ServletContextEvent sce, RuntimeException e) {
        ServletContext context = sce.getServletContext();
        String stopOnError = context.getInitParameter(STOP_ON_ERROR_PARAM);
        if (stopOnError != null) {
            stopOnError = stopOnError.trim();
        }
        if (Boolean.parseBoolean(stopOnError)) {
            throw e;
        }
    }
}

