/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.auth;

import com.isomorphic.auth.AuthenticatedUser;
import com.isomorphic.auth.AuthenticatorHandledResponse;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceAuthenticator;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.DataTools;
import java.security.Principal;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class BearerTokenAuthenticator
extends DataSourceAuthenticator {
    public String authorizationPrefix = "Bearer ";
    public String tokenDataSource = "token";
    public String tokenFetchOperation = "fetch";
    public String tokenFetchOperationId = "_fetch";
    public String tokenUsernameField = "username";
    public String tokenField = "access_token";
    public String tokenExpiresField = "expires";
    public int allowableDriftSeconds = 5;
    private String userCacheKey = "bearerTokenUser";
    private String userIdCacheKey = "bearerTokenUserId";

    @Override
    public Object getUserId(RequestContext context) throws Exception {
        DateTime nowMinusAllowableDrift;
        DateTime tokenExpires;
        Object cachedUserId = context.request.getAttribute(this.userIdCacheKey);
        if (cachedUserId != null) {
            return cachedUserId;
        }
        String authorizationHeader = context.request.getHeader("Authorization");
        if (authorizationHeader == null) {
            context.response.sendError(401);
            this.log.error("Null Authorization header - unable to authenticate request");
            throw new AuthenticatorHandledResponse();
        }
        if (!authorizationHeader.startsWith(this.authorizationPrefix)) {
            context.response.sendError(401);
            this.log.error("Malformed Authorization header - missing required '" + this.authorizationPrefix + "' prefix");
            throw new AuthenticatorHandledResponse();
        }
        String bearerToken = authorizationHeader.substring(this.authorizationPrefix.length()).trim();
        Map<String, Object> m = new DSRequest(this.tokenDataSource, this.tokenFetchOperation).setOperationId(this.tokenFetchOperationId).setCriteria((Object)DataTools.buildMap(this.tokenField, bearerToken)).setUserRoles("SuperUser").execute().getRecord();
        if (m == null || m.size() == 0) {
            context.response.sendError(401);
            throw new AuthenticatorHandledResponse();
        }
        DataTypeMap<String, Object> userRow = new DataTypeMap<String, Object>(m);
        long tokenExpiresSeconds = userRow.getLong((Object)this.tokenExpiresField, -1L);
        if (tokenExpiresSeconds != -1L && (tokenExpires = new DateTime(tokenExpiresSeconds * 1000L, DateTimeZone.UTC)).isBefore((ReadableInstant)(nowMinusAllowableDrift = new DateTime(DateTimeZone.UTC).minusSeconds(this.allowableDriftSeconds)))) {
            context.response.sendError(401);
            throw new AuthenticatorHandledResponse();
        }
        String username = userRow.getString(this.tokenUsernameField);
        this.log.debug("Bearer token auth succeded for username: " + username);
        context.request.setAttribute(this.userIdCacheKey, username);
        return username;
    }

    @Override
    public Principal getUser(RequestContext context) throws Exception {
        AuthenticatedUser cachedUser = (AuthenticatedUser)context.request.getAttribute(this.userCacheKey);
        if (cachedUser != null) {
            return cachedUser;
        }
        Object userId = this.getUserId(context);
        AuthenticatedUser user = this.principalForUserId(userId);
        context.request.setAttribute(this.userCacheKey, user);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticatedUser principalForUserId(Object userId) throws Exception {
        DataSource ds = DataSourceManager.getDataSource(this.datasource, null);
        if (ds == null) {
            throw new Exception("Unable to load datasource: " + this.datasource + " for authentication");
        }
        try {
            Map userRow = ds.selectSingle(this.usernameField, userId);
            if (userRow == null || userRow.size() == 0) {
                throw new Exception("Unable to find user recored for username: " + userId.toString());
            }
            userRow.remove(this.passwordField);
            AuthenticatedUser authenticatedUser = new AuthenticatedUser((String)userRow.get(this.usernameField), userRow, this);
            return authenticatedUser;
        }
        finally {
            try {
                DataSourceManager.freeDataSource(ds);
            }
            catch (Exception exception) {}
        }
    }
}

