/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.extend.form;

import javax.swing.JComponent;
import javax.swing.JTextField;
import org.w3c.dom.Element;
import org.xhtmlrenderer.simple.extend.XhtmlForm;
import org.xhtmlrenderer.simple.extend.form.InputField;
import org.xhtmlrenderer.simple.extend.form.SizeLimitedDocument;
import org.xhtmlrenderer.util.GeneralUtil;

class TextField
extends InputField {
    public TextField(Element e, XhtmlForm form) {
        super(e, form);
    }

    public JComponent create() {
        JTextField textfield = new JTextField();
        if (this.hasAttribute("size")) {
            int size = GeneralUtil.parseIntRelaxed(this.getAttribute("size"));
            if (size == 0) {
                textfield.setColumns(15);
            } else {
                textfield.setColumns(size);
            }
        } else {
            textfield.setColumns(15);
        }
        if (this.hasAttribute("maxlength")) {
            textfield.setDocument(new SizeLimitedDocument(GeneralUtil.parseIntRelaxed(this.getAttribute("maxlength"))));
        }
        if (this.hasAttribute("readonly") && this.getAttribute("readonly").equals("readonly")) {
            textfield.setEditable(false);
        }
        return textfield;
    }

    protected void applyOriginalState() {
        JTextField textfield = (JTextField)this.getComponent();
        textfield.setText(this.getOriginalState().getValue());
        textfield.setCaretPosition(0);
    }

    protected String[] getFieldValues() {
        JTextField textfield = (JTextField)this.getComponent();
        return new String[]{textfield.getText()};
    }
}

