/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal;

import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;

public class ExpressionDomainResultProducer
implements DomainResultProducer<Object>,
Expression {
    private final Expression expression;

    public ExpressionDomainResultProducer(Expression expression) {
        this.expression = expression;
    }

    @Override
    public DomainResult<Object> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(creationState);
        return new BasicResult<Object>(sqlSelection.getValuesArrayPosition(), resultVariable, this.expression.getExpressionType().getSingleJdbcMapping(), null);
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        this.resolveSqlSelection(creationState);
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.expression.accept(sqlTreeWalker);
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        return this.expression.getExpressionType();
    }

    private SqlSelection resolveSqlSelection(DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        return sqlAstCreationState.getSqlExpressionResolver().resolveSqlSelection(this.expression, this.expression.getExpressionType().getSingleJdbcMapping().getJdbcJavaType(), null, sqlAstCreationState.getCreationContext().getSessionFactory().getTypeConfiguration());
    }
}

