/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.complete;

import java.util.BitSet;
import java.util.function.Function;
import org.hibernate.LockMode;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerProducer;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.entity.EntityResult;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.internal.EntityAssembler;
import org.hibernate.sql.results.graph.entity.internal.EntityResultInitializer;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;

public class EntityResultImpl
implements EntityResult,
InitializerProducer<EntityResultImpl> {
    private final NavigablePath navigablePath;
    private final EntityValuedModelPart entityValuedModelPart;
    private final Fetch identifierFetch;
    private final BasicFetch<?> discriminatorFetch;
    private final ImmutableFetchList fetches;
    private final boolean hasJoinFetches;
    private final boolean containsCollectionFetches;
    private final String resultAlias;
    private final LockMode lockMode;

    public EntityResultImpl(NavigablePath navigablePath, EntityValuedModelPart entityValuedModelPart, String resultAlias, LockMode lockMode, Function<EntityResultImpl, BasicFetch<?>> discriminatorFetchBuilder, DomainResultCreationState creationState) {
        this.navigablePath = navigablePath;
        this.entityValuedModelPart = entityValuedModelPart;
        this.resultAlias = resultAlias;
        this.lockMode = lockMode;
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        sqlAstCreationState.getFromClauseAccess().resolveTableGroup(navigablePath, np -> entityValuedModelPart.getEntityMappingType().getEntityPersister().createRootTableGroup(true, navigablePath, null, null, () -> p -> {}, sqlAstCreationState));
        this.identifierFetch = creationState.visitIdentifierFetch(this);
        this.discriminatorFetch = discriminatorFetchBuilder.apply(this);
        this.fetches = creationState.visitFetches(this);
        this.hasJoinFetches = this.fetches.hasJoinFetches();
        this.containsCollectionFetches = this.fetches.containsCollectionFetches();
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public EntityValuedModelPart getReferencedMappingType() {
        return this.entityValuedModelPart;
    }

    @Override
    public EntityValuedModelPart getEntityValuedModelPart() {
        return this.entityValuedModelPart;
    }

    @Override
    public String getResultVariable() {
        return this.resultAlias;
    }

    @Override
    public ImmutableFetchList getFetches() {
        return this.fetches;
    }

    @Override
    public Fetch findFetch(Fetchable fetchable) {
        return this.fetches.get(fetchable);
    }

    @Override
    public boolean hasJoinFetches() {
        return this.hasJoinFetches;
    }

    @Override
    public boolean containsCollectionFetches() {
        return this.containsCollectionFetches;
    }

    @Override
    public void collectValueIndexesToCache(BitSet valueIndexes) {
        EntityPersister entityPersister = this.entityValuedModelPart.getEntityMappingType().getEntityPersister();
        this.identifierFetch.collectValueIndexesToCache(valueIndexes);
        if (!entityPersister.useShallowQueryCacheLayout()) {
            if (this.discriminatorFetch != null) {
                this.discriminatorFetch.collectValueIndexesToCache(valueIndexes);
            }
            EntityResult.super.collectValueIndexesToCache(valueIndexes);
        } else if (entityPersister.storeDiscriminatorInShallowQueryCacheLayout() && this.discriminatorFetch != null) {
            this.discriminatorFetch.collectValueIndexesToCache(valueIndexes);
        }
    }

    public DomainResultAssembler<?> createResultAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        return new EntityAssembler(this.getResultJavaType(), creationState.resolveInitializer(this, parentAccess, this).asEntityInitializer());
    }

    @Override
    public Initializer createInitializer(EntityResultImpl resultGraphNode, FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        return resultGraphNode.createInitializer(parentAccess, creationState);
    }

    @Override
    public Initializer createInitializer(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        return new EntityResultInitializer((EntityResultGraphNode)this, this.getNavigablePath(), this.lockMode, this.identifierFetch, this.discriminatorFetch, null, creationState);
    }
}

