/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.base.Init;
import com.isomorphic.base.InitListener;
import com.isomorphic.base.Reflection;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class BaseServlet
extends HttpServlet {
    protected static Config config;
    protected static String webRoot;
    protected Logger log;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        Init.go(servletConfig.getServletContext(), true);
        config = Config.getGlobal();
        webRoot = config.getPath("webRoot");
        String servletName = servletConfig.getServletName();
        String className = ((Object)((Object)this)).getClass().getName();
        String logPrefix = null;
        if (!className.endsWith(servletName)) {
            logPrefix = servletName;
        }
        this.log = new Logger(className, logPrefix);
        ServletTools.applyConfigToServletOrFilter((Object)this, servletConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean wasIgnored = Logger.threadIgnored();
        boolean mustPopLogContext = false;
        try {
            if (ServletTools.ignoreLog(request)) {
                Logger.ignoreThread();
            }
            boolean hadThreadLocal = RequestContext.getThreadLocal() != null;
            RequestContext requestContext = RequestContext.instance((Servlet)this, request, response);
            if (hadThreadLocal) {
                RequestContext.pushThreadLocal(requestContext);
            }
            mustPopLogContext = ServletTools.pushClientLogContext(request);
            if (request.getMethod().equalsIgnoreCase("PATCH")) {
                this.doPatch(request, response);
            } else {
                super.service(request, response);
            }
        }
        catch (Throwable e) {
            this.handleError(response, "BaseServlet Global Exception", e);
        }
        finally {
            if (mustPopLogContext && !InitListener.isRegistered) {
                Logger.popContext();
            }
            if (wasIgnored) {
                Logger.observeThread();
            }
            RequestContext.popThreadLocal();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doPatch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(501);
    }

    public void handleError(HttpServletResponse response, Throwable t) {
        this.handleError(response, ((Object)((Object)this)).getClass().getName() + " top-level exception", t);
    }

    public void handleError(HttpServletResponse response, String errorMessage, Throwable t) {
        this.log.forceError((Object)errorMessage, Reflection.getRealTargetException(t));
        ServletTools.handleServletError(response, errorMessage, t);
    }
}

