/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.Committable;
import com.isomorphic.datasource.DSCacheManager;
import com.isomorphic.datasource.DSTransaction;
import com.isomorphic.rpc.BaseResponse;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.servlet.RequestContext;

public abstract class BaseRequest<R extends BaseRequest, T extends BaseResponse>
extends Base
implements Committable {
    private RPCManager rpcManager;
    private DSTransaction dsTransaction;
    private DSCacheManager dsCacheManager;
    private Boolean clientRequest;
    @Deprecated
    public RequestContext context;

    public BaseRequest() {
        this(null, null);
    }

    public BaseRequest(RPCManager rpcManager) {
        this(rpcManager, rpcManager.getDsTransaction());
    }

    public BaseRequest(RPCManager rpcManager, DSTransaction dsTransaction) {
        this.rpcManager = rpcManager;
        this.dsTransaction = dsTransaction;
    }

    public abstract <T extends BaseResponse> T execute() throws Exception;

    public R freeResources() {
        return (R)this;
    }

    public R freeQueueResources() {
        return (R)this;
    }

    public R freeAllResources() {
        return (R)this;
    }

    public boolean shouldFreeOnExecute() {
        return false;
    }

    public RPCManager getRPCManager() {
        return this.rpcManager;
    }

    public DSCacheManager getDSCacheManager() {
        return this.dsCacheManager;
    }

    public void setRPCManager(RPCManager rpcManager) {
        this.rpcManager = rpcManager;
        if (this.rpcManager != null) {
            this.dsCacheManager = rpcManager;
            this.setContext(this.rpcManager.getContext());
            this.rpcManager.addAssociatedRequest(this);
            this.setDsTransaction(this.rpcManager.getDsTransaction());
        }
    }

    public void setDSCacheManager(DSCacheManager dsCacheManager) {
        this.dsCacheManager = dsCacheManager;
        if (dsCacheManager instanceof RPCManager) {
            this.setRPCManager((RPCManager)dsCacheManager);
        }
    }

    public DSTransaction getDSTransaction() {
        return this.getDsTransaction();
    }

    public DSTransaction getDsTransaction() {
        if (this.dsTransaction == null && this.getRPCManager() != null) {
            return this.getRPCManager().getDsTransaction();
        }
        return this.dsTransaction;
    }

    public void setDSTransaction(DSTransaction dsTransaction) {
        this.setDsTransaction(dsTransaction);
    }

    public void setDsTransaction(DSTransaction dsTransaction) {
        if (dsTransaction == null) {
            return;
        }
        if (this.getRPCManager() != null) {
            this.getRPCManager().setDsTransaction(dsTransaction);
        } else {
            this.dsTransaction = dsTransaction;
            this.dsTransaction.registerRequest(this);
        }
    }

    public RequestContext getContext() {
        return this.context;
    }

    public R setContext(RequestContext context) {
        this.context = context;
        return (R)this;
    }

    public boolean isClientRequest() {
        if (this.clientRequest != null) {
            return this.clientRequest;
        }
        DSTransaction transaction = this.getDsTransaction();
        if (transaction != null && transaction.isClientRequest() != null) {
            return transaction.isClientRequest();
        }
        return false;
    }

    public R setClientRequest(Boolean clientRequest) {
        this.clientRequest = clientRequest;
        return (R)this;
    }
}

